/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xml.xlxp.compiler.impl;

import com.ibm.xml.xlxp.compiler.impl.AllGroupTableImpl;
import com.ibm.xml.xlxp.compiler.impl.AllMemberElement;
import com.ibm.xml.xlxp.compiler.impl.AllMemberElementImpl;
import com.ibm.xml.xlxp.compiler.impl.AllModelGroup;
import com.ibm.xml.xlxp.compiler.impl.CodeGenerator;
import com.ibm.xml.xlxp.compiler.impl.ComplexBody;
import com.ibm.xml.xlxp.compiler.impl.ComplexType;
import com.ibm.xml.xlxp.compiler.impl.Element;
import com.ibm.xml.xlxp.compiler.impl.GeneratorInfo;
import com.ibm.xml.xlxp.compiler.impl.Grammar;
import com.ibm.xml.xlxp.compiler.impl.Label;
import com.ibm.xml.xlxp.compiler.impl.NonterminalSymbolImpl;
import com.ibm.xml.xlxp.compiler.impl.SymbolTable;
import com.ibm.xml.xlxp.compiler.impl.iterators.SymbolArrayIterator;
import com.ibm.xml.xlxp.compiler.tables.SearchTableInfo;
import com.ibm.xml.xlxp.compiler.tables.TableId;
import java.util.Map;
import java.util.TreeMap;

public class AllModelGroupImpl
extends NonterminalSymbolImpl
implements ComplexBody,
AllModelGroup {
    private final ComplexType fOwner;
    private final int fMinOccurs;
    private boolean fAllAreOptional = true;
    private final Object[] fElements;
    private TableId fTableId = null;
    private Map fInfo = new TreeMap();
    private int fIndex = 0;
    public static String staticCopyrightString = "Licensed Materials - Property of IBM\nXLXP - Part of various IBM products\n\u00a9 Copyright IBM Corp. 2006, 2007. All Rights Reserved.\nUS Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";

    public AllModelGroupImpl(ComplexType complexType, SymbolTable symbolTable, int n2, int n3) {
        super(symbolTable);
        this.fOwner = complexType;
        this.fMinOccurs = n2;
        this.fElements = new Object[n3];
    }

    public void computeModelInfo(CodeGenerator codeGenerator) {
        SymbolTable symbolTable = codeGenerator.grammar().symbolTable();
        int n2 = 1;
        int n3 = 0;
        while (n3 < this.fElements.length) {
            AllMemberElement allMemberElement = (AllMemberElement)this.fElements[n3];
            n2 = allMemberElement.numberSubstitutionGroupMembers(n2, symbolTable);
            ++n3;
        }
    }

    public void addMember(Element element2, int n2) {
        if (n2 != 0) {
            this.fAllAreOptional = false;
        }
        int n3 = this.fIndex++;
        this.fElements[n3] = new AllMemberElementImpl(element2, n2, n3);
    }

    public void createTheTables(CodeGenerator codeGenerator) {
        AllGroupTableImpl allGroupTableImpl = new AllGroupTableImpl(codeGenerator, this.fElements.length);
        int n2 = -1;
        Grammar grammar = codeGenerator.grammar();
        SymbolTable symbolTable = grammar.symbolTable();
        int n3 = 0;
        while (n3 < this.fElements.length) {
            AllMemberElementImpl allMemberElementImpl = (AllMemberElementImpl)this.fElements[n3];
            int n4 = allMemberElementImpl.minOccurs();
            int n5 = allMemberElementImpl.index();
            if (n5 > n2) {
                n2 = n5;
            }
            SymbolArrayIterator symbolArrayIterator = allMemberElementImpl.transitiveMembers(symbolTable);
            while (symbolArrayIterator.hasNext()) {
                Element element2 = (Element)symbolArrayIterator.next();
                int n6 = (Integer)symbolArrayIterator.value();
                GeneratorInfo generatorInfo = element2.createInfo(codeGenerator, null, this.fOwner);
                this.fInfo.put(element2, generatorInfo);
                SearchTableInfo searchTableInfo = element2.createAllGroupInfo(codeGenerator, generatorInfo, n4, n5, n6);
                String string2 = element2.inputText();
                allGroupTableImpl.addData(string2, searchTableInfo);
            }
            ++n3;
        }
        allGroupTableImpl.finishTable(codeGenerator);
        allGroupTableImpl.setNumberOfGroupMembers(n2 + 1);
        this.fTableId = allGroupTableImpl.tableId();
        codeGenerator.addTable(allGroupTableImpl);
    }

    public void generateInstructions(CodeGenerator codeGenerator, Label label) {
        SymbolTable symbolTable = codeGenerator.grammar().symbolTable();
        codeGenerator.generateLabel(label);
        this.fOwner.startComplexTypeExtensionInstructions(codeGenerator);
        short s = this.fOwner.contentType();
        Label label2 = codeGenerator.createLabel();
        codeGenerator.generateStartAllModelGroup(this.fElements.length);
        codeGenerator.generateLabel(label2);
        codeGenerator.generateReadAllModelGroup(this.fTableId, s == 0, this.allowEmptyTag());
        this.fOwner.endComplexTypeExtensionInstructions(codeGenerator);
        codeGenerator.returnFromSubroutine();
        int n2 = 0;
        while (n2 < this.fElements.length) {
            AllMemberElement allMemberElement = (AllMemberElement)this.fElements[n2];
            SymbolArrayIterator symbolArrayIterator = allMemberElement.transitiveMembers(symbolTable);
            while (symbolArrayIterator.hasNext()) {
                Element element2 = (Element)symbolArrayIterator.next();
                GeneratorInfo generatorInfo = (GeneratorInfo)this.fInfo.get(element2);
                generatorInfo.generateInlineInstructions(codeGenerator, label2, true);
            }
            ++n2;
        }
    }

    public boolean allowEmptyTag() {
        return this.fMinOccurs == 0 || this.fAllAreOptional;
    }
}

