/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xml.xlxp.api.wbm.xpath.impl.util;

import com.ibm.xml.xlxp.api.util.NamespaceContext;
import com.ibm.xml.xlxp.api.wbm.xpath.impl.util.Copyright;
import com.ibm.xml.xlxp.scan.util.DataBuffer;
import com.ibm.xml.xlxp.scan.util.SymbolTable;
import com.ibm.xml.xlxp.scan.util.UTF8Support;
import com.ibm.xml.xlxp.scan.util.XMLCharacterProperties;
import com.ibm.xml.xlxp.scan.util.XMLString;
import java.io.UnsupportedEncodingException;
import javax.xml.namespace.QName;

@Copyright(value="Licensed Materials - Property of IBM\nXLXP - Part of various IBM products\n\u00a9 Copyright IBM Corp. 2007. All Rights Reserved.\nUS Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.")
public class XMLStringHelper {
    private static final int SIGNED_INT_MULTMIN = -214748364;
    private static final long SIGNED_LONG_MULTMIN = -922337203685477580L;

    public static int parseInt(XMLString xMLString, int[] nArray) {
        nArray[0] = 0;
        if (xMLString.length == 0) {
            nArray[0] = 1;
            return 0;
        }
        if (xMLString.bytes != null) {
            return XMLStringHelper.parseIntUnbuffered(xMLString, nArray);
        }
        return XMLStringHelper.parseIntBuffered(xMLString, nArray);
    }

    private static int parseIntUnbuffered(XMLString xMLString, int[] nArray) {
        byte by2;
        boolean bl = false;
        int n2 = -2147483647;
        int n3 = -214748364;
        int n4 = xMLString.startOffset;
        int n5 = xMLString.endOffset;
        nArray[0] = 0;
        if ((by2 = xMLString.bytes[n4++]) <= 32) {
            while (by2 == 32 || by2 == 10 || by2 == 9 || by2 == 13) {
                if (n4 < n5) {
                    by2 = xMLString.bytes[n4++];
                    continue;
                }
                nArray[0] = 1;
                return 0;
            }
        }
        if (by2 == 45) {
            bl = true;
            n2 = Integer.MIN_VALUE;
            if (n4 < n5) {
                by2 = xMLString.bytes[n4++];
            }
        } else if (by2 == 43 && n4 < n5) {
            by2 = xMLString.bytes[n4++];
        }
        if (by2 >= 48 && by2 <= 57) {
            int n6 = 48 - by2;
            while (n4 < n5) {
                if ((by2 = xMLString.bytes[n4++]) >= 48 && by2 <= 57) {
                    int n7;
                    if (n6 >= n3 && (n6 *= 10) >= n2 + (n7 = by2 - 48)) {
                        n6 -= n7;
                        continue;
                    }
                } else if (by2 <= 32) {
                    while (by2 == 32 || by2 == 10 || by2 == 9 || by2 == 13) {
                        if (n4 < n5) {
                            by2 = xMLString.bytes[n4++];
                            continue;
                        }
                        return bl ? n6 : -n6;
                    }
                }
                nArray[0] = 1;
                return 0;
            }
            return bl ? n6 : -n6;
        }
        nArray[0] = 1;
        return 0;
    }

    private static int parseIntBuffered(XMLString xMLString, int[] nArray) {
        byte by2;
        boolean bl = false;
        int n2 = -2147483647;
        DataBuffer dataBuffer = xMLString.firstBuffer;
        DataBuffer dataBuffer2 = xMLString.lastBuffer == null ? dataBuffer : xMLString.lastBuffer;
        int n3 = xMLString.startOffset;
        int n4 = dataBuffer == dataBuffer2 ? xMLString.endOffset : dataBuffer.endOffset;
        nArray[0] = 0;
        if ((by2 = dataBuffer.bytes[n3++]) <= 32) {
            while (by2 == 32 || by2 == 10 || by2 == 9 || by2 == 13) {
                if (n3 < n4) {
                    by2 = dataBuffer.bytes[n3++];
                    continue;
                }
                if (dataBuffer == dataBuffer2) {
                    nArray[0] = 1;
                    return 0;
                }
                dataBuffer = dataBuffer.next;
                n3 = dataBuffer.startOffset;
                n4 = dataBuffer == dataBuffer2 ? xMLString.endOffset : dataBuffer.endOffset;
                by2 = dataBuffer.bytes[n3++];
            }
        }
        if (by2 == 45) {
            bl = true;
            n2 = Integer.MIN_VALUE;
            while (true) {
                if (n3 < n4) {
                    by2 = dataBuffer.bytes[n3++];
                } else if (dataBuffer != dataBuffer2) {
                    dataBuffer = dataBuffer.next;
                    n3 = dataBuffer.startOffset;
                    n4 = dataBuffer == dataBuffer2 ? xMLString.endOffset : dataBuffer.endOffset;
                    continue;
                }
                break;
            }
        } else if (by2 == 43) {
            while (true) {
                if (n3 < n4) {
                    by2 = dataBuffer.bytes[n3++];
                    break;
                }
                if (dataBuffer == dataBuffer2) break;
                dataBuffer = dataBuffer.next;
                n3 = dataBuffer.startOffset;
                n4 = dataBuffer == dataBuffer2 ? xMLString.endOffset : dataBuffer.endOffset;
            }
        }
        if (by2 >= 48 && by2 <= 57) {
            int n5 = 48 - by2;
            while (true) {
                if (n3 < n4) {
                    if ((by2 = dataBuffer.bytes[n3++]) >= 48 && by2 <= 57) {
                        int n6 = by2 - 48;
                        if (n5 >= -214748364 && (n5 *= 10) >= n2 + n6) {
                            n5 -= n6;
                            continue;
                        }
                    } else if (by2 <= 32) {
                        while (by2 == 32 || by2 == 10 || by2 == 9 || by2 == 13) {
                            if (n3 < n4) {
                                by2 = dataBuffer.bytes[n3++];
                                continue;
                            }
                            if (dataBuffer == dataBuffer2) {
                                return bl ? n5 : -n5;
                            }
                            dataBuffer = dataBuffer.next;
                            n3 = dataBuffer.startOffset;
                            n4 = dataBuffer == dataBuffer2 ? xMLString.endOffset : dataBuffer.endOffset;
                            by2 = dataBuffer.bytes[n3++];
                        }
                    }
                    nArray[0] = 1;
                    return 0;
                }
                if (dataBuffer == dataBuffer2) {
                    return bl ? n5 : -n5;
                }
                dataBuffer = dataBuffer.next;
                n3 = dataBuffer.startOffset;
                n4 = dataBuffer == dataBuffer2 ? xMLString.endOffset : dataBuffer.endOffset;
            }
        }
        nArray[0] = 1;
        return 0;
    }

    public static long parseLong(XMLString xMLString, int[] nArray) {
        nArray[0] = 0;
        if (xMLString.length == 0) {
            nArray[0] = 1;
            return 0L;
        }
        if (xMLString.bytes != null) {
            return XMLStringHelper.parseLongUnbuffered(xMLString, nArray);
        }
        return XMLStringHelper.parseLongBuffered(xMLString, nArray);
    }

    private static long parseLongUnbuffered(XMLString xMLString, int[] nArray) {
        byte by2;
        boolean bl = false;
        long l = -9223372036854775807L;
        long l2 = -922337203685477580L;
        int n2 = xMLString.startOffset;
        int n3 = xMLString.endOffset;
        nArray[0] = 0;
        if ((by2 = xMLString.bytes[n2++]) <= 32) {
            while (by2 == 32 || by2 == 10 || by2 == 9 || by2 == 13) {
                if (n2 < n3) {
                    by2 = xMLString.bytes[n2++];
                    continue;
                }
                nArray[0] = 1;
                return 0L;
            }
        }
        if (by2 == 45) {
            bl = true;
            l = Long.MIN_VALUE;
            if (n2 < n3) {
                by2 = xMLString.bytes[n2++];
            }
        } else if (by2 == 43 && n2 < n3) {
            by2 = xMLString.bytes[n2++];
        }
        if (by2 >= 48 && by2 <= 57) {
            long l3 = 48 - by2;
            while (n2 < n3) {
                if ((by2 = xMLString.bytes[n2++]) >= 48 && by2 <= 57) {
                    int n4;
                    if (l3 >= l2 && (l3 *= 10L) >= l + (long)(n4 = by2 - 48)) {
                        l3 -= (long)n4;
                        continue;
                    }
                } else if (by2 <= 32) {
                    while (by2 == 32 || by2 == 10 || by2 == 9 || by2 == 13) {
                        if (n2 < n3) {
                            by2 = xMLString.bytes[n2++];
                            continue;
                        }
                        return bl ? l3 : -l3;
                    }
                }
                nArray[0] = 1;
                return 0L;
            }
            return bl ? l3 : -l3;
        }
        nArray[0] = 1;
        return 0L;
    }

    private static long parseLongBuffered(XMLString xMLString, int[] nArray) {
        byte by2;
        boolean bl = false;
        long l = -9223372036854775807L;
        DataBuffer dataBuffer = xMLString.firstBuffer;
        DataBuffer dataBuffer2 = xMLString.lastBuffer == null ? dataBuffer : xMLString.lastBuffer;
        int n2 = xMLString.startOffset;
        int n3 = dataBuffer == dataBuffer2 ? xMLString.endOffset : dataBuffer.endOffset;
        nArray[0] = 0;
        if ((by2 = dataBuffer.bytes[n2++]) <= 32) {
            while (by2 == 32 || by2 == 10 || by2 == 9 || by2 == 13) {
                if (n2 < n3) {
                    by2 = dataBuffer.bytes[n2++];
                    continue;
                }
                if (dataBuffer == dataBuffer2) {
                    nArray[0] = 1;
                    return 0L;
                }
                dataBuffer = dataBuffer.next;
                n2 = dataBuffer.startOffset;
                n3 = dataBuffer == dataBuffer2 ? xMLString.endOffset : dataBuffer.endOffset;
                by2 = dataBuffer.bytes[n2++];
            }
        }
        if (by2 == 45) {
            bl = true;
            l = Long.MIN_VALUE;
            while (true) {
                if (n2 < n3) {
                    by2 = dataBuffer.bytes[n2++];
                } else if (dataBuffer != dataBuffer2) {
                    dataBuffer = dataBuffer.next;
                    n2 = dataBuffer.startOffset;
                    n3 = dataBuffer == dataBuffer2 ? xMLString.endOffset : dataBuffer.endOffset;
                    continue;
                }
                break;
            }
        } else if (by2 == 43) {
            while (true) {
                if (n2 < n3) {
                    by2 = dataBuffer.bytes[n2++];
                    break;
                }
                if (dataBuffer == dataBuffer2) break;
                dataBuffer = dataBuffer.next;
                n2 = dataBuffer.startOffset;
                n3 = dataBuffer == dataBuffer2 ? xMLString.endOffset : dataBuffer.endOffset;
            }
        }
        if (by2 >= 48 && by2 <= 57) {
            long l2 = 48 - by2;
            while (true) {
                if (n2 < n3) {
                    if ((by2 = dataBuffer.bytes[n2++]) >= 48 && by2 <= 57) {
                        int n4 = by2 - 48;
                        if (l2 >= -922337203685477580L && (l2 *= 10L) >= l + (long)n4) {
                            l2 -= (long)n4;
                            continue;
                        }
                    } else if (by2 <= 32) {
                        while (by2 == 32 || by2 == 10 || by2 == 9 || by2 == 13) {
                            if (n2 < n3) {
                                by2 = dataBuffer.bytes[n2++];
                                continue;
                            }
                            if (dataBuffer == dataBuffer2) {
                                return bl ? l2 : -l2;
                            }
                            dataBuffer = dataBuffer.next;
                            n2 = dataBuffer.startOffset;
                            n3 = dataBuffer == dataBuffer2 ? xMLString.endOffset : dataBuffer.endOffset;
                            by2 = dataBuffer.bytes[n2++];
                        }
                    }
                    nArray[0] = 1;
                    return 0L;
                }
                if (dataBuffer == dataBuffer2) {
                    return bl ? l2 : -l2;
                }
                dataBuffer = dataBuffer.next;
                n2 = dataBuffer.startOffset;
                n3 = dataBuffer == dataBuffer2 ? xMLString.endOffset : dataBuffer.endOffset;
            }
        }
        nArray[0] = 1;
        return 0L;
    }

    public static int compare(XMLString xMLString, XMLString xMLString2) {
        if (xMLString2.length == xMLString.length) {
            return XMLStringHelper.compare2(xMLString, xMLString2, xMLString2.length, 0);
        }
        if (xMLString2.length < xMLString.length) {
            return XMLStringHelper.compare2(xMLString, xMLString2, xMLString2.length, 1);
        }
        return XMLStringHelper.compare2(xMLString, xMLString2, xMLString.length, -1);
    }

    private static int compare2(XMLString xMLString, XMLString xMLString2, int n2, int n3) {
        if (n2 == 0) {
            return n3;
        }
        if (xMLString.bytes != null && xMLString2.bytes != null) {
            return XMLStringHelper.compare2Unbuffered(xMLString, xMLString2, n2, n3);
        }
        return XMLStringHelper.compare2Buffered(xMLString, xMLString2, n2, n3);
    }

    private static int compare2Unbuffered(XMLString xMLString, XMLString xMLString2, int n2, int n3) {
        byte[] byArray = xMLString.bytes;
        byte[] byArray2 = xMLString2.bytes;
        int n4 = xMLString.startOffset;
        int n5 = xMLString2.startOffset;
        int n6 = n4 + n2;
        while (n4 < n6) {
            byte by2;
            byte by3;
            if ((by3 = byArray[n4++]) > (by2 = byArray2[n5++])) {
                return 1;
            }
            if (by3 >= by2) continue;
            return -1;
        }
        return n3;
    }

    private static int compare2Buffered(XMLString xMLString, XMLString xMLString2, int n2, int n3) {
        DataBuffer dataBuffer = xMLString.firstBuffer;
        byte[] byArray = dataBuffer.bytes;
        int n4 = xMLString.startOffset;
        byte by2 = byArray[n4];
        DataBuffer dataBuffer2 = xMLString2.firstBuffer;
        byte[] byArray2 = dataBuffer2.bytes;
        int n5 = xMLString2.startOffset;
        byte by3 = byArray2[n5];
        if (by2 > by3) {
            return 1;
        }
        if (by2 < by3) {
            return -1;
        }
        DataBuffer dataBuffer3 = xMLString.lastBuffer;
        int n6 = dataBuffer.endOffset;
        if (dataBuffer3 == null) {
            dataBuffer3 = dataBuffer;
            n6 = xMLString.endOffset;
        }
        DataBuffer dataBuffer4 = xMLString2.lastBuffer;
        int n7 = dataBuffer2.endOffset;
        if (dataBuffer4 == null) {
            dataBuffer4 = dataBuffer2;
            n7 = xMLString2.endOffset;
        }
        int n8 = 0;
        while (++n8 < n2) {
            if (++n4 == n6) {
                dataBuffer = dataBuffer.next;
                byArray = dataBuffer.bytes;
                n4 = dataBuffer.startOffset;
                n6 = dataBuffer != dataBuffer3 ? dataBuffer.endOffset : xMLString.endOffset;
            }
            by2 = byArray[n4];
            if (++n5 == n7) {
                dataBuffer2 = dataBuffer2.next;
                byArray2 = dataBuffer2.bytes;
                n5 = dataBuffer2.startOffset;
                int n9 = n7 = dataBuffer2 != dataBuffer4 ? dataBuffer2.endOffset : xMLString2.endOffset;
            }
            if (by2 > (by3 = byArray2[n5])) {
                return 1;
            }
            if (by2 >= by3) continue;
            return -1;
        }
        return n3;
    }

    public static double parseDouble(XMLString xMLString, int[] nArray) {
        nArray[0] = 0;
        if (xMLString.length == 0) {
            nArray[0] = 1;
            return 0.0;
        }
        if (xMLString.bytes != null) {
            return XMLStringHelper.parseDoubleUnbuffered(xMLString, nArray);
        }
        return XMLStringHelper.parseDoubleBuffered(xMLString, nArray);
    }

    private static double parseDoubleBuffered(XMLString xMLString, int[] nArray) {
        DataBuffer dataBuffer = xMLString.firstBuffer;
        DataBuffer dataBuffer2 = xMLString.lastBuffer == null ? dataBuffer : xMLString.lastBuffer;
        int n2 = xMLString.startOffset;
        int n3 = dataBuffer == dataBuffer2 ? xMLString.endOffset : dataBuffer.endOffset;
        byte by2 = dataBuffer.bytes[n2];
        if (by2 <= 32) {
            while (true) {
                if ((by2 == 32 || by2 == 10 || by2 == 9 || by2 == 13) && ++n2 < n3) {
                    by2 = dataBuffer.bytes[n2];
                    continue;
                }
                if (n2 != n3 || dataBuffer == dataBuffer2) break;
                dataBuffer = dataBuffer.next;
                n2 = dataBuffer.startOffset;
                n3 = dataBuffer == dataBuffer2 ? xMLString.endOffset : dataBuffer.endOffset;
                by2 = dataBuffer.bytes[n2];
            }
        }
        if (by2 == 78) {
            while (true) {
                if (++n2 < n3) break;
                if (dataBuffer == dataBuffer2) {
                    nArray[0] = 1;
                    return 0.0;
                }
                dataBuffer = dataBuffer.next;
                n2 = dataBuffer.startOffset - 1;
                n3 = dataBuffer == dataBuffer2 ? xMLString.endOffset : dataBuffer.endOffset;
            }
            by2 = dataBuffer.bytes[n2];
            if (by2 == 97) {
                while (true) {
                    if (++n2 < n3) break;
                    if (dataBuffer == dataBuffer2) {
                        nArray[0] = 1;
                        return 0.0;
                    }
                    dataBuffer = dataBuffer.next;
                    n2 = dataBuffer.startOffset - 1;
                    n3 = dataBuffer == dataBuffer2 ? xMLString.endOffset : dataBuffer.endOffset;
                }
                by2 = dataBuffer.bytes[n2];
                if (by2 == 78) {
                    while (true) {
                        if (++n2 < n3) {
                            by2 = dataBuffer.bytes[n2];
                            break;
                        }
                        if (dataBuffer == dataBuffer2) break;
                        dataBuffer = dataBuffer.next;
                        n2 = dataBuffer.startOffset - 1;
                        n3 = dataBuffer == dataBuffer2 ? xMLString.endOffset : dataBuffer.endOffset;
                    }
                    if (by2 <= 32) {
                        while (true) {
                            if ((by2 == 32 || by2 == 10 || by2 == 9 || by2 == 13) && ++n2 < n3) {
                                by2 = dataBuffer.bytes[n2];
                                continue;
                            }
                            if (n2 != n3 || dataBuffer == dataBuffer2) break;
                            dataBuffer = dataBuffer.next;
                            n2 = dataBuffer.startOffset;
                            n3 = dataBuffer == dataBuffer2 ? xMLString.endOffset : dataBuffer.endOffset;
                            by2 = dataBuffer.bytes[n2];
                        }
                    }
                    if (n2 < n3) {
                        nArray[0] = 1;
                        return 0.0;
                    }
                    return Double.NaN;
                }
            }
            nArray[0] = 1;
            return 0.0;
        }
        boolean bl = false;
        if (by2 == 43 || by2 == 45 || by2 == 73) {
            boolean bl2 = bl = by2 == 45;
            if (bl || by2 == 43) {
                while (true) {
                    if (++n2 < n3) {
                        by2 = dataBuffer.bytes[n2];
                        break;
                    }
                    if (dataBuffer == dataBuffer2) {
                        nArray[0] = 1;
                        return 0.0;
                    }
                    dataBuffer = dataBuffer.next;
                    n2 = dataBuffer.startOffset - 1;
                    n3 = dataBuffer == dataBuffer2 ? xMLString.endOffset : dataBuffer.endOffset;
                }
            }
            if (by2 == 73) {
                while (true) {
                    if (++n2 < n3) break;
                    if (dataBuffer == dataBuffer2) {
                        nArray[0] = 1;
                        return 0.0;
                    }
                    dataBuffer = dataBuffer.next;
                    n2 = dataBuffer.startOffset - 1;
                    n3 = dataBuffer == dataBuffer2 ? xMLString.endOffset : dataBuffer.endOffset;
                }
                by2 = dataBuffer.bytes[n2];
                if (by2 == 78) {
                    while (true) {
                        if (++n2 < n3) break;
                        if (dataBuffer == dataBuffer2) {
                            nArray[0] = 1;
                            return 0.0;
                        }
                        dataBuffer = dataBuffer.next;
                        n2 = dataBuffer.startOffset - 1;
                        n3 = dataBuffer == dataBuffer2 ? xMLString.endOffset : dataBuffer.endOffset;
                    }
                    by2 = dataBuffer.bytes[n2];
                    if (by2 == 70) {
                        while (true) {
                            if (++n2 < n3) {
                                by2 = dataBuffer.bytes[n2];
                                break;
                            }
                            if (dataBuffer == dataBuffer2) break;
                            dataBuffer = dataBuffer.next;
                            n2 = dataBuffer.startOffset - 1;
                            n3 = dataBuffer == dataBuffer2 ? xMLString.endOffset : dataBuffer.endOffset;
                        }
                        if (by2 <= 32) {
                            while (true) {
                                if ((by2 == 32 || by2 == 10 || by2 == 9 || by2 == 13) && ++n2 < n3) {
                                    by2 = dataBuffer.bytes[n2];
                                    continue;
                                }
                                if (n2 != n3 || dataBuffer == dataBuffer2) break;
                                dataBuffer = dataBuffer.next;
                                n2 = dataBuffer.startOffset;
                                n3 = dataBuffer == dataBuffer2 ? xMLString.endOffset : dataBuffer.endOffset;
                                by2 = dataBuffer.bytes[n2];
                            }
                        }
                        if (n2 < n3) {
                            nArray[0] = 1;
                            return 0.0;
                        }
                        return bl ? Double.NEGATIVE_INFINITY : Double.POSITIVE_INFINITY;
                    }
                }
                nArray[0] = 1;
                return 0.0;
            }
        }
        StringBuffer stringBuffer = new StringBuffer((n3 - n2) * 2);
        if (by2 >= 48 && by2 <= 57 || by2 == 46) {
            stringBuffer.append((char)by2);
            while (true) {
                if (++n2 < n3) {
                    by2 = dataBuffer.bytes[n2];
                    if ((by2 >= 48 && by2 <= 57 || by2 == 46 || by2 == 69 || by2 == 101 || by2 == 43 || by2 == 45) && by2 != 32 && by2 != 10 && by2 != 9 && by2 != 13) {
                        stringBuffer.append((char)by2);
                        continue;
                    }
                    if (by2 == 32 || by2 == 10 || by2 == 9 || by2 == 13) break;
                    nArray[0] = 1;
                    return 0.0;
                }
                if (dataBuffer == dataBuffer2) break;
                dataBuffer = dataBuffer.next;
                n2 = dataBuffer.startOffset - 1;
                n3 = dataBuffer == dataBuffer2 ? xMLString.endOffset : dataBuffer.endOffset;
            }
            if (by2 <= 32) {
                while (true) {
                    if ((by2 == 32 || by2 == 10 || by2 == 9 || by2 == 13) && ++n2 < n3) {
                        by2 = dataBuffer.bytes[n2];
                        continue;
                    }
                    if (n2 != n3 || dataBuffer == dataBuffer2) break;
                    dataBuffer = dataBuffer.next;
                    n2 = dataBuffer.startOffset;
                    n3 = dataBuffer == dataBuffer2 ? xMLString.endOffset : dataBuffer.endOffset;
                    by2 = dataBuffer.bytes[n2];
                }
            }
            if (n2 < n3) {
                nArray[0] = 1;
                return 0.0;
            }
            try {
                double d = Double.parseDouble(stringBuffer.toString());
                return bl ? -d : d;
            }
            catch (NumberFormatException numberFormatException) {
                nArray[0] = 1;
                return 0.0;
            }
        }
        nArray[0] = 1;
        return 0.0;
    }

    private static double parseDoubleUnbuffered(XMLString xMLString, int[] nArray) {
        int n2 = xMLString.startOffset;
        int n3 = xMLString.endOffset;
        if ((n2 = XMLStringHelper.removeWhitespace(xMLString.bytes, n2, n3)) == n3) {
            nArray[0] = 1;
            return 0.0;
        }
        byte by2 = xMLString.bytes[n2];
        int n4 = n2;
        if (by2 == 78 && n2 + 2 <= n3 && xMLString.bytes[++n2] == 97 && xMLString.bytes[++n2] == 78) {
            if (++n2 < n3 && (n2 = XMLStringHelper.removeWhitespace(xMLString.bytes, n2, n3)) < n3) {
                nArray[0] = 1;
                return 0.0;
            }
            return Double.NaN;
        }
        if (by2 == 73 && n2 + 2 <= n3 && xMLString.bytes[++n2] == 78 && xMLString.bytes[++n2] == 70) {
            if (++n2 < n3 && (n2 = XMLStringHelper.removeWhitespace(xMLString.bytes, n2, n3)) < n3) {
                nArray[0] = 1;
                return 0.0;
            }
            return Double.POSITIVE_INFINITY;
        }
        if (by2 == 45 && xMLString.bytes[n2 + 1] == 73 && ++n2 + 2 <= n3 && xMLString.bytes[++n2] == 78 && xMLString.bytes[++n2] == 70) {
            if (++n2 < n3) {
                by2 = xMLString.bytes[n2];
                if ((n2 = XMLStringHelper.removeWhitespace(xMLString.bytes, n2, n3)) < n3) {
                    nArray[0] = 1;
                    return 0.0;
                }
            }
            return Double.NEGATIVE_INFINITY;
        }
        while (n2 < n3) {
            if (((by2 = xMLString.bytes[n2++]) < 48 || by2 > 57) && by2 != 46 && by2 != 69 && by2 != 101 && by2 != 43 && by2 != 45 && by2 != 32 && by2 != 10 && by2 != 9 && by2 != 13) {
                nArray[0] = 1;
                return 0.0;
            }
            if (by2 != 32 && by2 != 10 && by2 != 9 && by2 != 13) continue;
        }
        int n5 = n2;
        if ((n2 = XMLStringHelper.removeWhitespace(xMLString.bytes, n2, n3)) < n3) {
            nArray[0] = 1;
            return 0.0;
        }
        try {
            double d = Double.parseDouble(new String(xMLString.bytes, n4, n5 - n4, "UTF-8"));
            return d;
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            throw new RuntimeException("Broken VM: UTF-8 not supported.");
        }
        catch (NumberFormatException numberFormatException) {
            nArray[0] = 1;
            return 0.0;
        }
    }

    public static QName parseQName(XMLString xMLString, XMLString xMLString2, char[][] cArray, int[] nArray, NamespaceContext namespaceContext, int n2, SymbolTable symbolTable) {
        if (xMLString.length == 0) {
            return null;
        }
        if (xMLString.bytes != null) {
            return XMLStringHelper.parseQNameUnbuffered(xMLString, xMLString2, cArray, nArray, namespaceContext, n2, symbolTable);
        }
        return XMLStringHelper.parseQNameBuffered(xMLString, xMLString2, cArray, nArray, namespaceContext, n2, symbolTable);
    }

    private static QName parseQNameUnbuffered(XMLString xMLString, XMLString xMLString2, char[][] cArray, int[] nArray, NamespaceContext namespaceContext, int n2, SymbolTable symbolTable) {
        int n3 = xMLString.startOffset;
        int n4 = xMLString.endOffset;
        byte by2 = 0;
        byte[] byArray = null;
        int[] nArray2 = null;
        xMLString2.setValues(xMLString);
        int n5 = 0;
        int n6 = 0;
        String string2 = "";
        String string3 = null;
        String string4 = "";
        xMLString2.startOffset = n3 = XMLStringHelper.removeWhitespace(xMLString.bytes, n3, n4);
        if (n3 < n4) {
            by2 = xMLString.bytes[n3];
            if (!XMLCharacterProperties.nameStartChar10((int)by2)) {
                return null;
            }
            ++n3;
            while (n3 < n4) {
                by2 = xMLString.bytes[n3];
                if (by2 >= 0) {
                    if (by2 == 58) {
                        if (n5 != 0 || n3 + 1 == n4 || xMLString.startOffset == n3) {
                            return null;
                        }
                        xMLString2.endOffset = n3;
                        xMLString2.length = xMLString2.endOffset - xMLString.startOffset;
                        n5 = symbolTable.addSymbol(xMLString2);
                        nArray[0] = 0;
                        xMLString2.getChars(cArray, nArray);
                        string2 = new String(cArray[0], 0, nArray[0]);
                        xMLString2.startOffset = n3 + 1;
                        xMLString2.length = n4 - (n3 + 1);
                        xMLString2.endOffset = n4;
                    } else if (!XMLCharacterProperties.nameChar10((int)by2)) {
                        xMLString2.endOffset = n3;
                        if ((n3 = XMLStringHelper.removeWhitespace(xMLString.bytes, n3, n4)) >= n4) break;
                        return null;
                    }
                    ++n3;
                    continue;
                }
                if (byArray == null) {
                    byArray = new byte[4];
                    nArray2 = new int[2];
                }
                byArray[0] = by2;
                int n7 = 1;
                while (n7 < 4 && n3 + n7 < n4) {
                    byArray[n7++] = xMLString.bytes[n3 + n7 - 1];
                }
                UTF8Support.decodeCharacter((byte[])byArray, (int)0, (int)n7, (int[])nArray2);
                if (!XMLCharacterProperties.nameChar10((int)nArray2[0])) {
                    return null;
                }
                n3 += nArray2[1];
            }
        }
        nArray[0] = 0;
        xMLString2.getChars(cArray, nArray);
        string3 = new String(cArray[0], 0, nArray[0]);
        n6 = namespaceContext.prefixMapping(n2, n5);
        if (n6 == -1 && n5 != 0) {
            return null;
        }
        if (n6 != -1) {
            symbolTable.setStringValues(n6, xMLString2);
            nArray[0] = 0;
            xMLString2.getChars(cArray, nArray);
            string4 = new String(cArray[0], 0, nArray[0]);
        }
        return new QName(string4, string3, string2);
    }

    /*
     * Enabled aggressive block sorting
     */
    private static QName parseQNameBuffered(XMLString xMLString, XMLString xMLString2, char[][] cArray, int[] nArray, NamespaceContext namespaceContext, int n2, SymbolTable symbolTable) {
        String string2;
        String string3;
        String string4;
        int n3;
        block17: {
            DataBuffer dataBuffer = xMLString.firstBuffer;
            DataBuffer dataBuffer2 = xMLString.lastBuffer == null ? dataBuffer : xMLString.lastBuffer;
            int n4 = xMLString.startOffset;
            int n5 = dataBuffer == dataBuffer2 ? xMLString.endOffset : dataBuffer.endOffset;
            byte by2 = 0;
            byte[] byArray = null;
            int[] nArray2 = null;
            xMLString2.setValues(xMLString);
            int n6 = 0;
            n3 = 0;
            string4 = "";
            string3 = null;
            string2 = "";
            by2 = dataBuffer.bytes[n4];
            if (by2 <= 32) {
                while (true) {
                    if ((by2 == 32 || by2 == 10 || by2 == 9 || by2 == 13) && ++n4 < n5) {
                        by2 = dataBuffer.bytes[n4];
                        continue;
                    }
                    if (n4 != n5 || dataBuffer == dataBuffer2) break;
                    dataBuffer = dataBuffer.next;
                    n4 = dataBuffer.startOffset;
                    n5 = dataBuffer == dataBuffer2 ? xMLString.endOffset : dataBuffer.endOffset;
                    by2 = dataBuffer.bytes[n4];
                }
            }
            xMLString2.setStartPos(dataBuffer, n4);
            if (!XMLCharacterProperties.nameStartChar10((int)by2)) {
                return null;
            }
            ++n4;
            while (true) {
                block18: {
                    block24: {
                        block22: {
                            block23: {
                                block19: {
                                    block21: {
                                        block20: {
                                            if (n4 >= n5) break block18;
                                            by2 = dataBuffer.bytes[n4];
                                            if (by2 < 0) break block19;
                                            if (by2 != 58) break block20;
                                            if (n6 != 0 || n4 + 1 == n5 && dataBuffer == dataBuffer2 || xMLString.startOffset == n4 && dataBuffer == xMLString.firstBuffer) {
                                                return null;
                                            }
                                            xMLString2.setEndPos(dataBuffer, n4, 0);
                                            n6 = symbolTable.addSymbol(xMLString2);
                                            nArray[0] = 0;
                                            xMLString2.getChars(cArray, nArray);
                                            string4 = new String(cArray[0], 0, nArray[0]);
                                            xMLString2.setStartPos(dataBuffer, n4 + 1);
                                            xMLString2.length = n5 - (n4 + 1);
                                            xMLString2.setEndPos(dataBuffer2, xMLString.endOffset, 0);
                                            break block21;
                                        }
                                        if (XMLCharacterProperties.nameChar10((int)by2)) break block21;
                                        xMLString2.setEndPos(dataBuffer, n4, 0);
                                        if (by2 > 32) break block22;
                                        break block23;
                                    }
                                    ++n4;
                                    continue;
                                }
                                if (byArray != null) break block24;
                                byArray = new byte[4];
                                nArray2 = new int[2];
                                break block24;
                            }
                            while (true) {
                                if ((by2 == 32 || by2 == 10 || by2 == 9 || by2 == 13) && ++n4 < n5) {
                                    by2 = dataBuffer.bytes[n4];
                                    continue;
                                }
                                if (n4 != n5 || dataBuffer == dataBuffer2) break;
                                dataBuffer = dataBuffer.next;
                                n4 = dataBuffer.startOffset;
                                n5 = dataBuffer == dataBuffer2 ? xMLString.endOffset : dataBuffer.endOffset;
                                by2 = dataBuffer.bytes[n4];
                            }
                        }
                        if (n4 < n5 || dataBuffer != dataBuffer2) {
                            return null;
                        }
                        break block18;
                    }
                    byArray[0] = by2;
                    int n7 = 1;
                    while (true) {
                        if (n7 < 4 && n4 + n7 < n5) {
                            byArray[n7++] = dataBuffer.bytes[n4 + n7 - 1];
                            continue;
                        }
                        if (dataBuffer == dataBuffer2) {
                            UTF8Support.decodeCharacter((byte[])byArray, (int)0, (int)n7, (int[])nArray2);
                            if (!XMLCharacterProperties.nameChar10((int)nArray2[0])) {
                                return null;
                            }
                            break;
                        }
                        dataBuffer = dataBuffer.next;
                        n4 = dataBuffer.startOffset - n7;
                        n5 = dataBuffer == dataBuffer2 ? xMLString.endOffset : dataBuffer.endOffset;
                    }
                    n4 += nArray2[1];
                    continue;
                }
                if (dataBuffer == dataBuffer2) {
                    nArray[0] = 0;
                    xMLString2.getChars(cArray, nArray);
                    string3 = new String(cArray[0], 0, nArray[0]);
                    n3 = namespaceContext.prefixMapping(n2, n6);
                    if (n3 == -1) {
                        break;
                    }
                    break block17;
                }
                dataBuffer = dataBuffer.next;
                n4 = dataBuffer.startOffset;
                n5 = dataBuffer == dataBuffer2 ? xMLString.endOffset : dataBuffer.endOffset;
            }
            if (n6 != 0) {
                return null;
            }
        }
        if (n3 == -1) return new QName(string2, string3, string4);
        symbolTable.setStringValues(n3, xMLString2);
        nArray[0] = 0;
        xMLString2.getChars(cArray, nArray);
        string2 = new String(cArray[0], 0, nArray[0]);
        return new QName(string2, string3, string4);
    }

    public static int removeWhitespace(byte[] byArray, int n2, int n3) {
        if (n2 < n3) {
            byte by2 = byArray[n2];
            while ((by2 == 32 || by2 == 10 || by2 == 9 || by2 == 13) && ++n2 < n3) {
                by2 = byArray[n2];
            }
        }
        return n2;
    }

    public static int removeWhitespace2(byte[] byArray, int n2, int n3, boolean[] blArray) {
        while (n2 < n3) {
            byte by2 = byArray[n2];
            if (by2 != 32) {
                if (by2 != 10 && by2 != 9 && by2 != 13) break;
                blArray[0] = false;
            }
            ++n2;
        }
        return n2;
    }
}

