/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xml.xlxp.api.wbm.xpath.impl.predicates;

import com.ibm.xml.xlxp.api.wbm.xpath.impl.predicates.PredicateContext;
import com.ibm.xml.xlxp.api.wbm.xpath.impl.predicates.PredicateLiteral;
import com.ibm.xml.xlxp.api.wbm.xpath.impl.predicates.PredicateOperator;
import com.ibm.xml.xlxp.api.wbm.xpath.impl.util.Copyright;
import com.ibm.xml.xlxp.api.wbm.xpath.impl.util.XMLStringHelper;
import com.ibm.xml.xlxp.scan.util.XMLString;

@Copyright(value="Licensed Materials - Property of IBM\nXLXP - Part of various IBM products\n\u00a9 Copyright IBM Corp. 2007. All Rights Reserved.\nUS Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.")
public abstract class ComparisonOperator
extends PredicateOperator {
    public ComparisonOperator(int n2) {
        super(n2);
    }

    public abstract PredicateLiteral compare(PredicateLiteral var1, PredicateLiteral var2);

    /*
     * Enabled aggressive block sorting
     */
    @Override
    public final PredicateLiteral evaluate(PredicateContext predicateContext) {
        PredicateLiteral predicateLiteral = this.getLeftChild().evaluate(predicateContext);
        PredicateLiteral predicateLiteral2 = this.getRightChild().evaluate(predicateContext);
        if (predicateLiteral == null || predicateLiteral2 == null) {
            return PredicateLiteral.FALSE;
        }
        if (predicateLiteral.getType() == predicateLiteral2.getType() && !predicateLiteral.isWildcard() && !predicateLiteral2.isWildcard()) {
            return this.compare(predicateLiteral, predicateLiteral2);
        }
        if (this.getLeftChild().getType() != 4) {
            if (this.getRightChild().getType() != 4) {
                return PredicateLiteral.FALSE;
            }
            if (!predicateLiteral2.isWildcard()) {
                this.changeType(predicateLiteral2, predicateLiteral2.getStringValue(), predicateLiteral.getType());
                return this.compare(predicateLiteral, predicateLiteral2);
            }
        } else {
            if (!predicateLiteral.isWildcard()) {
                this.changeType(predicateLiteral, predicateLiteral.getStringValue(), predicateLiteral2.getType());
                return this.compare(predicateLiteral, predicateLiteral2);
            }
            for (int i = 0; i < predicateLiteral.getString_values().size(); ++i) {
                this.changeType(predicateLiteral, predicateLiteral.getString_values().get(i), predicateLiteral2.getType());
                if (!this.compare(predicateLiteral, predicateLiteral2).getBooleanValue()) continue;
                return PredicateLiteral.TRUE;
            }
            return PredicateLiteral.FALSE;
        }
        for (int i = 0; i < predicateLiteral2.getString_values().size(); ++i) {
            this.changeType(predicateLiteral2, predicateLiteral2.getString_values().get(i), predicateLiteral.getType());
            if (!this.compare(predicateLiteral, predicateLiteral2).getBooleanValue()) continue;
            return PredicateLiteral.TRUE;
        }
        return PredicateLiteral.FALSE;
    }

    final void changeType(PredicateLiteral predicateLiteral, XMLString xMLString, int n2) {
        int[] nArray = new int[]{0};
        switch (n2) {
            case 2: {
                predicateLiteral.setType(2);
                if (xMLString.toString().equals("true")) {
                    predicateLiteral.setValue(true);
                    return;
                }
                predicateLiteral.setValue(false);
                return;
            }
            case 0: {
                predicateLiteral.setType(0);
                int n3 = XMLStringHelper.parseInt(xMLString, nArray);
                if (nArray[0] == 0) {
                    predicateLiteral.setValue(n3);
                    return;
                }
            }
            case 3: {
                predicateLiteral.setType(3);
                double d = XMLStringHelper.parseDouble(xMLString, nArray);
                if (nArray[0] != 0) {
                    predicateLiteral.setValue(Double.NaN);
                    return;
                }
                predicateLiteral.setValue(d);
                return;
            }
            case 1: {
                predicateLiteral.setType(1);
                predicateLiteral.setValue(xMLString);
                return;
            }
        }
    }
}

