/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xml.xlxp.api.wbm.xpath.impl;

import com.ibm.xml.xlxp.api.wbm.xpath.impl.XPathActualTransitionSymbol;
import com.ibm.xml.xlxp.api.wbm.xpath.impl.XPathAttributeInfo;
import com.ibm.xml.xlxp.api.wbm.xpath.impl.XPathAttributeInfoImpl;
import com.ibm.xml.xlxp.api.wbm.xpath.impl.XPathDFA;
import com.ibm.xml.xlxp.api.wbm.xpath.impl.XPathDFABuilder;
import com.ibm.xml.xlxp.api.wbm.xpath.impl.XPathQNameActualTransitionSymbol;
import com.ibm.xml.xlxp.api.wbm.xpath.impl.util.Copyright;
import com.ibm.xml.xlxp.finiteStateMachine.ActualTransitionSymbol;
import com.ibm.xml.xlxp.finiteStateMachine.State;
import com.ibm.xml.xlxp.finiteStateMachine.Transition;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Vector;

@Copyright(value="Licensed Materials - Property of IBM\nXLXP - Part of various IBM products\n\u00a9 Copyright IBM Corp. 2006, 2007. All Rights Reserved.\nUS Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.")
public class XPathDFAImpl
implements XPathDFA {
    private XPathDFA.FunctionName function = null;
    private int fId;
    private int fSymbolsCount;
    private XPathActualTransitionSymbol[] fSymbols;
    private HashSet[] fStateAttributes;
    private boolean[] fAllowMoreInput;
    private boolean[] fFinalStates;
    private int[][] fTransTable;
    private int fTransTableSize;
    private Object[] predicates;
    private Object[] text_symbols;
    private ArrayList[] finalSymbols;
    private XPathDFA nextDFA = null;
    private boolean debug = false;

    public XPathDFAImpl(int n2, List list, List list2, Object[] objectArray, Object[] objectArray2, XPathDFA.FunctionName functionName, Vector<XPathDFABuilder.PathInfo> vector) {
        this.fId = n2;
        this.predicates = objectArray;
        this.text_symbols = objectArray2;
        this.function = functionName;
        this.buildDFA(list, list2);
        if (this.debug) {
            this.printStates(list);
        }
    }

    @Override
    public void setNextDFA(XPathDFA xPathDFA) {
        this.nextDFA = xPathDFA;
    }

    @Override
    public XPathDFA getNextDFA() {
        return this.nextDFA;
    }

    private void printActiveSymbols(List list) {
        System.out.println("-- Active Symbols --");
        this.fSymbolsCount = list.size();
        for (int i = 0; i < this.fSymbolsCount; ++i) {
            XPathActualTransitionSymbol xPathActualTransitionSymbol = (XPathActualTransitionSymbol)list.get(i);
            System.out.print("symbol[" + i + "]=" + xPathActualTransitionSymbol.name);
            if (xPathActualTransitionSymbol.namespace != null) {
                System.out.print(" (qname=" + xPathActualTransitionSymbol.namespace + ")");
            }
            System.out.println();
        }
    }

    private void printStates(List list) {
        System.out.println("-- States --");
        Iterator iterator = list.iterator();
        int n2 = 0;
        while (iterator.hasNext()) {
            State state = (State)iterator.next();
            System.out.println("State[" + n2++ + "]" + ((Object)state).toString() + "isFInal?" + state.isFinalState());
        }
    }

    @Override
    public XPathDFA.FunctionName getFunction() {
        return this.function;
    }

    public void setId(int n2) {
        this.fId = n2;
    }

    @Override
    public int id() {
        return this.fId;
    }

    @Override
    public boolean isStateFinal(int n2) {
        if (n2 < this.fTransTableSize) {
            return this.fFinalStates[n2];
        }
        return false;
    }

    @Override
    public boolean isStateFinalA(int n2) {
        if (n2 < this.fTransTableSize) {
            return this.fStateAttributes[n2] != null;
        }
        return false;
    }

    @Override
    public boolean allowMoreInput(int n2) {
        if (n2 < this.fTransTableSize) {
            return this.fAllowMoreInput[n2];
        }
        return false;
    }

    @Override
    public XPathAttributeInfo[] attributes(int n2) {
        if (n2 < this.fTransTableSize && this.fStateAttributes[n2] != null) {
            XPathAttributeInfo[] xPathAttributeInfoArray = new XPathAttributeInfo[this.fStateAttributes[n2].size()];
            Iterator iterator = this.fStateAttributes[n2].iterator();
            int n3 = 0;
            while (iterator.hasNext()) {
                XPathActualTransitionSymbol xPathActualTransitionSymbol = (XPathActualTransitionSymbol)iterator.next();
                xPathAttributeInfoArray[n3++] = new XPathAttributeInfoImpl(xPathActualTransitionSymbol.namespace(), xPathActualTransitionSymbol.name(), 0);
            }
            return xPathAttributeInfoArray;
        }
        return null;
    }

    public ArrayList[] finalSymbolsToPath() {
        return this.finalSymbols;
    }

    @Override
    public ArrayList[] getPredicates() {
        ArrayList[] arrayListArray = new ArrayList[this.predicates.length];
        for (int i = 0; i < this.predicates.length; ++i) {
            arrayListArray[i] = (ArrayList)this.predicates[i];
            if (!this.debug || arrayListArray[i] == null) continue;
            System.out.println("Symbol[" + i + "] has " + arrayListArray[i].size() + " packages");
        }
        return arrayListArray;
    }

    @Override
    public Boolean[] getTextSymbols() {
        Boolean[] booleanArray = new Boolean[this.text_symbols.length];
        for (int i = 0; i < this.text_symbols.length; ++i) {
            booleanArray[i] = (Boolean)this.text_symbols[i];
        }
        return booleanArray;
    }

    @Override
    public int transition(int n2, String string2, String string3) {
        if (n2 < this.fTransTableSize) {
            for (int i = 0; i < this.fSymbolsCount; ++i) {
                XPathActualTransitionSymbol xPathActualTransitionSymbol = this.fSymbols[i];
                if (!xPathActualTransitionSymbol.allowElement(string2, string3 == null ? "" : string3)) continue;
                return this.fTransTable[n2][i];
            }
        }
        return 0;
    }

    @Override
    public int[][] transitionTable() {
        return this.fTransTable;
    }

    @Override
    public boolean[] allowMoreInput() {
        return this.fAllowMoreInput;
    }

    @Override
    public String[] transitionSymbols() {
        int n2 = 0;
        String[] stringArray = new String[this.fSymbolsCount * 2];
        for (int i = 0; i < this.fSymbolsCount; ++i) {
            XPathActualTransitionSymbol xPathActualTransitionSymbol = this.fSymbols[i];
            stringArray[n2++] = xPathActualTransitionSymbol.namespace;
            stringArray[n2++] = xPathActualTransitionSymbol.type == 1 ? xPathActualTransitionSymbol.name : null;
        }
        return stringArray;
    }

    @Override
    public XPathAttributeInfo[][] finalAttrDecls() {
        XPathAttributeInfo[][] xPathAttributeInfoArray = new XPathAttributeInfo[this.fTransTableSize][];
        for (int i = 0; i < this.fTransTableSize; ++i) {
            xPathAttributeInfoArray[i] = this.attributes(i);
        }
        return xPathAttributeInfoArray;
    }

    public String toString() {
        int n2;
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("\t");
        for (n2 = 0; n2 < this.fSymbolsCount; ++n2) {
            stringBuffer.append(this.fSymbols[n2].toString() + "\t\t");
        }
        stringBuffer.append("\n");
        for (n2 = 1; n2 < this.fTransTableSize; ++n2) {
            stringBuffer.append(n2);
            if (this.isStateFinal(n2) || this.isStateFinalA(n2)) {
                stringBuffer.append("*:\t");
            } else {
                stringBuffer.append(":\t");
            }
            for (int i = 0; i < this.fSymbolsCount; ++i) {
                stringBuffer.append("[" + n2 + "][" + i + "]" + this.fTransTable[n2][i] + "\t\t");
            }
            stringBuffer.append("\n");
        }
        return stringBuffer.toString();
    }

    private void buildDFA(List list, List list2) {
        this.buildSymbolsTable(list2);
        this.createTransitionTable(list.size() + 1);
        this.buildTransitionTable(list);
    }

    private void buildSymbolsTable(List list) {
        this.fSymbolsCount = list.size();
        this.fSymbols = new XPathActualTransitionSymbol[this.fSymbolsCount];
        for (int i = 0; i < this.fSymbolsCount; ++i) {
            this.fSymbols[i] = (XPathActualTransitionSymbol)list.get(i);
        }
    }

    private void createTransitionTable(int n2) {
        this.fTransTableSize = n2;
        this.fTransTable = new int[this.fTransTableSize][];
        this.fStateAttributes = new HashSet[this.fTransTableSize];
        this.fAllowMoreInput = new boolean[this.fTransTableSize];
        this.fFinalStates = new boolean[this.fTransTableSize];
        for (int i = 0; i < n2; ++i) {
            int[] nArray = new int[this.fSymbolsCount];
            for (int j = 0; j < this.fSymbolsCount; ++j) {
                nArray[j] = 0;
            }
            this.fTransTable[i] = nArray;
        }
    }

    private void buildTransitionTable(List list) {
        for (State state : list) {
            this.processState(state);
        }
        if (this.debug) {
            System.out.println(" ---- Table Before ---");
            System.out.println(this.toString());
        }
        this.finalizeStateFlags();
    }

    private void processState(State state) {
        Iterator iterator = state.transitions().iterator();
        int n2 = 1 + state.index();
        if (this.debug) {
            System.out.println("-- Buliding State[" + n2 + "]'s row --");
        }
        while (iterator.hasNext()) {
            int n3;
            Transition transition = (Transition)iterator.next();
            ActualTransitionSymbol actualTransitionSymbol = transition.transitionSymbol();
            if (this.debug) {
                n3 = 1 + transition.state().index();
                System.out.println(" \t - Processing Transition : (" + transition.transitionSymbol().toString() + "," + n3 + ")");
            }
            if (this.isAttributeSymbol(actualTransitionSymbol)) {
                this.addStateAttribute(state.index() + 1, (XPathActualTransitionSymbol)actualTransitionSymbol);
                if (!this.debug) continue;
                System.out.println("Found an attribute !");
                continue;
            }
            n3 = this.getSymbolIndex(actualTransitionSymbol);
            this.fTransTable[n2][n3] = transition.state().isFinalState() ? -(1 + transition.state().index()) : 1 + transition.state().index();
            if (this.debug) {
                System.out.println("Made the entry Table[" + n2 + "][" + n3 + "]=" + this.fTransTable[n2][n3]);
            }
            this.fAllowMoreInput[n2] = true;
        }
        if (state.isFinalState()) {
            this.fFinalStates[n2] = true;
        }
    }

    private int getSymbolIndex(Object object2) {
        int n2;
        for (n2 = 0; n2 < this.fSymbolsCount; ++n2) {
            if (this.fSymbols[n2] != object2) continue;
            return n2;
        }
        if (this.debug) {
            System.out.println("ERROR : Could not find Symbol " + object2);
            System.out.println("Debugging fSymbols table");
            for (n2 = 0; n2 < this.fSymbolsCount; ++n2) {
                System.out.println(this.fSymbols[n2]);
            }
        }
        return -1;
    }

    private boolean isAttributeSymbol(ActualTransitionSymbol actualTransitionSymbol) {
        return actualTransitionSymbol instanceof XPathQNameActualTransitionSymbol && ((XPathQNameActualTransitionSymbol)actualTransitionSymbol).isAttribute();
    }

    private void addStateAttribute(int n2, XPathActualTransitionSymbol xPathActualTransitionSymbol) {
        if (this.fStateAttributes[n2] == null) {
            this.fStateAttributes[n2] = new HashSet();
        }
        if (!this.overlappingAttrSymbol(xPathActualTransitionSymbol, this.fStateAttributes[n2])) {
            if (xPathActualTransitionSymbol.name == null) {
                this.removeOverlappedAttrs(this.fStateAttributes[n2], xPathActualTransitionSymbol);
            }
            this.fStateAttributes[n2].add(xPathActualTransitionSymbol);
        }
    }

    private void removeOverlappedAttrs(HashSet hashSet, XPathActualTransitionSymbol xPathActualTransitionSymbol) {
        Object[] objectArray = hashSet.toArray();
        for (int i = 0; i < objectArray.length; ++i) {
            XPathActualTransitionSymbol xPathActualTransitionSymbol2 = (XPathActualTransitionSymbol)objectArray[i];
            if (xPathActualTransitionSymbol.namespace != null && !xPathActualTransitionSymbol.namespace.equals(xPathActualTransitionSymbol2.namespace)) continue;
            hashSet.remove(xPathActualTransitionSymbol2);
        }
    }

    private boolean overlappingAttrSymbol(XPathActualTransitionSymbol xPathActualTransitionSymbol, HashSet hashSet) {
        Object[] objectArray = hashSet.toArray();
        for (int i = 0; i < objectArray.length; ++i) {
            XPathActualTransitionSymbol xPathActualTransitionSymbol2 = (XPathActualTransitionSymbol)objectArray[i];
            if (xPathActualTransitionSymbol2.name != null || xPathActualTransitionSymbol2.namespace != null && !xPathActualTransitionSymbol2.namespace.equals(xPathActualTransitionSymbol.namespace)) continue;
            return true;
        }
        return false;
    }

    private void finalizeStateFlags() {
        for (int i = this.fTransTableSize - 1; i >= 1 && !this.isStateReferenced(i); --i) {
            if (this.fTransTableSize <= 2) continue;
            --this.fTransTableSize;
        }
        if (this.fTransTableSize != this.fTransTable.length) {
            this.compressTransitionTable();
        }
    }

    private void compressTransitionTable() {
        if (this.debug) {
            System.out.println(" ---- Table Before ---");
            System.out.println(this.toString());
        }
        int[][] nArrayArray = new int[this.fTransTableSize][];
        boolean[] blArray = new boolean[this.fTransTableSize];
        System.arraycopy(this.fAllowMoreInput, 0, blArray, 0, this.fTransTableSize);
        for (int i = 0; i < this.fTransTableSize; ++i) {
            int[] nArray = new int[this.fSymbolsCount];
            System.arraycopy(this.fTransTable[i], 0, nArray, 0, this.fSymbolsCount);
            nArrayArray[i] = nArray;
        }
        this.fTransTable = nArrayArray;
        this.fAllowMoreInput = blArray;
        if (this.debug) {
            System.out.println(" ---- Table After ---");
            System.out.println(this.toString());
        }
    }

    private boolean isStateReferenced(int n2) {
        for (int i = 1; i < n2; ++i) {
            for (int j = 0; j < this.fSymbolsCount; ++j) {
                if (n2 != Math.abs(this.fTransTable[i][j])) continue;
                return true;
            }
        }
        return false;
    }
}

