/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xml.xlxp.api.wbm.xpath;

import com.ibm.xml.xlxp.api.wbm.xpath.impl.util.Copyright;
import com.ibm.xml.xlxp.scan.util.DataBuffer;
import com.ibm.xml.xlxp.scan.util.XMLString;
import java.io.IOException;
import java.io.InputStream;
import java.io.Writer;

@Copyright(value="Licensed Materials - Property of IBM\nXLXP - Part of various IBM products\n\u00a9 Copyright IBM Corp. 2002, 2006, 2007. All Rights Reserved.\nUS Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.")
final class XMLStringStream
extends InputStream {
    private final XMLString fContent;
    private DataBuffer fDataBuffer;
    private DataBuffer fLastBuffer;
    private int fDataOffset;
    private int fDataLength;
    private int fLastOffset;

    public XMLStringStream(XMLString xMLString) {
        this.fContent = xMLString;
    }

    public void writeTo(Writer writer) throws IOException {
        int n2;
        char[][] cArrayArray = new char[1][];
        int[] nArray = new int[1];
        for (n2 = 8; n2 < this.fContent.length; n2 <<= 1) {
        }
        cArrayArray[0] = new char[n2];
        this.fContent.getChars((char[][])cArrayArray, nArray);
        writer.write(cArrayArray[0], 0, nArray[0]);
    }

    public String toString() {
        return this.fContent.toString();
    }

    private void prepareForReading() {
        this.fDataBuffer = this.fContent.firstBuffer;
        this.fDataLength = this.fContent.length;
        this.fDataOffset = this.fContent.startOffset;
        if (this.fContent.bytes != null) {
            this.fLastBuffer = this.fDataBuffer;
            this.fLastOffset = this.fContent.endOffset;
        } else {
            this.fLastBuffer = this.fContent.lastBuffer;
            this.fLastOffset = this.fDataBuffer.endOffset;
        }
    }

    @Override
    public int available() {
        if (this.fDataBuffer == null) {
            this.prepareForReading();
        }
        return this.fDataLength;
    }

    @Override
    public int read() {
        if (this.fDataBuffer == null) {
            this.prepareForReading();
        }
        while (true) {
            if (this.fDataOffset < this.fLastOffset) {
                --this.fDataLength;
                return this.fDataBuffer.bytes[this.fDataOffset++] & 0xFF;
            }
            if (this.fDataLength <= 0) break;
            this.fDataBuffer = this.fDataBuffer.next;
            this.fDataOffset = this.fDataBuffer.startOffset;
            if (this.fDataBuffer == this.fLastBuffer) {
                this.fLastOffset = this.fContent.endOffset;
                continue;
            }
            this.fLastOffset = this.fDataBuffer.endOffset;
        }
        return -1;
    }

    @Override
    public int read(byte[] byArray, int n2, int n3) {
        int n4 = 0;
        if (this.fDataBuffer == null) {
            this.prepareForReading();
        }
        while (this.fDataLength > 0) {
            int n5 = this.fLastOffset - this.fDataOffset;
            if (n5 > n3) {
                n5 = n3;
            }
            System.arraycopy(this.fDataBuffer.bytes, this.fDataOffset, byArray, n2, n5);
            this.fDataOffset += n5;
            this.fDataLength -= n5;
            n4 += n5;
            if (n5 < n3 && this.fDataLength > 0) {
                n2 += n5;
                n3 -= n5;
                this.fDataBuffer = this.fDataBuffer.next;
                this.fDataOffset = this.fDataBuffer.startOffset;
                if (this.fDataBuffer == this.fLastBuffer) {
                    this.fLastOffset = this.fContent.endOffset;
                    continue;
                }
                this.fLastOffset = this.fDataBuffer.endOffset;
                continue;
            }
            return n4;
        }
        return n4 > 0 ? n4 : -1;
    }
}

