/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xml.xlxp.api.wbm.xpath;

import com.ibm.xml.xlxp.api.wbm.xpath.AggregateFunction;
import com.ibm.xml.xlxp.api.wbm.xpath.XPathResultHandler;
import com.ibm.xml.xlxp.api.wbm.xpath.impl.util.Copyright;
import com.ibm.xml.xlxp.scan.util.XMLString;

@Copyright(value="Licensed Materials - Property of IBM\nXLXP - Part of various IBM products\n\u00a9 Copyright IBM Corp. 2007. All Rights Reserved.\nUS Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.")
final class CountFunction
implements AggregateFunction {
    private final int xpathID;
    private long count;

    public CountFunction(int n2) {
        this.xpathID = n2;
    }

    @Override
    public void reset() {
        this.count = 0L;
    }

    @Override
    public void element() {
        ++this.count;
    }

    @Override
    public void attribute(XMLString xMLString) {
        ++this.count;
    }

    @Override
    public void textBeforeComment(XMLString xMLString, boolean bl) {
        if (!bl && xMLString.length > 0) {
            ++this.count;
        }
    }

    @Override
    public void textBeforeProcessingInstruction(XMLString xMLString, boolean bl) {
        if (!bl && xMLString.length > 0) {
            ++this.count;
        }
    }

    @Override
    public void textBeforeStartTag(XMLString xMLString, boolean bl) {
        if (!bl && xMLString.length > 0) {
            ++this.count;
        }
    }

    @Override
    public void textBeforeEmptyTag(XMLString xMLString, boolean bl) {
        if (!bl && xMLString.length > 0) {
            ++this.count;
        }
    }

    @Override
    public void textBeforeEndTag(XMLString xMLString, boolean bl) {
        if (bl || xMLString.length > 0) {
            ++this.count;
        }
    }

    @Override
    public void writeResult(XPathResultHandler xPathResultHandler) {
        xPathResultHandler.longValue(this.xpathID, this.count);
    }
}

