/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xml.xci.xlxp.cdata;

import com.ibm.xml.ras.LoggerUtil;
import com.ibm.xml.xci.CData;
import com.ibm.xml.xci.bytes.Bytes;
import com.ibm.xml.xci.bytes.BytesUtils;
import com.ibm.xml.xci.dp.util.XCIErrorHelper;
import com.ibm.xml.xci.dp.values.ArrayCData;
import com.ibm.xml.xci.dp.values.BaseCData;
import com.ibm.xml.xci.dp.values.LazyBaseCData;
import com.ibm.xml.xci.dp.values.chars.Chars;
import com.ibm.xml.xci.errors.XCIDynamicErrorException;
import com.ibm.xml.xci.internal.values.Base64BinaryCData;
import com.ibm.xml.xci.internal.values.BigDecimalCData;
import com.ibm.xml.xci.internal.values.BigIntegerCData;
import com.ibm.xml.xci.internal.values.BooleanCData;
import com.ibm.xml.xci.internal.values.ByteCData;
import com.ibm.xml.xci.internal.values.DoubleCData;
import com.ibm.xml.xci.internal.values.DurationCData;
import com.ibm.xml.xci.internal.values.FloatCData;
import com.ibm.xml.xci.internal.values.HexBinaryCData;
import com.ibm.xml.xci.internal.values.IntCData;
import com.ibm.xml.xci.internal.values.LongCData;
import com.ibm.xml.xci.internal.values.QNameCData;
import com.ibm.xml.xci.internal.values.StoredCharsCData;
import com.ibm.xml.xci.internal.values.StringCData;
import com.ibm.xml.xci.internal.values.URICData;
import com.ibm.xml.xci.internal.values.XMLGregorianCalendarCData;
import com.ibm.xml.xci.res.XCIMessages;
import com.ibm.xml.xlxp.internal.s1.datatype.XBinary;
import com.ibm.xml.xlxp.internal.s1.datatype.XDecimal;
import com.ibm.xml.xlxp.internal.s1.datatype.validation.BooleanDV;
import com.ibm.xml.xlxp.internal.s1.datatype.validation.DecimalDV;
import com.ibm.xml.xlxp.internal.s1.datatype.validation.DoubleDV;
import com.ibm.xml.xlxp.internal.s1.datatype.validation.FloatDV;
import com.ibm.xml.xlxp.internal.s1.datatype.validation.IntegerDV;
import com.ibm.xml.xlxp.internal.s1.datatype.validation.XSBase64BinaryUtil;
import com.ibm.xml.xlxp.internal.s1.datatype.validation.XSHexBinaryUtil;
import com.ibm.xml.xlxp.internal.s1.datatype.validation.XSIntegerUtil;
import com.ibm.xml.xlxp.internal.s1.scan.Copyright;
import com.ibm.xml.xlxp.internal.s1.scan.util.ArrayAllocator;
import com.ibm.xml.xlxp.internal.s1.scan.util.CharConversionError;
import com.ibm.xml.xlxp.internal.s1.scan.util.DataBuffer;
import com.ibm.xml.xlxp.internal.s1.scan.util.NullDataBufferFactory;
import com.ibm.xml.xlxp.internal.s1.scan.util.UTF8Support;
import com.ibm.xml.xlxp.internal.s1.scan.util.XMLString;
import com.ibm.xml.xml4j.api.s1.xs.XSSimpleTypeDefinition;
import java.io.IOException;
import java.io.OutputStream;
import java.io.Writer;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.namespace.NamespaceContext;
import javax.xml.namespace.QName;
import org.w3c.dom.DOMErrorHandler;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Copyright(value="Licensed Materials - Property of IBM\nXL XML Processor for Java (XLXP-J) - Part of various IBM products\n\u00a9 Copyright IBM Corp. 2009. All Rights Reserved.\nUS Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.")
public final class XMLStringCData
extends LazyBaseCData {
    private static final Logger logger = LoggerUtil.getLogger(XMLStringCData.class);
    public byte[] bytes;
    public int startOffset;
    public int endOffset;
    public int length;
    public short flags;
    public short encodeFlags;
    public DataBuffer firstBuffer;
    public DataBuffer lastBuffer;
    protected String string;
    protected char[][] fConvertedChars;
    protected int[] fConvertedCharsOffset;
    private boolean isConstant;
    private QName myQName;
    private DOMErrorHandler errorHandler;

    protected XMLStringCData(XMLString xMLString, XSSimpleTypeDefinition xSSimpleTypeDefinition, NamespaceContext namespaceContext, DOMErrorHandler dOMErrorHandler) {
        this(xSSimpleTypeDefinition, xMLString.bytes, xMLString.startOffset, xMLString.endOffset, xMLString.length, xMLString.flags, xMLString.encodeFlags, xMLString.firstBuffer, xMLString.lastBuffer, namespaceContext, dOMErrorHandler);
    }

    protected XMLStringCData(XSSimpleTypeDefinition xSSimpleTypeDefinition, byte[] byArray, int n2, int n3, int n4, short s, short s2, DataBuffer dataBuffer, DataBuffer dataBuffer2, NamespaceContext namespaceContext, DOMErrorHandler dOMErrorHandler) {
        super(xSSimpleTypeDefinition);
        this.setValues(xSSimpleTypeDefinition, byArray, n2, n3, n4, s, s2, dataBuffer, dataBuffer2, namespaceContext, dOMErrorHandler);
    }

    @Override
    protected CData parse() {
        String string2;
        XMLString xMLString;
        boolean bl;
        block45: {
            bl = LoggerUtil.isAnyTracingEnabled();
            if (bl && logger.isLoggable(Level.FINER)) {
                logger.logp(Level.FINER, logger.getName(), "parse", "entering XMLStringCData.parse");
            }
            if (this.xstype.getBuiltInKind() == 19) {
                this.typedValue = new QNameCData(this.myQName, this.xstype);
                return this.typedValue;
            }
            xMLString = this.makeXMLString();
            string2 = null;
            int[] nArray = ArrayAllocator.newIntArray(1);
            try {
                switch (this.xstype.getBuiltInKind()) {
                    case 3: {
                        Boolean bl2 = BooleanDV.parseBoolean(xMLString);
                        if (bl2 != null) {
                            this.typedValue = new BooleanCData(bl2, this.xstype);
                        }
                        break;
                    }
                    case 36: {
                        byte by2 = XSIntegerUtil.parseByte(xMLString, nArray);
                        if (nArray[0] == 0) {
                            this.typedValue = new ByteCData(by2, this.xstype);
                        }
                        break;
                    }
                    case 34: 
                    case 35: 
                    case 40: 
                    case 41: {
                        int n2 = XSIntegerUtil.parseInt(xMLString, nArray);
                        if (nArray[0] == 0) {
                            this.typedValue = new IntCData(n2, this.xstype);
                        }
                        break;
                    }
                    case 33: 
                    case 39: {
                        long l = XSIntegerUtil.parseLong(xMLString, nArray);
                        if (nArray[0] == 0) {
                            this.typedValue = new LongCData(l, this.xstype);
                        }
                        break;
                    }
                    case 5: {
                        float f2 = FloatDV.parse(xMLString, nArray);
                        if (nArray[0] == 0) {
                            this.typedValue = new FloatCData(f2, this.xstype);
                        }
                        break;
                    }
                    case 6: {
                        double d = DoubleDV.parse(xMLString, nArray);
                        if (nArray[0] == 0) {
                            this.typedValue = new DoubleCData(d, this.xstype);
                        }
                        break;
                    }
                    case 4: {
                        XDecimal xDecimal = DecimalDV.parse(xMLString);
                        if (xDecimal != null) {
                            this.typedValue = new BigDecimalCData(new BigDecimal(xDecimal.toString()), this.xstype);
                        }
                        break;
                    }
                    case 30: 
                    case 31: 
                    case 32: 
                    case 37: 
                    case 38: 
                    case 42: {
                        XDecimal xDecimal = IntegerDV.parse(xMLString);
                        if (xDecimal != null) {
                            this.typedValue = new BigIntegerCData(new BigInteger(xDecimal.toString()), this.xstype);
                        }
                        break;
                    }
                    case 17: {
                        XBinary xBinary = XSBase64BinaryUtil.parseBase64Binary(xMLString);
                        if (xBinary != null) {
                            Bytes bytes2 = BytesUtils.make(xBinary.value, 0L, (long)xBinary.length);
                            this.typedValue = new Base64BinaryCData(bytes2, this.xstype);
                        }
                        break;
                    }
                    case 16: {
                        XBinary xBinary = XSHexBinaryUtil.parseHexBinary(xMLString);
                        if (xBinary != null) {
                            Bytes bytes3 = BytesUtils.make(xBinary.value, 0L, (long)xBinary.length);
                            this.typedValue = new HexBinaryCData(bytes3, this.xstype);
                        }
                        break;
                    }
                    case 18: {
                        string2 = this.toString();
                        if (string2 != null) {
                            try {
                                URI uRI = new URI(string2);
                                this.typedValue = new URICData(uRI, this.xstype);
                            }
                            catch (URISyntaxException uRISyntaxException) {}
                        }
                        break;
                    }
                    case 2: 
                    case 20: 
                    case 21: 
                    case 22: 
                    case 23: 
                    case 24: 
                    case 25: 
                    case 26: 
                    case 27: 
                    case 28: 
                    case 29: 
                    case 50: {
                        string2 = this.toString();
                        if (string2 != null) {
                            this.typedValue = new StringCData(string2, this.xstype);
                        }
                        break;
                    }
                    case 7: {
                        string2 = this.toString();
                        if (string2 != null) {
                            this.typedValue = new DurationCData(BaseCData.javaxFactory.newDuration(string2), this.xstype);
                        }
                        break;
                    }
                    case 46: {
                        string2 = this.toString();
                        if (string2 != null) {
                            this.typedValue = new DurationCData(BaseCData.javaxFactory.newDurationYearMonth(string2), this.xstype);
                        }
                        break;
                    }
                    case 47: {
                        string2 = this.toString();
                        if (string2 != null) {
                            this.typedValue = new DurationCData(BaseCData.javaxFactory.newDurationDayTime(string2), this.xstype);
                        }
                        break;
                    }
                    case 8: 
                    case 9: 
                    case 10: 
                    case 11: 
                    case 12: 
                    case 13: 
                    case 14: 
                    case 15: {
                        string2 = this.toString();
                        if (string2 != null) {
                            this.typedValue = new XMLGregorianCalendarCData(BaseCData.javaxFactory.newXMLGregorianCalendar(string2), this.xstype);
                        }
                        break;
                    }
                    default: {
                        string2 = this.toString();
                        if (string2 != null) {
                            this.typedValue = new StoredCharsCData(this, this.xstype);
                        }
                        break;
                    }
                }
            }
            catch (Exception exception) {
                XCIDynamicErrorException xCIDynamicErrorException;
                XCIErrorHelper.XCIErrorImpl xCIErrorImpl;
                if (bl && logger.isLoggable(Level.FINER)) {
                    logger.logp(Level.FINER, logger.getName(), "parse", "Encountered an exception while parsing the XMLString=" + this.toString() + " against type=" + this.xstype.toString());
                }
                if (this.errorHandler.handleError(xCIErrorImpl = new XCIErrorHelper.XCIErrorImpl(xCIDynamicErrorException = new XCIDynamicErrorException(exception), 1))) break block45;
                throw xCIDynamicErrorException;
            }
        }
        if (this.typedValue == null) {
            if (bl && logger.isLoggable(Level.FINER)) {
                logger.logp(Level.FINER, logger.getName(), "parse", "Could not transform the data=" + this.toString() + " to match the type=" + this.xstype.toString());
            }
            string2 = this.toString();
            this.typedValue = new StoredCharsCData(this, this.xstype);
        }
        xMLString.unregister();
        xMLString = null;
        assert (this.typedValue != null);
        return this.typedValue;
    }

    @Override
    public boolean isConstant() {
        return this.isConstant;
    }

    @Override
    public CData constant(boolean bl) {
        if (!this.isConstant) {
            int n2;
            Object object2;
            DataBuffer dataBuffer = this.firstBuffer;
            byte[] byArray = this.bytes;
            this.bytes = new byte[this.length];
            if (byArray != null) {
                System.arraycopy(byArray, this.startOffset, this.bytes, 0, this.length);
            } else {
                int n3;
                object2 = dataBuffer;
                n2 = this.startOffset;
                int n4 = 0;
                while (object2 != this.lastBuffer) {
                    n3 = ((DataBuffer)object2).endOffset - n2;
                    System.arraycopy(((DataBuffer)object2).bytes, n2, this.bytes, n4, n3);
                    n4 += n3;
                    object2 = ((DataBuffer)object2).next;
                    n2 = ((DataBuffer)object2).startOffset;
                }
                n3 = this.endOffset - ((DataBuffer)object2).startOffset;
                System.arraycopy(((DataBuffer)object2).bytes, n2, this.bytes, n4, n3);
            }
            this.startOffset = 0;
            this.endOffset = this.bytes.length;
            this.length = this.bytes.length;
            this.firstBuffer = null;
            this.lastBuffer = null;
            this.isConstant = true;
            if (this.isListType()) {
                object2 = (ArrayCData)this.typedValue;
                for (n2 = 1; n2 <= ((ArrayCData)object2).getSize(); ++n2) {
                    ((ArrayCData)object2).itemAt(n2).constant(bl);
                }
            }
        }
        return this;
    }

    private boolean isListType() {
        return this.xstype != null && this.xstype.getVariety() == 2;
    }

    @Override
    public String toString() {
        if (this.string == null) {
            CharConversionError charConversionError = this.convertToChars();
            this.string = charConversionError == null ? new String(this.fConvertedChars[0], 0, this.fConvertedCharsOffset[0]) : null;
        }
        return this.string;
    }

    @Override
    public int writeTo(Writer writer, boolean bl) throws IOException {
        String string2 = this.toString();
        writer.write(string2);
        return string2.length();
    }

    @Override
    public int writeEncodedBytesTo(int n2, byte[] byArray, int n3, String string2, short s, boolean bl) {
        if (Chars.UTF8.name().equals(string2)) {
            if (this.bytes == null) {
                if (n2 >= this.length) {
                    return 0;
                }
                DataBuffer dataBuffer = this.firstBuffer;
                int n4 = 0;
                int n5 = (dataBuffer == this.lastBuffer ? this.endOffset : dataBuffer.endOffset) - this.startOffset;
                while (n2 >= n4 + n5) {
                    n4 += n5;
                    dataBuffer = dataBuffer.next;
                    n5 = (dataBuffer == this.lastBuffer ? this.endOffset : dataBuffer.endOffset) - dataBuffer.startOffset;
                }
                n4 = n2 - n4 + (dataBuffer == this.firstBuffer ? this.startOffset : dataBuffer.startOffset);
                int n6 = n3;
                n5 = Math.min((dataBuffer == this.lastBuffer ? this.endOffset : dataBuffer.endOffset) - n4, byArray.length - n6);
                while (n5 > 0) {
                    System.arraycopy(dataBuffer.bytes, n4, byArray, n6, n5);
                    n6 += n5;
                    if (dataBuffer == this.lastBuffer) break;
                    dataBuffer = dataBuffer.next;
                    n4 = dataBuffer.startOffset;
                    n5 = Math.min((dataBuffer == this.lastBuffer ? this.endOffset : dataBuffer.endOffset) - (dataBuffer == this.firstBuffer ? this.startOffset : dataBuffer.startOffset), byArray.length - n6);
                }
                return n6 - n3;
            }
            int n7 = Math.min(this.endOffset - this.startOffset - n2, byArray.length - n3);
            System.arraycopy(this.bytes, n2 + this.startOffset, byArray, n3, n7);
            return n7;
        }
        return super.writeEncodedBytesTo(n2, byArray, n3, string2, s, bl);
    }

    @Override
    public Bytes toEncodedBytes(String string2) {
        if (Chars.UTF8.name().equals(string2)) {
            if (this.bytes == null) {
                return BytesUtils.make(this.toString().getBytes());
            }
            return BytesUtils.make(this.bytes, (long)this.startOffset, (long)this.endOffset);
        }
        return super.toEncodedBytes(string2);
    }

    @Override
    public void writeEncodedBytesTo(OutputStream outputStream, String string2, short s, boolean bl) throws IOException {
        if (Chars.UTF8.name().equals(string2) && !this.mayContain(s)) {
            if (this.bytes == null) {
                outputStream.write(this.firstBuffer.bytes, this.startOffset, this.firstBuffer.endOffset);
                DataBuffer dataBuffer = this.firstBuffer.next;
                while (dataBuffer != this.lastBuffer) {
                    outputStream.write(dataBuffer.bytes, dataBuffer.startOffset, dataBuffer.endOffset);
                    dataBuffer = dataBuffer.next;
                }
                outputStream.write(this.lastBuffer.bytes, this.lastBuffer.startOffset, this.endOffset);
            } else {
                outputStream.write(this.bytes, this.startOffset, this.length);
            }
        } else {
            this.toEncodedBytes(string2).writeBytesTo(outputStream, bl);
        }
    }

    public void clear() {
        this.string = null;
        this.typedValue = null;
        this.firstBuffer = null;
        this.lastBuffer = null;
        this.bytes = null;
        this.startOffset = 0;
        this.endOffset = 0;
        this.length = 0;
        this.flags = 0;
        this.isConstant = false;
    }

    protected void setValues(XMLString xMLString, XSSimpleTypeDefinition xSSimpleTypeDefinition, NamespaceContext namespaceContext, DOMErrorHandler dOMErrorHandler) {
        this.setValues(xSSimpleTypeDefinition, xMLString.bytes, xMLString.startOffset, xMLString.endOffset, xMLString.length, xMLString.flags, xMLString.encodeFlags, xMLString.firstBuffer, xMLString.lastBuffer, namespaceContext, dOMErrorHandler);
    }

    protected void setValues(XSSimpleTypeDefinition xSSimpleTypeDefinition, byte[] byArray, int n2, int n3, int n4, short s, short s2, DataBuffer dataBuffer, DataBuffer dataBuffer2, NamespaceContext namespaceContext, DOMErrorHandler dOMErrorHandler) {
        this.xstype = xSSimpleTypeDefinition;
        this.bytes = byArray;
        this.startOffset = n2;
        this.endOffset = n3;
        this.length = n4;
        this.flags = s;
        this.encodeFlags = s2;
        this.firstBuffer = dataBuffer;
        this.lastBuffer = dataBuffer2;
        this.isConstant = false;
        this.errorHandler = dOMErrorHandler;
        if (this.xstype.getBuiltInKind() == 19 || this.xstype.getBuiltInKind() == 20) {
            this.processQName(this.toString(), namespaceContext);
            if (this.myQName == null) {
                XCIDynamicErrorException xCIDynamicErrorException = new XCIDynamicErrorException(XCIMessages.createXCIMessage("ER_NONAMESPACEINCONTEXT", new String[]{this.toString()}));
                XCIErrorHelper.XCIErrorImpl xCIErrorImpl = new XCIErrorHelper.XCIErrorImpl(xCIDynamicErrorException, 1);
                if (!dOMErrorHandler.handleError(xCIErrorImpl)) {
                    throw xCIDynamicErrorException;
                }
                this.typedValue = new StoredCharsCData(this, this.xstype);
            }
        } else {
            this.myQName = null;
        }
    }

    public CharConversionError getChars(char[][] cArray, int[] nArray) {
        this.checkBuffer();
        if ((this.flags & 0xC) != 0) {
            return UTF8Support.normalizeBytesToChars(this.firstBuffer, this.lastBuffer, this.startOffset, this.endOffset, cArray, nArray, (this.flags & 8) != 0);
        }
        return UTF8Support.convertBytesToChars(this.firstBuffer, this.lastBuffer, this.startOffset, this.endOffset, cArray, nArray);
    }

    private XMLString makeXMLString() {
        this.checkBuffer();
        XMLString xMLString = new XMLString();
        xMLString.setValues(this.firstBuffer, this.lastBuffer, this.startOffset, this.endOffset);
        xMLString.flags = this.flags;
        return xMLString;
    }

    private void checkBuffer() {
        if (this.firstBuffer == null) {
            this.firstBuffer = NullDataBufferFactory.createNewBuffer();
            this.firstBuffer.bytes = this.bytes;
            this.firstBuffer.startOffset = this.startOffset;
            this.firstBuffer.endOffset = this.endOffset;
            this.lastBuffer = this.firstBuffer;
        }
    }

    protected final CharConversionError convertToChars() {
        if (this.fConvertedChars == null) {
            int n2;
            for (n2 = 16; n2 < this.length; n2 <<= 1) {
            }
            this.fConvertedChars = new char[1][];
            this.fConvertedChars[0] = new char[n2];
            this.fConvertedCharsOffset = new int[1];
        }
        this.fConvertedCharsOffset[0] = 0;
        return this.getChars(this.fConvertedChars, this.fConvertedCharsOffset);
    }

    @Override
    public CharSequence getOriginalLexicalValue() {
        return this.toString();
    }

    public String getLexicalValue() {
        return this.toString();
    }

    public void processQName(String string2, NamespaceContext namespaceContext) {
        boolean bl = LoggerUtil.isAnyTracingEnabled();
        if (namespaceContext == null) {
            if (bl && logger.isLoggable(Level.FINER)) {
                logger.logp(Level.FINER, logger.getName(), "processQName", "namespace context was NULL when processing QName:" + string2);
            }
            return;
        }
        this.myQName = null;
        int n2 = string2.indexOf(58);
        String string3 = n2 == -1 ? "" : string2.substring(0, n2);
        String string4 = string2.substring(n2 + 1);
        String string5 = namespaceContext.getNamespaceURI(string3);
        if (string5 != null) {
            this.myQName = new QName(string5, string4, string3);
            return;
        }
        if (n2 == -1) {
            this.myQName = new QName("", string4, "");
            return;
        }
        if (bl && logger.isLoggable(Level.FINER)) {
            logger.logp(Level.FINER, logger.getName(), "processQName", "Prefix={" + string3 + "} was not bound to any URI. inside qname=" + string2);
        }
    }

    public void buildList(List<CData> list) {
        if (LoggerUtil.isAnyTracingEnabled() && logger.isLoggable(Level.FINER)) {
            logger.logp(Level.FINER, logger.getName(), "buildList", "Building a list of CDatas for the content=" + this.toString());
        }
        CData[] cDataArray = new CData[list.size()];
        cDataArray = list.toArray(cDataArray);
        this.typedValue = new ArrayCData(cDataArray, this.xstype);
    }

    private boolean checkWhitespace() {
        boolean bl;
        boolean bl2 = bl = (this.flags & 8) != 0;
        if (this.length > 0) {
            int n2 = this.startOffset;
            if (this.bytes != null) {
                while (n2 < this.endOffset) {
                    byte by2;
                    if ((by2 = this.bytes[n2++]) == 32 || by2 == 10 || by2 == 9 || by2 == 13) continue;
                    if (bl && (by2 & 0xDF) == 194) {
                        if (n2 == this.endOffset) {
                            this.flags = (short)(this.flags | 1);
                            return false;
                        }
                        if ((by2 & 0xFF) == 194 && (this.bytes[n2] & 0xFF) == 133) {
                            ++n2;
                            continue;
                        }
                        if ((by2 & 0xFF) != 226 || (this.bytes[n2] & 0xFF) != 128) continue;
                        if (n2 + 1 < this.endOffset) {
                            if ((this.bytes[n2 + 1] & 0xFF) != 168) continue;
                            n2 += 2;
                            continue;
                        }
                        this.flags = (short)(this.flags | 1);
                        return false;
                    }
                    this.flags = (short)(this.flags | 1);
                    return false;
                }
            } else {
                DataBuffer dataBuffer = this.firstBuffer;
                byte[] byArray = dataBuffer.bytes;
                int n3 = dataBuffer.endOffset;
                while (true) {
                    if (n2 < n3) {
                        byte by3;
                        if ((by3 = byArray[n2++]) == 32 || by3 == 10 || by3 == 9 || by3 == 13) continue;
                        if (bl && (by3 & 0xDF) == 194) {
                            if (n2 == n3) {
                                if (dataBuffer == this.lastBuffer) {
                                    this.flags = (short)(this.flags | 1);
                                    return false;
                                }
                                dataBuffer = dataBuffer.next;
                                byArray = dataBuffer.bytes;
                                n2 = dataBuffer.startOffset;
                                int n4 = n3 = dataBuffer == this.lastBuffer ? this.endOffset : dataBuffer.endOffset;
                            }
                            if ((by3 & 0xFF) == 194 && (byArray[n2] & 0xFF) == 133) {
                                ++n2;
                                continue;
                            }
                            if ((by3 & 0xFF) != 226 || (byArray[n2] & 0xFF) != 128) continue;
                            if (n2 + 1 < n3) {
                                if ((byArray[n2 + 1] & 0xFF) != 168) continue;
                                n2 += 2;
                                continue;
                            }
                            if (dataBuffer != this.lastBuffer && (dataBuffer.next.bytes[dataBuffer.next.startOffset] & 0xFF) == 168) {
                                dataBuffer = dataBuffer.next;
                                byArray = dataBuffer.bytes;
                                n2 = dataBuffer.startOffset + 1;
                                n3 = dataBuffer == this.lastBuffer ? this.endOffset : dataBuffer.endOffset;
                                continue;
                            }
                            this.flags = (short)(this.flags | 1);
                            return false;
                        }
                        this.flags = (short)(this.flags | 1);
                        return false;
                    }
                    if (dataBuffer == this.lastBuffer) break;
                    dataBuffer = dataBuffer.next;
                    byArray = dataBuffer.bytes;
                    n2 = dataBuffer.startOffset;
                    if (dataBuffer == this.lastBuffer) {
                        n3 = this.endOffset;
                        continue;
                    }
                    n3 = dataBuffer.endOffset;
                }
            }
        }
        this.flags = (short)(this.flags | 2);
        return true;
    }

    @Override
    public boolean isEmpty() {
        return this.length <= 0;
    }

    @Override
    public int length() {
        return this.toString().length();
    }

    @Override
    public char charAt(int n2) {
        return this.toString().charAt(n2);
    }

    @Override
    public boolean isSpace() {
        if ((this.flags & 2) != 0) {
            return true;
        }
        if ((this.flags & 1) != 0) {
            return false;
        }
        return this.checkWhitespace();
    }

    @Override
    public boolean mayContain(short s) {
        int n2 = this.encodeFlags != 0 ? (int)this.encodeFlags : -1;
        return (s & n2) != 0;
    }

    @Override
    public int appendQuotedTo(Appendable appendable, short s, boolean bl) throws IOException {
        assert (!this.mayContain(s));
        appendable.append(this);
        return this.length();
    }
}

