/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xml.xci.xlxp;

import com.ibm.xml.xci.ExtendedNamespaceContext;
import com.ibm.xml.xlxp.internal.s1.scan.Copyright;
import com.ibm.xml.xlxp.internal.s1.scan.DocumentScanner;
import com.ibm.xml.xlxp.internal.s1.scan.util.SymbolTable;
import java.util.Arrays;
import java.util.Iterator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Copyright(value="Licensed Materials - Property of IBM\nXL XML Processor for Java (XLXP-J) - Part of various IBM products\n\u00a9 Copyright IBM Corp. 2009. All Rights Reserved.\nUS Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.")
public class NamespaceContextAdapter
implements ExtendedNamespaceContext {
    protected final DocumentScanner nscontext;
    protected final SymbolTable symbolTable;

    public NamespaceContextAdapter(DocumentScanner documentScanner, SymbolTable symbolTable) {
        this.nscontext = documentScanner;
        this.symbolTable = symbolTable;
    }

    @Override
    public String getNamespaceURI(String string2) {
        return this.nscontext.prefixMapping(this.symbolTable.addSymbol(string2));
    }

    @Override
    public String getPrefix(String string2) {
        return this.nscontext.prefixForNamespaceURI(this.symbolTable.addSymbol(string2));
    }

    public Iterator getPrefixes(String string2) {
        if (string2 == null) {
            throw new IllegalArgumentException("namespaceURI is null!");
        }
        int n2 = this.nscontext.totalMappingsCount();
        String[] stringArray = new String[n2];
        int n3 = this.nscontext.prefixesForNamespaceURI(stringArray, this.symbolTable.addSymbol(string2));
        return Arrays.asList(stringArray).subList(0, n3).iterator();
    }

    @Override
    public Iterator<String> getInScopeNamespaces() {
        int n2 = this.nscontext.totalMappingsCount();
        String[] stringArray = new String[n2 * 2];
        int n3 = this.nscontext.inScopeNamespaces(stringArray);
        return Arrays.asList(stringArray).subList(0, n3 * 2).iterator();
    }

    @Override
    public ExtendedNamespaceContext constantENS(boolean bl) {
        return new PersistedNamespaceContextAdapter(this.nscontext, this.symbolTable);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    @Copyright(value="Licensed Materials - Property of IBM\nXL XML Processor for Java (XLXP-J) - Part of various IBM products\n\u00a9 Copyright IBM Corp. 2009. All Rights Reserved.\nUS Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.")
    static class PersistedNamespaceContextAdapter
    implements ExtendedNamespaceContext {
        final SymbolTable symbolTable;
        final String[] mappings;
        final int mappingsCount;

        public PersistedNamespaceContextAdapter(DocumentScanner documentScanner, SymbolTable symbolTable) {
            this.symbolTable = symbolTable;
            int n2 = documentScanner.totalMappingsCount();
            this.mappings = new String[n2 * 2];
            this.mappingsCount = documentScanner.inScopeNamespaces(this.mappings);
        }

        @Override
        public String getNamespaceURI(String string2) {
            string2 = this.symbolTable.addSymbol(string2);
            for (int i = this.mappingsCount - 1; i >= 0; --i) {
                if (string2 != this.mappings[i * 2]) continue;
                return this.mappings[i * 2 + 1];
            }
            return null;
        }

        @Override
        public String getPrefix(String string2) {
            string2 = this.symbolTable.addSymbol(string2);
            for (int i = this.mappingsCount - 1; i >= 0; --i) {
                if (string2 != this.mappings[i * 2 + 1]) continue;
                return this.mappings[i * 2];
            }
            return null;
        }

        public Iterator getPrefixes(String string2) {
            string2 = this.symbolTable.addSymbol(string2);
            String[] stringArray = new String[this.mappingsCount];
            int n2 = 0;
            for (int i = this.mappingsCount - 1; i >= 0; --i) {
                if (string2 != this.mappings[i * 2 + 1]) continue;
                stringArray[n2] = this.mappings[i * 2];
                ++n2;
            }
            return Arrays.asList(stringArray).subList(0, n2).iterator();
        }

        @Override
        public Iterator<String> getInScopeNamespaces() {
            return Arrays.asList(this.mappings).subList(0, this.mappingsCount * 2).iterator();
        }

        @Override
        public ExtendedNamespaceContext constantENS(boolean bl) {
            return this;
        }
    }
}

