/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xml.xci.util;

import com.ibm.xml.xci.Cursor;
import com.ibm.xml.xci.NameTest;
import com.ibm.xml.xci.NodeTest;
import com.ibm.xml.xci.VolatileCData;
import java.io.Serializable;

public final class SimpleKindTest
implements NodeTest,
Serializable {
    private static final long serialVersionUID = -4995386811071289095L;
    static final String IBM_COPYRIGHT = "Licensed Materials - Property of IBM\n\nXML Cursor Interface for Java (XCI-J)\u00a9 Copyright IBM Corp. 2004, 2009. All Rights Reserved.\n\nUS Government Users Restricted Rights - Use, duplication or disclosure \nrestricted by GSA ADP Schedule Contract with IBM Corp.";
    public static final NodeTest NODE = new SimpleKindTest(true, true, true, true, true, true, true);
    public static final NodeTest DOCUMENT = new SimpleKindTest(true, false, false, false, false, false);
    public static final NodeTest ELEMENT = new SimpleKindTest(false, true, false, false, false, false);
    public static final NodeTest ATTRIBUTE = new SimpleKindTest(false, false, true, false, false, false);
    public static final NodeTest NAMESPACE = new SimpleKindTest(false, false, false, false, false, false, true);
    public static final NodeTest TEXT = new SimpleKindTest(false, false, false, true, false, false);
    public static final NodeTest COMMENT = new SimpleKindTest(false, false, false, false, true, false);
    public static final NodeTest PROCESSING_INSTRUCTION = new SimpleKindTest(false, false, false, false, false, true);
    public static final NodeTest ANY = new SimpleKindTest(true, true, true, true, true, true);
    public static final NodeTest NONE = new SimpleKindTest(false, false, false, false, false, false);
    public static final NodeTest ELEMENT_TEXT = new SimpleKindTest(false, true, false, true, false, false);
    public static final NodeTest ANY_BUT_ATTR = new SimpleKindTest(true, true, false, true, true, true);
    private boolean document;
    private boolean element;
    private boolean attribute;
    private boolean text;
    private boolean pi;
    private boolean comment;
    private boolean namespace;

    public SimpleKindTest(boolean bl, boolean bl2, boolean bl3, boolean bl4, boolean bl5, boolean bl6) {
        this(bl, bl2, bl3, bl4, bl5, bl6, false);
    }

    public SimpleKindTest(boolean bl, boolean bl2, boolean bl3, boolean bl4, boolean bl5, boolean bl6, boolean bl7) {
        this.document = bl;
        this.element = bl2;
        this.attribute = bl3;
        this.text = bl4;
        this.pi = bl6;
        this.comment = bl5;
        this.namespace = bl7;
    }

    public boolean allowsDocument() {
        return this.document;
    }

    public boolean allowsElement(VolatileCData volatileCData) {
        return this.element;
    }

    public boolean allowsAttribute(VolatileCData volatileCData) {
        return this.attribute;
    }

    public boolean allowsText() {
        return this.text;
    }

    public boolean allowsProcessingInstruction(String string2) {
        return this.pi;
    }

    public boolean allowsComment() {
        return this.comment;
    }

    public boolean allowsNamespace(VolatileCData volatileCData) {
        return this.namespace;
    }

    public NameTest theNameTest() {
        return null;
    }

    public boolean test(Cursor cursor2) {
        switch (cursor2.itemKind()) {
            case 9: {
                return this.allowsDocument();
            }
            case 1: {
                return this.allowsElement(null);
            }
            case 2: {
                return this.allowsAttribute(null);
            }
            case 3: {
                if (cursor2.itemIsAtomic()) {
                    return false;
                }
                return this.allowsText();
            }
            case 8: {
                return this.allowsComment();
            }
            case 7: {
                return this.allowsProcessingInstruction(null);
            }
            case 4: {
                return this.allowsNamespace(null);
            }
        }
        assert (false) : "unexpected node kind" + cursor2.itemKind();
        return false;
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        boolean bl = false;
        if (this == NODE) {
            return "node()";
        }
        if (this.attribute) {
            stringBuilder.append("attribute()");
            bl = true;
        }
        if (this.comment) {
            if (bl) {
                stringBuilder.append("|");
            }
            stringBuilder.append("comment()");
            bl = true;
        }
        if (this.document) {
            if (bl) {
                stringBuilder.append("|");
            }
            stringBuilder.append("document()");
            bl = true;
        }
        if (this.element) {
            if (bl) {
                stringBuilder.append("|");
            }
            stringBuilder.append("element()");
            bl = true;
        }
        if (this.namespace) {
            if (bl) {
                stringBuilder.append("|");
            }
            stringBuilder.append("namespace()");
            bl = true;
        }
        if (this.pi) {
            if (bl) {
                stringBuilder.append("|");
            }
            stringBuilder.append("processing-instruction()");
            bl = true;
        }
        if (this.text) {
            if (bl) {
                stringBuilder.append("|");
            }
            stringBuilder.append("text()");
            bl = true;
        }
        return stringBuilder.toString();
    }
}

