/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xml.xci.serializer.fixer;

import com.ibm.xml.xci.CData;
import com.ibm.xml.xci.Cursor;
import com.ibm.xml.xci.CursorFactory;
import com.ibm.xml.xci.VolatileCData;
import com.ibm.xml.xci.dp.values.chars.CharBufferChars;
import com.ibm.xml.xci.dp.values.chars.Chars;
import com.ibm.xml.xci.dp.values.chars.StringChars;
import com.ibm.xml.xci.dp.values.chars.WhitespaceCharsConstant;
import com.ibm.xml.xci.serializer.AddContentInterface;
import com.ibm.xml.xci.serializer.AdditionalAPIs;
import com.ibm.xml.xci.serializer.CursorExtended;
import com.ibm.xml.xci.serializer.ElemContext;
import com.ibm.xml.xci.serializer.SerializeParam;
import com.ibm.xml.xci.serializer.fixer.FixerBase;
import com.ibm.xml.xml4j.api.s1.xs.XSTypeDefinition;
import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public class FixerXMLWhitespace
extends FixerBase
implements AddContentInterface,
CursorExtended {
    static final String IBM_COPYRIGHT = "Licensed Materials - Property of IBM\n\nXML Cursor Interface for Java (XCI-J)\u00c3\u0192\u00e2\u20ac\u0161\u00c3\u201a\u00c2\u00a9 Copyright IBM Corp. 2008, 2009. All Rights Reserved.\n\nUS Government Users Restricted Rights - Use, duplication or disclosure \nrestricted by GSA ADP Schedule Contract with IBM Corp.";
    final CursorFactory fCursorFactory;
    final Chars fIndentNewLine;
    final Chars fIndentSequence;
    final int fIndentCount;
    final boolean fStripWhitespace;
    boolean fPreviousNonWhitespaceExists;
    private boolean fReleaseJustCalled1;
    private final boolean fForHTML;
    private boolean fNoIndentation = false;
    private boolean fExpectingFirstChild = false;
    private int fNoIndentationElemDepth = -1;
    List<Chars> fTextNodes = new ArrayList<Chars>();
    List<Cursor.Area> fTextNodeArea = new ArrayList<Cursor.Area>();

    private final CData getStringValue(byte[] byArray, int n2, int n3) {
        String string2 = new String(byArray, n2, n3);
        CData cData = this.fCursorFactory.data((CharSequence)string2, null, false);
        return cData;
    }

    public FixerXMLWhitespace(CursorFactory cursorFactory, Map map2, CursorExtended cursorExtended, boolean bl, boolean bl2) {
        super(cursorExtended);
        assert (this.initForkReleaseCounter());
        this.fStripWhitespace = bl;
        this.fCursorFactory = cursorFactory;
        this.fForHTML = bl2;
        if (map2 == null) {
            this.fIndentNewLine = WhitespaceCharsConstant.newLineChar;
            this.fIndentSequence = null;
            this.fIndentCount = 2;
        } else {
            Object v = map2.get(SerializeParam.INDENT_AMOUNT);
            this.fIndentCount = v instanceof Integer ? (Integer)v : 2;
            v = map2.get(SerializeParam.INDENT_LINE_SEPARATOR);
            this.fIndentNewLine = v instanceof String ? new StringChars((String)v) : WhitespaceCharsConstant.newLineChar;
            v = map2.get(SerializeParam.INDENT_CHARACTER);
            if (v instanceof Character && !((Character)v).equals(Character.valueOf(' '))) {
                char[] cArray = new char[this.fIndentCount];
                for (int i = 0; i < this.fIndentCount; ++i) {
                    Array.setChar(cArray, i, ((Character)v).charValue());
                }
                this.fIndentSequence = CharBufferChars.make(cArray);
            } else {
                this.fIndentSequence = null;
            }
        }
    }

    private void setReleaseJustCalled(boolean bl) {
        this.fReleaseJustCalled1 = bl;
        if (bl) {
            this.setNoPreviousNonWhite();
        }
    }

    private void setHasPreviousNonWhite() {
        this.fPreviousNonWhitespaceExists = true;
    }

    private boolean previousNonWhiteExists() {
        return this.fPreviousNonWhitespaceExists;
    }

    private void setNoPreviousNonWhite() {
        this.fPreviousNonWhitespaceExists = false;
    }

    private int numWhitespaceNodes() {
        return this.fTextNodes.size();
    }

    private void dumpWhitespace() {
        int n2 = this.fTextNodes.size();
        for (int i = 0; i < n2; ++i) {
            Chars chars = this.fTextNodes.get(i);
            Cursor.Area area = this.fTextNodeArea.get(i);
            this.fCursor.addText(area, chars);
        }
        this.clearWhitespace();
    }

    private void clearWhitespace() {
        this.fTextNodes.clear();
        this.fTextNodeArea.clear();
    }

    private Cursor.Area whereIsWhitespace() {
        Cursor.Area area = 1 <= this.numWhitespaceNodes() ? this.fTextNodeArea.get(0) : null;
        return area;
    }

    private void addWhitespace(Cursor.Area area, Chars chars) {
        chars = chars.constant(false);
        this.fTextNodes.add(chars);
        this.fTextNodeArea.add(area);
    }

    static boolean isAllWhitespace(Chars chars) {
        char[] cArray = chars.toCharArray();
        int n2 = cArray.length;
        for (int i = 0; i < n2; ++i) {
            if (Character.isWhitespace(cArray[i])) continue;
            return false;
        }
        return true;
    }

    private static boolean isAllWhitespace(byte[] byArray, int n2, int n3) {
        int n4 = byArray.length;
        for (int i = 0; i < n4; ++i) {
            if (Character.isWhitespace(byArray[i])) continue;
            return false;
        }
        return true;
    }

    public void addComment(Cursor.Area area, VolatileCData volatileCData) {
        if (this.fExpectingFirstChild) {
            if (area == Cursor.Area.FIRST_CHILD) {
                this.fExpectingFirstChild = false;
            } else {
                this.fNoIndentation = false;
            }
        }
        area = this.maybeDumpWhitespace(area);
        this.fCursor.addComment(area, volatileCData);
        this.setReleaseJustCalled(false);
    }

    public void addComment(Cursor.Area area, Chars chars) {
        if (this.fExpectingFirstChild) {
            if (area == Cursor.Area.FIRST_CHILD) {
                this.fExpectingFirstChild = false;
            } else {
                this.fNoIndentation = false;
            }
        }
        area = this.maybeDumpWhitespace(area);
        this.fCursor.addComment(area, chars);
        this.setReleaseJustCalled(false);
    }

    private Cursor.Area maybeDumpWhitespace(Cursor.Area area) {
        if (1 <= this.numWhitespaceNodes()) {
            if (this.fStripWhitespace) {
                area = this.fTextNodeArea.get(0);
                this.clearWhitespace();
            } else {
                this.dumpWhitespace();
            }
        }
        return area;
    }

    private boolean startTagIsOpen() {
        int n2 = this.getCursorExtensions().getSerializationState();
        boolean bl = ElemContext.mayAddElemAttr(n2);
        return bl;
    }

    public final void addElement(Cursor.Area area, VolatileCData volatileCData, XSTypeDefinition xSTypeDefinition) {
        if (this.fExpectingFirstChild) {
            if (area == Cursor.Area.FIRST_CHILD) {
                this.fExpectingFirstChild = false;
            } else {
                this.fNoIndentation = false;
            }
        }
        boolean bl = this.getCursorExtensions().isPreviousElemInline() || this.getCursorExtensions().isCurrentElemInline(volatileCData);
        Cursor.Area area2 = area;
        if (!this.fNoIndentation) {
            if (bl) {
                if (area != Cursor.Area.FIRST_CHILD) {
                    this.dumpWhitespace();
                }
            } else {
                Cursor.Area area3 = this.whereIsWhitespace();
                if (area3 != null) {
                    this.clearWhitespace();
                }
                if (this.startTagIsOpen() || this.fReleaseJustCalled1 || area3 != null) {
                    if (!this.fStripWhitespace) {
                        Cursor.Area area4 = area3;
                        if (area4 == null) {
                            area4 = area;
                        }
                        int n2 = this.getCursorExtensions().getElemDepth();
                        if (this.startTagIsOpen()) {
                            if (area3 != Cursor.Area.FIRST_CHILD && area != Cursor.Area.FIRST_CHILD) {
                                --n2;
                            }
                        } else if (!this.fReleaseJustCalled1 && area3 != Cursor.Area.FOLLOWING_SIBLING) {
                            --n2;
                        }
                        this.insertIndentation(area4, n2);
                        area2 = Cursor.Area.FOLLOWING_SIBLING;
                    } else if (area == Cursor.Area.FOLLOWING_SIBLING && area3 != null) {
                        area2 = area3;
                    }
                }
            }
        }
        this.fCursor.addElement(area2, volatileCData, xSTypeDefinition);
        if (this.fForHTML && !this.fNoIndentation) {
            this.checkForNoIndentationElement(volatileCData);
        }
        this.setReleaseJustCalled(false);
    }

    private void insertIndentation(Cursor.Area area, int n2) {
        this.clearWhitespace();
        this.fCursor.addText(area, this.fIndentNewLine);
        if (this.fIndentSequence == null) {
            int n3;
            for (n3 = this.fIndentCount * n2; n3 > 20; n3 -= 20) {
                this.fCursor.addText(Cursor.Area.FOLLOWING_SIBLING, WhitespaceCharsConstant.whitespaceConstants[20]);
            }
            this.fCursor.addText(Cursor.Area.FOLLOWING_SIBLING, WhitespaceCharsConstant.whitespaceConstants[n3]);
        } else {
            for (int i = 0; i < n2; ++i) {
                this.fCursor.addText(Cursor.Area.FOLLOWING_SIBLING, this.fIndentSequence);
            }
        }
    }

    public final void addText(Cursor.Area area, VolatileCData volatileCData) {
        if (this.fExpectingFirstChild) {
            if (area == Cursor.Area.FIRST_CHILD) {
                this.fExpectingFirstChild = false;
            } else {
                this.fNoIndentation = false;
            }
        }
        if (!(this.fNoIndentation || area != Cursor.Area.FIRST_CHILD && this.getCursorExtensions().isPreviousElemInline())) {
            if (this.startTagIsOpen()) {
                if (FixerXMLWhitespace.isAllWhitespace(volatileCData)) {
                    this.addWhitespace(area, volatileCData);
                    this.setReleaseJustCalled(false);
                    return;
                }
            } else {
                int n2 = this.getCursorExtensions().getSerializationState();
                if (n2 == 4 && FixerXMLWhitespace.isAllWhitespace(volatileCData)) {
                    this.addWhitespace(area, volatileCData);
                    this.setReleaseJustCalled(false);
                    return;
                }
            }
        }
        this.dumpWhitespace();
        this.fCursor.addText(area, volatileCData);
        this.setReleaseJustCalled(false);
        this.setHasPreviousNonWhite();
    }

    public final void addText(Cursor.Area area, Chars chars) {
        if (this.fExpectingFirstChild) {
            if (area == Cursor.Area.FIRST_CHILD) {
                this.fExpectingFirstChild = false;
            } else {
                this.fNoIndentation = false;
            }
        }
        if (!(this.fNoIndentation || area != Cursor.Area.FIRST_CHILD && this.getCursorExtensions().isPreviousElemInline())) {
            if (this.startTagIsOpen()) {
                if (FixerXMLWhitespace.isAllWhitespace(chars)) {
                    this.addWhitespace(area, chars);
                    this.setReleaseJustCalled(false);
                    return;
                }
            } else {
                int n2 = this.getCursorExtensions().getSerializationState();
                if (n2 == 4 && FixerXMLWhitespace.isAllWhitespace(chars)) {
                    this.addWhitespace(area, chars);
                    this.setReleaseJustCalled(false);
                    return;
                }
            }
        }
        this.dumpWhitespace();
        this.fCursor.addText(area, chars);
        this.setReleaseJustCalled(false);
        this.setHasPreviousNonWhite();
    }

    public final void closeMutation() {
        this.fCursor.closeMutation();
        this.setReleaseJustCalled(false);
        this.fNoIndentation = false;
    }

    public final boolean openMutation(Cursor.Area area) {
        this.setReleaseJustCalled(false);
        this.fNoIndentation = false;
        return this.fCursor.openMutation(area);
    }

    public final void addProcessingInstruction(Cursor.Area area, VolatileCData volatileCData, VolatileCData volatileCData2) {
        if (this.fExpectingFirstChild) {
            if (area == Cursor.Area.FIRST_CHILD) {
                this.fExpectingFirstChild = false;
            } else {
                this.fNoIndentation = false;
            }
        }
        area = this.maybeDumpWhitespace(area);
        this.fCursor.addProcessingInstruction(area, volatileCData, volatileCData2);
        this.setReleaseJustCalled(false);
        this.setNoPreviousNonWhite();
    }

    public final void addProcessingInstruction(Cursor.Area area, VolatileCData volatileCData, Chars chars) {
        if (this.fExpectingFirstChild) {
            if (area == Cursor.Area.FIRST_CHILD) {
                this.fExpectingFirstChild = false;
            } else {
                this.fNoIndentation = false;
            }
        }
        area = this.maybeDumpWhitespace(area);
        this.fCursor.addProcessingInstruction(area, volatileCData, chars);
        this.setReleaseJustCalled(false);
        this.setNoPreviousNonWhite();
    }

    public final void release() {
        Cursor.Area area = this.whereIsWhitespace();
        if (area != null) {
            if (area == Cursor.Area.FIRST_CHILD) {
                this.dumpWhitespace();
            } else {
                this.clearWhitespace();
            }
        }
        if (!this.fNoIndentation && !this.getCursorExtensions().isPreviousElemInline()) {
            int n2 = this.getCursorExtensions().getSerializationState();
            switch (n2) {
                case 4: {
                    int n3;
                    if (this.fStripWhitespace || area == null && this.previousNonWhiteExists() || (n3 = this.getCursorExtensions().getElemDepth()) <= 0) break;
                    this.insertIndentation(Cursor.Area.FOLLOWING_SIBLING, n3 - 1);
                    break;
                }
                case 1: 
                case 2: 
                case 3: {
                    if (this.fStripWhitespace) break;
                    int n4 = this.getCursorExtensions().getElemDepth() - 2;
                    if (n4 < 0) {
                        n4 = 0;
                    }
                    this.insertIndentation(Cursor.Area.FOLLOWING_SIBLING, n4);
                    break;
                }
            }
        }
        this.fCursor.release();
        if (this.fNoIndentation && this.fCursor.getCursorExtensions().getElemDepth() < this.fNoIndentationElemDepth) {
            this.fNoIndentation = false;
            this.fExpectingFirstChild = false;
        }
        this.setReleaseJustCalled(true);
        assert (this.decrementForkReleaseCounter());
    }

    public final void addContent(Cursor.Area area, byte[] byArray, int n2, int n3) {
        if (this.startTagIsOpen() && FixerXMLWhitespace.isAllWhitespace(byArray, n2, n3)) {
            CData cData = this.getStringValue(byArray, n2, n3);
            this.addWhitespace(area, cData);
            this.setReleaseJustCalled(false);
            this.setNoPreviousNonWhite();
            return;
        }
        this.dumpWhitespace();
        if (this.fCursor instanceof AddContentInterface) {
            this.fCursor.addContent(area, byArray, n2, n3);
        }
        this.setReleaseJustCalled(false);
        this.setHasPreviousNonWhite();
    }

    public final Cursor fork(boolean bl, Cursor.Profile profile, Cursor.Profile profile2) {
        this.setReleaseJustCalled(false);
        assert (this.incrementForkReleaseCounter());
        this.fCursor.fork(bl);
        return this;
    }

    public AdditionalAPIs getCursorExtensions() {
        return this.fCursor.getCursorExtensions();
    }

    private void checkForNoIndentationElement(VolatileCData volatileCData) {
        String string2 = volatileCData.getQNameNamespaceURI(1);
        String string3 = volatileCData.getQNameLocalPart(1);
        if ((string2 == null || string2.length() == 0) && (string3.equalsIgnoreCase("pre") || string3.equalsIgnoreCase("script") || string3.equalsIgnoreCase("style") || string3.equalsIgnoreCase("textarea"))) {
            this.fNoIndentation = true;
            this.fExpectingFirstChild = true;
            this.fNoIndentationElemDepth = this.getCursorExtensions().getElemDepth();
        }
    }
}

