/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xml.xci.serializer.fixer;

import com.ibm.xml.xci.CData;
import com.ibm.xml.xci.Cursor;
import com.ibm.xml.xci.CursorFactory;
import com.ibm.xml.xci.VolatileCData;
import com.ibm.xml.xci.dp.values.chars.Chars;
import com.ibm.xml.xci.internal.values.QNameCData;
import com.ibm.xml.xci.serializer.AddContentInterface;
import com.ibm.xml.xci.serializer.AdditionalAPIs;
import com.ibm.xml.xci.serializer.CursorExtended;
import com.ibm.xml.xci.serializer.fixer.FixerBase;
import com.ibm.xml.xci.type.TypeRegistry;
import com.ibm.xml.xml4j.api.s1.xs.XSTypeDefinition;
import java.util.ArrayList;
import java.util.Map;
import javax.xml.namespace.QName;

public class FixerMeta
extends FixerBase
implements AddContentInterface,
CursorExtended {
    static final String IBM_COPYRIGHT = "Licensed Materials - Property of IBM\n\nXML Cursor Interface for Java (XCI-J)\u00a9 Copyright IBM Corp. 2008, 2009. All Rights Reserved.\n\nUS Government Users Restricted Rights - Use, duplication or disclosure \nrestricted by GSA ADP Schedule Contract with IBM Corp.";
    final boolean fIsForXHTML;
    private boolean fIsInMetaElement = false;
    private boolean fIgnoreMetaAttributes = false;
    private XSTypeDefinition fMetaType = null;
    private ArrayList<Object> fMetaAttributes = new ArrayList();
    private ArrayList<Object> fMetaNamespaces = new ArrayList();
    private int fHeadElemDepth = -1;
    private int fMetaElemDepth = -1;
    final VolatileCData http_equiv;
    final VolatileCData http_equiv_val;
    final VolatileCData content;
    final VolatileCData content_val;
    final CData meta;
    private boolean fHTMLAlreadyAdded;
    boolean fShouldStillAddMETA = true;
    final CursorFactory fCursorFactory;
    private boolean fHEADJustAdded;

    public FixerMeta(CursorFactory cursorFactory, Map map2, CursorExtended cursorExtended, boolean bl) {
        super(cursorExtended);
        Object object2;
        String string2;
        assert (this.initForkReleaseCounter());
        this.fCursorFactory = cursorFactory;
        this.fIsForXHTML = bl;
        this.http_equiv = this.getStringValue("http-equiv");
        this.http_equiv_val = this.getStringValue("Content-Type");
        this.content = this.getStringValue("content");
        String string3 = "UTF-8";
        if (map2 != null && (string2 = map2.get("encoding")) instanceof String) {
            string3 = string2;
        }
        string2 = "text/html";
        if (map2 != null && (object2 = map2.get("media-type")) instanceof String) {
            string2 = (String)object2;
        }
        this.content_val = this.getStringValue(string2 + "; charset=" + string3);
        object2 = bl ? new QName("http://www.w3.org/1999/xhtml", "meta") : new QName("", "META");
        this.meta = new QNameCData((QName)object2, TypeRegistry.XSQNAME);
    }

    private final CData getStringValue(String string2) {
        CData cData = this.fCursorFactory.data((CharSequence)string2, TypeRegistry.XSSTRING, false);
        return cData;
    }

    private void setHEADJustAdded(boolean bl) {
        if (bl) {
            this.fHEADJustAdded = true;
            this.fHTMLAlreadyAdded = true;
        } else {
            this.fHEADJustAdded = false;
        }
    }

    private boolean HEADJustAdded() {
        return this.fHEADJustAdded;
    }

    public final void closeMutation() {
        this.fCursor.closeMutation();
        this.setHEADJustAdded(false);
        this.clearMETA();
        this.fHeadElemDepth = -1;
        this.fMetaElemDepth = -1;
        this.fIgnoreMetaAttributes = false;
    }

    public final boolean openMutation(Cursor.Area area) {
        this.setHEADJustAdded(false);
        this.clearMETA();
        this.fHeadElemDepth = -1;
        this.fMetaElemDepth = -1;
        this.fIgnoreMetaAttributes = false;
        return this.fCursor.openMutation(area);
    }

    public final Cursor fork(boolean bl, Cursor.Profile profile, Cursor.Profile profile2) {
        assert (this.incrementForkReleaseCounter());
        this.fCursor.fork(bl);
        return this;
    }

    public final void release() {
        if (this.HEADJustAdded()) {
            if (this.fShouldStillAddMETA) {
                this.insertMETA(Cursor.Area.FIRST_CHILD);
            } else if (this.fIsInMetaElement) {
                this.handleMETA();
            }
        }
        this.fCursor.release();
        if (this.HEADJustAdded()) {
            int n2 = this.getCursorExtensions().getElemDepth();
            if (n2 < this.fHeadElemDepth) {
                this.setHEADJustAdded(false);
            } else if (n2 == this.fHeadElemDepth) {
                this.fMetaElemDepth = this.fHeadElemDepth;
            }
        }
        assert (this.decrementForkReleaseCounter());
    }

    public final void addProcessingInstruction(Cursor.Area area, VolatileCData volatileCData, VolatileCData volatileCData2) {
        if (this.HEADJustAdded()) {
            if (this.fShouldStillAddMETA) {
                boolean bl = area == Cursor.Area.FIRST_CHILD;
                area = this.insertMETA(Cursor.Area.FIRST_CHILD);
                if (!bl) {
                    this.fork(true, this.profile(), this.futureProfile());
                    this.release();
                }
            } else if (this.fIsInMetaElement) {
                this.handleMETA();
            }
        }
        this.fCursor.addProcessingInstruction(area, volatileCData, volatileCData2);
        this.setHEADJustAdded(false);
    }

    public final void addProcessingInstruction(Cursor.Area area, VolatileCData volatileCData, Chars chars) {
        if (this.HEADJustAdded()) {
            if (this.fShouldStillAddMETA) {
                boolean bl = area == Cursor.Area.FIRST_CHILD;
                area = this.insertMETA(Cursor.Area.FIRST_CHILD);
                if (!bl) {
                    this.fork(true, this.profile(), this.futureProfile());
                    this.release();
                }
            } else if (this.fIsInMetaElement) {
                this.handleMETA();
            }
        }
        this.fCursor.addProcessingInstruction(area, volatileCData, chars);
        this.setHEADJustAdded(false);
    }

    public final void addComment(Cursor.Area area, VolatileCData volatileCData) {
        if (this.HEADJustAdded()) {
            if (this.fShouldStillAddMETA) {
                boolean bl = area == Cursor.Area.FIRST_CHILD;
                area = this.insertMETA(Cursor.Area.FIRST_CHILD);
                if (!bl) {
                    this.fork(true, this.profile(), this.futureProfile());
                    this.release();
                }
            } else if (this.fIsInMetaElement) {
                this.handleMETA();
            }
        }
        this.fCursor.addComment(area, volatileCData);
        this.setHEADJustAdded(false);
    }

    public final void addComment(Cursor.Area area, Chars chars) {
        if (this.HEADJustAdded()) {
            if (this.fShouldStillAddMETA) {
                boolean bl = area == Cursor.Area.FIRST_CHILD;
                area = this.insertMETA(Cursor.Area.FIRST_CHILD);
                if (!bl) {
                    this.fork(true, this.profile(), this.futureProfile());
                    this.release();
                }
            } else if (this.fIsInMetaElement) {
                this.handleMETA();
            }
        }
        this.fCursor.addComment(area, chars);
        this.setHEADJustAdded(false);
    }

    public final void addText(Cursor.Area area, VolatileCData volatileCData) {
        if (this.HEADJustAdded()) {
            if (this.fShouldStillAddMETA) {
                boolean bl = area == Cursor.Area.FIRST_CHILD;
                area = this.insertMETA(Cursor.Area.FIRST_CHILD);
                if (!bl) {
                    this.fork(true, this.profile(), this.futureProfile());
                    this.release();
                }
            } else if (this.fIsInMetaElement) {
                this.handleMETA();
            }
        }
        this.fCursor.addText(area, volatileCData);
    }

    public final void addText(Cursor.Area area, Chars chars) {
        if (this.HEADJustAdded()) {
            if (this.fShouldStillAddMETA) {
                boolean bl = area == Cursor.Area.FIRST_CHILD;
                area = this.insertMETA(Cursor.Area.FIRST_CHILD);
                if (!bl) {
                    this.fork(true, this.profile(), this.futureProfile());
                    this.release();
                }
            } else if (this.fIsInMetaElement) {
                this.handleMETA();
            }
        }
        this.fCursor.addText(area, chars);
    }

    public final void addAttribute(VolatileCData volatileCData, VolatileCData volatileCData2) {
        if (!this.fIsInMetaElement) {
            this.fCursor.addAttribute(volatileCData, volatileCData2);
        } else if (!this.fIgnoreMetaAttributes) {
            String string2 = volatileCData.getQNameLocalPart(1);
            if (string2.equalsIgnoreCase("http-equiv") && "Content-Type".equalsIgnoreCase(volatileCData2.getString(1).trim())) {
                this.fIgnoreMetaAttributes = true;
                return;
            }
            this.fMetaAttributes.add(volatileCData.constant(false));
            this.fMetaAttributes.add(volatileCData2.constant(false));
        }
    }

    public final void addAttribute(VolatileCData volatileCData, Chars chars) {
        if (!this.fIsInMetaElement) {
            this.fCursor.addAttribute(volatileCData, chars);
        } else if (!this.fIgnoreMetaAttributes) {
            String string2 = volatileCData.getQNameLocalPart(1);
            if (string2.equalsIgnoreCase("http-equiv") && "Content-Type".equalsIgnoreCase(((Object)chars).toString().trim())) {
                this.fIgnoreMetaAttributes = true;
                return;
            }
            this.fMetaAttributes.add(volatileCData.constant(false));
            this.fMetaAttributes.add(chars.constant(false));
        }
    }

    public final void addNamespaceNode(VolatileCData volatileCData, VolatileCData volatileCData2, boolean bl) {
        if (!this.fIgnoreMetaAttributes) {
            if (!this.fIsInMetaElement) {
                this.fCursor.addNamespaceNode(volatileCData, volatileCData2, bl);
            } else {
                this.fMetaNamespaces.add(volatileCData.constant(false));
                this.fMetaNamespaces.add(volatileCData2.constant(false));
                this.fMetaNamespaces.add(bl);
            }
        }
    }

    public final void addElement(Cursor.Area area, VolatileCData volatileCData, XSTypeDefinition xSTypeDefinition) {
        String string2 = volatileCData.getQNameLocalPart(1);
        String string3 = volatileCData.getQNameNamespaceURI(1);
        if (this.HEADJustAdded()) {
            boolean bl;
            boolean bl2 = bl = this.fShouldStillAddMETA || area != Cursor.Area.FIRST_CHILD && this.getCursorExtensions().getElemDepth() == this.fMetaElemDepth;
            if (this.fShouldStillAddMETA) {
                boolean bl3 = area == Cursor.Area.FIRST_CHILD;
                area = this.insertMETA(Cursor.Area.FIRST_CHILD);
                if (!bl3) {
                    bl = false;
                    this.fork(true, this.profile(), this.futureProfile());
                    this.release();
                }
            } else if (this.fIsInMetaElement) {
                this.handleMETA();
            }
            if (bl) {
                this.fIsInMetaElement = this.isElement(string2, string3, "meta");
                if (this.fIsInMetaElement) {
                    this.fMetaType = xSTypeDefinition;
                    return;
                }
            }
        }
        this.fCursor.addElement(area, volatileCData, xSTypeDefinition);
        if (this.fShouldStillAddMETA && this.isElement(string2, string3, "head")) {
            this.fHeadElemDepth = this.getCursorExtensions().getElemDepth();
            this.setHEADJustAdded(true);
            this.setInMetaElement(false);
        }
    }

    private boolean isElement(String string2, String string3, String string4) {
        if (string2.length() != 4) {
            return false;
        }
        return this.isElement2(string2, string3, string4);
    }

    private boolean isElement2(String string2, String string3, String string4) {
        boolean bl = this.fIsForXHTML ? "http://www.w3.org/1999/xhtml".equals(string3) && string2.equals(string4) : string3.length() == 0 && string2.equalsIgnoreCase(string4);
        return bl;
    }

    private boolean isHttpEquiv(String string2, String string3) {
        return this.fIsForXHTML ? "http://www.w3.org/1999/xhtml".equals(string2) && string3.equals("http-equiv") : string2.length() == 0 && string3.equalsIgnoreCase("http-equiv");
    }

    private Cursor.Area insertMETA(Cursor.Area area) {
        this.fCursor.addElement(area, this.meta, null);
        this.fCursor.addAttribute(this.content, this.content_val);
        this.fCursor.addAttribute(this.http_equiv, this.http_equiv_val);
        this.fShouldStillAddMETA = false;
        this.fMetaElemDepth = this.getCursorExtensions().getElemDepth();
        return Cursor.Area.FOLLOWING_SIBLING;
    }

    private void handleMETA() {
        if (!this.fIgnoreMetaAttributes) {
            this.dumpMETA();
        }
        this.clearMETA();
        this.setInMetaElement(false);
        this.fIgnoreMetaAttributes = false;
    }

    private void dumpMETA() {
        int n2;
        this.fCursor.addElement(Cursor.Area.FOLLOWING_SIBLING, this.meta, this.fMetaType);
        int n3 = this.fMetaNamespaces.size();
        for (n2 = 0; n2 < n3; n2 += 3) {
            this.fCursor.addNamespaceNode((VolatileCData)this.fMetaNamespaces.get(n2), (VolatileCData)this.fMetaNamespaces.get(n2 + 1), (boolean)((Boolean)this.fMetaNamespaces.get(n2 + 2)));
        }
        n3 = this.fMetaAttributes.size();
        for (n2 = 0; n2 < n3; n2 += 2) {
            this.fCursor.addAttribute((VolatileCData)this.fMetaAttributes.get(n2), (Chars)this.fMetaAttributes.get(n2 + 1));
        }
    }

    private void clearMETA() {
        this.fMetaType = null;
        this.fMetaAttributes.clear();
        this.fMetaNamespaces.clear();
    }

    private void setInMetaElement(boolean bl) {
        this.fIsInMetaElement = bl;
    }

    public final void addContent(Cursor.Area area, byte[] byArray, int n2, int n3) {
        if (this.HEADJustAdded()) {
            if (this.fShouldStillAddMETA) {
                boolean bl = area == Cursor.Area.FIRST_CHILD;
                area = this.insertMETA(Cursor.Area.FIRST_CHILD);
                if (!bl) {
                    this.fork(true, this.profile(), this.futureProfile());
                    this.release();
                }
            } else if (this.fIsInMetaElement) {
                this.handleMETA();
            }
        }
        if (this.fCursor instanceof AddContentInterface) {
            this.fCursor.addContent(area, byArray, n2, n3);
        }
    }

    public AdditionalAPIs getCursorExtensions() {
        return this.fCursor.getCursorExtensions();
    }
}

