/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xml.xci.serializer.fixer;

import com.ibm.xml.xci.Cursor;
import com.ibm.xml.xci.VolatileCData;
import com.ibm.xml.xci.serializer.AddContentInterface;
import com.ibm.xml.xci.serializer.AdditionalAPIs;
import com.ibm.xml.xci.serializer.CachedItem;
import com.ibm.xml.xci.serializer.CursorExtended;
import com.ibm.xml.xci.serializer.fixer.FixerBase;
import com.ibm.xml.xml4j.api.s1.xs.XSTypeDefinition;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FixerCachedData
extends FixerBase
implements AddContentInterface,
CursorExtended {
    static final String IBM_COPYRIGHT = "Licensed Materials - Property of IBM\n\nXML Cursor Interface for Java (XCI-J)\u00a9 Copyright IBM Corp. 2009, 2009. All Rights Reserved.\n\nUS Government Users Restricted Rights - Use, duplication or disclosure \nrestricted by GSA ADP Schedule Contract with IBM Corp.";
    private List<CachedItem> fCache;

    public FixerCachedData(CursorExtended cursorExtended, List<CachedItem> list) {
        super(cursorExtended);
        this.fCache = list;
    }

    @Override
    public void addComment(Cursor.Area area, VolatileCData volatileCData) {
        this.fCursor.addComment(area, volatileCData);
    }

    @Override
    public final void addElement(Cursor.Area area, VolatileCData volatileCData, XSTypeDefinition xSTypeDefinition) {
        this.fCursor.addElement(area, volatileCData, xSTypeDefinition);
    }

    @Override
    public final void addText(Cursor.Area area, VolatileCData volatileCData) {
        this.fCursor.addText(area, volatileCData);
    }

    @Override
    public final void addProcessingInstruction(Cursor.Area area, VolatileCData volatileCData, VolatileCData volatileCData2) {
        this.fCursor.addProcessingInstruction(area, volatileCData, volatileCData2);
    }

    @Override
    public final boolean openMutation(Cursor.Area area) {
        boolean bl = this.fCursor.openMutation(area);
        this.serializeCachedData();
        return bl;
    }

    @Override
    public final void closeMutation() {
        this.fCursor.closeMutation();
    }

    @Override
    public final void release() {
        this.fCursor.release();
        assert (null == this.forkReleaseInstanceTracker || this.forkReleaseInstanceTracker.checkAndRecordRelease(false, this));
        assert (this.decrementForkReleaseCounter());
    }

    @Override
    public final Cursor fork(boolean bl, Cursor.Profile profile, Cursor.Profile profile2) {
        assert (this.incrementForkReleaseCounter());
        return this;
    }

    @Override
    public final void addContent(Cursor.Area area, byte[] byArray, int n2, int n3) {
        if (this.fCursor instanceof AddContentInterface) {
            this.fCursor.addContent(area, byArray, n2, n3);
        }
    }

    @Override
    public AdditionalAPIs getCursorExtensions() {
        return this.fCursor.getCursorExtensions();
    }

    private void serializeCachedData() {
        int n2 = this.fCache.size();
        block5: for (int i = 0; i < n2; ++i) {
            CachedItem cachedItem = this.fCache.get(i);
            List<VolatileCData> list = cachedItem.itemData();
            switch (cachedItem.itemKind()) {
                case 3: {
                    this.fCursor.addText(cachedItem.where(), list.get(0));
                    continue block5;
                }
                case 8: {
                    this.fCursor.addComment(cachedItem.where(), list.get(0));
                    continue block5;
                }
                case 7: {
                    this.fCursor.addProcessingInstruction(cachedItem.where(), list.get(0), list.get(1));
                }
            }
        }
        this.fCache.clear();
    }
}

