/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xml.xci.serializer.fixer;

import com.ibm.xml.xci.CData;
import com.ibm.xml.xci.Cursor;
import com.ibm.xml.xci.CursorFactory;
import com.ibm.xml.xci.VolatileCData;
import com.ibm.xml.xci.dp.values.chars.Chars;
import com.ibm.xml.xci.serializer.AddContentInterface;
import com.ibm.xml.xci.serializer.AdditionalAPIs;
import com.ibm.xml.xci.serializer.CursorExtended;
import com.ibm.xml.xci.serializer.ElemContext;
import com.ibm.xml.xci.serializer.fixer.FixerBase;
import com.ibm.xml.xci.type.TypeRegistry;
import com.ibm.xml.xml4j.api.s1.xs.XSTypeDefinition;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.xml.namespace.QName;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FixerAvoidUsingDefaultNS
extends FixerBase
implements CursorExtended,
AddContentInterface {
    static final String IBM_COPYRIGHT = "Licensed Materials - Property of IBM\n\nXML Cursor Interface for Java (XCI-J)\u00c3\u201a\u00c2\u00a9 Copyright IBM Corp. 2008, 2009. All Rights Reserved.\n\nUS Government Users Restricted Rights - Use, duplication or disclosure \nrestricted by GSA ADP Schedule Contract with IBM Corp.";
    final CursorFactory fCursorFactory;
    List<String> m_uris = new ArrayList<String>();
    List<String> m_prefixes = new ArrayList<String>();

    private final CData getStringValue(String string2) {
        CData cData = this.fCursorFactory.data((CharSequence)string2, null, false);
        return cData;
    }

    private final CData getQName(String string2, VolatileCData volatileCData) {
        String string3 = volatileCData.getQNameNamespaceURI(1);
        String string4 = volatileCData.getQNameLocalPart(1);
        QName qName = new QName(string3, string4, string2);
        CData cData = this.fCursorFactory.data(qName, TypeRegistry.XSQNAME, false);
        return cData;
    }

    public FixerAvoidUsingDefaultNS(CursorFactory cursorFactory, Map<String, Object> map2, CursorExtended cursorExtended) {
        super(cursorExtended);
        this.fCursorFactory = cursorFactory;
    }

    private int numExtraNamespaceNodes() {
        int n2 = this.m_uris.size();
        return n2;
    }

    private void dumpNamespaceNodes() {
        if (this.startTagIsOpen()) {
            int n2 = this.numExtraNamespaceNodes();
            for (int i = 0; i < n2; ++i) {
                String string2 = this.getGeneratedURI(i);
                String string3 = this.getGeneratedPrefix(i);
                CData cData = this.getStringValue(string3);
                CData cData2 = this.getStringValue(string2);
                this.fCursor.addNamespaceNode(cData, cData2, false);
            }
            this.clearNamepacesNodesToGenerate();
        }
    }

    private String getGeneratedURI(int n2) {
        String string2 = this.m_uris.get(n2);
        return string2;
    }

    private String getGeneratedPrefix(int n2) {
        String string2 = this.m_prefixes.get(n2);
        return string2;
    }

    private String getRequiredPrefix(String string2, String string3) {
        if (string2.length() == 0 && string3.length() > 0) {
            String string4 = this.getCursorExtensions().getPrefix(string3);
            if (string4 != null && string4.length() > 0) {
                return string4;
            }
            string4 = this.getCursorExtensions().getUnusedPrefix();
            return string4;
        }
        return null;
    }

    private void clearNamepacesNodesToGenerate() {
        this.m_uris.clear();
        this.m_prefixes.clear();
    }

    private void addNamespaceNodeToGenerate(String string2, String string3) {
        this.m_uris.add(string3);
        this.m_prefixes.add(string2);
    }

    private boolean startTagIsOpen() {
        int n2 = this.getCursorExtensions().getSerializationState();
        boolean bl = ElemContext.mayAddElemAttr(n2);
        return bl;
    }

    @Override
    public final void addElement(Cursor.Area area, VolatileCData volatileCData, XSTypeDefinition xSTypeDefinition) {
        this.clearNamepacesNodesToGenerate();
        volatileCData = this.enforceRequiredPrefix(volatileCData);
        this.fCursor.addElement(area, volatileCData, xSTypeDefinition);
    }

    private VolatileCData enforceRequiredPrefix(VolatileCData volatileCData) {
        String string2 = volatileCData.getQNameNamespaceURI(1);
        String string3 = volatileCData.getQNamePrefix(1);
        String string4 = this.getRequiredPrefix(string3, string2);
        if (string4 != null && !string4.equals(string3)) {
            volatileCData = this.getQName(string4, volatileCData);
            this.addNamespaceNodeToGenerate(string4, string2);
        }
        return volatileCData;
    }

    @Override
    public final void addText(Cursor.Area area, VolatileCData volatileCData) {
        this.dumpNamespaceNodes();
        this.fCursor.addText(area, volatileCData);
    }

    @Override
    public final void closeMutation() {
        this.fCursor.closeMutation();
    }

    @Override
    public final boolean openMutation(Cursor.Area area) {
        return this.fCursor.openMutation(area);
    }

    @Override
    public final void release() {
        int n2 = this.getCursorExtensions().getSerializationState();
        switch (n2) {
            case 4: {
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                this.dumpNamespaceNodes();
                break;
            }
        }
        this.fCursor.release();
        assert (this.decrementForkReleaseCounter());
    }

    @Override
    public final void addContent(Cursor.Area area, byte[] byArray, int n2, int n3) {
        this.dumpNamespaceNodes();
        if (this.fCursor instanceof AddContentInterface) {
            this.fCursor.addContent(area, byArray, n2, n3);
        }
    }

    @Override
    public final Cursor fork(boolean bl, Cursor.Profile profile, Cursor.Profile profile2) {
        assert (this.incrementForkReleaseCounter());
        return this;
    }

    @Override
    public void addNamespaceNode(VolatileCData volatileCData, VolatileCData volatileCData2, boolean bl) {
        this.dumpNamespaceNodes();
        if (volatileCData == null) {
            return;
        }
        String string2 = volatileCData.toString();
        if (string2.length() == 0) {
            return;
        }
        this.fCursor.addNamespaceNode(volatileCData, volatileCData2, bl);
    }

    @Override
    public void addAttribute(VolatileCData volatileCData, VolatileCData volatileCData2) {
        this.dumpNamespaceNodes();
        this.fCursor.addAttribute(volatileCData, volatileCData2);
    }

    @Override
    public void addAttribute(VolatileCData volatileCData, Chars chars) {
        this.dumpNamespaceNodes();
        this.fCursor.addAttribute(volatileCData, chars);
    }

    @Override
    public AdditionalAPIs getCursorExtensions() {
        return this.fCursor.getCursorExtensions();
    }
}

