/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xml.xci.serializer;

import com.ibm.xml.xci.Cursor;
import com.ibm.xml.xci.CursorFactory;
import com.ibm.xml.xci.VolatileCData;
import com.ibm.xml.xci.dp.values.chars.Chars;
import com.ibm.xml.xci.serializer.AbstractStreamCursor;
import com.ibm.xml.xci.serializer.AddContentInterface;
import com.ibm.xml.xci.serializer.AdditionalAPIs;
import com.ibm.xml.xci.serializer.CursorExtended;
import com.ibm.xml.xci.serializer.Messages;
import com.ibm.xml.xci.serializer.NamespaceMappings;
import com.ibm.xml.xci.serializer.Serialize;
import com.ibm.xml.xci.serializer.SerializeParam;
import com.ibm.xml.xci.serializer.WriterOptimized;
import com.ibm.xml.xci.serializer.WriterToUTF8Buffered;
import java.io.IOException;
import java.io.OutputStream;
import java.io.Writer;
import java.util.Map;

public class XMLUtf8StreamCursor
extends AbstractStreamCursor
implements Cursor,
AdditionalAPIs,
AddContentInterface,
CursorExtended {
    static final String IBM_COPYRIGHT = "Licensed Materials - Property of IBM\n\nXML Cursor Interface for Java (XCI-J)\u00a9 Copyright IBM Corp. 2008, 2009. All Rights Reserved.\n\nUS Government Users Restricted Rights - Use, duplication or disclosure \nrestricted by GSA ADP Schedule Contract with IBM Corp.";
    static final byte[] BRACKET_SLASH_UTF8 = new byte[]{60, 47};
    static final byte[] XML_HEADER_ENCODING2_BYTES = new byte[]{34, 32, 101, 110, 99, 111, 100, 105, 110, 103, 61, 34, 85, 84, 70, 45, 56, 34};
    static final byte[] XMLNS_BYTES = new byte[]{32, 120, 109, 108, 110, 115};

    public XMLUtf8StreamCursor(CursorFactory cursorFactory, OutputStream outputStream, Map map2) {
        super(cursorFactory, outputStream, (Map<SerializeParam, Object>)map2);
    }

    void writeOutHeader(String string2, String string3, String string4) throws IOException {
        WriterOptimized writerOptimized = this.m_writerOptimized;
        if (writerOptimized != null) {
            writerOptimized.writeBytes(XML_HEADER_VERSION_BYTES, 0, XML_HEADER_VERSION_BYTES.length);
            writerOptimized.write(string2);
            if (writerOptimized instanceof WriterToUTF8Buffered) {
                writerOptimized.writeBytes(XML_HEADER_ENCODING2_BYTES, 0, XML_HEADER_ENCODING2_BYTES.length);
            } else {
                writerOptimized.writeBytes(XML_HEADER_ENCODING_BYTES, 0, XML_HEADER_ENCODING_BYTES.length);
                writerOptimized.write(string3);
                writerOptimized.writeByte(DOUBLE_QUOTE_BYTE);
            }
            if (string4.length() > 0) {
                writerOptimized.write(string4);
            }
            writerOptimized.writeBytes(XML_HEADER_END_BYTES, 0, XML_HEADER_END_BYTES.length);
            if (this.doIndent()) {
                writerOptimized.write(this.m_indentLineSep, 0, this.m_indentLineSepLen);
            }
        } else {
            Writer writer = this.m_writer;
            writer.write("<?xml version=\"");
            writer.write(string2);
            writer.write("\" encoding=\"");
            writer.write(string3);
            writer.write(34);
            writer.write(string4);
            writer.write("?>");
            if (this.doIndent()) {
                writer.write(this.m_indentLineSep, 0, this.m_indentLineSepLen);
            }
        }
    }

    protected void privateWriteAttrNSDecl(int n2) throws IOException {
        WriterOptimized writerOptimized = this.m_writerOptimized;
        if (writerOptimized != null) {
            writerOptimized.writeBytes(XMLNS_BYTES, 0, XMLNS_BYTES.length);
            NamespaceMappings.MappingRecord mappingRecord = this.m_prefixMap.lookupNamespace(n2);
            String string2 = mappingRecord.get_uri();
            String string3 = mappingRecord.get_prefix();
            if (string3.length() != 0) {
                writerOptimized.writeByte((byte)58);
                writerOptimized.write(string3);
            }
            writerOptimized.writeByte((byte)61);
            writerOptimized.writeByte((byte)34);
            this.escapeValue(string2, this.getCharEscapeMap((short)4));
            writerOptimized.writeByte((byte)34);
        } else {
            Writer writer = this.m_writer;
            writer.write(XMLNS);
            NamespaceMappings.MappingRecord mappingRecord = this.m_prefixMap.lookupNamespace(n2);
            String string4 = mappingRecord.get_uri();
            String string5 = mappingRecord.get_prefix();
            if (string5.length() != 0) {
                writer.write(58);
                writer.write(string5);
            }
            writer.write(61);
            writer.write(34);
            this.escapeValue(string4, this.getCharEscapeMap((short)4));
            writer.write(34);
        }
    }

    void writeASCII(char c) throws IOException {
        if (this.m_writerOptimized != null) {
            this.m_writerOptimized.writeByte((byte)c);
        } else {
            this.m_writer.write(c);
        }
    }

    void writeASCII(char[] cArray) throws IOException {
        this.m_writerOptimized.writeASCII(cArray, 0, cArray.length);
    }

    public void writeBytes(byte[] byArray, int n2, int n3) throws IOException {
        this.m_writerOptimized.writeBytes(byArray, n2, n3);
    }

    final void writeNonElementQName(String string2, String string3) throws IOException {
        if (string2 != null && string2.length() > 0) {
            this.m_writer.write(string2);
            this.writeASCII(COLON_CHAR);
        }
        if (this.m_writerOptimized != null) {
            this.m_writerOptimized.write(string3);
        } else {
            this.m_writer.write(string3);
        }
    }

    void writeAttributeValue(VolatileCData volatileCData) throws IOException {
        if (Serialize.utf8opt1 && this.m_writerOptimized != null) {
            OutputStream outputStream = ((WriterToUTF8Buffered)this.m_writerOptimized).asOutputStream();
            volatileCData.quote((short)141).writeEncodedBytesTo(outputStream, Chars.UTF8, false);
            return;
        }
        this.writeValue(volatileCData, (short)141, true);
    }

    public AdditionalAPIs getCursorExtensions() {
        return this;
    }

    public String getPrefix(String string2) {
        String string3;
        NamespaceMappings.MappingRecord mappingRecord = this.m_prefixMap.lookupPrefix(string2);
        if (mappingRecord != null && (string3 = mappingRecord.get_prefix()).length() > 0) {
            return string3;
        }
        return null;
    }

    public String getUnusedPrefix() {
        String string2 = this.m_prefixMap.generateUnusedPrefix();
        return string2;
    }

    public boolean toIds(VolatileCData volatileCData, boolean bl) {
        if (bl) {
            String string2 = Messages.createMessage2("ER_UNIMPLEMENTED_METHOD", new String[]{"toIds", this.getClass().getName()});
            Messages.xciDynamicErrorException(string2);
        }
        return false;
    }
}

