/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xml.xci.serializer;

import com.ibm.xml.xci.Cursor;
import com.ibm.xml.xci.CursorFactory;
import com.ibm.xml.xci.VolatileCData;
import com.ibm.xml.xci.dp.values.chars.Chars;
import com.ibm.xml.xci.internal.values.StoredCharsCData;
import com.ibm.xml.xci.serializer.Messages;
import com.ibm.xml.xci.serializer.NamespaceMappings;
import com.ibm.xml.xci.serializer.RawQName;
import com.ibm.xml.xci.serializer.XMLUtf8StreamCursor;
import com.ibm.xml.xci.type.TypeRegistry;
import com.ibm.xml.xml4j.api.s1.xs.XSTypeDefinition;
import java.io.IOException;
import java.io.OutputStream;
import java.util.HashMap;
import java.util.Map;

public class XMLUTF8OutputStreamCursor
extends XMLUtf8StreamCursor {
    static final String IBM_COPYRIGHT = "Licensed Materials - Property of IBM\n\nXML Cursor Interface for Java (XCI-J)\n\n\u00a9 Copyright IBM Corp. 2009. All Rights Reserved.\n\nUS Government Users Restricted Rights - Use, duplication or disclosure \nrestricted by GSA ADP Schedule Contract with IBM Corp.";
    protected Map<String, RawQName> m_rawQNames = new HashMap<String, RawQName>();

    public XMLUTF8OutputStreamCursor(CursorFactory cursorFactory, OutputStream outputStream, Map map2) {
        super(cursorFactory, outputStream, map2);
    }

    public void writeOutHeader(String string2, String string3, String string4) throws IOException {
        super.writeOutHeader(string2, string3, string4);
        this.m_writerOptimized.flushBuffer();
    }

    public void writeBytes(byte[] byArray, int n2, int n3) throws IOException {
        this.m_writerOptimized.flushBuffer();
        this.m_outputStream.write(byArray, n2, n3);
    }

    void writeASCII(char c) throws IOException {
        this.m_writerOptimized.flushBuffer();
        this.m_outputStream.write((byte)c);
    }

    protected void quoteValue(Chars chars, short s, boolean bl) throws IOException {
        this.m_writerOptimized.flushBuffer();
        if (!chars.mayContain(s)) {
            chars.writeEncodedBytesTo(this.m_outputStream, "UTF-8", s, false);
        } else {
            this.escapeValue(chars, 0, chars.length(), this.getCharEscapeMap(bl ? (short)1 : 0));
        }
    }

    void privateElemStart() throws IOException {
        String string2;
        int n2;
        String string3;
        int n3;
        int n4;
        this.m_writerOptimized.flushBuffer();
        this.writeASCII(LESSTHAN_CHAR);
        RawQName rawQName = this.m_elemContext.geRawQName();
        String string4 = this.m_elemContext.get_elemURI();
        String string5 = rawQName.prefix;
        NamespaceMappings.MappingRecord mappingRecord = this.m_prefixMap.getMappingFromPrefix(string5);
        int n5 = n4 = string4 == null ? 0 : string4.length();
        if (mappingRecord != null && (n3 = (string3 = mappingRecord.get_uri()).length()) > 0) {
            if (n3 != n4 || !string3.equals(string4)) {
                if (n4 > 0 || this.isXML11()) {
                    n2 = mappingRecord.m_declarationDepth;
                    mappingRecord = this.m_prefixMap.getMappingFromURI(string4);
                    if (mappingRecord != null && !string5.equals(mappingRecord.get_prefix())) {
                        string2 = mappingRecord.get_prefix();
                    } else {
                        string2 = n2 == this.m_elemContext.get_elemDepth() ? this.m_prefixMap.generateUnusedPrefix() : string5;
                        this.declareNS(string4, string2, false);
                    }
                } else {
                    string2 = "";
                    this.declareNS(string4, string2, false);
                }
            } else {
                string2 = string5;
            }
        } else if (n4 > 0 || string5.length() > 0 && this.isXML11()) {
            string2 = string5;
            this.declareNS(string4, string5, false);
        } else {
            string2 = "";
            if (string5.length() > 0) {
                this.declareNS(string4, string2, false);
            }
        }
        if (string2 != string5) {
            String string6 = "".equals(string5) ? rawQName.localPart : string5 + ":" + rawQName.localPart;
            rawQName = this.m_rawQNames.get(string6);
            if (rawQName == null) {
                rawQName = new RawQName(string5, rawQName.localPart, string6.getBytes("UTF-8"));
                this.m_rawQNames.put(string6, rawQName);
            }
            this.m_elemContext.setElementValues(string4, rawQName);
        }
        this.m_outputStream.write(rawQName.raw);
        n2 = this.m_elemContext.get_firstNamespaceNode();
        if (0 <= n2) {
            int n6 = this.m_elemContext.get_lastNamespaceNode();
            for (int i = n2; i <= n6; ++i) {
                this.privateWriteAttrNSDecl(i);
            }
        }
    }

    public void writeClosingTag(VolatileCData volatileCData) throws IOException {
        if (this.mayAddNamespaceNode()) {
            this.privateElemStart();
        } else {
            this.m_writerOptimized.flushBuffer();
            this.m_outputStream.write(BRACKET_SLASH_UTF8);
            this.m_outputStream.write(this.m_elemContext.geRawQName().raw);
        }
        this.writeASCII(GREATERTHAN_CHAR);
    }

    public void addElement(Cursor.Area area, VolatileCData volatileCData, XSTypeDefinition xSTypeDefinition) {
        if (XMLStreamCursor) {
            this.dbgTrace(".addElement('" + this.dbgGetQName(volatileCData) + "'); called");
        }
        try {
            String string2;
            if (this.m_needTowriteDOCTYPE) {
                this.writeoutDOCTYPE(volatileCData.toString());
                this.m_needTowriteDOCTYPE = false;
            }
            this.ensureContentState(area);
            if (this.m_elemContext.get_elemDepth() == 0) {
                if (this.m_isFirstRoot) {
                    if (this.standaloneApplicable() || this.getDoctypeSystem() != null) {
                        string2 = Messages.createMessage2("ER_SER_ROOT_MULTIPLE_ELEMENT_TEXT_CHILDREN", null);
                        Messages.xciDynamicErrorException(string2);
                    }
                } else {
                    this.m_isFirstRoot = true;
                }
            }
            this.pushNamespaceContext();
            string2 = volatileCData.getQNameNamespaceURI(1);
            String string3 = volatileCData.getString(1);
            RawQName rawQName = this.m_rawQNames.get(string3);
            if (rawQName == null) {
                String string4 = volatileCData.getQNamePrefix(1);
                if (string4 == null) {
                    string4 = "";
                }
                String string5 = volatileCData.getQNameLocalPart(1);
                rawQName = new RawQName(string4, string5, string3.getBytes("UTF-8"));
                this.m_rawQNames.put(string3, rawQName);
            }
            this.m_elemContext.setElementValues(string2, rawQName);
            if (this.checkForCDataSectionElements()) {
                this.m_elemContext.set_isCdataSection(this.isCDataSectionElement(string2, rawQName.localPart));
            }
        }
        catch (IOException iOException) {
            Messages.xciDynamicErrorException(iOException);
        }
    }

    public void addAttribute(VolatileCData volatileCData, Chars chars) {
        if (chars instanceof VolatileCData) {
            this.addAttribute(volatileCData, (VolatileCData)chars);
        } else {
            this.addAttribute(volatileCData, new StoredCharsCData(chars, TypeRegistry.XSUNTYPEDATOMIC));
        }
    }
}

