/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xml.xci.serializer;

import com.ibm.xml.xci.Cursor;
import com.ibm.xml.xci.CursorFactory;
import com.ibm.xml.xci.VolatileCData;
import com.ibm.xml.xci.serializer.AbstractStreamCursor;
import com.ibm.xml.xci.serializer.AddContentInterface;
import com.ibm.xml.xci.serializer.AdditionalAPIs;
import com.ibm.xml.xci.serializer.CursorExtended;
import com.ibm.xml.xci.serializer.Messages;
import com.ibm.xml.xci.serializer.NamespaceMappings;
import com.ibm.xml.xci.serializer.SerializeParam;
import java.io.IOException;
import java.io.OutputStream;
import java.io.Writer;
import java.util.Map;

public class XMLStreamCursor
extends AbstractStreamCursor
implements Cursor,
AdditionalAPIs,
CursorExtended,
AddContentInterface {
    static final String IBM_COPYRIGHT = "Licensed Materials - Property of IBM\n\nXML Cursor Interface for Java (XCI-J)\u00a9 Copyright IBM Corp. 2004, 2009. All Rights Reserved.\n\nUS Government Users Restricted Rights - Use, duplication or disclosure \nrestricted by GSA ADP Schedule Contract with IBM Corp.";

    public XMLStreamCursor(CursorFactory cursorFactory, OutputStream outputStream, Map map2) {
        super(cursorFactory, outputStream, (Map<SerializeParam, Object>)map2);
    }

    public XMLStreamCursor(CursorFactory cursorFactory, Writer writer, Map map2) {
        super(cursorFactory, writer, (Map<SerializeParam, Object>)map2);
    }

    final void privateWriteAttrNSDecl(int n2) throws IOException {
        String string2;
        this.m_writer.write(XMLNS);
        NamespaceMappings.MappingRecord mappingRecord = this.m_prefixMap.lookupNamespace(n2);
        String string3 = string2 = mappingRecord.get_uri();
        String string4 = mappingRecord.get_prefix();
        if (string4.length() != 0) {
            this.m_writer.write(58);
            this.m_writer.write(string4);
        }
        this.m_writer.write(61);
        this.m_writer.write(34);
        this.escapeValue(string3, this.getCharEscapeMap((short)4));
        this.m_writer.write(34);
    }

    void writeOutHeader(String string2, String string3, String string4) throws IOException {
        Writer writer = this.m_writer;
        writer.write("<?xml version=\"");
        writer.write(string2);
        writer.write("\" encoding=\"");
        writer.write(string3);
        writer.write(34);
        writer.write(string4);
        writer.write("?>");
        if (this.doIndent() || null != this.getOutputPropertyNonDefault("doctype-system")) {
            writer.write(this.m_indentLineSep, 0, this.m_indentLineSepLen);
        }
    }

    void writeASCII(char c) throws IOException {
        this.m_writer.write(c);
    }

    void writeASCII(char[] cArray) throws IOException {
        this.m_writer.write(cArray, 0, cArray.length);
    }

    public final void writeBytes(byte[] byArray, int n2, int n3) throws IOException {
        if (this.m_writerOptimized != null) {
            this.m_writerOptimized.writeBytes(byArray, n2, n3);
        } else if (this.m_outputStream != null) {
            if (this.m_writer != null) {
                this.m_writer.flush();
            }
            this.m_outputStream.write(byArray, n2, n3);
        } else {
            this.m_writer.write(new String(byArray, n2, n3));
        }
    }

    final void writeNonElementQName(String string2, String string3) throws IOException {
        if (string2 != null && string2.length() > 0) {
            this.m_writer.write(string2);
            this.writeASCII(COLON_CHAR);
        }
        if (this.m_writerOptimized != null) {
            this.m_writerOptimized.write(string3);
        } else {
            this.m_writer.write(string3);
        }
    }

    void writeAttributeValue(VolatileCData volatileCData) throws IOException {
        this.writeValue(volatileCData, (short)141, true);
    }

    public AdditionalAPIs getCursorExtensions() {
        return this;
    }

    public String getPrefix(String string2) {
        String string3;
        NamespaceMappings.MappingRecord mappingRecord = this.m_prefixMap.lookupPrefix(string2);
        if (mappingRecord != null && (string3 = mappingRecord.get_prefix()).length() > 0) {
            return string3;
        }
        return null;
    }

    public String getUnusedPrefix() {
        String string2 = this.m_prefixMap.generateUnusedPrefix();
        return string2;
    }

    void writeoutDOCTYPE(String string2) throws IOException {
        String string3 = this.getDoctypeSystem();
        if (null == string3) {
            return;
        }
        Writer writer = this.m_writer;
        writer.write("<!DOCTYPE ");
        writer.write(string2);
        String string4 = this.getDoctypePublic();
        if (null != string4) {
            writer.write(" PUBLIC \"");
            writer.write(string4);
            writer.write("\" \"");
        } else {
            writer.write(" SYSTEM \"");
        }
        writer.write(string3);
        writer.write("\">");
        writer.write(this.m_indentLineSep, 0, this.m_indentLineSepLen);
    }

    public void flushContent() {
        try {
            if (this.m_writerOptimized != null) {
                this.m_writerOptimized.flushBuffer();
            } else if (this.m_writer != null) {
                this.m_writer.flush();
            } else if (this.m_outputStream != null) {
                this.m_outputStream.flush();
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public boolean toIds(VolatileCData volatileCData, boolean bl) {
        if (bl) {
            String string2 = Messages.createMessage2("ER_UNIMPLEMENTED_METHOD", new String[]{"toIds", this.getClass().getName()});
            Messages.xciDynamicErrorException(string2);
        }
        return false;
    }
}

