/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xml.xci.serializer;

import com.ibm.xml.xci.CData;
import com.ibm.xml.xci.Cursor;
import com.ibm.xml.xci.CursorFactory;
import com.ibm.xml.xci.VolatileCData;
import com.ibm.xml.xci.dp.values.chars.Chars;
import com.ibm.xml.xci.serializer.AbstractStreamCursor;
import com.ibm.xml.xci.serializer.AddContentInterface;
import com.ibm.xml.xci.serializer.AdditionalAPIs;
import com.ibm.xml.xci.serializer.CursorExtended;
import com.ibm.xml.xci.serializer.EncodingInfo;
import com.ibm.xml.xci.serializer.Encodings;
import com.ibm.xml.xci.serializer.HtmlElemInfo;
import com.ibm.xml.xci.serializer.Messages;
import com.ibm.xml.xci.serializer.NamespaceMappings;
import com.ibm.xml.xci.serializer.SerializeParam;
import com.ibm.xml.xci.serializer.WriterOptimized;
import com.ibm.xml.xml4j.api.s1.xs.XSTypeDefinition;
import java.io.IOException;
import java.io.OutputStream;
import java.io.StringWriter;
import java.io.Writer;
import java.util.Map;

public class XHTMLStreamCursor
extends AbstractStreamCursor
implements Cursor,
AdditionalAPIs,
CursorExtended,
AddContentInterface {
    static final String IBM_COPYRIGHT = "Licensed Materials - Property of IBM\n\nXML Cursor Interface for Java (XCI-J)\u00a9 Copyright IBM Corp. 2004, 2009. All Rights Reserved.\n\nUS Government Users Restricted Rights - Use, duplication or disclosure \nrestricted by GSA ADP Schedule Contract with IBM Corp.";
    public static final String s_xhtmlURI = "http://www.w3.org/1999/xhtml";
    static final HtmlElemInfo.Trie m_elementFlags = new HtmlElemInfo.Trie(true);
    String m_attrName;
    private final boolean m_percentEscapeURIAttrs;
    private boolean m_inlineOnlyIfEmpty = false;
    protected final int CHARSBUFF_MAX_SIZE = 65536;
    private char[] m_charsBuff = new char[60];

    public XHTMLStreamCursor(CursorFactory cursorFactory, OutputStream outputStream, Map map2) {
        super(cursorFactory, outputStream, (Map<SerializeParam, Object>)map2);
        this.m_percentEscapeURIAttrs = this.shouldEscape(map2);
    }

    private boolean shouldEscape(Map map2) {
        Object v;
        return map2 == null || !((v = map2.get("escape-uri-attributes")) instanceof Boolean) || !Boolean.FALSE.equals(v);
    }

    public XHTMLStreamCursor(CursorFactory cursorFactory, Writer writer, Map map2) {
        super(cursorFactory, writer, (Map<SerializeParam, Object>)map2);
        this.m_percentEscapeURIAttrs = this.shouldEscape(map2);
    }

    final void privateWriteAttrNSDecl(int n2) throws IOException {
        String string2;
        this.m_writer.write(XMLNS);
        NamespaceMappings.MappingRecord mappingRecord = this.m_prefixMap.lookupNamespace(n2);
        String string3 = string2 = mappingRecord.get_uri();
        String string4 = mappingRecord.get_prefix();
        if (string4 != EMPTY_STRING) {
            this.m_writer.write(58);
            this.m_writer.write(string4);
        }
        this.m_writer.write(61);
        this.m_writer.write(34);
        this.escapeValue(string3, this.getCharEscapeMap((short)4));
        this.m_writer.write(34);
    }

    void writeOutHeader(String string2, String string3, String string4) throws IOException {
        Writer writer = this.m_writer;
        writer.write("<?xml version=\"");
        writer.write(string2);
        writer.write("\" encoding=\"");
        writer.write(string3);
        writer.write(34);
        writer.write(string4);
        writer.write("?>");
        if (this.doIndent() || null != this.getOutputPropertyNonDefault("doctype-system")) {
            this.m_writer.write(this.m_indentLineSep, 0, this.m_indentLineSepLen);
        }
    }

    void writeASCII(char c) throws IOException {
        this.m_writer.write(c);
    }

    void writeASCII(char[] cArray) throws IOException {
        this.m_writer.write(cArray, 0, cArray.length);
    }

    public final void writeBytes(byte[] byArray, int n2, int n3) throws IOException {
        if (this.m_writerOptimized != null) {
            this.m_writerOptimized.writeBytes(byArray, n2, n3);
        } else if (this.m_outputStream != null) {
            if (this.m_writer != null) {
                this.m_writer.flush();
            }
            this.m_outputStream.write(byArray, n2, n3);
        } else {
            this.m_writer.write(new String(byArray, n2, n3));
        }
    }

    final void writeNonElementQName(String string2, String string3) throws IOException {
        if (string2 != null && string2.length() > 0) {
            this.m_writer.write(string2);
            this.writeASCII(COLON_CHAR);
        }
        this.m_attrName = string3;
        if (this.m_writerOptimized != null) {
            this.m_writerOptimized.write(this.m_attrName);
        } else {
            this.m_writer.write(this.m_attrName);
        }
    }

    void writeAttributeValue(VolatileCData volatileCData) throws IOException {
        String string2;
        HtmlElemInfo.ElemDesc elemDesc;
        boolean bl;
        String string3 = this.m_elemContext.get_elemURI();
        boolean bl2 = bl = string3 != null && s_xhtmlURI.equals(string3);
        if (bl && (elemDesc = XHTMLStreamCursor.getElemDesc(string2 = this.m_elemContext.get_elemLocalName())).isAttrFlagSet(this.m_attrName, 2) && this.m_percentEscapeURIAttrs) {
            StringWriter stringWriter = new StringWriter();
            volatileCData.writeTo(stringWriter, false);
            this.writeHTMLAttrURI(this.m_writer, this.m_writerOptimized, stringWriter.toString());
            return;
        }
        this.writeValue(volatileCData, (short)141, true);
    }

    private void resetInlineElem(boolean bl) {
        this.m_isInlineElem = false;
        if (this.m_inlineOnlyIfEmpty) {
            if (!bl) {
                this.m_elemContext.set_isInline(false);
            }
            this.m_inlineOnlyIfEmpty = false;
        }
    }

    public final void addText(Cursor.Area area, VolatileCData volatileCData) {
        if (this.m_isInlineElem) {
            this.resetInlineElem(area == Cursor.Area.FOLLOWING_SIBLING);
        }
        super.addText(area, volatileCData);
    }

    public final void addText(Cursor.Area area, Chars chars) {
        if (this.m_isInlineElem) {
            this.resetInlineElem(area == Cursor.Area.FOLLOWING_SIBLING);
        }
        super.addText(area, chars);
    }

    public final void addProcessingInstruction(Cursor.Area area, VolatileCData volatileCData, VolatileCData volatileCData2) {
        if (this.m_isInlineElem) {
            this.resetInlineElem(area == Cursor.Area.FOLLOWING_SIBLING);
        }
        super.addProcessingInstruction(area, volatileCData, volatileCData2);
    }

    public final void addComment(Cursor.Area area, VolatileCData volatileCData) {
        if (this.m_isInlineElem) {
            this.resetInlineElem(area == Cursor.Area.FOLLOWING_SIBLING);
        }
        super.addComment(area, volatileCData);
    }

    public final void addElement(Cursor.Area area, VolatileCData volatileCData, XSTypeDefinition xSTypeDefinition) {
        String string2;
        HtmlElemInfo.ElemDesc elemDesc;
        if (this.m_isInlineElem) {
            this.resetInlineElem(area == Cursor.Area.FOLLOWING_SIBLING);
        }
        super.addElement(area, volatileCData, xSTypeDefinition);
        String string3 = this.m_elemContext.get_elemURI();
        if (string3 != null && s_xhtmlURI.equals(string3) && this.isAnHTMLElemName(elemDesc = XHTMLStreamCursor.getElemDesc(string2 = this.m_elemContext.get_elemLocalName()))) {
            this.m_isInlineElem = elemDesc.is(512);
            if (this.m_isInlineElem && (string2.equalsIgnoreCase("ins") || string2.equalsIgnoreCase("del"))) {
                this.m_inlineOnlyIfEmpty = true;
            }
            this.m_elemContext.set_isInline(this.m_isInlineElem);
        }
    }

    private boolean notAnHTMLElemName(HtmlElemInfo.ElemDesc elemDesc) {
        return elemDesc == HtmlElemInfo.s_elemNotFound;
    }

    private boolean isAnHTMLElemName(HtmlElemInfo.ElemDesc elemDesc) {
        return elemDesc != HtmlElemInfo.s_elemNotFound;
    }

    private static final HtmlElemInfo.ElemDesc getElemDesc(String string2) {
        Object object2 = m_elementFlags.get(string2);
        if (null != object2) {
            return (HtmlElemInfo.ElemDesc)object2;
        }
        return HtmlElemInfo.s_elemNotFound;
    }

    public AdditionalAPIs getCursorExtensions() {
        return this;
    }

    public String getPrefix(String string2) {
        String string3;
        NamespaceMappings.MappingRecord mappingRecord = this.m_prefixMap.lookupPrefix(string2);
        if (mappingRecord != null && (string3 = mappingRecord.get_prefix()).length() > 0) {
            return string3;
        }
        return null;
    }

    public String getUnusedPrefix() {
        String string2 = this.m_prefixMap.generateUnusedPrefix();
        return string2;
    }

    public void writeClosingTag(VolatileCData volatileCData) throws IOException {
        this.m_isInlineElem = this.m_elemContext.is_Inline();
        super.writeClosingTag(volatileCData);
    }

    public final void writeSlashBracket() throws IOException {
        String string2 = this.m_elemContext.get_elemURI();
        boolean bl = string2 == null || !s_xhtmlURI.equals(string2);
        String string3 = this.m_elemContext.get_elemLocalName();
        this.m_isInlineElem = this.m_elemContext.is_Inline();
        if (this.mayAddNamespaceNode()) {
            if (bl) {
                super.privateElemStart();
                this.writeASCII(SPACE_SLASH_BRACKET);
                return;
            }
            HtmlElemInfo.ElemDesc elemDesc = XHTMLStreamCursor.getElemDesc(string3);
            if (this.notAnHTMLElemName(elemDesc)) {
                super.privateElemStart();
                this.writeASCII(SPACE_SLASH_BRACKET);
                return;
            }
            this.privateElemStart();
            if (elemDesc.is(2)) {
                this.writeASCII(SPACE_SLASH_BRACKET);
            } else {
                this.m_writer.write("></");
                this.m_writer.write(string3);
                this.writeASCII(GREATERTHAN_CHAR);
            }
            return;
        }
        if (bl) {
            this.writeASCII(SPACE_SLASH_BRACKET);
        } else {
            HtmlElemInfo.ElemDesc elemDesc = XHTMLStreamCursor.getElemDesc(string3);
            if (this.notAnHTMLElemName(elemDesc)) {
                this.writeASCII(SPACE_SLASH_BRACKET);
                return;
            }
            if (elemDesc.is(2)) {
                this.writeASCII(SPACE_SLASH_BRACKET);
            } else {
                this.m_writer.write("></");
                this.m_writer.write(string3);
                this.writeASCII(GREATERTHAN_CHAR);
            }
        }
    }

    protected void indent() throws IOException {
        int n2 = this.getElemDepth() - 1;
        Object object2 = this.getOutputProperty(SerializeParam.INDENT_AMOUNT);
        Integer n3 = (Integer)object2;
        n2 *= n3.intValue();
        Character c = (Character)this.getOutputProperty(SerializeParam.INDENT_CHARACTER);
        for (int i = 0; i < n2; ++i) {
            this.m_writer.write(c.charValue());
        }
    }

    final void privateElemStart() throws IOException {
        String string2 = this.m_elemContext.get_elemURI();
        if (string2 == null || !s_xhtmlURI.equals(string2)) {
            super.privateElemStart();
            return;
        }
        String string3 = this.m_elemContext.get_elemLocalName();
        HtmlElemInfo.ElemDesc elemDesc = XHTMLStreamCursor.getElemDesc(string3);
        if (this.notAnHTMLElemName(elemDesc)) {
            super.privateElemStart();
            return;
        }
        this.writeASCII(LESSTHAN_CHAR);
        String string4 = this.m_elemContext.get_elemLocalName();
        this.m_writer.write(string4);
        int n2 = this.m_elemContext.get_firstNamespaceNode();
        if (0 <= n2) {
            int n3 = this.m_elemContext.get_lastNamespaceNode();
            for (int i = n2; i <= n3; ++i) {
                this.privateWriteAttrNSDecl(i);
            }
        }
    }

    public boolean isCurrentElemInline(VolatileCData volatileCData) {
        CData cData = volatileCData.constant(true);
        String string2 = cData.getQNameLocalPart(1);
        HtmlElemInfo.ElemDesc elemDesc = XHTMLStreamCursor.getElemDesc(string2);
        if (this.isAnHTMLElemName(elemDesc) && !string2.equalsIgnoreCase("ins") && !string2.equalsIgnoreCase("del")) {
            return elemDesc.is(512);
        }
        return false;
    }

    void writeHTMLAttrURI(Writer writer, WriterOptimized writerOptimized, String string2) throws IOException {
        int n2;
        int n3 = string2.length();
        for (int i = 0; i < n3; i += n2) {
            n2 = this.getChars(string2, i, n3);
            char[] cArray = this.getCharsBuff();
            char c = '\u0000';
            for (int j = 0; j < n2; ++j) {
                String string3;
                c = cArray[j];
                if (c < ' ' || c > '~') {
                    int n4;
                    int n5;
                    if (c <= '\u007f') {
                        writer.write(37);
                        writer.write(XHTMLStreamCursor.makeHexString(c));
                        continue;
                    }
                    if (c <= '\u07ff') {
                        int n6 = c >> 6 | 0xC0;
                        n5 = c & 0x3F | 0x80;
                        writer.write(37);
                        writer.write(XHTMLStreamCursor.makeHexString(n6));
                        writer.write(37);
                        writer.write(XHTMLStreamCursor.makeHexString(n5));
                        continue;
                    }
                    if (Encodings.isHighUTF16Surrogate(c)) {
                        int n7 = c & 0x3FF;
                        n5 = (n7 & 0x3C0) >> 6;
                        n4 = n5 + 1;
                        int n8 = (n7 & 0x3C) >> 2;
                        int n9 = (n7 & 3) << 4 & 0x30;
                        c = cArray[++j];
                        int n10 = c & 0x3FF;
                        int n11 = n10 & 0x3F;
                        int n12 = 0xF0 | n4 >> 2;
                        int n13 = 0x80 | (n4 & 3) << 4 & 0x30 | n8;
                        int n14 = 0x80 | (n9 |= (n10 & 0x3C0) >> 6);
                        int n15 = 0x80 | n11;
                        writer.write(37);
                        writer.write(XHTMLStreamCursor.makeHexString(n12));
                        writer.write(37);
                        writer.write(XHTMLStreamCursor.makeHexString(n13));
                        writer.write(37);
                        writer.write(XHTMLStreamCursor.makeHexString(n14));
                        writer.write(37);
                        writer.write(XHTMLStreamCursor.makeHexString(n15));
                        continue;
                    }
                    int n16 = c >> 12 | 0xE0;
                    n5 = (c & 0xFC0) >> 6 | 0x80;
                    n4 = c & 0x3F | 0x80;
                    writer.write(37);
                    writer.write(XHTMLStreamCursor.makeHexString(n16));
                    writer.write(37);
                    writer.write(XHTMLStreamCursor.makeHexString(n5));
                    writer.write(37);
                    writer.write(XHTMLStreamCursor.makeHexString(n4));
                    continue;
                }
                switch (c) {
                    case '\"': {
                        string3 = "&quot;";
                        break;
                    }
                    case '&': {
                        string3 = "&amp;";
                        break;
                    }
                    case '>': {
                        string3 = "&gt;";
                        break;
                    }
                    case '<': {
                        string3 = "&lt;";
                        break;
                    }
                    default: {
                        string3 = null;
                    }
                }
                if (string3 != null) {
                    writer.write(string3);
                    continue;
                }
                writer.write(c);
            }
        }
    }

    int getChars(String string2, int n2, int n3) {
        int n4;
        int n5 = n3 - n2;
        if (n5 <= 0) {
            n4 = 0;
        } else {
            char[] cArray = this.m_charsBuff;
            int n6 = cArray.length;
            if (n5 <= n6) {
                int n7 = n5 - 1;
                string2.getChars(n2, n3, cArray, 0);
                char c = cArray[n7];
                n4 = Encodings.isHighUTF16Surrogate(c) ? n7 : n5;
            } else {
                if (n6 != 65536) {
                    n6 = n5 * 2 + 1;
                    if (n6 > 65536) {
                        n6 = 65536;
                    }
                    this.m_charsBuff = cArray = new char[n6];
                }
                if (n6 < n5) {
                    n5 = n6;
                    n3 = n2 + n5;
                }
                int n8 = n5 - 1;
                string2.getChars(n2, n3, cArray, 0);
                char c = cArray[n8];
                n4 = Encodings.isHighUTF16Surrogate(c) ? n8 : n5;
            }
        }
        return n4;
    }

    final char[] getCharsBuff() {
        return this.m_charsBuff;
    }

    void writeoutDOCTYPE(String string2) throws IOException {
        String string3 = this.getDoctypeSystem();
        if (null == string3) {
            return;
        }
        Writer writer = this.m_writer;
        writer.write("<!DOCTYPE ");
        writer.write(string2);
        String string4 = this.getDoctypePublic();
        if (null != string4) {
            writer.write(" PUBLIC \"");
            writer.write(string4);
            writer.write("\" \"");
        } else {
            writer.write(" SYSTEM \"");
        }
        writer.write(string3);
        writer.write("\">");
        writer.write(this.m_indentLineSep, 0, this.m_indentLineSepLen);
    }

    void setDefaultProperties() {
        EncodingInfo encodingInfo = Encodings.getEncodingInfo("UTF-8");
        this.m_version = "1.0";
        this.m_isXML11 = false;
        this.m_encodingInfo = encodingInfo;
        this.m_isUTF8 = true;
        this.setIndent(true);
        this.setStandalone("omit");
        this.m_wasJustReset = true;
        this.m_normalizerMode = 1;
        this.m_isFirstRoot = false;
        this.m_isASCIIEncoding = false;
        this.m_doctypeSystem = null;
        this.m_doctypePublic = null;
    }

    Object getProp(Object object2, boolean bl) {
        Object object3 = null;
        String string2 = null;
        if (object2 instanceof String) {
            string2 = (String)object2;
        } else if (object2 instanceof SerializeParam) {
            string2 = ((SerializeParam)object2).toString();
        } else {
            return null;
        }
        if (bl) {
            if (string2.equals("version".toString())) {
                object3 = "1.0";
                return object3;
            }
            if (string2.equals("encoding".toString())) {
                object3 = "UTF-8";
                return object3;
            }
            if (string2.equals("indent".toString())) {
                object3 = Boolean.TRUE;
                return object3;
            }
            if (string2.equals("method".toString())) {
                object3 = "xhtml";
                return object3;
            }
            if (string2.equals("media-type".toString())) {
                object3 = "text/html";
                return object3;
            }
            if (string2.equals("omit-xml-declaration".toString())) {
                object3 = Boolean.FALSE;
                return object3;
            }
            if (string2.equals("standalone".toString())) {
                object3 = Boolean.FALSE;
                return object3;
            }
            if (string2.equals(SerializeParam.INDENT_AMOUNT.toString())) {
                object3 = 2;
                return object3;
            }
            if (string2.equals(SerializeParam.INDENT_CHARACTER.toString())) {
                object3 = Character.valueOf(' ');
                return object3;
            }
        } else if (this.m_OutputProps == null) {
            object3 = null;
        } else {
            object3 = this.m_OutputProps.get(object2);
            if (object3 == null && object2 instanceof SerializeParam) {
                object3 = this.m_OutputProps.get(object2.toString());
            }
        }
        return object3;
    }

    public boolean toIds(VolatileCData volatileCData, boolean bl) {
        if (bl) {
            String string2 = Messages.createMessage2("ER_UNIMPLEMENTED_METHOD", new String[]{"toIds", this.getClass().getName()});
            Messages.xciDynamicErrorException(string2);
        }
        return false;
    }

    static {
        HtmlElemInfo.initTagReference(m_elementFlags);
    }
}

