/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xml.xci.serializer;

import com.ibm.xml.xci.serializer.HiddenOptions;
import com.ibm.xml.xci.serializer.WriterChain;
import com.ibm.xml.xci.serializer.WriterOptimized;
import java.io.IOException;
import java.io.OutputStream;
import java.io.Writer;

public final class WriterToUTF8Buffered
extends WriterOptimized
implements WriterChain {
    static final String IBM_COPYRIGHT = "Licensed Materials - Property of IBM\n\nXML Cursor Interface for Java (XCI-J)\u00a9 Copyright IBM Corp. 2004, 2008. All Rights Reserved.\n\nUS Government Users Restricted Rights - Use, duplication or disclosure\nrestricted by GSA ADP Schedule Contract with IBM Corp.";
    private static final int BYTES_MAX;
    private static final int CHARS_MAX;
    private OutputStream m_os;
    private final byte[] m_outputBytes;
    private final char[] m_inputChars;
    private int count;
    OutputStream m_asOutputStream;

    WriterToUTF8Buffered(OutputStream outputStream) {
        this.m_os = outputStream;
        this.m_outputBytes = new byte[BYTES_MAX + 3];
        this.m_inputChars = new char[CHARS_MAX + 2];
        this.count = 0;
        this.m_asOutputStream = null;
    }

    public void write(int n2) throws IOException {
        if (this.count >= BYTES_MAX) {
            this.flushBuffer();
        }
        if (n2 < 128) {
            this.m_outputBytes[this.count++] = (byte)n2;
        } else if (n2 < 2048) {
            this.m_outputBytes[this.count++] = (byte)(192 + (n2 >> 6));
            this.m_outputBytes[this.count++] = (byte)(128 + (n2 & 0x3F));
        } else if (n2 < 65536) {
            this.m_outputBytes[this.count++] = (byte)(224 + (n2 >> 12));
            this.m_outputBytes[this.count++] = (byte)(128 + (n2 >> 6 & 0x3F));
            this.m_outputBytes[this.count++] = (byte)(128 + (n2 & 0x3F));
        } else {
            this.m_outputBytes[this.count++] = (byte)(240 + (n2 >> 18));
            this.m_outputBytes[this.count++] = (byte)(128 + (n2 >> 12 & 0x3F));
            this.m_outputBytes[this.count++] = (byte)(128 + (n2 >> 6 & 0x3F));
            this.m_outputBytes[this.count++] = (byte)(128 + (n2 & 0x3F));
        }
    }

    public void write(char[] cArray, int n2, int n3) throws IOException {
        char c;
        int n4;
        int n5 = 3 * n3;
        if (n5 >= BYTES_MAX - this.count) {
            this.flushBuffer();
            if (n5 > BYTES_MAX) {
                int n6 = this.getNumberOfChunks(n3);
                int n7 = n2;
                for (int i = 1; i <= n6; ++i) {
                    int n8 = n7;
                    n7 = this.getEndOfChunk(n2, n3, n6, i);
                    char c2 = cArray[n7 - 1];
                    if (c2 >= '\ud800' && c2 <= '\udbff') {
                        n7 = n7 < n2 + n3 ? ++n7 : --n7;
                    }
                    int n9 = n7 - n8;
                    this.write(cArray, n8, n9);
                }
                return;
            }
        }
        int n10 = n3 + n2;
        byte[] byArray = this.m_outputBytes;
        int n11 = this.count;
        for (n4 = n2; n4 < n10 && (c = cArray[n4]) < '\u0080'; ++n4) {
            byArray[n11++] = (byte)c;
        }
        while (n4 < n10) {
            c = cArray[n4];
            if (c < '\u0080') {
                byArray[n11++] = (byte)c;
            } else if (c < '\u0800') {
                byArray[n11++] = (byte)(192 + (c >> 6));
                byArray[n11++] = (byte)(128 + (c & 0x3F));
            } else if (c >= '\ud800' && c <= '\udbff') {
                char c3 = c;
                char c4 = cArray[++n4];
                byArray[n11++] = (byte)(0xF0 | c3 + 64 >> 8 & 7);
                byArray[n11++] = (byte)(0x80 | c3 + 64 >> 2 & 0x3F);
                byArray[n11++] = (byte)(0x80 | (c4 >> 6 & 0xF) + (c3 << 4 & 0x30));
                byArray[n11++] = (byte)(0x80 | c4 & 0x3F);
            } else {
                byArray[n11++] = (byte)(224 + (c >> 12));
                byArray[n11++] = (byte)(128 + (c >> 6 & 0x3F));
                byArray[n11++] = (byte)(128 + (c & 0x3F));
            }
            ++n4;
        }
        this.count = n11;
    }

    private int getNumberOfChunks(int n2) {
        int n3 = n2 / CHARS_MAX;
        int n4 = n2 % CHARS_MAX > 0 ? n3 + 1 : n3;
        return n4;
    }

    public void write(String string2) throws IOException {
        char c;
        int n2;
        int n3 = string2.length();
        int n4 = 3 * n3;
        if (n4 >= BYTES_MAX - this.count) {
            this.flushBuffer();
            if (n4 > BYTES_MAX) {
                int n5 = this.getNumberOfChunks(n3);
                int n6 = 0;
                for (int i = 1; i <= n5; ++i) {
                    int n7 = n6;
                    n6 = this.getEndOfChunk(0, n3, n5, i);
                    string2.getChars(n7, n6, this.m_inputChars, 0);
                    int n8 = n6 - n7;
                    char c2 = this.m_inputChars[n8 - 1];
                    if (c2 >= '\ud800' && c2 <= '\udbff') {
                        --n6;
                        --n8;
                        if (i == n5) {
                            // empty if block
                        }
                    }
                    this.write(this.m_inputChars, 0, n8);
                }
                return;
            }
        }
        string2.getChars(0, n3, this.m_inputChars, 0);
        char[] cArray = this.m_inputChars;
        int n9 = n3;
        byte[] byArray = this.m_outputBytes;
        int n10 = this.count;
        for (n2 = 0; n2 < n9 && (c = cArray[n2]) < '\u0080'; ++n2) {
            byArray[n10++] = (byte)c;
        }
        while (n2 < n9) {
            c = cArray[n2];
            if (c < '\u0080') {
                byArray[n10++] = (byte)c;
            } else if (c < '\u0800') {
                byArray[n10++] = (byte)(192 + (c >> 6));
                byArray[n10++] = (byte)(128 + (c & 0x3F));
            } else if (c >= '\ud800' && c <= '\udbff') {
                char c3 = c;
                char c4 = cArray[++n2];
                byArray[n10++] = (byte)(0xF0 | c3 + 64 >> 8 & 7);
                byArray[n10++] = (byte)(0x80 | c3 + 64 >> 2 & 0x3F);
                byArray[n10++] = (byte)(0x80 | (c4 >> 6 & 0xF) + (c3 << 4 & 0x30));
                byArray[n10++] = (byte)(0x80 | c4 & 0x3F);
            } else {
                byArray[n10++] = (byte)(224 + (c >> 12));
                byArray[n10++] = (byte)(128 + (c >> 6 & 0x3F));
                byArray[n10++] = (byte)(128 + (c & 0x3F));
            }
            ++n2;
        }
        this.count = n10;
    }

    public void flushBuffer() throws IOException {
        if (this.count > 0) {
            this.m_os.write(this.m_outputBytes, 0, this.count);
            this.count = 0;
        }
    }

    public void flush() throws IOException {
        this.flushBuffer();
        this.m_os.flush();
    }

    public void close() throws IOException {
        this.flushBuffer();
        this.m_os.close();
    }

    public OutputStream getOutputStream() {
        return this.m_os;
    }

    public Writer getWriter() {
        return null;
    }

    public void writeASCII(char[] cArray, int n2, int n3) throws IOException {
        int n4 = 3 * n3;
        if (n4 >= BYTES_MAX - this.count) {
            this.flushBuffer();
            if (n4 > BYTES_MAX) {
                int n5 = this.getNumberOfChunks(n3);
                int n6 = n2;
                for (int i = 1; i <= n5; ++i) {
                    int n7 = n6;
                    n6 = this.getEndOfChunk(n2, n3, n5, i);
                    int n8 = n6 - n7;
                    this.writeASCIIChunk(cArray, n7, n8);
                }
                return;
            }
        }
        this.writeASCIIChunk(cArray, n2, n3);
    }

    private int getEndOfChunk(int n2, int n3, int n4, int n5) {
        return n2 + (int)((long)n3 * (long)n5 / (long)n4);
    }

    public void writeASCII(String string2) throws IOException {
        int n2 = string2.length();
        int n3 = 3 * n2;
        if (n3 >= BYTES_MAX - this.count) {
            this.flushBuffer();
            if (n3 > BYTES_MAX) {
                int n4 = this.getNumberOfChunks(n2);
                int n5 = 0;
                for (int i = 1; i <= n4; ++i) {
                    int n6 = n5;
                    n5 = this.getEndOfChunk(0, n2, n4, i);
                    string2.getChars(n6, n5, this.m_inputChars, 0);
                    int n7 = n5 - n6;
                    this.writeASCIIChunk(this.m_inputChars, 0, n7);
                }
                return;
            }
        }
        string2.getChars(0, n2, this.m_inputChars, 0);
        this.writeASCIIChunk(this.m_inputChars, 0, n2);
    }

    private void writeASCIIChunk(char[] cArray, int n2, int n3) throws IOException {
        int n4 = n3 + n2;
        byte[] byArray = this.m_outputBytes;
        int n5 = this.count;
        for (int i = n2; i < n4; ++i) {
            byArray[n5++] = (byte)cArray[i];
        }
        this.count = n5;
    }

    public void setOuputStream(OutputStream outputStream) {
        this.m_os = outputStream;
        this.count = 0;
    }

    void writeCharsNoChunking(char[] cArray, int n2, int n3) {
    }

    void writeASCIINoChunking(char[] cArray, int n2, int n3) {
    }

    void writeBytes(byte[] byArray, int n2, int n3) throws IOException {
        int n4 = 3 * n3;
        if (n4 >= BYTES_MAX - this.count) {
            this.flushBuffer();
            if (n4 > BYTES_MAX) {
                int n5 = this.getNumberOfChunks(n3);
                int n6 = n2;
                for (int i = 1; i <= n5; ++i) {
                    int n7 = n6;
                    n6 = this.getEndOfChunk(n2, n3, n5, i);
                    int n8 = n6 - n7;
                    this.writeBytes(byArray, n7, n8);
                }
                return;
            }
        }
        int n9 = n3 + n2;
        System.arraycopy(byArray, n2, this.m_outputBytes, this.count, n3);
        this.count += n3;
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        for (int i = 0; i < this.count; ++i) {
            if (this.m_outputBytes[i] >= 127) continue;
            char c = (char)this.m_outputBytes[i];
            stringBuilder.append(c);
        }
        return stringBuilder.toString();
    }

    public void writeByte(byte by2) throws IOException {
        if (this.count >= BYTES_MAX) {
            this.flushBuffer();
        }
        this.m_outputBytes[this.count++] = by2;
    }

    public OutputStream asOutputStream() {
        if (this.m_asOutputStream == null) {
            this.m_asOutputStream = new AsOutputStream(this);
        }
        return this.m_asOutputStream;
    }

    static {
        Integer n2 = HiddenOptions.getIntegerValue("WriterToUTF8Buffered.buffsize");
        BYTES_MAX = n2 != null && n2 > 0 ? n2 : 16384;
        CHARS_MAX = BYTES_MAX / 3;
    }

    public static final class AsOutputStream
    extends OutputStream {
        final WriterToUTF8Buffered m_w;

        public AsOutputStream(WriterToUTF8Buffered writerToUTF8Buffered) {
            this.m_w = writerToUTF8Buffered;
        }

        public void write(int n2) throws IOException {
            this.m_w.write(n2);
        }

        public void close() throws IOException {
            this.m_w.close();
        }

        public void flush() throws IOException {
            this.m_w.flush();
        }

        public void write(byte[] byArray) throws IOException {
            this.write(byArray, 0, byArray.length);
        }

        public void write(byte[] byArray, int n2, int n3) throws IOException {
            this.m_w.writeBytes(byArray, n2, n3);
        }

        public WriterToUTF8Buffered getAssociatedWriter() {
            return this.m_w;
        }
    }
}

