/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xml.xci.serializer;

import com.ibm.xml.xci.serializer.WriterChain;
import java.io.IOException;
import java.io.OutputStream;
import java.io.Writer;

public abstract class WriterOptimized
extends Writer
implements WriterChain {
    static final String IBM_COPYRIGHT = "Licensed Materials - Property of IBM\n\nXML Cursor Interface for Java (XCI-J)\u00a9 Copyright IBM Corp. 2004, 2008. All Rights Reserved.\n\nUS Government Users Restricted Rights - Use, duplication or disclosure \nrestricted by GSA ADP Schedule Contract with IBM Corp.";
    protected static final int BYTES_MAX = 16384;
    static final int CHARS_MAX = 5461;
    OutputStream m_os;
    protected final byte[] m_outputBytes;
    final char[] m_inputChars;
    protected int count;

    protected WriterOptimized(OutputStream outputStream) {
        this.m_os = outputStream;
        this.m_outputBytes = new byte[16387];
        this.m_inputChars = new char[5463];
        this.count = 0;
    }

    protected WriterOptimized() {
        this.m_inputChars = null;
        this.m_outputBytes = null;
    }

    public abstract void write(int var1) throws IOException;

    public abstract void writeByte(byte var1) throws IOException;

    public void write(char[] cArray, int n2, int n3) throws IOException {
        int n4 = 3 * n3;
        if (n4 >= 16384 - this.count) {
            this.flushBuffer();
            if (n4 > 16384) {
                int n5 = this.getNumberOfChunks(n3);
                int n6 = n2;
                for (int i = 1; i <= n5; ++i) {
                    int n7 = n6;
                    n6 = this.getEndOfChunk(n2, n3, n5, i);
                    char c = cArray[n6 - 1];
                    if (c >= '\ud800' && c <= '\udbff') {
                        n6 = n6 < n2 + n3 ? ++n6 : --n6;
                    }
                    int n8 = n6 - n7;
                    this.write(cArray, n7, n8);
                }
                return;
            }
        }
        this.writeCharsNoChunking(cArray, n2, n3);
    }

    abstract void writeCharsNoChunking(char[] var1, int var2, int var3);

    abstract void writeASCIINoChunking(char[] var1, int var2, int var3);

    private final int getNumberOfChunks(int n2) {
        int n3 = n2 / 5461;
        int n4 = n2 % 5461 > 0 ? n3 + 1 : n3;
        return n4;
    }

    public void write(String string2) throws IOException {
        int n2 = string2.length();
        int n3 = 3 * n2;
        if (n3 >= 16384 - this.count) {
            this.flushBuffer();
            if (n3 > 16384) {
                int n4 = this.getNumberOfChunks(n2);
                int n5 = 0;
                for (int i = 1; i <= n4; ++i) {
                    int n6 = n5;
                    n5 = this.getEndOfChunk(0, n2, n4, i);
                    string2.getChars(n6, n5, this.m_inputChars, 0);
                    int n7 = n5 - n6;
                    char c = this.m_inputChars[n7 - 1];
                    if (c >= '\ud800' && c <= '\udbff') {
                        --n5;
                        --n7;
                        if (i == n4) {
                            // empty if block
                        }
                    }
                    this.write(this.m_inputChars, 0, n7);
                }
                return;
            }
        }
        string2.getChars(0, n2, this.m_inputChars, 0);
        char[] cArray = this.m_inputChars;
        this.writeCharsNoChunking(cArray, 0, n2);
    }

    void flushBuffer() throws IOException {
        if (this.count > 0) {
            this.m_os.write(this.m_outputBytes, 0, this.count);
            this.count = 0;
        }
    }

    public void flush() throws IOException {
        this.flushBuffer();
        this.m_os.flush();
    }

    public void close() throws IOException {
        this.flushBuffer();
        this.m_os.close();
    }

    public OutputStream getOutputStream() {
        return this.m_os;
    }

    public Writer getWriter() {
        return null;
    }

    void writeASCII(char[] cArray, int n2, int n3) throws IOException {
        int n4 = 3 * n3;
        if (n4 >= 16384 - this.count) {
            this.flushBuffer();
            if (n4 > 16384) {
                int n5 = this.getNumberOfChunks(n3);
                int n6 = n2;
                for (int i = 1; i <= n5; ++i) {
                    int n7 = n6;
                    n6 = this.getEndOfChunk(n2, n3, n5, i);
                    int n8 = n6 - n7;
                    this.writeASCII(cArray, n7, n8);
                }
                return;
            }
        }
        this.writeASCIINoChunking(cArray, n2, n3);
    }

    void writeBytes(byte[] byArray, int n2, int n3) throws IOException {
        int n4 = 3 * n3;
        if (n4 >= 16384 - this.count) {
            this.flushBuffer();
            if (n4 > 16384) {
                int n5 = this.getNumberOfChunks(n3);
                int n6 = n2;
                for (int i = 1; i <= n5; ++i) {
                    int n7 = n6;
                    n6 = this.getEndOfChunk(n2, n3, n5, i);
                    int n8 = n6 - n7;
                    this.writeBytes(byArray, n7, n8);
                }
                return;
            }
        }
        int n9 = n3 + n2;
        byte[] byArray2 = this.m_outputBytes;
        int n10 = this.count;
        for (int i = n2; i < n9; ++i) {
            byArray2[n10++] = byArray[i];
        }
        this.count = n10;
    }

    private final int getEndOfChunk(int n2, int n3, int n4, int n5) {
        return n2 + (int)((long)n3 * (long)n5 / (long)n4);
    }

    void writeASCII(String string2) throws IOException {
        int n2 = string2.length();
        int n3 = 3 * n2;
        if (n3 >= 16384 - this.count) {
            this.flushBuffer();
            if (n3 > 16384) {
                int n4 = this.getNumberOfChunks(n2);
                int n5 = 0;
                for (int i = 1; i <= n4; ++i) {
                    int n6 = n5;
                    n5 = this.getEndOfChunk(0, n2, n4, i);
                    string2.getChars(n6, n5, this.m_inputChars, 0);
                    int n7 = n5 - n6;
                    this.writeASCII(this.m_inputChars, 0, n7);
                }
                return;
            }
        }
        string2.getChars(0, n2, this.m_inputChars, 0);
        char[] cArray = this.m_inputChars;
        this.writeASCIINoChunking(cArray, 0, n2);
    }

    void setOuputStream(OutputStream outputStream) {
        this.m_os = outputStream;
        this.count = 0;
    }
}

