/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xml.xci.serializer;

import com.ibm.xml.xci.serializer.WriterToUTF8Buffered;
import java.io.OutputStream;
import java.lang.ref.SoftReference;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class WriterCache {
    static final String IBM_COPYRIGHT = "Licensed Materials - Property of IBM\n\nXML Cursor Interface for Java (XCI-J)\u00a9 Copyright IBM Corp. 2008. All Rights Reserved.\n\nUS Government Users Restricted Rights - Use, duplication or disclosure \nrestricted by GSA ADP Schedule Contract with IBM Corp.";
    static final ThreadLocal s_singleton = new ThreadLocal();

    private WriterCache() {
    }

    public static final WriterToUTF8Buffered getWriterToUTF8Buffered(OutputStream outputStream) {
        WriterToUTF8Buffered writerToUTF8Buffered;
        assert (outputStream != null);
        SoftReference<WriterToUTF8Buffered> softReference = WriterCache.getThisThreadSoftReference();
        if (softReference != null && (writerToUTF8Buffered = softReference.get()) != null) {
            if (WriterCache.writerIsInUse(writerToUTF8Buffered)) {
                writerToUTF8Buffered = new WriterToUTF8Buffered(outputStream);
                WriterCache.setThisThreadsWriter(writerToUTF8Buffered);
            } else {
                writerToUTF8Buffered.setOuputStream(outputStream);
            }
        } else {
            writerToUTF8Buffered = new WriterToUTF8Buffered(outputStream);
            WriterCache.setThisThreadsWriter(writerToUTF8Buffered);
        }
        return writerToUTF8Buffered;
    }

    private static final boolean writerIsInUse(WriterToUTF8Buffered writerToUTF8Buffered) {
        OutputStream outputStream = writerToUTF8Buffered.getOutputStream();
        boolean bl = outputStream != null;
        return bl;
    }

    public static final void returnWriterToUTF8Buffered(WriterToUTF8Buffered writerToUTF8Buffered) {
        assert (writerToUTF8Buffered != null);
        writerToUTF8Buffered.setOuputStream(null);
    }

    private static SoftReference<WriterToUTF8Buffered> getThisThreadSoftReference() {
        SoftReference softReference = (SoftReference)ThreadLocalHolder.s_singleton.get();
        return softReference;
    }

    private static final void setThisThreadsWriter(WriterToUTF8Buffered writerToUTF8Buffered) {
        if (writerToUTF8Buffered != null) {
            SoftReference<WriterToUTF8Buffered> softReference = new SoftReference<WriterToUTF8Buffered>(writerToUTF8Buffered);
            ThreadLocalHolder.s_singleton.set(softReference);
        }
    }

    private static class ThreadLocalHolder {
        static final ThreadLocal s_singleton = new ThreadLocal();

        private ThreadLocalHolder() {
        }
    }
}

