/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xml.xci.serializer;

import com.ibm.xml.xci.CData;
import com.ibm.xml.xci.Cursor;
import com.ibm.xml.xci.CursorFactory;
import com.ibm.xml.xci.NodeTest;
import com.ibm.xml.xci.VolatileCData;
import com.ibm.xml.xci.dp.values.chars.Chars;
import com.ibm.xml.xci.serializer.AbstractSerializeCommon;
import com.ibm.xml.xci.serializer.AddContentInterface;
import com.ibm.xml.xci.serializer.AdditionalAPIs;
import com.ibm.xml.xci.serializer.CodepointMappings;
import com.ibm.xml.xci.serializer.CursorExtended;
import com.ibm.xml.xci.serializer.ElemContext;
import com.ibm.xml.xci.serializer.EncodingInfo;
import com.ibm.xml.xci.serializer.Encodings;
import com.ibm.xml.xci.serializer.Messages;
import com.ibm.xml.xci.serializer.NamespaceMappings;
import com.ibm.xml.xci.serializer.SecuritySupport;
import com.ibm.xml.xci.serializer.Serialize;
import com.ibm.xml.xci.serializer.SerializeParam;
import com.ibm.xml.xci.serializer.SerializeParamValue;
import com.ibm.xml.xci.serializer.UnicodeNormalizer;
import com.ibm.xml.xci.serializer.UnicodeNormalizerFactory;
import com.ibm.xml.xci.serializer.WriterCache;
import com.ibm.xml.xci.serializer.WriterOptimized;
import com.ibm.xml.xci.serializer.WriterStateless;
import com.ibm.xml.xci.serializer.WriterToASCI;
import com.ibm.xml.xci.serializer.WriterToUTF8Buffered;
import com.ibm.xml.xml4j.api.s1.xs.XSTypeDefinition;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import java.util.List;
import java.util.Map;
import javax.xml.namespace.QName;
import javax.xml.transform.SourceLocator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TEXTStreamCursor
extends AbstractSerializeCommon
implements Cursor,
AdditionalAPIs,
CursorExtended,
AddContentInterface {
    static final String IBM_COPYRIGHT = "Licensed Materials - Property of IBM\n\nXML Cursor Interface for Java (XCI-J)\u00a9 Copyright IBM Corp. 2004, 2009. All Rights Reserved.\n\nUS Government Users Restricted Rights - Use, duplication or disclosure \nrestricted by GSA ADP Schedule Contract with IBM Corp.";
    private static final boolean s_supportYesNo = true;
    private CodepointMappings m_codePointMappings;
    private final Map<SerializeParam, Object> m_OutputProps;
    protected static final String EMPTY_STRING;
    private static final char[] XMLNS_PREFIX;
    private static final char[] SLASH_BRACKET;
    private static final char[] BRACKET_SLASH;
    protected static final char[] XMLNS;
    private static final char[] LESSTHAN_QUESTIONMARK;
    private static final char[] QUESTIONMARK_GREATERTHAN;
    private static final char[] COMMENT_START;
    private static final char[] COMMENT_END;
    private static final char[] XMLNS_COLON;
    private static final char[] EQUALS_DOUBLEQUOTE;
    static final String XML_HEADER_VERSION_STRING;
    static final byte[] XML_HEADER_VERSION_BYTES;
    static final char[] XML_HEADER_VERSION_CHARS;
    static final String XML_HEADER_ENCODING_STRING;
    static final byte[] XML_HEADER_ENCODING_BYTES;
    static final char[] XML_HEADER_ENCODING_CHARS;
    static final String XML_HEADER_END_STRING;
    static final byte[] XML_HEADER_END_BYTES;
    static final char[] XML_HEADER_END_CHARS;
    static final char DOUBLE_QUOTE_CHAR;
    static final char SPACE_CHAR;
    static final char EQUALS_CHAR;
    static final char LESSTHAN_CHAR;
    static final char GREATERTHAN_CHAR;
    static final char COLON_CHAR;
    static final byte DOUBLE_QUOTE_BYTE;
    static final char[] DOUBLE_QUOTE_CHARS;
    static final char[] LESSTHAN_QUESTION_CHARS;
    static final char[] QUESTION_GREATERTHAN_CHARS;
    boolean m_openMutationCalled = false;
    private boolean m_wasJustReset;
    protected Writer m_writer = null;
    protected OutputStream m_outputStream;
    private CursorFactory m_factory;
    private int m_normalizerMode = 1;
    private UnicodeNormalizer m_unicodeNormalizer = null;
    private boolean m_isUTF8 = false;
    WriterOptimized m_writerOptimized;
    private boolean m_writer_set_by_user;
    private EncodingInfo m_encodingInfo = new EncodingInfo(null, null, true);
    private String m_resultDocAbsoluteURI;
    private SourceLocator m_sourceLocator;
    private boolean m_needToOutputDocTypeDecl;
    private boolean m_startNewLine;
    private static final String XMLVERSION11 = "1.1";
    private static final String XMLVERSION10 = "1.0";
    private boolean m_shouldNotWriteXMLHeader;
    private boolean m_standaloneWasSpecified;
    private Boolean m_standalone;
    private boolean m_doIndent;
    private String m_doctypeSystem;
    private String m_doctypePublic;
    private static final char[] s_systemLineSep;
    char[] m_lineSep = (char[])s_systemLineSep.clone();
    private final boolean m_lineSepUse = true;
    protected final int m_lineSepLen = this.m_lineSep.length;
    private final boolean fXMLVersionNotKnown = true;
    private boolean fisXML11 = false;
    final boolean strict = false;

    final void privateWriteAttrNSDecl(int n2) throws IOException {
    }

    void writeASCII(char c) throws IOException {
        this.m_writer.write(c);
    }

    void writeASCII(char[] cArray) throws IOException {
        this.m_writer.write(cArray, 0, cArray.length);
    }

    @Override
    public final void writeBytes(byte[] byArray, int n2, int n3) throws IOException {
        if (this.m_writerOptimized != null) {
            this.m_writerOptimized.writeBytes(byArray, n2, n3);
        } else if (this.m_outputStream != null) {
            if (this.m_writer != null) {
                this.m_writer.flush();
            }
            this.m_outputStream.write(byArray, n2, n3);
        } else {
            this.m_writer.write(new String(byArray, n2, n3));
        }
    }

    void writeAttributeValue(VolatileCData volatileCData) throws IOException {
    }

    @Override
    public AdditionalAPIs getCursorExtensions() {
        return this;
    }

    TEXTStreamCursor(CursorFactory cursorFactory, OutputStream outputStream, Map map2) {
        super(cursorFactory);
        this.m_OutputProps = map2;
        this.m_outputStream = outputStream;
        this.m_factory = cursorFactory;
    }

    TEXTStreamCursor(CursorFactory cursorFactory, Writer writer, Map map2) {
        super(cursorFactory, null);
        this.m_OutputProps = map2;
        this.setWriter(writer);
        this.m_factory = cursorFactory;
    }

    @Override
    public final void addAttribute(VolatileCData volatileCData, VolatileCData volatileCData2) {
    }

    public final boolean processAttrNamespace(VolatileCData volatileCData) throws IOException {
        String string2 = volatileCData.getQNameNamespaceURI(1);
        String string3 = null;
        int n2 = -1;
        if (!(string2 != null && string2.length() != 0 || (string3 = volatileCData.getQNamePrefix(1)) != null && string3.length() != 0 || (n2 = this.toHandle(string2)) != -1)) {
            return false;
        }
        if (this.toHandle(string2) == -1) {
            if (string3 == null) {
                string3 = volatileCData.getQNamePrefix(1);
            }
            this.declareNS(string2, string3, true);
            return true;
        }
        return false;
    }

    @Override
    public void addComment(Cursor.Area area, VolatileCData volatileCData) {
        try {
            this.ensureContentState(area);
            this.writeComment(volatileCData);
        }
        catch (IOException iOException) {
            Messages.xciDynamicErrorException(iOException);
        }
    }

    @Override
    public final void addElement(Cursor.Area area, VolatileCData volatileCData, XSTypeDefinition xSTypeDefinition) {
        try {
            String string2;
            String string3;
            int n2;
            CData cData = volatileCData.constant(true);
            this.ensureContentState(area);
            this.m_elemContext.set_STATE(4);
            this.pushNamespaceContext();
            this.m_elemContext.set_STATE(1);
            String string4 = cData.getQNamePrefix(1);
            if (string4 == null) {
                string4 = "";
            }
            if (0 < (n2 = (string3 = cData.getQNameLocalPart(1)).indexOf(58))) {
                if (string4.length() == 0) {
                    string4 = string3.substring(0, n2);
                }
                string3 = string3.substring(n2 + 1);
            }
            String string5 = cData.getQNameNamespaceURI(1);
            if (string4.length() == 0) {
                string2 = string3;
            } else {
                StringBuilder stringBuilder = new StringBuilder();
                stringBuilder.append(string4);
                stringBuilder.append(':');
                stringBuilder.append(string3);
                string2 = stringBuilder.toString();
            }
            this.m_elemContext.setElementValues(string4, string3, string5, string2);
            this.m_elemContext.set_STATE(1);
        }
        catch (IOException iOException) {
            Messages.xciDynamicErrorException(iOException);
        }
    }

    @Override
    public final void addNamespaceNode(VolatileCData volatileCData, VolatileCData volatileCData2, boolean bl) {
    }

    @Override
    public final void addText(Cursor.Area area, VolatileCData volatileCData) {
        try {
            this.ensureContentState(area);
            this.m_elemContext.set_STATE(5);
            this.writeValue(volatileCData);
        }
        catch (IOException iOException) {
            Messages.xciDynamicErrorException(iOException);
        }
    }

    @Override
    public final void addText(Cursor.Area area, Chars chars) {
        try {
            this.ensureContentState(area);
            this.m_elemContext.set_STATE(5);
            this.writeValue(chars);
        }
        catch (IOException iOException) {
            Messages.xciDynamicErrorException(iOException);
        }
    }

    @Override
    public final void closeMutation() {
        if (Serialize.XMLStreamCursor) {
            this.dbgTrace(".closeMutation(); called");
        }
        try {
            this.m_openMutationCalled = false;
            this.m_writer.flush();
            if (this.m_writer instanceof WriterToUTF8Buffered) {
                WriterCache.returnWriterToUTF8Buffered((WriterToUTF8Buffered)this.m_writer);
            }
        }
        catch (IOException iOException) {
            Messages.xciDynamicErrorException(iOException);
        }
    }

    @Override
    public final Cursor fork(boolean bl, Cursor.Profile profile, Cursor.Profile profile2) {
        if (Serialize.XMLStreamCursor) {
            this.dbgTrace(".fork(...); called");
        }
        assert (this.incrementForkReleaseCounter());
        return this;
    }

    @Override
    public final boolean isWrapped() {
        this.unimplemented("isWrapped");
        return false;
    }

    @Override
    public final boolean openMutation(Cursor.Area area) {
        if (Serialize.XMLStreamCursor) {
            this.dbgTrace(".openMutation(...); called");
        }
        if (this.m_openMutationCalled) {
            return false;
        }
        this.m_openMutationCalled = true;
        this.m_elemContext.set_STATE(0);
        try {
            this.startDocumentInternal();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return true;
    }

    @Override
    public final Cursor.Profile profile() {
        Cursor.Profile profile = super.profile();
        return profile;
    }

    @Override
    public final Cursor.Profile profileLimit() {
        return this.futureProfile();
    }

    @Override
    public final Cursor.Profile futureProfile() {
        return FEATURES_LIMIT;
    }

    @Override
    public final void writeAttrNSDecl(int n2) throws IOException {
    }

    @Override
    public final void writeAttribute(boolean bl, VolatileCData volatileCData, VolatileCData volatileCData2) throws IOException {
    }

    private final void privateWritePrefix(String string2) throws IOException {
        if (string2 != null && string2.length() > 0) {
            this.m_writer.write(string2);
            this.writeASCII(COLON_CHAR);
        }
    }

    @Override
    public final void writeBracketClosingTag(VolatileCData volatileCData) throws IOException {
    }

    @Override
    public final void writeClosingBracket() throws IOException {
    }

    @Override
    public final void writeClosingTag(VolatileCData volatileCData) throws IOException {
    }

    @Override
    public final void writeComment(VolatileCData volatileCData) throws IOException {
    }

    @Override
    public final void writeOpenTag(VolatileCData volatileCData) throws IOException {
    }

    @Override
    public final void writePI(VolatileCData volatileCData, VolatileCData volatileCData2) throws IOException {
    }

    @Override
    public final void writeQName(VolatileCData volatileCData) throws IOException {
    }

    @Override
    public final void writeSlashBracket() throws IOException {
    }

    @Override
    public final void writeValue(VolatileCData volatileCData) throws IOException {
        String string2 = volatileCData.toString();
        if (this.m_codePointMappings != null) {
            this.writeValueCharacterMap(string2);
        } else {
            this.writeValue(string2);
        }
    }

    @Override
    protected void writeValue(Chars chars) throws IOException {
        String string2 = ((Object)chars).toString();
        if (this.m_codePointMappings != null) {
            this.writeValueCharacterMap(string2);
        } else {
            this.writeValue(string2);
        }
    }

    protected final void writeValueCharacterMap(String string2) throws IOException {
        int n2;
        int n3 = string2.length();
        int n4 = 0;
        for (n2 = 0; n2 < n3; ++n2) {
            char c = string2.charAt(n2);
            String string3 = this.m_codePointMappings.getString(c);
            if (string3 == null) continue;
            if (n4 < n2) {
                this.writeValue(string2, n4, n2);
            }
            n4 = n2 + 1;
            this.m_writer.append(string3);
        }
        if (n4 < n2) {
            this.writeValue(string2, n4, n2);
        }
    }

    protected final void writeValue(String string2) throws IOException {
        if (this.m_normalizerMode != 1 && !this.m_unicodeNormalizer.alreadyNormalized(string2, this.m_normalizerMode)) {
            string2 = this.m_unicodeNormalizer.normalizeUnicode(string2, this.m_normalizerMode);
        }
        this.checkEncodingValid(string2, 0, string2.length());
        this.m_writer.append(string2);
    }

    protected final void writeValue(String string2, int n2, int n3) throws IOException {
        if (this.m_normalizerMode != 1) {
            this.checkEncodingValid(string2, n2, n3);
            this.m_writer.append(string2, n2, n3);
        } else {
            this.writeValue(string2.substring(n2, n3));
        }
    }

    private final void checkEncodingValid(String string2, int n2, int n3) {
    }

    private final void startDocumentInternal0(String string2) throws IOException {
        Object object2;
        Object object3;
        int n2;
        Object object4 = this.getOutputPropertyNonDefault("use-character-maps");
        if (object4 instanceof List && (n2 = (object3 = (List)object4).size()) > 0) {
            this.m_codePointMappings = new CodepointMappings();
            for (int i = 0; i < n2; i += 2) {
                this.m_codePointMappings.setString(((String)object3.get(i)).charAt(0), (String)object3.get(i + 1));
            }
        }
        if (Boolean.TRUE.equals(object3 = this.getOutputPropertyNonDefault("byte-order-mark"))) {
            this.m_writer.write(65279);
        }
        if ((object2 = this.getOutputPropertyNonDefault("normalization-form")) instanceof QName) {
            QName qName = (QName)object2;
            if (SerializeParamValue.UNICODE_NF_C.equals(qName)) {
                this.m_normalizerMode = 2;
            } else if (SerializeParamValue.UNICODE_NF_D.equals(qName)) {
                this.m_normalizerMode = 3;
            } else if (SerializeParamValue.UNICODE_NF_KC.equals(qName)) {
                this.m_normalizerMode = 4;
            } else if (SerializeParamValue.UNICODE_NF_KD.equals(qName)) {
                this.m_normalizerMode = 5;
            } else if (!SerializeParamValue.UNICODE_NF_NONE.equals(qName)) {
                String string3 = Messages.createMessage2("ER_SER_NORM_FORM_NOT_SUPPORTED", new String[]{qName.getLocalPart()});
                Messages.xciDynamicErrorException(string3);
            }
            if (this.m_normalizerMode != 1) {
                this.m_unicodeNormalizer = UnicodeNormalizerFactory.getUnicodeNormalizer();
            }
        }
    }

    private final void startDocumentInternal() throws IOException {
        this.setDefaultProperties();
        this.m_wasJustReset = false;
        String string2 = Encodings.getMimeEncoding(this.getEncoding());
        EncodingInfo encodingInfo = Encodings.getEncodingInfo(string2);
        if (encodingInfo != null) {
            this.m_encodingInfo = encodingInfo;
        } else {
            String string3 = Messages.createMessage2("ER_SER_ENCODING_NOT_SUPPORTED", new String[]{string2});
            Messages.xciDynamicErrorException(string3);
        }
        if (this.m_writer == null && this.m_outputStream != null) {
            this.setOutputStreamInternal(this.m_outputStream, false);
        }
        if (this.m_OutputProps != null) {
            this.startDocumentInternal0(string2);
        }
        this.m_needToOutputDocTypeDecl = true;
        this.m_startNewLine = false;
    }

    private final void setOutputStreamInternal(OutputStream outputStream, boolean bl) {
        this.m_outputStream = outputStream;
        String string2 = (String)this.getOutputProperty("encoding");
        if ("UTF-8".equalsIgnoreCase(string2)) {
            WriterOptimized writerOptimized = this.m_writerOptimized;
            if (writerOptimized == null) {
                writerOptimized = WriterCache.getWriterToUTF8Buffered(outputStream);
            } else {
                writerOptimized.setOuputStream(outputStream);
            }
            this.setWriterInternal(writerOptimized, false);
        } else if ("WINDOWS-1250".equals(string2) || "US-ASCII".equals(string2) || "ASCII".equals(string2)) {
            this.setWriterInternal(new WriterToASCI(outputStream), false);
        } else if (string2 != null) {
            Object object2;
            Writer writer = null;
            try {
                if ("UTF-16".equals(string2) && Boolean.FALSE.equals(object2 = this.getOutputPropertyNonDefault("byte-order-mark"))) {
                    string2 = "UnicodeBigUnmarked";
                }
                writer = !bl && this.m_encodingInfo != null && this.m_encodingInfo.isStatelessEncoding() ? new WriterStateless(outputStream, this.m_encodingInfo) : Encodings.getWriter(outputStream, string2);
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                writer = null;
            }
            if (writer == null) {
                object2 = Messages.createMessage2("ER_SER_ENCODING_NOT_SUPPORTED", new String[]{string2, "UTF-8"});
                Messages.xciDynamicErrorException((String)object2);
                string2 = "UTF-8";
                try {
                    writer = Encodings.getWriter(outputStream, string2);
                }
                catch (UnsupportedEncodingException unsupportedEncodingException) {
                    String string3 = Messages.createMessage2("ER_SER_ENCODING_NOT_SUPPORTED", new String[]{string2, "UTF-8"});
                    Messages.xciDynamicErrorException(string3);
                }
            }
            this.setWriterInternal(writer, false);
        } else {
            OutputStreamWriter outputStreamWriter = new OutputStreamWriter(outputStream);
            this.setWriterInternal(outputStreamWriter, false);
        }
    }

    private final Object getOutputProperty(Object object2) {
        Object object3 = this.getOutputPropertyNonDefault(object2);
        if (object3 == null) {
            object3 = this.getOutputPropertyDefault(object2);
        }
        return object3;
    }

    private final Object getOutputPropertyNonDefault(Object object2) {
        return this.getProp(object2, false);
    }

    private final void setWriterInternal(Writer writer, boolean bl) {
        this.m_writer_set_by_user = bl;
        this.m_writer = writer;
        this.m_writerOptimized = this.m_writer instanceof WriterOptimized ? (WriterOptimized)this.m_writer : null;
    }

    private final Object getOutputPropertyDefault(Object object2) {
        return this.getProp(object2, true);
    }

    private final Object getProp(Object object2, boolean bl) {
        Object object3 = null;
        String string2 = null;
        if (object2 instanceof String) {
            string2 = (String)object2;
        } else if (object2 instanceof SerializeParam) {
            string2 = ((SerializeParam)object2).toString();
        } else {
            return null;
        }
        if (bl) {
            if (string2.equals("version".toString())) {
                object3 = XMLVERSION10;
                return object3;
            }
            if (string2.equals("encoding".toString())) {
                object3 = "UTF-8";
                return object3;
            }
            if (string2.equals("indent".toString())) {
                object3 = Boolean.FALSE;
                return object3;
            }
            if (string2.equals("method".toString())) {
                object3 = "xml";
                return object3;
            }
            if (string2.equals("media-type".toString())) {
                object3 = "text/xml";
                return object3;
            }
            if (string2.equals("omit-xml-declaration".toString())) {
                object3 = Boolean.FALSE;
                return object3;
            }
            if (string2.equals("standalone".toString())) {
                object3 = Boolean.FALSE;
                return object3;
            }
            if (string2.equals(SerializeParam.INDENT_AMOUNT.toString())) {
                object3 = "2";
                return object3;
            }
        } else if (this.m_OutputProps == null) {
            object3 = null;
        } else {
            object3 = this.m_OutputProps.get(object2);
            if (object3 == null && object2 instanceof SerializeParam) {
                object3 = this.m_OutputProps.get(object2.toString());
            }
        }
        return object3;
    }

    private final String getEncoding() {
        return (String)this.getOutputProperty("encoding");
    }

    private final void setStandalone(Boolean bl) {
        this.m_standalone = bl;
    }

    protected final String getDoctypeSystem() {
        return this.m_doctypeSystem;
    }

    private final void setDefaultProperties() {
        EncodingInfo encodingInfo;
        this.m_encodingInfo = encodingInfo = Encodings.getEncodingInfo("UTF-8");
        this.m_isUTF8 = true;
        this.setIndent(false);
        this.setStandalone(Boolean.FALSE);
        this.m_wasJustReset = true;
        this.m_normalizerMode = 1;
        this.m_unicodeNormalizer = null;
    }

    public final void setOutputStream(OutputStream outputStream) {
        this.m_outputStream = outputStream;
        this.m_writer = null;
        this.m_writerOptimized = null;
        this.m_writer_set_by_user = false;
    }

    public final void setWriter(Writer writer) {
        this.m_outputStream = null;
        this.setWriterInternal(writer, true);
    }

    @Override
    public final void addProcessingInstruction(Cursor.Area area, VolatileCData volatileCData, VolatileCData volatileCData2) {
        String string2 = volatileCData.toString();
        if (!string2.equals("javax.xml.transform.disable-output-escaping") && !string2.equals("javax.xml.transform.enable-output-escaping")) {
            try {
                if (this.mayAddElemAttr()) {
                    this.m_elemContext.set_STATE(4);
                }
                this.writePI(volatileCData, volatileCData2);
                this.m_startNewLine = true;
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    private final void setIndent(Boolean bl) {
        this.m_doIndent = bl;
    }

    protected final boolean doIndent() {
        return this.m_doIndent;
    }

    @Override
    public final void release() {
        if (Serialize.XMLStreamCursor) {
            this.dbgTrace(".release(); called");
        }
        try {
            if (this.mayAddElemAttr()) {
                // empty if block
            }
            if (this.m_elemContext.get_elemDepth() == 0) {
                int n2 = this.m_elemContext.get_STATE();
                switch (n2) {
                    case 0: {
                        break;
                    }
                    case 6: {
                        break;
                    }
                    default: {
                        this.m_elemContext.set_STATE(6);
                        break;
                    }
                }
            } else {
                this.writeClosingTag(null);
                this.popNamespaceContext();
                this.m_elemContext.set_STATE(4);
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        assert (this.decrementForkReleaseCounter());
    }

    @Override
    public final void ensureContentState(Cursor.Area area) throws IOException {
        if (this.mayAddElemAttr()) {
            if (area == Cursor.Area.FOLLOWING_SIBLING) {
                // empty if block
            }
            this.m_elemContext.set_STATE(4);
        }
    }

    @Override
    public final boolean toChildren(NodeTest nodeTest) {
        return true;
    }

    @Override
    public final void addContent(Cursor.Area area, byte[] byArray, int n2, int n3) {
        try {
            this.ensureContentState(area);
            this.writeBytes(byArray, n2, n3);
        }
        catch (IOException iOException) {
            Messages.xciDynamicErrorException(iOException);
        }
    }

    @Override
    public final void toEndOfDocument() {
        while (this.m_elemContext.get_elemDepth() > 0) {
            this.m_elemContext = this.m_elemContext.pop();
        }
        this.m_elemContext.set_STATE(6);
    }

    private boolean mayAddElemAttr() {
        int n2 = this.m_elemContext.get_STATE();
        boolean bl = ElemContext.mayAddElemAttr(n2);
        return bl;
    }

    @Override
    public int getElemDepth() {
        int n2 = this.m_elemContext.get_elemDepth();
        return n2;
    }

    @Override
    public boolean isPreviousElemInline() {
        return false;
    }

    @Override
    public boolean isCurrentElemInline(VolatileCData volatileCData) {
        return false;
    }

    @Override
    public boolean isXML11() {
        return false;
    }

    @Override
    public int getSerializationState() {
        int n2 = this.m_elemContext.get_STATE();
        return n2;
    }

    @Override
    public int getParentSerializationState() {
        ElemContext elemContext = this.m_elemContext.pop();
        if (elemContext != null) {
            int n2 = elemContext.get_STATE();
            return n2;
        }
        return -1;
    }

    @Override
    public CursorFactory factory() {
        return this.m_factory;
    }

    @Override
    public final List<NamespaceMappings.MappingRecord> getInScopeNamespaces(int n2) {
        List<NamespaceMappings.MappingRecord> list = this.m_prefixMap.getPrefixMappingsAtDepth(n2);
        return list;
    }

    @Override
    public final void writeAttribute(String string2, String string3) throws IOException {
    }

    @Override
    public String getUnusedPrefix() {
        return "";
    }

    @Override
    public boolean toIds(VolatileCData volatileCData, boolean bl) {
        if (bl) {
            String string2 = Messages.createMessage2("ER_UNIMPLEMENTED_METHOD", new String[]{"toIds", this.getClass().getName()});
            Messages.xciDynamicErrorException(string2);
        }
        return false;
    }

    static {
        byte[] byArray;
        byte[] byArray2;
        byte[] byArray3;
        EMPTY_STRING = "";
        XMLNS_PREFIX = "".toCharArray();
        XMLNS = " xmlns".toCharArray();
        SLASH_BRACKET = "/>".toCharArray();
        BRACKET_SLASH = "</".toCharArray();
        LESSTHAN_QUESTIONMARK = new char[]{'<', '?'};
        QUESTIONMARK_GREATERTHAN = new char[]{'?', '>'};
        COMMENT_START = new char[]{'<', '!', '-', '-'};
        COMMENT_END = new char[]{'-', '-', '>'};
        XMLNS_COLON = new char[]{'x', 'm', 'l', 'n', 's', ':'};
        EQUALS_DOUBLEQUOTE = new char[]{'=', '\"'};
        XML_HEADER_VERSION_STRING = "<?xml version=\"";
        try {
            byArray3 = XML_HEADER_VERSION_STRING.getBytes("UTF-8");
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            byArray3 = XML_HEADER_VERSION_STRING.getBytes();
        }
        XML_HEADER_VERSION_BYTES = byArray3;
        XML_HEADER_VERSION_CHARS = XML_HEADER_VERSION_STRING.toCharArray();
        XML_HEADER_ENCODING_STRING = "\" encoding=\"";
        try {
            byArray2 = XML_HEADER_ENCODING_STRING.getBytes("UTF-8");
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            byArray2 = XML_HEADER_ENCODING_STRING.getBytes();
        }
        XML_HEADER_ENCODING_BYTES = byArray2;
        XML_HEADER_ENCODING_CHARS = XML_HEADER_ENCODING_STRING.toCharArray();
        XML_HEADER_END_STRING = "?>";
        try {
            byArray = XML_HEADER_END_STRING.getBytes("UTF-8");
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            byArray = XML_HEADER_END_STRING.getBytes();
        }
        XML_HEADER_END_BYTES = byArray;
        XML_HEADER_END_CHARS = XML_HEADER_END_STRING.toCharArray();
        DOUBLE_QUOTE_CHAR = (char)34;
        SPACE_CHAR = (char)32;
        EQUALS_CHAR = (char)61;
        DOUBLE_QUOTE_BYTE = (byte)34;
        DOUBLE_QUOTE_CHARS = new char[]{'\"'};
        LESSTHAN_CHAR = (char)60;
        GREATERTHAN_CHAR = (char)62;
        COLON_CHAR = (char)58;
        LESSTHAN_QUESTION_CHARS = new char[]{'<', '?'};
        QUESTION_GREATERTHAN_CHARS = new char[]{'?', '>'};
        s_systemLineSep = SecuritySupport.getSystemProperty("line.separator").toCharArray();
    }
}

