/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xml.xci.serializer;

public final class StringToIntTable {
    static final String IBM_COPYRIGHT = "Licensed Materials - Property of IBM\n\nXML Cursor Interface for Java (XCI-J)\u00a9 Copyright IBM Corp. 2004, 2008. All Rights Reserved.\n\nUS Government Users Restricted Rights - Use, duplication or disclosure \nrestricted by GSA ADP Schedule Contract with IBM Corp.";
    public static final int INVALID_KEY = 0;
    private int m_blocksize;
    private String[] m_map;
    private int[] m_values;
    private int m_firstFree = 0;
    private int m_mapSize;

    public StringToIntTable() {
        this.m_mapSize = this.m_blocksize = 8;
        this.m_map = new String[this.m_blocksize];
        this.m_values = new int[this.m_blocksize];
    }

    public StringToIntTable(int n2) {
        this.m_blocksize = n2;
        this.m_mapSize = n2;
        this.m_map = new String[n2];
        this.m_values = new int[this.m_blocksize];
    }

    public final int getLength() {
        return this.m_firstFree;
    }

    public final void put(String string2, int n2) {
        if (this.m_firstFree + 1 >= this.m_mapSize) {
            this.m_mapSize += this.m_blocksize;
            String[] stringArray = new String[this.m_mapSize];
            System.arraycopy(this.m_map, 0, stringArray, 0, this.m_firstFree + 1);
            this.m_map = stringArray;
            int[] nArray = new int[this.m_mapSize];
            System.arraycopy(this.m_values, 0, nArray, 0, this.m_firstFree + 1);
            this.m_values = nArray;
        }
        this.m_map[this.m_firstFree] = string2;
        this.m_values[this.m_firstFree] = n2;
        ++this.m_firstFree;
    }

    public final int get(String string2) {
        for (int i = 0; i < this.m_firstFree; ++i) {
            if (!this.m_map[i].equals(string2)) continue;
            return this.m_values[i];
        }
        return 0;
    }

    public final int getIgnoreCase(String string2) {
        int n2 = string2.length();
        for (int i = 0; i < this.m_firstFree; ++i) {
            int n3;
            String string3 = this.m_map[i];
            int n4 = string3.length();
            if (n2 != n4) continue;
            for (n3 = 0; n3 < n2 && (string2.charAt(n3) | 0x20) == (string3.charAt(n3) | 0x20); ++n3) {
            }
            if (n3 != n2) continue;
            return this.m_values[i];
        }
        return 0;
    }

    public final boolean contains(String string2) {
        for (int i = 0; i < this.m_firstFree; ++i) {
            if (!this.m_map[i].equals(string2)) continue;
            return true;
        }
        return false;
    }

    public final String[] keys() {
        String[] stringArray = new String[this.m_firstFree];
        for (int i = 0; i < this.m_firstFree; ++i) {
            stringArray[i] = this.m_map[i];
        }
        return stringArray;
    }
}

