/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xml.xci.serializer;

import com.ibm.xml.xci.Cursor;
import com.ibm.xml.xci.dp.util.copy.Copier;
import com.ibm.xml.xci.dp.util.copy.ItemCopier;
import com.ibm.xml.xci.serializer.SerializeCopierDelegate;

public class SerializeCopier
extends Copier {
    static final String IBM_COPYRIGHT = "Licensed Materials - Property of IBM\n\nXML Cursor Interface for Java (XCI-J)\u00a9 Copyright IBM Corp. 2004, 2009. All Rights Reserved.\n\nUS Government Users Restricted Rights - Use, duplication or disclosure \nrestricted by GSA ADP Schedule Contract with IBM Corp.";

    public static void copy(Cursor cursor2, Cursor cursor3, Cursor.Area area, int n2, ItemCopier itemCopier) {
        if (cursor2 != null) {
            assert (SOURCE_FEATURES.containedIn(cursor2.profile())) : "Insufficient source features for copy!";
            assert (cursor3 != null) : "Cannot copy into empty target sequence, only document and element parents!";
            assert (TARGET_FEATURES.containedIn(cursor3.profile())) : "Insufficient target features for copy!";
            boolean bl = cursor3.openMutation(Cursor.Area.SUBTREE);
            SerializeCopier serializeCopier = itemCopier == null ? new SerializeCopier(n2) : new SerializeCopierDelegate(n2, itemCopier);
            serializeCopier.copySequenceCursor(cursor2, cursor3, area);
            if (bl) {
                cursor3.closeMutation();
            }
            if ((n2 & 1) != 0) {
                cursor2.release();
            }
            if ((n2 & 0x10) != 0) {
                cursor3.release();
            }
        }
    }

    static void copy(Cursor cursor2, Cursor cursor3, Cursor cursor4, Cursor.Area area, int n2, ItemCopier itemCopier) {
        assert (SOURCE_FEATURES.containedIn(cursor2.profile())) : "Insufficient source features for copy!";
        assert (cursor4 != null) : "Cannot copy into empty target sequence, only document and element parents!";
        assert (TARGET_FEATURES.containedIn(cursor4.profile())) : "Insufficient target features for copy!";
        boolean bl = cursor4.openMutation(Cursor.Area.SUBTREE);
        SerializeCopier serializeCopier = itemCopier == null ? new SerializeCopier(n2) : new SerializeCopierDelegate(n2, itemCopier);
        serializeCopier.copySequenceCursor(cursor2, cursor3, cursor4, area);
        if (bl) {
            cursor4.closeMutation();
        }
        if ((n2 & 1) != 0) {
            cursor2.release();
        }
        if ((n2 & 0x10) != 0) {
            cursor4.release();
        }
    }

    public SerializeCopier(int n2) {
        super(n2);
    }

    protected void copySequenceCursor(Cursor cursor2, Cursor cursor3, Cursor.Area area) {
        cursor3.fork(true, cursor3.profile(), cursor3.futureProfile());
        do {
            if (cursor2.itemKind() == 9) {
                Cursor cursor4 = cursor2.fork(true);
                if (cursor4.toChildren(null)) {
                    this.copySequence2Content(cursor4, cursor3, area);
                    area = Cursor.Area.FOLLOWING_SIBLING;
                }
                cursor4.release();
                continue;
            }
            int n2 = this.copyNode(cursor2, cursor3, area);
            if (n2 == 0 && cursor2.itemKind() == 1) {
                n2 = this.copyContents(cursor2, cursor3);
            }
            area = Cursor.Area.FOLLOWING_SIBLING;
        } while (cursor2.toNext());
        cursor3.release();
    }

    protected void copySequenceCursor(Cursor cursor2, Cursor cursor3, Cursor cursor4, Cursor.Area area) {
        cursor4.fork(true, cursor4.profile(), cursor4.futureProfile());
        this.copySequence2Content(cursor3, cursor4, area);
        cursor3.release();
        area = Cursor.Area.FOLLOWING_SIBLING;
        while (cursor2.toNext()) {
            if (cursor2.itemKind() == 9) {
                Cursor cursor5 = cursor2.fork(true);
                if (cursor5.toChildren(null)) {
                    this.copySequence2Content(cursor5, cursor4, area);
                }
                cursor5.release();
            } else {
                int n2 = this.copyNode(cursor2, cursor4, area);
                if (n2 == 0 && cursor2.itemKind() == 1) {
                    n2 = this.copyContents(cursor2, cursor4);
                }
            }
            area = Cursor.Area.FOLLOWING_SIBLING;
        }
        cursor4.release();
    }
}

