/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xml.xci.serializer;

import com.ibm.xml.xci.Cursor;
import com.ibm.xml.xci.CursorFactory;
import com.ibm.xml.xci.dp.util.copy.Copier;
import com.ibm.xml.xci.sax.serializer.SAXCursor;
import com.ibm.xml.xci.serializer.CursorExtended;
import com.ibm.xml.xci.serializer.HTMLStreamCursor;
import com.ibm.xml.xci.serializer.HiddenOptions;
import com.ibm.xml.xci.serializer.Messages;
import com.ibm.xml.xci.serializer.SerializeParamValue;
import com.ibm.xml.xci.serializer.TEXTStreamCursor;
import com.ibm.xml.xci.serializer.Utils;
import com.ibm.xml.xci.serializer.XHTMLStreamCursor;
import com.ibm.xml.xci.serializer.XMLStreamCursor;
import com.ibm.xml.xci.serializer.XMLUtf8DirectStreamCursor;
import com.ibm.xml.xci.serializer.XMLUtf8StreamCursor;
import com.ibm.xml.xci.serializer.fixer.FixerAvoidUsingDefaultNS;
import com.ibm.xml.xci.serializer.fixer.FixerCachedData;
import com.ibm.xml.xci.serializer.fixer.FixerExplicitNSDecl;
import com.ibm.xml.xci.serializer.fixer.FixerMeta;
import com.ibm.xml.xci.serializer.fixer.FixerRequiredPrefixes;
import com.ibm.xml.xci.serializer.fixer.FixerSmartPrefixes;
import com.ibm.xml.xci.serializer.fixer.FixerStateChecker;
import com.ibm.xml.xci.serializer.fixer.FixerXMLWhitespace;
import java.io.OutputStream;
import java.io.Writer;
import java.util.List;
import java.util.Map;
import javax.xml.namespace.QName;
import org.xml.sax.ContentHandler;
import org.xml.sax.ext.LexicalHandler;

public class Serialize {
    static final String IBM_COPYRIGHT = "Licensed Materials - Property of IBM\n\nXML Cursor Interface for Java (XCI-J)\u00a9 Copyright IBM Corp. 2004, 2009. All Rights Reserved.\n\nUS Government Users Restricted Rights - Use, duplication or disclosure \nrestricted by GSA ADP Schedule Contract with IBM Corp.";
    public static final boolean TRACE_SER_NS = HiddenOptions.wasSpecified("TRACE_SER_NS");
    public static final boolean TRACE_SER_API = HiddenOptions.wasSpecified("TRACE_SER_API");
    public static final boolean XMLStreamCursor = HiddenOptions.wasSpecified("XMLStreamCursor");
    public static final boolean xserializer = HiddenOptions.wasSpecified("xserializer");
    public static final boolean utf8opt1 = HiddenOptions.wasSpecified("utf8opt1");
    public static final boolean utf8direct = HiddenOptions.wasSpecified("utf8direct");
    public static final boolean s_stateChecker = HiddenOptions.wasSpecified("FixerStateChecker");
    private static final int INT_XML = 1;
    private static final int INT_HTML = 2;
    private static final int INT_XHTML = 3;
    private static final int INT_TEXT = 4;
    private static final int INT_UNKNOWN = 5;

    private Serialize() {
    }

    public static void toWriter(Cursor cursor2, Writer writer, Map map2) {
        Cursor cursor3 = Serialize.getTargetCursor(cursor2.factory(), writer, map2);
        Copier.copy(cursor2, cursor3);
    }

    public static Cursor getTargetCursor(CursorFactory cursorFactory, Writer writer, Map map2) {
        CursorExtended cursorExtended = null;
        if (map2 != null) {
            int n2 = Serialize.getMethod(map2);
            switch (n2) {
                case 1: {
                    try {
                        Object object2 = Serialize.getParameter(map2, "encoding");
                        String string2 = null;
                        if (object2 instanceof String) {
                            string2 = (String)object2;
                        }
                        if (string2 == null || Utils.equalsIgnoreCase2(string2, "UTF-8")) break;
                        cursorExtended = new XMLStreamCursor(cursorFactory, writer, map2);
                    }
                    catch (Exception exception) {}
                    break;
                }
                case 2: {
                    cursorExtended = new HTMLStreamCursor(cursorFactory, writer, map2);
                    break;
                }
                case 3: {
                    cursorExtended = new XHTMLStreamCursor(cursorFactory, writer, map2);
                    break;
                }
                case 4: {
                    cursorExtended = new TEXTStreamCursor(cursorFactory, writer, map2);
                }
            }
        }
        if (cursorExtended == null) {
            cursorExtended = new XMLStreamCursor(cursorFactory, writer, map2);
        }
        cursorExtended = Serialize.wrapWithOptionCursors(cursorFactory, map2, cursorExtended);
        return cursorExtended;
    }

    public static void toOutputStream(Cursor cursor2, OutputStream outputStream, Map map2) {
        Cursor cursor3 = Serialize.getTargetCursor(cursor2.factory(), outputStream, map2);
        Copier.copy(cursor2, cursor3);
    }

    public static Cursor getTargetCursor(CursorFactory cursorFactory, OutputStream outputStream, Map map2) {
        CursorExtended cursorExtended = null;
        if (map2 != null) {
            int n2 = Serialize.getMethod(map2);
            switch (n2) {
                case 1: {
                    try {
                        Object object2 = Serialize.getParameter(map2, "encoding");
                        String string2 = null;
                        if (object2 instanceof String) {
                            string2 = (String)object2;
                        }
                        if (string2 == null || Utils.equalsIgnoreCase2(string2, "UTF-8")) {
                            if (utf8direct) {
                                cursorExtended = new XMLUtf8DirectStreamCursor(cursorFactory, outputStream, map2);
                                break;
                            }
                            cursorExtended = new XMLUtf8StreamCursor(cursorFactory, outputStream, map2);
                            break;
                        }
                        cursorExtended = new XMLStreamCursor(cursorFactory, outputStream, map2);
                    }
                    catch (Exception exception) {
                        cursorExtended = null;
                    }
                    break;
                }
                case 2: {
                    cursorExtended = new HTMLStreamCursor(cursorFactory, outputStream, map2);
                    break;
                }
                case 3: {
                    cursorExtended = new XHTMLStreamCursor(cursorFactory, outputStream, map2);
                    break;
                }
                case 4: {
                    cursorExtended = new TEXTStreamCursor(cursorFactory, outputStream, map2);
                }
            }
        } else {
            cursorExtended = new XMLUtf8StreamCursor(cursorFactory, outputStream, map2);
        }
        if (cursorExtended == null) {
            cursorExtended = new XMLStreamCursor(cursorFactory, outputStream, map2);
        }
        cursorExtended = Serialize.wrapWithOptionCursors(cursorFactory, map2, cursorExtended);
        return cursorExtended;
    }

    private static CursorExtended wrapWithOptionCursors(CursorFactory cursorFactory, Map map2, CursorExtended cursorExtended) {
        if (map2 != null) {
            Object object2;
            Object object3;
            int n2 = Serialize.getMethod(map2);
            Object object4 = Serialize.getParameter(map2, "method");
            boolean bl = false;
            switch (n2) {
                case 2: 
                case 3: {
                    Object object5 = Serialize.getParameter(map2, "indent");
                    boolean bl2 = false;
                    if (object5 instanceof Boolean) {
                        object3 = (Boolean)object5;
                        if (((Boolean)object3).booleanValue()) {
                            bl2 = true;
                        }
                    } else if (object5 == null) {
                        bl2 = true;
                    }
                    if (bl2) {
                        cursorExtended = new FixerXMLWhitespace(cursorFactory, map2, cursorExtended, false, n2 == 2);
                        break;
                    }
                    object2 = Serialize.getParameter(map2, "{http://ibm.com/xml/xci/serializer}strip-whitespace");
                    if (!Boolean.TRUE.equals(object2)) break;
                    cursorExtended = new FixerXMLWhitespace(cursorFactory, map2, cursorExtended, true, n2 == 2);
                    break;
                }
                case 1: 
                case 5: {
                    Object object6 = Serialize.getParameter(map2, "indent");
                    boolean bl3 = false;
                    if (object6 instanceof Boolean) {
                        object3 = (Boolean)object6;
                        if (((Boolean)object3).booleanValue()) {
                            bl3 = true;
                        }
                    } else if (object6 == null) {
                        bl3 = false;
                    }
                    if (bl3) {
                        cursorExtended = new FixerXMLWhitespace(cursorFactory, map2, cursorExtended, false, false);
                        break;
                    }
                    object2 = Serialize.getParameter(map2, "{http://ibm.com/xml/xci/serializer}strip-whitespace");
                    if (!Boolean.TRUE.equals(object2)) break;
                    cursorExtended = new FixerXMLWhitespace(cursorFactory, map2, cursorExtended, true, false);
                }
            }
            switch (n2) {
                case 3: {
                    List list;
                    object3 = Serialize.getParameter(map2, "include-content-type");
                    if (object3 == null || Boolean.TRUE.equals(object3)) {
                        cursorExtended = new FixerMeta(cursorFactory, map2, cursorExtended, true);
                    }
                    if ((object2 = Serialize.getParameter(map2, "{http://ibm.com/xml/xci/serializer}required-prefixes")) instanceof List) {
                        list = (List)object2;
                        cursorExtended = new FixerRequiredPrefixes(cursorFactory, map2, cursorExtended, list);
                    } else {
                        boolean bl4;
                        object2 = Serialize.getParameter(map2, "{http://ibm.com/xml/xci/serializer}prefix-format");
                        if (object2 instanceof String && ((bl4 = "short".equals(object2)) || "meaningful".equals(object2))) {
                            cursorExtended = new FixerSmartPrefixes(cursorFactory, map2, cursorExtended, bl4);
                        }
                    }
                    object2 = Serialize.getParameter(map2, "{http://ibm.com/xml/xci/serializer}use-default-ns");
                    if (Boolean.FALSE.equals(object2)) {
                        cursorExtended = new FixerAvoidUsingDefaultNS(cursorFactory, map2, cursorExtended);
                    }
                    if (Boolean.TRUE.equals(object2 = Serialize.getParameter(map2, "{http://ibm.com/xml/xci/serializer}include-empty-xmlns"))) {
                        bl = true;
                    }
                    if ((object2 = Serialize.getParameter(map2, "{http://ibm.com/xml/xci/serializer}force-ns-delcarations")) instanceof List) {
                        list = (List)object2;
                        if (list.size() > 0 || bl) {
                            cursorExtended = new FixerExplicitNSDecl(cursorFactory, map2, cursorExtended, list.size() > 0 ? list : null, bl);
                        }
                    } else if (bl) {
                        cursorExtended = new FixerExplicitNSDecl(cursorFactory, map2, cursorExtended, null, true);
                    }
                    object2 = Serialize.getParameter(map2, "{http://ibm.com/xml/xci/serializer}cached-data");
                    if (object2 instanceof List) {
                        list = (List)object2;
                        cursorExtended = new FixerCachedData(cursorExtended, list);
                        map2.remove("{http://ibm.com/xml/xci/serializer}cached-data");
                    }
                    if (s_stateChecker) {
                        cursorExtended = new FixerStateChecker(cursorExtended);
                    }
                    return cursorExtended;
                }
                case 2: {
                    List list;
                    object3 = Serialize.getParameter(map2, "include-content-type");
                    if (object3 == null || Boolean.TRUE.equals(object3)) {
                        cursorExtended = new FixerMeta(cursorFactory, map2, cursorExtended, false);
                    }
                    if ((object2 = Serialize.getParameter(map2, "{http://ibm.com/xml/xci/serializer}required-prefixes")) instanceof List) {
                        List list2 = (List)object2;
                        cursorExtended = new FixerRequiredPrefixes(cursorFactory, map2, cursorExtended, list2);
                    } else {
                        boolean bl5;
                        object2 = Serialize.getParameter(map2, "{http://ibm.com/xml/xci/serializer}prefix-format");
                        if (object2 instanceof String && ((bl5 = "short".equals(object2)) || "meaningful".equals(object2))) {
                            cursorExtended = new FixerSmartPrefixes(cursorFactory, map2, cursorExtended, bl5);
                        }
                    }
                    object2 = Serialize.getParameter(map2, "{http://ibm.com/xml/xci/serializer}use-default-ns");
                    if (Boolean.FALSE.equals(object2)) {
                        cursorExtended = new FixerAvoidUsingDefaultNS(cursorFactory, map2, cursorExtended);
                    }
                    if ((object2 = Serialize.getParameter(map2, "{http://ibm.com/xml/xci/serializer}force-ns-delcarations")) instanceof List && (list = (List)object2).size() > 0) {
                        cursorExtended = new FixerExplicitNSDecl(cursorFactory, map2, cursorExtended, list, false);
                    }
                    if ((object2 = Serialize.getParameter(map2, "{http://ibm.com/xml/xci/serializer}cached-data")) instanceof List) {
                        List list3 = (List)object2;
                        cursorExtended = new FixerCachedData(cursorExtended, list3);
                    }
                    if (s_stateChecker) {
                        cursorExtended = new FixerStateChecker(cursorExtended);
                    }
                    return cursorExtended;
                }
                case 1: 
                case 5: {
                    object2 = Serialize.getParameter(map2, "{http://ibm.com/xml/xci/serializer}required-prefixes");
                    if (object2 instanceof List) {
                        List list = (List)object2;
                        cursorExtended = new FixerRequiredPrefixes(cursorFactory, map2, cursorExtended, list);
                    } else {
                        object2 = Serialize.getParameter(map2, "{http://ibm.com/xml/xci/serializer}prefix-format");
                        if (object2 instanceof String) {
                            boolean bl6;
                            boolean bl7 = bl6 = "short" == object2;
                            if (bl6 || "meaningful" == object2) {
                                cursorExtended = new FixerSmartPrefixes(cursorFactory, map2, cursorExtended, bl6);
                            }
                        }
                    }
                    object2 = Serialize.getParameter(map2, "{http://ibm.com/xml/xci/serializer}use-default-ns");
                    if (Boolean.FALSE.equals(object2)) {
                        cursorExtended = new FixerAvoidUsingDefaultNS(cursorFactory, map2, cursorExtended);
                    }
                    if (Boolean.TRUE.equals(object2 = Serialize.getParameter(map2, "{http://ibm.com/xml/xci/serializer}include-empty-xmlns"))) {
                        bl = true;
                    }
                    if ((object2 = Serialize.getParameter(map2, "{http://ibm.com/xml/xci/serializer}force-ns-delcarations")) instanceof List) {
                        List list = (List)object2;
                        if (list.size() > 0 || bl) {
                            cursorExtended = new FixerExplicitNSDecl(cursorFactory, map2, cursorExtended, list.size() > 0 ? list : null, bl);
                        }
                    } else if (bl) {
                        cursorExtended = new FixerExplicitNSDecl(cursorFactory, map2, cursorExtended, null, bl);
                    }
                    object2 = Serialize.getParameter(map2, "{http://ibm.com/xml/xci/serializer}cached-data");
                    if (object2 instanceof List) {
                        List list = (List)object2;
                        cursorExtended = new FixerCachedData(cursorExtended, list);
                    }
                    if (s_stateChecker) {
                        cursorExtended = new FixerStateChecker(cursorExtended);
                    }
                    return cursorExtended;
                }
                case 4: {
                    if (s_stateChecker) {
                        cursorExtended = new FixerStateChecker(cursorExtended);
                    }
                    return cursorExtended;
                }
            }
        }
        return cursorExtended;
    }

    public static void toContentHandler(Cursor cursor2, ContentHandler contentHandler, LexicalHandler lexicalHandler, Map map2) {
        SAXCursor sAXCursor = new SAXCursor(null, contentHandler, lexicalHandler, map2);
        Copier.copy(cursor2, sAXCursor);
    }

    private static int getMethod(Map map2) {
        Object object2;
        Object object3 = Serialize.getParameter(map2, "method");
        String string2 = null;
        if (object3 instanceof QName) {
            object2 = (QName)object3;
            if (object2 == SerializeParamValue.METHOD_XML) {
                return 1;
            }
            if (object2 == SerializeParamValue.METHOD_HTML) {
                return 2;
            }
            if (object2 == SerializeParamValue.METHOD_XHTML) {
                return 3;
            }
            if (object2 == SerializeParamValue.METHOD_TEXT) {
                return 4;
            }
            string2 = ((QName)object2).getLocalPart();
        } else if (object3 instanceof String) {
            string2 = (String)object3;
        } else {
            if (string2 != null) {
                String string3 = Messages.createMessage2("ER_SER_PARAM_VAL_NOT_QNAME", new String[]{"method"});
                Messages.warning(string3);
            }
            return 1;
        }
        if (object3 instanceof String) {
            string2 = (String)object3;
        }
        if (SerializeParamValue.METHOD_XML.toString().equals(string2)) {
            return 1;
        }
        if (SerializeParamValue.METHOD_HTML.toString().equals(string2)) {
            return 2;
        }
        if (SerializeParamValue.METHOD_XHTML.toString().equals(string2) || "xhtml".equals(string2)) {
            return 3;
        }
        if (SerializeParamValue.METHOD_TEXT.toString().equals(string2)) {
            return 4;
        }
        object2 = Messages.createMessage2("ER_SER_PARAM_BAD", new String[]{"method", string2});
        Messages.xciDynamicErrorException((String)object2);
        return 1;
    }

    private static Object getParameter(Map map2, Object object2) {
        Object v = map2.get(object2);
        if (v == null) {
            v = map2.get(object2.toString());
        }
        return v;
    }
}

