/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xml.xci.serializer;

import com.ibm.xml.xci.errors.XCIIllegalArgumentException;

public final class Int2StringHashMap {
    static final String IBM_COPYRIGHT = "Licensed Materials - Property of IBM\n\nXML Cursor Interface for Java (XCI-J)\u00a9 Copyright IBM Corp. 2009. All Rights Reserved.\n\nUS Government Users Restricted Rights - Use, duplication or disclosure \nrestricted by GSA ADP Schedule Contract with IBM Corp.";
    private int[] table;
    private int headerSize;
    private int size;
    private String[] values;

    public Int2StringHashMap(int n2) {
        this.table = new int[n2 << 1];
        this.values = new String[n2];
        this.size = this.headerSize = n2 * 3 / 2;
    }

    public String get(int n2) {
        if (n2 == 0) {
            throw new XCIIllegalArgumentException("ER_INVALID_KEY_VALUE", new String[]{"0"});
        }
        int n3 = n2 % (this.headerSize >> 1) << 1;
        long l;
        while ((l = (long)this.table[n3]) != 0L) {
            if (l == (long)n2) {
                return this.values[n3 >> 1];
            }
            n3 = this.table[n3 + 1];
        }
        return null;
    }

    public void put(int n2, String string2) {
        if (n2 == 0) {
            throw new XCIIllegalArgumentException("ER_INVALID_KEY_VALUE", new String[]{"0"});
        }
        int n3 = n2 % (this.headerSize >> 1) << 1;
        if (this.table[n3] == 0 || this.table[n3] == n2) {
            this.table[n3] = n2;
            this.values[n3 >> 1] = string2;
        } else {
            if (this.size >= this.table.length) {
                int[] nArray = new int[this.table.length * 2];
                System.arraycopy(this.table, 0, nArray, 0, this.table.length);
                this.table = nArray;
                String[] stringArray = new String[this.values.length * 2];
                System.arraycopy(this.values, 0, stringArray, 0, this.values.length);
                this.values = stringArray;
            }
            this.table[this.size] = n2;
            this.table[this.size + 1] = this.table[n3 + 1];
            this.table[n3 + 1] = this.size;
            this.values[this.size >> 1] = string2;
            this.size += 2;
        }
    }

    public void clear() {
        int n2;
        for (n2 = 0; n2 < this.size; ++n2) {
            this.table[n2] = 0;
        }
        for (n2 = 0; n2 < this.size >> 1; ++n2) {
            this.values[n2] = null;
        }
    }
}

