/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xml.xci.serializer;

import com.ibm.xml.xci.serializer.CharInfo;
import com.ibm.xml.xci.serializer.StringToIntTable;
import org.xml.sax.SAXException;

public class HtmlElemInfo {
    static final ElemDesc s_elemNotFound = new ElemDesc(8);
    private static final CharInfo s_htmlcharInfo = CharInfo.getCharInfo(null, "html");
    static final Trie m_elementFlags = new Trie();
    private Trie m_htmlInfo = new Trie(m_elementFlags);

    static void initTagReference(Trie trie) {
        trie.put("BASEFONT", new ElemDesc(2));
        trie.put("FRAME", new ElemDesc(10));
        trie.put("FRAMESET", new ElemDesc(8));
        trie.put("NOFRAMES", new ElemDesc(8));
        trie.put("ISINDEX", new ElemDesc(10));
        trie.put("APPLET", new ElemDesc(0x200000));
        trie.put("CENTER", new ElemDesc(8));
        trie.put("DIR", new ElemDesc(8));
        trie.put("MENU", new ElemDesc(8));
        trie.put("TT", new ElemDesc(4608));
        trie.put("I", new ElemDesc(4608));
        trie.put("B", new ElemDesc(4608));
        trie.put("BIG", new ElemDesc(4608));
        trie.put("SMALL", new ElemDesc(4608));
        trie.put("EM", new ElemDesc(8704));
        trie.put("STRONG", new ElemDesc(8704));
        trie.put("DFN", new ElemDesc(8704));
        trie.put("CODE", new ElemDesc(8704));
        trie.put("SAMP", new ElemDesc(8704));
        trie.put("KBD", new ElemDesc(8704));
        trie.put("VAR", new ElemDesc(8704));
        trie.put("CITE", new ElemDesc(8704));
        trie.put("ABBR", new ElemDesc(8704));
        trie.put("ACRONYM", new ElemDesc(8704));
        trie.put("SUP", new ElemDesc(98816));
        trie.put("SUB", new ElemDesc(98816));
        trie.put("SPAN", new ElemDesc(98816));
        trie.put("BDO", new ElemDesc(98816));
        trie.put("BR", new ElemDesc(98314));
        trie.put("BODY", new ElemDesc(8));
        trie.put("ADDRESS", new ElemDesc(568));
        trie.put("DIV", new ElemDesc(56));
        trie.put("A", new ElemDesc(33280));
        trie.put("MAP", new ElemDesc(98312));
        trie.put("AREA", new ElemDesc(10));
        trie.put("LINK", new ElemDesc(131082));
        trie.put("IMG", new ElemDesc(2195970));
        trie.put("OBJECT", new ElemDesc(2326528));
        trie.put("PARAM", new ElemDesc(2));
        trie.put("HR", new ElemDesc(58));
        trie.put("P", new ElemDesc(56));
        trie.put("H1", new ElemDesc(262664));
        trie.put("H2", new ElemDesc(262664));
        trie.put("H3", new ElemDesc(262664));
        trie.put("H4", new ElemDesc(262664));
        trie.put("H5", new ElemDesc(262664));
        trie.put("H6", new ElemDesc(262664));
        trie.put("PRE", new ElemDesc(0x100008));
        trie.put("Q", new ElemDesc(98816));
        trie.put("BLOCKQUOTE", new ElemDesc(56));
        trie.put("INS", new ElemDesc(512));
        trie.put("DEL", new ElemDesc(512));
        trie.put("DL", new ElemDesc(56));
        trie.put("DT", new ElemDesc(8));
        trie.put("DD", new ElemDesc(8));
        trie.put("OL", new ElemDesc(524296));
        trie.put("UL", new ElemDesc(524296));
        trie.put("LI", new ElemDesc(8));
        trie.put("FORM", new ElemDesc(8));
        trie.put("LABEL", new ElemDesc(16384));
        trie.put("INPUT", new ElemDesc(18434));
        trie.put("SELECT", new ElemDesc(18432));
        trie.put("OPTGROUP", new ElemDesc(0));
        trie.put("OPTION", new ElemDesc(0));
        trie.put("TEXTAREA", new ElemDesc(18432));
        trie.put("FIELDSET", new ElemDesc(24));
        trie.put("LEGEND", new ElemDesc(0));
        trie.put("BUTTON", new ElemDesc(18432));
        trie.put("TABLE", new ElemDesc(56));
        trie.put("CAPTION", new ElemDesc(8));
        trie.put("THEAD", new ElemDesc(8));
        trie.put("TFOOT", new ElemDesc(8));
        trie.put("TBODY", new ElemDesc(8));
        trie.put("COLGROUP", new ElemDesc(8));
        trie.put("COL", new ElemDesc(10));
        trie.put("TR", new ElemDesc(8));
        trie.put("TH", new ElemDesc(0));
        trie.put("TD", new ElemDesc(0));
        trie.put("HEAD", new ElemDesc(0x400008));
        trie.put("TITLE", new ElemDesc(8));
        trie.put("BASE", new ElemDesc(10));
        trie.put("META", new ElemDesc(131082));
        trie.put("STYLE", new ElemDesc(131336));
        trie.put("SCRIPT", new ElemDesc(230144));
        trie.put("NOSCRIPT", new ElemDesc(56));
        trie.put("HTML", new ElemDesc(0x800008));
        trie.put("FONT", new ElemDesc(4096));
        trie.put("S", new ElemDesc(4096));
        trie.put("STRIKE", new ElemDesc(4096));
        trie.put("U", new ElemDesc(4096));
        trie.put("NOBR", new ElemDesc(4096));
        trie.put("IFRAME", new ElemDesc(56));
        trie.put("LAYER", new ElemDesc(56));
        trie.put("ILAYER", new ElemDesc(56));
        ElemDesc elemDesc = (ElemDesc)trie.get("a");
        elemDesc.setAttr("HREF", 2);
        elemDesc.setAttr("NAME", 2);
        elemDesc = (ElemDesc)trie.get("applet");
        elemDesc.setAttr("CODEBASE", 2);
        elemDesc = (ElemDesc)trie.get("area");
        elemDesc.setAttr("HREF", 2);
        elemDesc.setAttr("NOHREF", 4);
        elemDesc = (ElemDesc)trie.get("base");
        elemDesc.setAttr("HREF", 2);
        elemDesc = (ElemDesc)trie.get("body");
        elemDesc.setAttr("BACKGROUND", 2);
        elemDesc = (ElemDesc)trie.get("button");
        elemDesc.setAttr("DISABLED", 4);
        elemDesc.setAttr("DATASRC", 2);
        elemDesc = (ElemDesc)trie.get("blockquote");
        elemDesc.setAttr("CITE", 2);
        elemDesc = (ElemDesc)trie.get("del");
        elemDesc.setAttr("CITE", 2);
        elemDesc = (ElemDesc)trie.get("dir");
        elemDesc.setAttr("COMPACT", 4);
        elemDesc = (ElemDesc)trie.get("div");
        elemDesc.setAttr("SRC", 2);
        elemDesc.setAttr("NOWRAP", 4);
        elemDesc.setAttr("DATASRC", 2);
        elemDesc = (ElemDesc)trie.get("dl");
        elemDesc.setAttr("COMPACT", 4);
        elemDesc = (ElemDesc)trie.get("form");
        elemDesc.setAttr("ACTION", 2);
        elemDesc = (ElemDesc)trie.get("frame");
        elemDesc.setAttr("SRC", 2);
        elemDesc.setAttr("LONGDESC", 2);
        elemDesc.setAttr("NORESIZE", 4);
        elemDesc = (ElemDesc)trie.get("head");
        elemDesc.setAttr("PROFILE", 2);
        elemDesc = (ElemDesc)trie.get("hr");
        elemDesc.setAttr("NOSHADE", 4);
        elemDesc = (ElemDesc)trie.get("iframe");
        elemDesc.setAttr("SRC", 2);
        elemDesc.setAttr("LONGDESC", 2);
        elemDesc = (ElemDesc)trie.get("ilayer");
        elemDesc.setAttr("SRC", 2);
        elemDesc = (ElemDesc)trie.get("img");
        elemDesc.setAttr("SRC", 2);
        elemDesc.setAttr("LONGDESC", 2);
        elemDesc.setAttr("USEMAP", 2);
        elemDesc.setAttr("ISMAP", 4);
        elemDesc = (ElemDesc)trie.get("input");
        elemDesc.setAttr("SRC", 2);
        elemDesc.setAttr("USEMAP", 2);
        elemDesc.setAttr("CHECKED", 4);
        elemDesc.setAttr("DISABLED", 4);
        elemDesc.setAttr("ISMAP", 4);
        elemDesc.setAttr("READONLY", 4);
        elemDesc.setAttr("DATASRC", 2);
        elemDesc = (ElemDesc)trie.get("ins");
        elemDesc.setAttr("CITE", 2);
        elemDesc = (ElemDesc)trie.get("layer");
        elemDesc.setAttr("SRC", 2);
        elemDesc = (ElemDesc)trie.get("link");
        elemDesc.setAttr("HREF", 2);
        elemDesc = (ElemDesc)trie.get("menu");
        elemDesc.setAttr("COMPACT", 4);
        elemDesc = (ElemDesc)trie.get("object");
        elemDesc.setAttr("CLASSID", 2);
        elemDesc.setAttr("CODEBASE", 2);
        elemDesc.setAttr("DATA", 2);
        elemDesc.setAttr("ARCHIVE", 2);
        elemDesc.setAttr("USEMAP", 2);
        elemDesc.setAttr("DECLARE", 4);
        elemDesc.setAttr("DATASRC", 2);
        elemDesc = (ElemDesc)trie.get("ol");
        elemDesc.setAttr("COMPACT", 4);
        elemDesc = (ElemDesc)trie.get("optgroup");
        elemDesc.setAttr("DISABLED", 4);
        elemDesc = (ElemDesc)trie.get("option");
        elemDesc.setAttr("SELECTED", 4);
        elemDesc.setAttr("DISABLED", 4);
        elemDesc = (ElemDesc)trie.get("q");
        elemDesc.setAttr("CITE", 2);
        elemDesc = (ElemDesc)trie.get("script");
        elemDesc.setAttr("SRC", 2);
        elemDesc.setAttr("FOR", 2);
        elemDesc.setAttr("DEFER", 4);
        elemDesc = (ElemDesc)trie.get("span");
        elemDesc.setAttr("DATASRC", 2);
        elemDesc = (ElemDesc)trie.get("select");
        elemDesc.setAttr("DISABLED", 4);
        elemDesc.setAttr("MULTIPLE", 4);
        elemDesc.setAttr("DATASRC", 2);
        elemDesc = (ElemDesc)trie.get("table");
        elemDesc.setAttr("NOWRAP", 4);
        elemDesc.setAttr("DATASRC", 2);
        elemDesc = (ElemDesc)trie.get("td");
        elemDesc.setAttr("NOWRAP", 4);
        elemDesc = (ElemDesc)trie.get("textarea");
        elemDesc.setAttr("DISABLED", 4);
        elemDesc.setAttr("READONLY", 4);
        elemDesc.setAttr("DATASRC", 2);
        elemDesc = (ElemDesc)trie.get("th");
        elemDesc.setAttr("NOWRAP", 4);
        elemDesc = (ElemDesc)trie.get("tr");
        elemDesc.setAttr("NOWRAP", 4);
        elemDesc = (ElemDesc)trie.get("ul");
        elemDesc.setAttr("COMPACT", 4);
    }

    public static final ElemDesc getElemDesc(String string2) {
        Object object2 = m_elementFlags.get(string2);
        if (null != object2) {
            return (ElemDesc)object2;
        }
        return s_elemNotFound;
    }

    public void internalEntityDecl(String string2, String string3) throws SAXException {
    }

    static {
        HtmlElemInfo.initTagReference(m_elementFlags);
    }

    static class Trie {
        public static final int ALPHA_SIZE = 128;
        final Node m_Root;
        private char[] m_charBuffer = new char[0];
        private final boolean m_lowerCaseOnly;

        public Trie() {
            this.m_Root = new Node();
            this.m_lowerCaseOnly = false;
        }

        public Trie(boolean bl) {
            this.m_Root = new Node();
            this.m_lowerCaseOnly = bl;
        }

        public Object put(String string2, Object object2) {
            int n2 = string2.length();
            if (n2 > this.m_charBuffer.length) {
                this.m_charBuffer = new char[n2];
            }
            Node node2 = this.m_Root;
            for (int i = 0; i < n2; ++i) {
                Node node3 = node2.m_nextChar[Character.toLowerCase(string2.charAt(i))];
                if (node3 != null) {
                    node2 = node3;
                    continue;
                }
                while (i < n2) {
                    Node node4 = new Node();
                    if (this.m_lowerCaseOnly) {
                        node2.m_nextChar[Character.toLowerCase((char)string2.charAt((int)i))] = node4;
                    } else {
                        node2.m_nextChar[Character.toUpperCase((char)string2.charAt((int)i))] = node4;
                        node2.m_nextChar[Character.toLowerCase((char)string2.charAt((int)i))] = node4;
                    }
                    node2 = node4;
                    ++i;
                }
                break;
            }
            Object object3 = node2.m_Value;
            node2.m_Value = object2;
            return object3;
        }

        public Object get(String string2) {
            int n2 = string2.length();
            if (this.m_charBuffer.length < n2) {
                return null;
            }
            Node node2 = this.m_Root;
            switch (n2) {
                case 0: {
                    return null;
                }
                case 1: {
                    char c = string2.charAt(0);
                    if (c < '\u0080' && (node2 = node2.m_nextChar[c]) != null) {
                        return node2.m_Value;
                    }
                    return null;
                }
            }
            for (int i = 0; i < n2; ++i) {
                char c = string2.charAt(i);
                if ('\u0080' <= c) {
                    return null;
                }
                node2 = node2.m_nextChar[c];
                if (node2 != null) continue;
                return null;
            }
            return node2.m_Value;
        }

        public Trie(Trie trie) {
            this.m_Root = trie.m_Root;
            this.m_lowerCaseOnly = trie.m_lowerCaseOnly;
            int n2 = trie.getLongestKeyLength();
            this.m_charBuffer = new char[n2];
        }

        public Object get2(String string2) {
            int n2 = string2.length();
            if (this.m_charBuffer.length < n2) {
                return null;
            }
            Node node2 = this.m_Root;
            switch (n2) {
                case 0: {
                    return null;
                }
                case 1: {
                    char c = string2.charAt(0);
                    if (c < '\u0080' && (node2 = node2.m_nextChar[c]) != null) {
                        return node2.m_Value;
                    }
                    return null;
                }
            }
            string2.getChars(0, n2, this.m_charBuffer, 0);
            for (int i = 0; i < n2; ++i) {
                char c = this.m_charBuffer[i];
                if ('\u0080' <= c) {
                    return null;
                }
                node2 = node2.m_nextChar[c];
                if (node2 != null) continue;
                return null;
            }
            return node2.m_Value;
        }

        public int getLongestKeyLength() {
            return this.m_charBuffer.length;
        }

        private class Node {
            final Node[] m_nextChar = new Node[128];
            Object m_Value = null;

            Node() {
            }
        }
    }

    public static final class ElemDesc {
        private int m_flags;
        private StringToIntTable m_attrs = null;
        static final int EMPTY = 2;
        private static final int FLOW = 4;
        static final int BLOCK = 8;
        static final int BLOCKFORM = 16;
        static final int BLOCKFORMFIELDSET = 32;
        private static final int CDATA = 64;
        private static final int PCDATA = 128;
        static final int RAW = 256;
        static final int INLINE = 512;
        private static final int INLINEA = 1024;
        static final int INLINELABEL = 2048;
        static final int FONTSTYLE = 4096;
        static final int PHRASE = 8192;
        static final int FORMCTRL = 16384;
        static final int SPECIAL = 32768;
        static final int ASPECIAL = 65536;
        static final int HEADMISC = 131072;
        static final int HEAD = 262144;
        static final int LIST = 524288;
        static final int PREFORMATTED = 0x100000;
        static final int WHITESPACESENSITIVE = 0x200000;
        static final int HEADELEM = 0x400000;
        static final int HTMLELEM = 0x800000;
        public static final int ATTRURL = 2;
        public static final int ATTREMPTY = 4;

        ElemDesc(int n2) {
            this.m_flags = n2;
        }

        boolean is(int n2) {
            return (this.m_flags & n2) != 0;
        }

        int getFlags() {
            return this.m_flags;
        }

        void setAttr(String string2, int n2) {
            if (null == this.m_attrs) {
                this.m_attrs = new StringToIntTable();
            }
            this.m_attrs.put(string2, n2);
        }

        public boolean isAttrFlagSet(String string2, int n2) {
            return null != this.m_attrs ? (this.m_attrs.getIgnoreCase(string2) & n2) != 0 : false;
        }

        public String toString() {
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append("ElemDesc:\n");
            if (this.is(65536)) {
                stringBuilder.append("  ASPECIAL\n");
            }
            if (this.is(4)) {
                stringBuilder.append("  ATTREMPTY\n");
            }
            if (this.is(2)) {
                stringBuilder.append("  ATTRURL\n");
            }
            if (this.is(8)) {
                stringBuilder.append("  BLOCK\n");
            }
            if (this.is(16)) {
                stringBuilder.append("  BLOCKFORM\n");
            }
            if (this.is(32)) {
                stringBuilder.append("  BLOCKFORMFIELDSET\n");
            }
            if (this.is(64)) {
                stringBuilder.append("  CDATA\n");
            }
            if (this.is(2)) {
                stringBuilder.append("  EMPTY\n");
            }
            if (this.is(4)) {
                stringBuilder.append("  FLOW\n");
            }
            if (this.is(4096)) {
                stringBuilder.append("  FONTSTYLE\n");
            }
            if (this.is(16384)) {
                stringBuilder.append("  FORMCTRL\n");
            }
            if (this.is(262144)) {
                stringBuilder.append("  \n");
            }
            if (this.is(0x400000)) {
                stringBuilder.append("  HEAD\n");
            }
            if (this.is(131072)) {
                stringBuilder.append("  HEADMISC\n");
            }
            if (this.is(0x800000)) {
                stringBuilder.append("  HEADELEM\n");
            }
            if (this.is(512)) {
                stringBuilder.append("  INLINE\n");
            }
            if (this.is(1024)) {
                stringBuilder.append("  INLINEA\n");
            }
            if (this.is(2048)) {
                stringBuilder.append("  \n");
            }
            if (this.is(524288)) {
                stringBuilder.append("  INLINELABEL\n");
            }
            if (this.is(128)) {
                stringBuilder.append("  PCDATA\n");
            }
            if (this.is(8192)) {
                stringBuilder.append("  PHRASE\n");
            }
            if (this.is(0x100000)) {
                stringBuilder.append("  PREFORMATTED\n");
            }
            if (this.is(256)) {
                stringBuilder.append("  RAW\n");
            }
            if (this.is(32768)) {
                stringBuilder.append("  SPECIAL\n");
            }
            if (this.is(0x200000)) {
                stringBuilder.append("  WHITESPACESENSITIVE\n");
            }
            return stringBuilder.toString();
        }
    }
}

