/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xml.xci.serializer;

import com.ibm.xml.xci.CData;
import com.ibm.xml.xci.Cursor;
import com.ibm.xml.xci.CursorFactory;
import com.ibm.xml.xci.VolatileCData;
import com.ibm.xml.xci.dp.values.chars.Chars;
import com.ibm.xml.xci.serializer.AbstractStreamCursor;
import com.ibm.xml.xci.serializer.AddContentInterface;
import com.ibm.xml.xci.serializer.AdditionalAPIs;
import com.ibm.xml.xci.serializer.CharInfo;
import com.ibm.xml.xci.serializer.CursorExtended;
import com.ibm.xml.xci.serializer.EncodingInfo;
import com.ibm.xml.xci.serializer.Encodings;
import com.ibm.xml.xci.serializer.HtmlElemInfo;
import com.ibm.xml.xci.serializer.Messages;
import com.ibm.xml.xci.serializer.NamespaceMappings;
import com.ibm.xml.xci.serializer.SerializeParam;
import com.ibm.xml.xci.serializer.UnicodeNormalizerFactory;
import com.ibm.xml.xci.serializer.WriterOptimized;
import com.ibm.xml.xml4j.api.s1.xs.XSTypeDefinition;
import java.io.IOException;
import java.io.OutputStream;
import java.io.StringWriter;
import java.io.Writer;
import java.util.Map;

public class HTMLStreamCursor
extends AbstractStreamCursor
implements Cursor,
AdditionalAPIs,
CursorExtended,
AddContentInterface {
    static final String IBM_COPYRIGHT = "Licensed Materials - Property of IBM\n\nXML Cursor Interface for Java (XCI-J)\u00a9 Copyright IBM Corp. 2004, 2009. All Rights Reserved.\n\nUS Government Users Restricted Rights - Use, duplication or disclosure \nrestricted by GSA ADP Schedule Contract with IBM Corp.";
    static final HtmlElemInfo.Trie m_elementFlags = new HtmlElemInfo.Trie();
    private static final CharInfo s_htmlcharInfo;
    private CharInfo.CharKey m_charKey = new CharInfo.CharKey();
    private boolean m_inlineOnlyIfEmpty = false;
    private boolean m_ScriptOrStyle = false;
    private int m_ScriptOrStyleDepth = -1;
    private short m_TextEntityEncodings = (short)33;
    private static final byte[] CHARACTERS_CHAR_ESCAPE_MAP;
    private static final byte[] ATTRIBUTE_CHAR_ESCAPE_MAP;
    private static final byte[] CHARACTERS_CHAR_ESCAPE_MAP_ASCII;
    private static final byte[] ATTRIBUTE_CHAR_ESCAPE_MAP_ASCII;
    private static final byte[] PI_CHAR_ESCAPE_MAP;
    private static final byte[] PI_CHAR_ESCAPE_MAP_ASCII;
    private static final byte[] COMMENT_CHAR_ESCAPE_MAP;
    private static final byte[] COMMENT_CHAR_ESCAPE_MAP_ASCII;
    String m_attrName;
    private final boolean m_percentEscapeURIAttrs;
    protected final int CHARSBUFF_MAX_SIZE = 65536;
    private char[] m_charsBuff = new char[60];
    static final Integer s_i2;

    public HTMLStreamCursor(CursorFactory cursorFactory, OutputStream outputStream, Map map2) {
        super(cursorFactory, outputStream, (Map<SerializeParam, Object>)map2);
        this.m_percentEscapeURIAttrs = this.shouldEscape(map2);
    }

    private boolean shouldEscape(Map map2) {
        Object v;
        return map2 == null || !((v = map2.get("escape-uri-attributes")) instanceof Boolean) || !Boolean.FALSE.equals(v);
    }

    public HTMLStreamCursor(CursorFactory cursorFactory, Writer writer, Map map2) {
        super(cursorFactory, writer, (Map<SerializeParam, Object>)map2);
        this.m_percentEscapeURIAttrs = this.shouldEscape(map2);
    }

    final void privateWriteAttrNSDecl(int n2) throws IOException {
        String string2;
        this.m_writer.write(XMLNS);
        NamespaceMappings.MappingRecord mappingRecord = this.m_prefixMap.lookupNamespace(n2);
        String string3 = string2 = mappingRecord.get_uri();
        String string4 = mappingRecord.get_prefix();
        if (string4 != EMPTY_STRING) {
            this.m_writer.write(58);
            this.m_writer.write(string4);
        }
        this.m_writer.write(61);
        this.m_writer.write(34);
        this.escapeValue(string3, this.getCharEscapeMap((short)4));
        this.m_writer.write(34);
    }

    void writeOutHeader(String string2, String string3, String string4) throws IOException {
        this.m_ScriptOrStyle = false;
    }

    private void resetInlineElem(boolean bl) {
        this.m_isInlineElem = false;
        if (this.m_inlineOnlyIfEmpty) {
            if (!bl) {
                this.m_elemContext.set_isInline(false);
            }
            this.m_inlineOnlyIfEmpty = false;
        }
    }

    public final void addText(Cursor.Area area, VolatileCData volatileCData) {
        if (this.m_isInlineElem) {
            this.resetInlineElem(area == Cursor.Area.FOLLOWING_SIBLING);
        }
        super.addText(area, volatileCData);
    }

    public final void addText(Cursor.Area area, Chars chars) {
        if (this.m_isInlineElem) {
            this.resetInlineElem(area == Cursor.Area.FOLLOWING_SIBLING);
        }
        super.addText(area, chars);
    }

    public final void addProcessingInstruction(Cursor.Area area, VolatileCData volatileCData, VolatileCData volatileCData2) {
        if (this.m_isInlineElem) {
            this.resetInlineElem(area == Cursor.Area.FOLLOWING_SIBLING);
        }
        super.addProcessingInstruction(area, volatileCData, volatileCData2);
    }

    public final void addComment(Cursor.Area area, VolatileCData volatileCData) {
        if (this.m_isInlineElem) {
            this.resetInlineElem(area == Cursor.Area.FOLLOWING_SIBLING);
        }
        super.addComment(area, volatileCData);
    }

    public final void addElement(Cursor.Area area, VolatileCData volatileCData, XSTypeDefinition xSTypeDefinition) {
        if (this.m_isInlineElem) {
            this.resetInlineElem(area == Cursor.Area.FOLLOWING_SIBLING);
        }
        super.addElement(area, volatileCData, xSTypeDefinition);
        String string2 = this.m_elemContext.get_elemURI();
        String string3 = this.m_elemContext.get_elemLocalName();
        if (string2 == null || string2.length() == 0) {
            boolean bl = string3.equalsIgnoreCase("script");
            if (bl || string3.equalsIgnoreCase("style")) {
                this.m_ScriptOrStyle = true;
                this.m_ScriptOrStyleDepth = this.m_elemContext.get_elemDepth();
                this.m_TextEntityEncodings = 0;
                this.m_isInlineElem = bl;
                this.m_elemContext.set_isInline(this.m_isInlineElem);
            } else {
                HtmlElemInfo.ElemDesc elemDesc = HTMLStreamCursor.getElemDesc(string3);
                if (this.isAnHTMLElemName(elemDesc)) {
                    this.m_isInlineElem = elemDesc.is(512);
                    if (this.m_isInlineElem && (string3.equalsIgnoreCase("ins") || string3.equalsIgnoreCase("del"))) {
                        this.m_inlineOnlyIfEmpty = true;
                    }
                    this.m_elemContext.set_isInline(this.m_isInlineElem);
                }
            }
        }
    }

    public void writeValue(VolatileCData volatileCData) throws IOException {
        this.writeValue(volatileCData, this.m_TextEntityEncodings, false);
    }

    protected void writeValue(Chars chars) throws IOException {
        this.writeValue(chars, this.m_TextEntityEncodings, false);
    }

    byte[] getCharEscapeMap(short s) {
        switch (s) {
            case 0: {
                return this.m_isASCIIEncoding ? CHARACTERS_CHAR_ESCAPE_MAP_ASCII : CHARACTERS_CHAR_ESCAPE_MAP;
            }
            case 1: {
                return this.m_isASCIIEncoding ? ATTRIBUTE_CHAR_ESCAPE_MAP_ASCII : ATTRIBUTE_CHAR_ESCAPE_MAP;
            }
            case 2: {
                return this.m_isASCIIEncoding ? PI_CHAR_ESCAPE_MAP_ASCII : PI_CHAR_ESCAPE_MAP;
            }
            case 3: {
                return this.m_isASCIIEncoding ? COMMENT_CHAR_ESCAPE_MAP_ASCII : COMMENT_CHAR_ESCAPE_MAP;
            }
        }
        return super.getCharEscapeMap(s);
    }

    protected final void escapeValue(CharSequence charSequence, int n2, int n3, int n4, byte[] byArray) throws IOException {
        int n5 = n2;
        block11: for (int i = n3; i < n4; ++i) {
            String string2;
            char c = charSequence.charAt(i);
            if (c < byArray.length) {
                block0 : switch (byArray[c]) {
                    case 0: {
                        ++i;
                        while (i < n4) {
                            c = charSequence.charAt(i);
                            if (c >= byArray.length || byArray[c] != 0) {
                                --i;
                                break block0;
                            }
                            ++i;
                        }
                        continue block11;
                    }
                    case 4: {
                        if (n5 < i) {
                            this.m_writer.append(charSequence, n5, i);
                        }
                        this.m_writer.append("&lt;");
                        n5 = i + 1;
                        break;
                    }
                    case 5: {
                        if (n5 < i) {
                            this.m_writer.append(charSequence, n5, i);
                        }
                        this.m_writer.append("&gt;");
                        n5 = i + 1;
                        break;
                    }
                    case 9: {
                        if (i < n4 - 1 && charSequence.charAt(i + 1) == '{') {
                            ++i;
                            break;
                        }
                    }
                    case 6: {
                        if (n5 < i) {
                            this.m_writer.append(charSequence, n5, i);
                        }
                        this.m_writer.append("&amp;");
                        n5 = i + 1;
                        break;
                    }
                    case 7: {
                        if (n5 < i) {
                            this.m_writer.append(charSequence, n5, i);
                        }
                        this.m_writer.append("&quot;");
                        n5 = i + 1;
                        break;
                    }
                    case 10: {
                        if (this.m_encodingInfo.isCharInEncoding(c)) break;
                    }
                    case 12: {
                        if (n5 < i) {
                            this.m_writer.append(charSequence, n5, i);
                        }
                        this.m_writer.append(s_htmlcharInfo.getOutputStringForChar(c, this.m_charKey));
                        n5 = i + 1;
                        break;
                    }
                    case 16: {
                        string2 = Messages.createMessage2("ER_SER_BAD_HTML_CONTROL_CHARS", new String[]{Integer.toString(c, 16)});
                        Messages.xciDynamicErrorException(string2);
                        break;
                    }
                }
                continue;
            }
            if (c >= '\ud800' && c <= '\udbff') {
                if (i < n4 - 1) {
                    char c2;
                    if (!Encodings.isLowUTF16Surrogate(c2 = charSequence.charAt(++i))) {
                        String string3 = Messages.createMessage2("ER_SER_INVALID_UTF16_SURROGATE2", new String[]{Integer.toString(c, 16), Integer.toString(c2, 16)});
                        Messages.xciDynamicErrorException(string3);
                    }
                    if (this.m_encodingInfo.isSurrogatePairInEncoding(c, c2)) continue;
                    if (n5 < i) {
                        this.m_writer.append(charSequence, n5, i);
                    }
                    this.writeCharacterAsHex(Encodings.toCodePoint(c, c2));
                    n5 = i + 1;
                    continue;
                }
                string2 = Messages.createMessage2("ER_SER_INVALID_UTF16_SURROGATE1", new String[]{Integer.toString(c, 16)});
                Messages.xciDynamicErrorException(string2);
                continue;
            }
            if (Encodings.isLowUTF16Surrogate(c)) {
                string2 = Messages.createMessage2("ER_SER_INVALID_UTF16_SURROGATE3", new String[]{Integer.toString(c, 16)});
                Messages.xciDynamicErrorException(string2);
                continue;
            }
            if (this.m_encodingInfo.isCharInEncoding(c)) continue;
            if (s_htmlcharInfo.shouldMapTextChar(c)) {
                if (n5 < i) {
                    this.m_writer.append(charSequence, n5, i);
                }
                this.m_writer.append(s_htmlcharInfo.getOutputStringForChar(c, this.m_charKey));
                n5 = i + 1;
                continue;
            }
            if (n5 < i) {
                this.m_writer.append(charSequence, n5, i);
            }
            this.writeCharacterAsInt(c);
            n5 = i + 1;
        }
        if (n5 < n4) {
            this.m_writer.append(charSequence, n5, n4);
        }
    }

    protected final void escapeValueOld(CharSequence charSequence, int n2, int n3, boolean bl) throws IOException {
        while (n2 < n3) {
            char c = charSequence.charAt(n2);
            if (c < '\u007f') {
                if (c == '<' && !bl) {
                    this.m_writer.append("&lt;");
                } else if (c == '>') {
                    this.m_writer.append("&gt;");
                } else if (c == '&') {
                    if (!bl || n2 + 1 == n3 || charSequence.charAt(n2 + 1) != '{') {
                        this.m_writer.append("&amp;");
                    } else {
                        this.m_writer.append("&{");
                        ++n2;
                    }
                } else if (c == '\"' && bl) {
                    this.m_writer.append("&quot;");
                } else {
                    this.m_writer.append(c);
                }
            } else if (c > '\u009f') {
                if (c == '\u00a0') {
                    this.m_writer.append("&nbsp;");
                } else if (Encodings.isHighUTF16Surrogate(c) && n2 + 1 < n3) {
                    this.m_writer.append(charSequence, n2, n2 + 2);
                    ++n2;
                } else if (this.m_encodingInfo.isCharInEncoding(c)) {
                    this.m_writer.append(c);
                } else if (s_htmlcharInfo.shouldMapTextChar(c)) {
                    this.m_writer.append(s_htmlcharInfo.getOutputStringForChar(c, this.m_charKey));
                } else {
                    this.writeCharacterAsInt(c);
                }
            } else {
                String string2 = Messages.createMessage2("ER_SER_BAD_HTML_CONTROL_CHARS", new String[]{Integer.toString(c, 16)});
                Messages.xciDynamicErrorException(string2);
            }
            ++n2;
        }
    }

    protected boolean isCDataSectionElement(String string2, String string3) {
        if (string2 == null || string2.length() == 0) {
            return false;
        }
        return super.isCDataSectionElement(string2, string3);
    }

    protected void checkPI_CommentValue(VolatileCData volatileCData, int n2, int n3, byte[] byArray, boolean bl) {
        block7: for (int i = n2; i < n3; ++i) {
            char c = volatileCData.charAt(i);
            if (c < byArray.length) {
                block0 : switch (byArray[c]) {
                    case 0: {
                        ++i;
                        while (i < n3 && (c = volatileCData.charAt(i)) < byArray.length) {
                            if (byArray[c] != 0) break block0;
                            ++i;
                        }
                        continue block7;
                    }
                    case 5: {
                        String string2 = Messages.createMessage2("ER_SER_GT_IN_PROCESSING_INSTRUCTION1", new String[]{volatileCData.getString(1)});
                        Messages.xciDynamicErrorException(string2);
                        break;
                    }
                    case 8: {
                        if (i >= n3 - 1 || volatileCData.charAt(++i) != '-') continue block7;
                        String string3 = Messages.createMessage2("ER_SER_INVALID_DASH_IN_COMMENT", null);
                        Messages.xciDynamicErrorException(string3);
                        break;
                    }
                    case 16: {
                        String string4 = Messages.createMessage2("ER_SER_BAD_HTML_CONTROL_CHARS", new String[]{Integer.toString(c, 16)});
                        Messages.xciDynamicErrorException(string4);
                        break;
                    }
                    case 15: {
                        String string5 = Messages.createMessage2(bl ? "ER_SER_CHAR_NOT_REPRESENTABLE_IN_ENCODING_FOR_PI" : "ER_SER_CHAR_NOT_REPRESENTABLE_IN_ENCODING_FOR_COMMENT", new String[]{HTMLStreamCursor.makeHexString(c), this.getEncoding()});
                        Messages.xciDynamicErrorException(string5);
                        break;
                    }
                }
                continue;
            }
            if (c >= '\ud800' && c <= '\udbff') {
                if (i < n3 - 1) {
                    String string6;
                    char c2;
                    if (!Encodings.isLowUTF16Surrogate(c2 = volatileCData.charAt(++i))) {
                        string6 = Messages.createMessage2("ER_SER_INVALID_UTF16_SURROGATE2", new String[]{Integer.toString(c, 16), Integer.toString(c2, 16)});
                        Messages.xciDynamicErrorException(string6);
                    }
                    if (this.m_encodingInfo.isSurrogatePairInEncoding(c, c2)) continue;
                    string6 = Messages.createMessage2(bl ? "ER_SER_CHAR_NOT_REPRESENTABLE_IN_ENCODING_FOR_PI" : "ER_SER_CHAR_NOT_REPRESENTABLE_IN_ENCODING_FOR_COMMENT", new String[]{HTMLStreamCursor.makeHexString(Encodings.toCodePoint(c, c2)), this.getEncoding()});
                    Messages.xciDynamicErrorException(string6);
                    continue;
                }
                String string7 = Messages.createMessage2("ER_SER_INVALID_UTF16_SURROGATE1", new String[]{Integer.toString(c, 16)});
                Messages.xciDynamicErrorException(string7);
                continue;
            }
            if (Encodings.isLowUTF16Surrogate(c)) {
                String string8 = Messages.createMessage2("ER_SER_INVALID_UTF16_SURROGATE3", new String[]{Integer.toString(c, 16)});
                Messages.xciDynamicErrorException(string8);
                continue;
            }
            if (this.m_encodingInfo.isCharInEncoding(c)) continue;
            String string9 = Messages.createMessage2(bl ? "ER_SER_CHAR_NOT_REPRESENTABLE_IN_ENCODING_FOR_PI" : "ER_SER_CHAR_NOT_REPRESENTABLE_IN_ENCODING_FOR_COMMENT", new String[]{HTMLStreamCursor.makeHexString(c), this.getEncoding()});
            Messages.xciDynamicErrorException(string9);
        }
    }

    protected void writePIEnd() throws IOException {
        this.writeASCII(GREATERTHAN_CHAR);
    }

    void writeASCII(char c) throws IOException {
        this.m_writer.write(c);
    }

    void writeASCII(char[] cArray) throws IOException {
        this.m_writer.write(cArray, 0, cArray.length);
    }

    public final void writeBytes(byte[] byArray, int n2, int n3) throws IOException {
        if (this.m_writerOptimized != null) {
            this.m_writerOptimized.writeBytes(byArray, n2, n3);
        } else if (this.m_outputStream != null) {
            if (this.m_writer != null) {
                this.m_writer.flush();
            }
            this.m_outputStream.write(byArray, n2, n3);
        } else {
            this.m_writer.write(new String(byArray, n2, n3));
        }
    }

    public boolean isCurrentElemInline(VolatileCData volatileCData) {
        CData cData = volatileCData.constant(true);
        String string2 = cData.getQNameLocalPart(1);
        HtmlElemInfo.ElemDesc elemDesc = HTMLStreamCursor.getElemDesc(string2);
        if (this.isAnHTMLElemName(elemDesc) && !string2.equalsIgnoreCase("ins") && !string2.equalsIgnoreCase("del")) {
            return elemDesc.is(512);
        }
        return false;
    }

    final void writeNonElementQName(String string2, String string3) throws IOException {
        if (string2 != null && string2.length() > 0) {
            this.m_writer.write(string2);
            this.writeASCII(COLON_CHAR);
        }
        this.m_attrName = string3;
        if (this.m_writerOptimized != null) {
            this.m_writerOptimized.write(this.m_attrName);
        } else {
            this.m_writer.write(this.m_attrName);
        }
    }

    void writeAttributeValue(VolatileCData volatileCData) throws IOException {
        boolean bl;
        String string2 = this.m_elemContext.get_elemURI();
        boolean bl2 = bl = string2 != null && string2.length() > 0;
        if (!bl) {
            Object object2;
            HtmlElemInfo.ElemDesc elemDesc = this.m_elemContext.getElementDesc();
            if (elemDesc == null) {
                object2 = this.m_elemContext.get_elemLocalName();
                elemDesc = HTMLStreamCursor.getElemDesc((String)object2);
                this.m_elemContext.setElementDesc(elemDesc);
            }
            if (this.notAnHTMLElemName(elemDesc)) {
                bl = true;
            } else if (elemDesc.isAttrFlagSet(this.m_attrName, 2) && this.m_percentEscapeURIAttrs) {
                object2 = new StringWriter();
                volatileCData.writeTo((Writer)object2, false);
                this.writeHTMLAttrURI(this.m_writer, this.m_writerOptimized, ((StringWriter)object2).toString());
                return;
            }
        }
        this.writeValue(volatileCData, (short)141, true);
    }

    private boolean notAnHTMLElemName(HtmlElemInfo.ElemDesc elemDesc) {
        return elemDesc == HtmlElemInfo.s_elemNotFound;
    }

    private boolean isAnHTMLElemName(HtmlElemInfo.ElemDesc elemDesc) {
        return elemDesc != HtmlElemInfo.s_elemNotFound;
    }

    private static final HtmlElemInfo.ElemDesc getElemDesc(String string2) {
        Object object2 = m_elementFlags.get(string2);
        if (null != object2) {
            return (HtmlElemInfo.ElemDesc)object2;
        }
        return HtmlElemInfo.s_elemNotFound;
    }

    public AdditionalAPIs getCursorExtensions() {
        return this;
    }

    public String getPrefix(String string2) {
        String string3;
        NamespaceMappings.MappingRecord mappingRecord = this.m_prefixMap.lookupPrefix(string2);
        if (mappingRecord != null && (string3 = mappingRecord.get_prefix()).length() > 0) {
            return string3;
        }
        return null;
    }

    public String getUnusedPrefix() {
        String string2 = this.m_prefixMap.generateUnusedPrefix();
        return string2;
    }

    protected void indent() throws IOException {
        int n2 = this.getElemDepth() - 1;
        Integer n3 = (Integer)this.getOutputProperty(SerializeParam.INDENT_AMOUNT);
        n2 *= n3.intValue();
        Character c = (Character)this.getOutputProperty(SerializeParam.INDENT_CHARACTER);
        for (int i = 0; i < n2; ++i) {
            this.m_writer.write(c.charValue());
        }
    }

    public void writeClosingTag(VolatileCData volatileCData) throws IOException {
        this.m_isInlineElem = this.m_elemContext.is_Inline();
        super.writeClosingTag(volatileCData);
        if (this.m_ScriptOrStyle && this.m_ScriptOrStyleDepth == this.m_elemContext.get_elemDepth()) {
            this.m_ScriptOrStyle = false;
            this.m_TextEntityEncodings = (short)33;
        }
    }

    public final void writeSlashBracket() throws IOException {
        String string2 = this.m_elemContext.get_elemURI();
        boolean bl = string2 != null && string2.length() > 0;
        String string3 = this.m_elemContext.get_elemLocalName();
        this.m_isInlineElem = this.m_elemContext.is_Inline();
        if (this.mayAddNamespaceNode()) {
            if (bl) {
                super.privateElemStart();
                this.m_writer.write("/>");
                return;
            }
            HtmlElemInfo.ElemDesc elemDesc = HTMLStreamCursor.getElemDesc(string3);
            if (this.notAnHTMLElemName(elemDesc)) {
                super.privateElemStart();
                this.m_writer.write("></");
                this.m_writer.write(string3);
                this.writeASCII(GREATERTHAN_CHAR);
                return;
            }
            this.writeASCII(LESSTHAN_CHAR);
            String string4 = this.m_elemContext.get_elemLocalName();
            this.m_writer.write(string4);
            if (elemDesc.is(2)) {
                this.writeASCII(GREATERTHAN_CHAR);
            } else {
                this.m_writer.write("></");
                this.m_writer.write(string3);
                this.writeASCII(GREATERTHAN_CHAR);
            }
            return;
        }
        if (bl) {
            this.m_writer.write("/>");
        } else {
            HtmlElemInfo.ElemDesc elemDesc = HTMLStreamCursor.getElemDesc(string3);
            if (elemDesc.is(2)) {
                this.m_writer.write(">");
            } else {
                this.m_writer.write("></");
                this.m_writer.write(string3);
                this.writeASCII(GREATERTHAN_CHAR);
            }
        }
        if (this.m_ScriptOrStyle && this.m_ScriptOrStyleDepth == this.m_elemContext.get_elemDepth()) {
            this.m_ScriptOrStyle = false;
            this.m_TextEntityEncodings = (short)33;
        }
    }

    final void privateElemStart() throws IOException {
        String string2 = this.m_elemContext.get_elemURI();
        if (string2 != null && string2.length() > 0) {
            super.privateElemStart();
            return;
        }
        String string3 = this.m_elemContext.get_elemLocalName();
        HtmlElemInfo.ElemDesc elemDesc = HTMLStreamCursor.getElemDesc(string3);
        if (this.notAnHTMLElemName(elemDesc)) {
            super.privateElemStart();
            return;
        }
        this.writeASCII(LESSTHAN_CHAR);
        String string4 = this.m_elemContext.get_elemLocalName();
        this.m_writer.write(string4);
        int n2 = this.m_elemContext.get_firstNamespaceNode();
        if (0 <= n2) {
            int n3 = this.m_elemContext.get_lastNamespaceNode();
            for (int i = n2; i <= n3; ++i) {
                this.privateWriteAttrNSDecl(i);
            }
        }
    }

    void writeHTMLAttrURI(Writer writer, WriterOptimized writerOptimized, String string2) throws IOException {
        int n2;
        if (this.m_unicodeNormalizer == null) {
            this.m_unicodeNormalizer = UnicodeNormalizerFactory.getUnicodeNormalizer();
        }
        if (!this.m_unicodeNormalizer.alreadyNormalized(string2, 2)) {
            string2 = this.m_unicodeNormalizer.normalizeUnicode(string2, 2);
        }
        int n3 = string2.length();
        for (int i = 0; i < n3; i += n2) {
            n2 = this.getChars(string2, i, n3);
            char[] cArray = this.getCharsBuff();
            char c = '\u0000';
            for (int j = 0; j < n2; ++j) {
                String string3;
                c = cArray[j];
                if (c < ' ' || c > '~') {
                    int n4;
                    int n5;
                    if (c <= '\u007f') {
                        writer.write(37);
                        writer.write(HTMLStreamCursor.makeHexString(c));
                        continue;
                    }
                    if (c <= '\u07ff') {
                        int n6 = c >> 6 | 0xC0;
                        n5 = c & 0x3F | 0x80;
                        writer.write(37);
                        writer.write(HTMLStreamCursor.makeHexString(n6));
                        writer.write(37);
                        writer.write(HTMLStreamCursor.makeHexString(n5));
                        continue;
                    }
                    if (Encodings.isHighUTF16Surrogate(c)) {
                        int n7 = c & 0x3FF;
                        n5 = (n7 & 0x3C0) >> 6;
                        n4 = n5 + 1;
                        int n8 = (n7 & 0x3C) >> 2;
                        int n9 = (n7 & 3) << 4 & 0x30;
                        c = cArray[++j];
                        int n10 = c & 0x3FF;
                        int n11 = n10 & 0x3F;
                        int n12 = 0xF0 | n4 >> 2;
                        int n13 = 0x80 | (n4 & 3) << 4 & 0x30 | n8;
                        int n14 = 0x80 | (n9 |= (n10 & 0x3C0) >> 6);
                        int n15 = 0x80 | n11;
                        writer.write(37);
                        writer.write(HTMLStreamCursor.makeHexString(n12));
                        writer.write(37);
                        writer.write(HTMLStreamCursor.makeHexString(n13));
                        writer.write(37);
                        writer.write(HTMLStreamCursor.makeHexString(n14));
                        writer.write(37);
                        writer.write(HTMLStreamCursor.makeHexString(n15));
                        continue;
                    }
                    int n16 = c >> 12 | 0xE0;
                    n5 = (c & 0xFC0) >> 6 | 0x80;
                    n4 = c & 0x3F | 0x80;
                    writer.write(37);
                    writer.write(HTMLStreamCursor.makeHexString(n16));
                    writer.write(37);
                    writer.write(HTMLStreamCursor.makeHexString(n5));
                    writer.write(37);
                    writer.write(HTMLStreamCursor.makeHexString(n4));
                    continue;
                }
                switch (c) {
                    case '\"': {
                        string3 = "&quot;";
                        break;
                    }
                    case '&': {
                        string3 = "&amp;";
                        break;
                    }
                    case '>': {
                        string3 = "&gt;";
                        break;
                    }
                    default: {
                        string3 = null;
                    }
                }
                if (string3 != null) {
                    writer.write(string3);
                    continue;
                }
                writer.write(c);
            }
        }
    }

    int getChars(String string2, int n2, int n3) {
        int n4;
        int n5 = n3 - n2;
        if (n5 <= 0) {
            n4 = 0;
        } else {
            char[] cArray = this.m_charsBuff;
            int n6 = cArray.length;
            if (n5 <= n6) {
                int n7 = n5 - 1;
                string2.getChars(n2, n3, cArray, 0);
                char c = cArray[n7];
                n4 = Encodings.isHighUTF16Surrogate(c) ? n7 : n5;
            } else {
                if (n6 != 65536) {
                    n6 = n5 * 2 + 1;
                    if (n6 > 65536) {
                        n6 = 65536;
                    }
                    this.m_charsBuff = cArray = new char[n6];
                }
                if (n6 < n5) {
                    n5 = n6;
                    n3 = n2 + n5;
                }
                int n8 = n5 - 1;
                string2.getChars(n2, n3, cArray, 0);
                char c = cArray[n8];
                n4 = Encodings.isHighUTF16Surrogate(c) ? n8 : n5;
            }
        }
        return n4;
    }

    final char[] getCharsBuff() {
        return this.m_charsBuff;
    }

    Object getProp(Object object2, boolean bl) {
        Object object3 = null;
        String string2 = null;
        if (object2 instanceof String) {
            string2 = (String)object2;
        } else if (object2 instanceof SerializeParam) {
            string2 = ((SerializeParam)object2).toString();
        } else {
            return null;
        }
        if (bl) {
            if (string2.equals("version".toString())) {
                object3 = "4.01";
                return object3;
            }
            if (string2.equals("encoding".toString())) {
                object3 = "UTF-8";
                return object3;
            }
            if (string2.equals("indent".toString())) {
                object3 = Boolean.TRUE;
                return object3;
            }
            if (string2.equals("method".toString())) {
                object3 = "xml";
                return object3;
            }
            if (string2.equals("media-type".toString())) {
                object3 = "text/xml";
                return object3;
            }
            if (string2.equals("omit-xml-declaration".toString())) {
                object3 = Boolean.FALSE;
                return object3;
            }
            if (string2.equals("standalone".toString())) {
                object3 = Boolean.FALSE;
                return object3;
            }
            if (string2.equals(SerializeParam.INDENT_AMOUNT.toString())) {
                object3 = s_i2;
                return object3;
            }
            if (string2.equals(SerializeParam.INDENT_CHARACTER.toString())) {
                object3 = Character.valueOf(' ');
                return object3;
            }
        } else if (this.m_OutputProps == null) {
            object3 = null;
        } else {
            object3 = this.m_OutputProps.get(object2);
            if (object3 == null && object2 instanceof SerializeParam) {
                object3 = this.m_OutputProps.get(object2.toString());
            }
        }
        return object3;
    }

    void setDefaultProperties() {
        EncodingInfo encodingInfo;
        this.m_version = "4.01";
        this.m_encodingInfo = encodingInfo = Encodings.getEncodingInfo("UTF-8");
        this.m_isUTF8 = true;
        this.setIndent(true);
        this.setStandalone("omit");
        this.m_wasJustReset = true;
        this.m_normalizerMode = 1;
        this.m_isFirstRoot = false;
        this.m_isASCIIEncoding = false;
        this.m_doctypeSystem = null;
        this.m_doctypePublic = null;
    }

    public final void writeAttribute(boolean bl, VolatileCData volatileCData, VolatileCData volatileCData2) throws IOException {
        String string2;
        String string3;
        if (this.mayAddNamespaceNode()) {
            this.privateElemStart();
            this.m_elemContext.set_STATE(3);
        }
        String string4 = this.processNonElemQName(volatileCData);
        boolean bl2 = HTMLStreamCursor.isQNameType(volatileCData2);
        String string5 = string3 = bl2 ? this.processNonElemQName(volatileCData2) : null;
        if (bl) {
            this.writeASCII(SPACE_CHAR);
        }
        this.writeNonElementQName(string4, volatileCData.getQNameLocalPart(1));
        HtmlElemInfo.ElemDesc elemDesc = this.m_elemContext.getElementDesc();
        if (elemDesc == null && (string2 = this.m_elemContext.get_elemURI()).length() == 0) {
            String string6 = this.m_elemContext.get_elemLocalName();
            elemDesc = HTMLStreamCursor.getElemDesc(string6);
            this.m_elemContext.setElementDesc(elemDesc);
        }
        if (elemDesc != null && !this.notAnHTMLElemName(elemDesc) && elemDesc.isAttrFlagSet(this.m_attrName, 4) && this.m_attrName.equals(volatileCData2.toString())) {
            return;
        }
        this.writeASCII(EQUALS_CHAR);
        this.writeASCII(DOUBLE_QUOTE_CHAR);
        if (bl2) {
            this.writeNonElementQName(string3, volatileCData2.getQNameLocalPart(1));
        } else {
            this.writeAttributeValue(volatileCData2);
        }
        this.writeASCII(DOUBLE_QUOTE_CHAR);
    }

    void writeoutDOCTYPE(String string2) throws IOException {
        Writer writer = this.m_writer;
        boolean bl = "HTML".equals(string2) || "html".equals(string2);
        String string3 = this.getDoctypeSystem();
        String string4 = this.getDoctypePublic();
        if (null != string4) {
            writer.write("<!DOCTYPE ");
            if (bl) {
                writer.write(string2);
            } else {
                writer.write("HTML");
            }
            writer.write(" PUBLIC \"");
            writer.write(string4);
            if (null != string3) {
                writer.write("\" \"");
                writer.write(string3);
                writer.write("\">");
            } else {
                writer.write("\">");
            }
            writer.write(this.m_indentLineSep, 0, this.m_indentLineSepLen);
        } else if (null != string3) {
            writer.write("<!DOCTYPE ");
            if (bl) {
                writer.write(string2);
            } else {
                writer.write("HTML");
            }
            writer.write(" SYSTEM \"");
            writer.write(string3);
            writer.write("\">");
            writer.write(this.m_indentLineSep, 0, this.m_indentLineSepLen);
        }
    }

    public boolean toIds(VolatileCData volatileCData, boolean bl) {
        if (bl) {
            String string2 = Messages.createMessage2("ER_UNIMPLEMENTED_METHOD", new String[]{"toIds", this.getClass().getName()});
            Messages.xciDynamicErrorException(string2);
        }
        return false;
    }

    final void checkSupportedVersion(String string2) {
        if (!string2.equals("4.01") && !string2.equals("4.0")) {
            String string3 = Messages.createMessage2("ER_SER_BAD_HTML_VERSION", new String[]{string2});
            Messages.xciDynamicErrorException(string3);
        }
    }

    static {
        HtmlElemInfo.initTagReference(m_elementFlags);
        s_htmlcharInfo = CharInfo.getCharInfo(null, "html");
        CHARACTERS_CHAR_ESCAPE_MAP = new byte[]{16, 16, 16, 16, 16, 16, 16, 16, 16, 0, 0, 16, 16, 0, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 0, 0, 0, 0, 0, 0, 6, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 4, 0, 5, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 12, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10};
        ATTRIBUTE_CHAR_ESCAPE_MAP = new byte[]{16, 16, 16, 16, 16, 16, 16, 16, 16, 0, 0, 16, 16, 0, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 0, 0, 7, 0, 0, 0, 9, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 5, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 12, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10};
        CHARACTERS_CHAR_ESCAPE_MAP_ASCII = new byte[]{16, 16, 16, 16, 16, 16, 16, 16, 16, 0, 0, 16, 16, 0, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 0, 0, 0, 0, 0, 0, 6, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 4, 0, 5, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 12, 12, 12, 12, 12, 12, 12, 12, 12, 12, 12, 12, 12, 12, 12, 12, 12, 12, 12, 12, 12, 12, 12, 12, 12, 12, 12, 12, 12, 12, 12, 12, 12, 12, 12, 12, 12, 12, 12, 12, 12, 12, 12, 12, 12, 12, 12, 12, 12, 12, 12, 12, 12, 12, 12, 12, 12, 12, 12, 12, 12, 12, 12, 12, 12, 12, 12, 12, 12, 12, 12, 12, 12, 12, 12, 12, 12, 12, 12, 12, 12, 12, 12, 12, 12, 12, 12, 12, 12, 12, 12, 12, 12, 12, 12, 12};
        ATTRIBUTE_CHAR_ESCAPE_MAP_ASCII = new byte[]{16, 16, 16, 16, 16, 16, 16, 16, 16, 0, 0, 16, 16, 0, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 0, 0, 7, 0, 0, 0, 9, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 5, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 12, 12, 12, 12, 12, 12, 12, 12, 12, 12, 12, 12, 12, 12, 12, 12, 12, 12, 12, 12, 12, 12, 12, 12, 12, 12, 12, 12, 12, 12, 12, 12, 12, 12, 12, 12, 12, 12, 12, 12, 12, 12, 12, 12, 12, 12, 12, 12, 12, 12, 12, 12, 12, 12, 12, 12, 12, 12, 12, 12, 12, 12, 12, 12, 12, 12, 12, 12, 12, 12, 12, 12, 12, 12, 12, 12, 12, 12, 12, 12, 12, 12, 12, 12, 12, 12, 12, 12, 12, 12, 12, 12, 12, 12, 12, 12};
        PI_CHAR_ESCAPE_MAP = new byte[]{16, 16, 16, 16, 16, 16, 16, 16, 16, 0, 0, 16, 16, 0, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 5, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0};
        PI_CHAR_ESCAPE_MAP_ASCII = new byte[]{16, 16, 16, 16, 16, 16, 16, 16, 16, 0, 0, 16, 16, 0, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 5, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 16, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15};
        COMMENT_CHAR_ESCAPE_MAP = new byte[]{16, 16, 16, 16, 16, 16, 16, 16, 16, 0, 0, 16, 16, 0, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 8, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0};
        COMMENT_CHAR_ESCAPE_MAP_ASCII = new byte[]{16, 16, 16, 16, 16, 16, 16, 16, 16, 0, 0, 16, 16, 0, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 8, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 16, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15};
        s_i2 = 2;
    }
}

