/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xml.xci.serializer;

import com.ibm.xml.xci.serializer.Encodings;

public final class EncodingInfo {
    static final String IBM_COPYRIGHT = "Licensed Materials - Property of IBM\n\nXML Cursor Interface for Java (XCI-J)\u00a9 Copyright IBM Corp. 2004, 2008. All Rights Reserved.\n\nUS Government Users Restricted Rights - Use, duplication or disclosure \nrestricted by GSA ADP Schedule Contract with IBM Corp.";
    final String name;
    final String javaName;
    final boolean isStateless;
    InEncoding m_encoding;
    private static final byte[] s_noBytes = new byte[0];

    public boolean isCharInEncoding(char c) {
        if (this.m_encoding == null) {
            this.m_encoding = new EncodingImpl(this);
        }
        return this.m_encoding.isCharInEncoding(c);
    }

    public boolean isCodePointInEncoding(int n2) {
        if (this.m_encoding == null) {
            this.m_encoding = new EncodingImpl(this);
        }
        return this.m_encoding.isCodePointInEncoding(n2);
    }

    public byte[] getEncodedBytesForChar(char c) {
        if (this.m_encoding == null) {
            this.m_encoding = new EncodingImpl(this);
        }
        return this.m_encoding.getEncodedBytesForChar(c);
    }

    public boolean isSurrogatePairInEncoding(char c, char c2) {
        if (this.m_encoding == null) {
            this.m_encoding = new EncodingImpl(this);
        }
        return this.m_encoding.isSurrogatePairInEncoding(c, c2);
    }

    public byte[] getEncodedBytesForCodepoint(int n2, char c, char c2) {
        if (this.m_encoding == null) {
            this.m_encoding = new EncodingImpl(this);
        }
        return this.m_encoding.getEncodedBytesForCodepoint(n2, c, c2);
    }

    public EncodingInfo(String string2, String string3, boolean bl) {
        this.name = string2;
        this.javaName = string3;
        this.isStateless = bl;
    }

    private static byte[] inEncoding(int n2, String string2) {
        byte[] byArray;
        try {
            char[] cArray = new char[]{(char)n2};
            String string3 = new String(cArray);
            byte[] byArray2 = string3.getBytes(string2);
            boolean bl = EncodingInfo.inEncoding(n2, byArray2);
            byArray = (byte[])(bl ? byArray2 : null);
        }
        catch (Exception exception) {
            boolean bl = false;
            if (string2 == null) {
                bl = true;
                byArray = s_noBytes;
            }
            byArray = null;
        }
        return byArray;
    }

    private static byte[] getEncBytes(char c, char c2, String string2) {
        try {
            char[] cArray = new char[]{c, c2};
            String string3 = new String(cArray);
            byte[] byArray = string3.getBytes(string2);
            boolean bl = EncodingInfo.inEncoding((int)c, byArray);
            if (bl) {
                return byArray;
            }
            return null;
        }
        catch (Exception exception) {
            boolean bl = false;
            return null;
        }
    }

    private static boolean inEncoding(int n2, byte[] byArray) {
        boolean bl = byArray == null || byArray.length == 0 ? false : (byArray[0] == 0 ? false : byArray[0] != 63 || n2 == 63);
        return bl;
    }

    public final boolean isStatelessEncoding() {
        return this.isStateless;
    }

    static final class EncodingImpl
    implements InEncoding {
        private final EncodingInfo m_encoding;
        private final int m_first;
        private final int m_explFirst;
        private final int m_explLast;
        private final int m_last;
        private EncodingImpl m_before;
        private EncodingImpl m_after;
        private static final int RANGE = 128;
        private final boolean[] m_alreadyKnown = new boolean[128];
        private final byte[][] m_char2Bytes = new byte[128][];

        public boolean isCharInEncoding(char c) {
            byte[] byArray = this.getEncodedBytesForChar(c);
            return byArray != null;
        }

        public boolean isSurrogatePairInEncoding(char c, char c2) {
            int n2 = Encodings.toCodePoint(c, c2);
            byte[] byArray = this.getEncodedBytesForCodepoint(n2, c, c2);
            return byArray != null;
        }

        public final byte[] getEncodedBytes127(int n2) {
            return this.m_char2Bytes[n2];
        }

        public byte[] getEncodedBytesForChar(char c) {
            byte[] byArray;
            char c2 = c;
            if (c2 < this.m_explFirst) {
                if (this.m_before == null) {
                    this.m_before = new EncodingImpl(this.m_encoding, this.m_first, this.m_explFirst - 1, c2);
                }
                byArray = this.m_before.getEncodedBytesForChar(c);
            } else if (this.m_explLast < c2) {
                if (this.m_after == null) {
                    this.m_after = new EncodingImpl(this.m_encoding, this.m_explLast + 1, this.m_last, c2);
                }
                byArray = this.m_after.getEncodedBytesForChar(c);
            } else {
                int n2 = c2 - this.m_explFirst;
                if (this.m_alreadyKnown[n2]) {
                    byArray = this.m_char2Bytes[n2];
                } else {
                    byArray = EncodingInfo.inEncoding(c, this.m_encoding.javaName);
                    this.m_alreadyKnown[n2] = true;
                    this.m_char2Bytes[n2] = byArray;
                }
            }
            return byArray;
        }

        public byte[] getEncodedBytesForCodepoint(int n2, char c, char c2) {
            byte[] byArray;
            if (n2 < this.m_explFirst) {
                if (this.m_before == null) {
                    this.m_before = new EncodingImpl(this.m_encoding, this.m_first, this.m_explFirst - 1, n2);
                }
                byArray = this.m_before.getEncodedBytesForCodepoint(n2, c, c2);
            } else if (this.m_explLast < n2) {
                if (this.m_after == null) {
                    this.m_after = new EncodingImpl(this.m_encoding, this.m_explLast + 1, this.m_last, n2);
                }
                byArray = this.m_after.getEncodedBytesForCodepoint(n2, c, c2);
            } else {
                int n3 = n2 - this.m_explFirst;
                if (this.m_alreadyKnown[n3]) {
                    byArray = this.m_char2Bytes[n3];
                } else {
                    byArray = EncodingInfo.getEncBytes(c, c2, this.m_encoding.javaName);
                    this.m_alreadyKnown[n3] = true;
                    this.m_char2Bytes[n3] = byArray;
                }
            }
            return byArray;
        }

        EncodingImpl(EncodingInfo encodingInfo) {
            this(encodingInfo, 0, Integer.MAX_VALUE, 0);
        }

        private EncodingImpl(EncodingInfo encodingInfo, int n2, int n3, int n4) {
            char c;
            this.m_first = n2;
            this.m_last = n3;
            this.m_explFirst = n4;
            this.m_explLast = n4 + 127;
            this.m_encoding = encodingInfo;
            String string2 = encodingInfo.javaName;
            if (string2 != null && 0 <= this.m_explFirst && this.m_explFirst <= 127 && encodingInfo.isStatelessEncoding()) {
                int n5;
                if ("UTF8".equals(string2) || "UTF-16".equals(string2) || "ASCII".equals(string2) || "US-ASCII".equals(string2) || "Unicode".equals(string2) || "UNICODE".equals(string2) || string2.startsWith("ISO8859")) {
                    for (c = '\u0000'; c < '\u007f'; ++c) {
                        n5 = c - this.m_explFirst;
                        if (0 > n5 || n5 >= 128) continue;
                        this.m_alreadyKnown[n5] = true;
                        this.m_char2Bytes[n5] = new byte[]{(byte)c};
                    }
                } else {
                    for (c = '\u0000'; c < '\u007f'; c = (char)((char)(c + 1))) {
                        n5 = c - this.m_explFirst;
                        if (0 > n5 || n5 >= 128) continue;
                        this.m_char2Bytes[n5] = this.getEncodedBytesForChar(c);
                    }
                }
            }
            if (string2 == null) {
                for (c = '\u0000'; c < this.m_alreadyKnown.length; ++c) {
                    this.m_alreadyKnown[c] = true;
                    this.m_char2Bytes[c] = s_noBytes;
                }
            }
        }

        public boolean isCodePointInEncoding(int n2) {
            block4: {
                try {
                    if (Encodings.codePointHasSurrogatePair(n2)) {
                        int n3 = Encodings.getLowSurrogate(n2);
                        int n4 = Encodings.getHighSurrogate(n2);
                        if (n3 != -1 && n4 != -1) {
                            return this.isSurrogatePairInEncoding((char)n4, (char)n3);
                        }
                        break block4;
                    }
                    char c = (char)n2;
                    return this.isCharInEncoding(c);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            return false;
        }
    }

    private static interface InEncoding {
        public boolean isCharInEncoding(char var1);

        public boolean isSurrogatePairInEncoding(char var1, char var2);

        public boolean isCodePointInEncoding(int var1);

        public byte[] getEncodedBytesForChar(char var1);

        public byte[] getEncodedBytesForCodepoint(int var1, char var2, char var3);
    }
}

