/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xml.xci.serializer;

import com.ibm.xml.xci.serializer.StringToIntTable;

public final class ElemDesc {
    static final String IBM_COPYRIGHT = "Licensed Materials - Property of IBM\n\nXML Cursor Interface for Java (XCI-J)\u00a9 Copyright IBM Corp. 2004, 2008. All Rights Reserved.\n\nUS Government Users Restricted Rights - Use, duplication or disclosure \nrestricted by GSA ADP Schedule Contract with IBM Corp.";
    private int m_flags;
    private StringToIntTable m_attrs = null;
    static final int EMPTY = 2;
    private static final int FLOW = 4;
    static final int BLOCK = 8;
    static final int BLOCKFORM = 16;
    static final int BLOCKFORMFIELDSET = 32;
    private static final int CDATA = 64;
    private static final int PCDATA = 128;
    static final int RAW = 256;
    private static final int INLINE = 512;
    private static final int INLINEA = 1024;
    static final int INLINELABEL = 2048;
    static final int FONTSTYLE = 4096;
    static final int PHRASE = 8192;
    static final int FORMCTRL = 16384;
    static final int SPECIAL = 32768;
    static final int ASPECIAL = 65536;
    static final int HEADMISC = 131072;
    static final int HEAD = 262144;
    static final int LIST = 524288;
    static final int PREFORMATTED = 0x100000;
    static final int WHITESPACESENSITIVE = 0x200000;
    static final int HEADELEM = 0x400000;
    static final int HTMLELEM = 0x800000;
    public static final int ATTRURL = 2;
    public static final int ATTREMPTY = 4;

    ElemDesc(int n2) {
        this.m_flags = n2;
    }

    boolean is(int n2) {
        return (this.m_flags & n2) != 0;
    }

    int getFlags() {
        return this.m_flags;
    }

    void setAttr(String string2, int n2) {
        if (null == this.m_attrs) {
            this.m_attrs = new StringToIntTable();
        }
        this.m_attrs.put(string2, n2);
    }

    public boolean isAttrFlagSet(String string2, int n2) {
        return null != this.m_attrs ? (this.m_attrs.getIgnoreCase(string2) & n2) != 0 : false;
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("ElemDesc:\n");
        if (this.is(65536)) {
            stringBuilder.append("  ASPECIAL\n");
        }
        if (this.is(4)) {
            stringBuilder.append("  ATTREMPTY\n");
        }
        if (this.is(2)) {
            stringBuilder.append("  ATTRURL\n");
        }
        if (this.is(8)) {
            stringBuilder.append("  BLOCK\n");
        }
        if (this.is(16)) {
            stringBuilder.append("  BLOCKFORM\n");
        }
        if (this.is(32)) {
            stringBuilder.append("  BLOCKFORMFIELDSET\n");
        }
        if (this.is(64)) {
            stringBuilder.append("  CDATA\n");
        }
        if (this.is(2)) {
            stringBuilder.append("  EMPTY\n");
        }
        if (this.is(4)) {
            stringBuilder.append("  FLOW\n");
        }
        if (this.is(4096)) {
            stringBuilder.append("  FONTSTYLE\n");
        }
        if (this.is(16384)) {
            stringBuilder.append("  FORMCTRL\n");
        }
        if (this.is(262144)) {
            stringBuilder.append("  \n");
        }
        if (this.is(0x400000)) {
            stringBuilder.append("  HEAD\n");
        }
        if (this.is(131072)) {
            stringBuilder.append("  HEADMISC\n");
        }
        if (this.is(0x800000)) {
            stringBuilder.append("  HEADELEM\n");
        }
        if (this.is(512)) {
            stringBuilder.append("  INLINE\n");
        }
        if (this.is(1024)) {
            stringBuilder.append("  INLINEA\n");
        }
        if (this.is(2048)) {
            stringBuilder.append("  \n");
        }
        if (this.is(524288)) {
            stringBuilder.append("  INLINELABEL\n");
        }
        if (this.is(128)) {
            stringBuilder.append("  PCDATA\n");
        }
        if (this.is(8192)) {
            stringBuilder.append("  PHRASE\n");
        }
        if (this.is(0x100000)) {
            stringBuilder.append("  PREFORMATTED\n");
        }
        if (this.is(256)) {
            stringBuilder.append("  RAW\n");
        }
        if (this.is(32768)) {
            stringBuilder.append("  SPECIAL\n");
        }
        if (this.is(0x200000)) {
            stringBuilder.append("  WHITESPACESENSITIVE\n");
        }
        return stringBuilder.toString();
    }
}

