/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xml.xci.serializer;

import com.ibm.xml.xci.VolatileCData;
import com.ibm.xml.xci.serializer.HtmlElemInfo;
import com.ibm.xml.xci.serializer.RawQName;

public final class ElemContext {
    static final String IBM_COPYRIGHT = "Licensed Materials - Property of IBM\n\nXML Cursor Interface for Java (XCI-J)\u00a9 Copyright IBM Corp. 2004, 2009. All Rights Reserved.\n\nUS Government Users Restricted Rights - Use, duplication or disclosure\nrestricted by GSA ADP Schedule Contract with IBM Corp.";
    private final int m_currentElemDepth;
    private int m_firstNamespaceNode;
    private int m_lastNamespaceNode;
    private HtmlElemInfo.ElemDesc m_elementDesc = null;
    private String m_elementPrefix = null;
    private String m_elementLocalName = null;
    private String m_elementName = null;
    private String m_elementURI = null;
    private RawQName m_rawQName;
    private boolean m_isCdataSection = false;
    private boolean m_isInline = false;
    private boolean m_isRaw = false;
    private ElemContext m_next;
    private final ElemContext m_prev;
    private VolatileCData m_qname;
    public static final int STATE_NOTHING = -1;
    public static final int STATE_START_DOCUMENT = 0;
    public static final int STATE_IN_START_TAG = 1;
    public static final int STATE_IN_NAMESPACES = 2;
    public static final int STATE_IN_ATTRIBUTES = 3;
    public static final int STATE_IN_CONTENT = 4;
    public static final int STATE_IN_TEXT_CONTENT = 5;
    public static final int STATE_END_DOCUMENT = 6;
    private int fState;

    ElemContext() {
        this.m_prev = this;
        this.m_currentElemDepth = 0;
        this.set_STATE(-1);
    }

    private ElemContext(ElemContext elemContext) {
        this.m_prev = elemContext;
        this.m_currentElemDepth = elemContext.get_elemDepth() + 1;
    }

    final ElemContext pop() {
        return this.m_prev;
    }

    final ElemContext push() {
        ElemContext elemContext = this.m_next;
        if (elemContext == null) {
            this.m_next = elemContext = new ElemContext(this);
        }
        elemContext.set_STATE(1);
        return elemContext;
    }

    final ElemContext push(String string2, String string3, String string4) {
        ElemContext elemContext = this.m_next;
        if (elemContext == null) {
            this.m_next = elemContext = new ElemContext(this);
        } else {
            elemContext.set_isCdataSection(false);
            elemContext.setElementDesc(null);
        }
        elemContext.set_elemName(string4);
        elemContext.set_elemLocalName(string3);
        elemContext.set_elemURI(string2);
        elemContext.set_isInline(false);
        elemContext.set_firstNamespaceNode(-1);
        elemContext.set_lastNamespaceNode(-1);
        elemContext.set_STATE(1);
        return elemContext;
    }

    public final void setElementValues(String string2, String string3, String string4, String string5) {
        this.m_elementPrefix = string2;
        this.set_elemLocalName(string3);
        this.set_elemURI(string4);
        this.set_elemName(string5);
    }

    public final void setElementValues(String string2, RawQName rawQName) {
        this.m_elementURI = string2;
        this.m_rawQName = rawQName;
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("depth     : " + this.get_elemDepth() + '\n');
        stringBuilder.append("state     : ");
        switch (this.fState) {
            case -1: {
                stringBuilder.append("STATE_NOTHING\n");
                break;
            }
            case 0: {
                stringBuilder.append("STATE_NOTHING\n");
                break;
            }
            case 1: {
                stringBuilder.append("STATE_IN_START_TAG\n");
                break;
            }
            case 2: {
                stringBuilder.append("STATE_IN_NAMESPACES\n");
                break;
            }
            case 3: {
                stringBuilder.append("STATE_IN_ATTRIBUTES\n");
                break;
            }
            case 4: {
                stringBuilder.append("STATE_IN_CONTENT\n");
                break;
            }
            case 5: {
                stringBuilder.append("STATE_IN_TEXT_CONTENT\n");
                break;
            }
            case 6: {
                stringBuilder.append("STATE_END_DOCUMENT\n");
                break;
            }
            default: {
                stringBuilder.append("*** ERROR IN VALUE ***\n");
            }
        }
        stringBuilder.append("name      : " + this.get_elemName() + '\n');
        stringBuilder.append("local name: " + this.get_elemLocalName() + '\n');
        stringBuilder.append("prefix    : \"" + this.get_elemPrefix() + "\"\n");
        stringBuilder.append("uri       : " + this.get_elemURI() + '\n');
        stringBuilder.append("ElemDesc  :\n");
        if (this.getElementDesc() != null) {
            stringBuilder.append(this.getElementDesc().toString());
        }
        return stringBuilder.toString();
    }

    private void set_firstNamespaceNode(int n2) {
        this.m_firstNamespaceNode = n2;
    }

    public int get_firstNamespaceNode() {
        return this.m_firstNamespaceNode;
    }

    private void set_lastNamespaceNode(int n2) {
        this.m_lastNamespaceNode = n2;
    }

    public int get_lastNamespaceNode() {
        return this.m_lastNamespaceNode;
    }

    public void addNamespaceNode(int n2) {
        int n3 = this.get_firstNamespaceNode();
        if (n3 == -1) {
            this.set_firstNamespaceNode(n2);
        }
        this.set_lastNamespaceNode(n2);
    }

    public int get_elemDepth() {
        return this.m_currentElemDepth;
    }

    public void set_elemLocalName(String string2) {
        this.m_elementLocalName = string2;
    }

    public String get_elemLocalName() {
        return this.m_elementLocalName;
    }

    public String get_elemPrefix() {
        return this.m_elementPrefix;
    }

    void set_elemName(String string2) {
        this.m_elementName = string2;
    }

    public String get_elemName() {
        return this.m_elementName;
    }

    void set_elemURI(String string2) {
        this.m_elementURI = string2;
    }

    void set_elemPrefix(String string2) {
        this.m_elementPrefix = string2;
    }

    public String get_elemURI() {
        return this.m_elementURI;
    }

    public void setElementDesc(HtmlElemInfo.ElemDesc elemDesc) {
        this.m_elementDesc = elemDesc;
    }

    public HtmlElemInfo.ElemDesc getElementDesc() {
        return this.m_elementDesc;
    }

    void set_volatileCDataQName(VolatileCData volatileCData) {
        this.m_qname = volatileCData;
    }

    public VolatileCData get_volatileCDataQName() {
        return this.m_qname;
    }

    public void set_isCdataSection(boolean bl) {
        this.m_isCdataSection = bl;
    }

    public boolean is_CdataSection() {
        return this.isCdataSection();
    }

    public void set_isInline(boolean bl) {
        this.m_isInline = bl;
    }

    public boolean is_Inline() {
        return this.m_isInline;
    }

    public void set_isRaw(boolean bl) {
        this.m_isRaw = bl;
    }

    public boolean isRaw() {
        return this.m_isRaw;
    }

    public boolean isCdataSection() {
        return this.m_isCdataSection;
    }

    int get_STATE() {
        return this.fState;
    }

    void set_STATE(int n2) {
        this.fState = n2;
    }

    public static final boolean mayAddElemAttr(int n2) {
        return n2 == 1 || n2 == 3 || n2 == 2;
    }

    public static final boolean mayAddNamespaceNode(int n2) {
        return n2 == 1 || n2 == 2;
    }

    public RawQName geRawQName() {
        return this.m_rawQName;
    }
}

