/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xml.xci.serializer;

import com.ibm.xml.xci.Cursor;
import com.ibm.xml.xci.RequestInfo;
import com.ibm.xml.xci.VolatileCData;
import com.ibm.xml.xci.dp.base.AbstractCursor;
import com.ibm.xml.xci.dp.util.copy.Copier;
import com.ibm.xml.xci.dp.util.copy.ItemCopier;
import com.ibm.xml.xci.serializer.CachedItem;
import com.ibm.xml.xci.serializer.SerializeCopier;
import com.ibm.xml.xci.serializer.SerializeCopierMeta;
import com.ibm.xml.xci.serializer.SerializeParam;
import com.ibm.xml.xci.serializer.SerializeParamValue;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.xml.namespace.QName;
import javax.xml.transform.Result;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CopierExtended {
    static final String IBM_COPYRIGHT = "Licensed Materials - Property of IBM\n\nXML Cursor Interface for Java (XCI-J)\u00a9 Copyright IBM Corp. 2004, 2009. All Rights Reserved.\n\nUS Government Users Restricted Rights - Use, duplication or disclosure \nrestricted by GSA ADP Schedule Contract with IBM Corp.";
    public static final int METHOD_PROCESSED = 3;
    public static final int NODE_PROCESSED = 4;
    public static final int SUBTREE_PROCESSED = 5;
    public static final int SEQUENCE_PROCESSED = 6;

    public static void serialize(Cursor cursor2, Result result2, Map<String, Object> map2) {
        CopierExtended.serialize(cursor2, result2, map2, Cursor.Area.FIRST_CHILD);
    }

    public static void serialize(Cursor cursor2, Result result2, Map<String, Object> map2, Cursor.Area area) {
        CopierExtended.serialize(cursor2, result2, map2, area, 17);
    }

    public static void serialize(Cursor cursor2, Result result2, Map<String, Object> map2, Cursor.Area area, int n2) {
        CopierExtended.serialize(cursor2, result2, map2, area, n2, null);
    }

    public static void serialize(Cursor cursor2, Result result2, Map<String, Object> map2, Cursor.Area area, int n2, ItemCopier itemCopier) {
        if (cursor2 != null) {
            String string2 = CopierExtended.getMethod(map2);
            if (string2 != null) {
                CopierExtended.serialize(cursor2, result2, map2, area, n2, itemCopier, string2);
            } else {
                CopierExtended.serializeExtended(cursor2, result2, map2, area, n2, itemCopier);
            }
        }
    }

    private static void serialize(Cursor cursor2, Result result2, Map<String, Object> map2, Cursor.Area area, int n2, ItemCopier itemCopier, String string2) {
        if (CopierExtended.toIncludeContentType(string2, map2)) {
            SerializeCopierMeta.copy(cursor2, cursor2.factory().document(result2, new RequestInfo(Copier.targetProfile(Cursor.Area.FIRST_CHILD, itemCopier), 0, null, map2)), area, n2, itemCopier, string2.equals("xhtml"));
        } else {
            SerializeCopier.copy(cursor2, cursor2.factory().document(result2, new RequestInfo(Copier.targetProfile(Cursor.Area.FIRST_CHILD, itemCopier), 0, null, map2)), area, n2, itemCopier);
        }
    }

    private static void serializeExtended(Cursor cursor2, Result result2, Map<String, Object> map2, Cursor.Area area, int n2, ItemCopier itemCopier) {
        boolean bl;
        Object object2 = map2.get(SerializeParam.BACKWARDS_COMPATIBLE);
        ArrayList<CachedItem> arrayList = new ArrayList<CachedItem>();
        int[] nArray = new int[]{3};
        Cursor cursor3 = CopierExtended.processOutputMethod(cursor2, map2, area, arrayList, Boolean.TRUE.equals(object2), nArray);
        boolean bl2 = bl = arrayList.size() == 0;
        if (!bl) {
            map2.put("{http://ibm.com/xml/xci/serializer}cached-data", arrayList);
        }
        if (nArray[0] == 6) {
            CopierExtended.copySpecial(cursor2, cursor2.factory().document(result2, new RequestInfo(Copier.targetProfile(Cursor.Area.FIRST_CHILD, itemCopier), 0, null, map2)), area, n2, itemCopier);
            return;
        }
        String string2 = CopierExtended.getMethod(map2);
        if (cursor3 == null) {
            CopierExtended.serialize(cursor2, result2, map2, bl ? area : Cursor.Area.FOLLOWING_SIBLING, n2, itemCopier, string2);
        } else {
            CopierExtended.serialize(cursor2, cursor3, result2, map2, bl ? area : Cursor.Area.FOLLOWING_SIBLING, n2, itemCopier, string2);
        }
    }

    private static void serialize(Cursor cursor2, Cursor cursor3, Result result2, Map<String, Object> map2, Cursor.Area area, int n2, ItemCopier itemCopier, String string2) {
        if (CopierExtended.toIncludeContentType(string2, map2)) {
            SerializeCopierMeta.copy(cursor2, cursor3, cursor2.factory().document(result2, new RequestInfo(Copier.targetProfile(Cursor.Area.FIRST_CHILD, itemCopier), 0, null, map2)), area, n2, itemCopier, string2.equals("xhtml"));
        } else {
            SerializeCopier.copy(cursor2, cursor3, cursor2.factory().document(result2, new RequestInfo(Copier.targetProfile(Cursor.Area.FIRST_CHILD, itemCopier), 0, null, map2)), area, n2, itemCopier);
        }
    }

    private static Cursor processOutputMethod(Cursor cursor2, Map<String, Object> map2, Cursor.Area area, List<CachedItem> list, boolean bl, int[] nArray) {
        boolean[] blArray = new boolean[]{true};
        Cursor cursor3 = null;
        do {
            int n2;
            if (cursor2.itemKind() == 9) {
                cursor3 = cursor2.fork(true);
                if (cursor3.toChildren(null)) {
                    n2 = CopierExtended.processSequenceContent(cursor3, map2, area, list, bl, blArray);
                    if (n2 == 3) {
                        return cursor3;
                    }
                    area = Cursor.Area.FOLLOWING_SIBLING;
                }
                cursor3.release();
                cursor3 = null;
                continue;
            }
            n2 = CopierExtended.processNode(cursor2, map2, area, list, bl, blArray);
            if (n2 == 3) {
                return null;
            }
            area = Cursor.Area.FOLLOWING_SIBLING;
        } while (cursor2.toNext());
        map2.put("method", "xml");
        nArray[0] = 6;
        return null;
    }

    protected static void copySpecial(Cursor cursor2, Cursor cursor3, Cursor.Area area, int n2, ItemCopier itemCopier) {
        assert (Copier.SOURCE_FEATURES.containedIn(cursor2.profile())) : "Insufficient source features for copy!";
        assert (cursor3 != null) : "Cannot copy into empty target sequence, only document and element parents!";
        assert (Copier.TARGET_FEATURES.containedIn(cursor3.profile())) : "Insufficient target features for copy!";
        boolean bl = cursor3.openMutation(Cursor.Area.SUBTREE);
        if (bl) {
            cursor3.closeMutation();
        }
        if ((n2 & 1) != 0) {
            cursor2.release();
        }
        if ((n2 & 0x10) != 0) {
            cursor3.release();
        }
    }

    protected static boolean toIncludeContentType(String string2, Map<String, Object> map2) {
        Object object2;
        return !(!string2.equals("html") && !string2.equals("xhtml") || (object2 = map2.get("include-content-type")) != null && !Boolean.TRUE.equals(object2));
    }

    private static String getMethod(Map<String, Object> map2) {
        Object object2 = map2.get("method");
        if (object2 == null) {
            return null;
        }
        String string2 = null;
        if (object2 instanceof QName) {
            QName qName = (QName)object2;
            if (qName == SerializeParamValue.METHOD_XML) {
                return "xml";
            }
            if (qName == SerializeParamValue.METHOD_HTML) {
                return "html";
            }
            if (qName == SerializeParamValue.METHOD_XHTML) {
                return "xhtml";
            }
            if (qName == SerializeParamValue.METHOD_TEXT) {
                return "text";
            }
            string2 = qName.getLocalPart();
        } else if (object2 instanceof String) {
            string2 = (String)object2;
        }
        if ("xml".equals(string2)) {
            return "xml";
        }
        if ("html".equals(string2)) {
            return "html";
        }
        if (SerializeParamValue.METHOD_XHTML.toString().equals(string2) || "xhtml".equals(string2)) {
            return "xhtml";
        }
        if ("text".equals(string2)) {
            return "text";
        }
        return "xml";
    }

    private static int processSequenceContent(Cursor cursor2, Map<String, Object> map2, Cursor.Area area, List<CachedItem> list, boolean bl, boolean[] blArray) {
        int n2 = CopierExtended.processNode(cursor2, map2, area, list, bl, blArray);
        if (n2 == 3) {
            return 3;
        }
        while (cursor2.toNext()) {
            n2 = CopierExtended.processNode(cursor2, map2, Cursor.Area.FOLLOWING_SIBLING, list, bl, blArray);
            if (n2 != 3) continue;
            return 3;
        }
        map2.put("method", "xml");
        return 5;
    }

    private static int processNode(Cursor cursor2, Map<String, Object> map2, Cursor.Area area, List<CachedItem> list, boolean bl, boolean[] blArray) {
        switch (cursor2.itemKind()) {
            case 1: {
                CopierExtended.processElement(cursor2.itemName(), map2, bl, blArray);
                return 3;
            }
            case 3: {
                Cursor cursor3 = cursor2.unwrap();
                VolatileCData volatileCData = cursor3 != null && cursor3 instanceof AbstractCursor ? ((AbstractCursor)cursor3).itemValue() : cursor2.itemTypedValue();
                if (blArray[0]) {
                    blArray[0] = volatileCData.isSpace();
                }
                CopierExtended.processItemData((short)3, area, volatileCData, list);
                break;
            }
            case 8: {
                CopierExtended.processItemData((short)8, area, cursor2.itemStringValue(), list);
                break;
            }
            case 7: {
                CopierExtended.processItemData((short)7, area, cursor2.itemName(), cursor2.itemStringValue(), list);
                break;
            }
            case 2: 
            case 4: {
                map2.put("method", "xml");
                return 3;
            }
            default: {
                assert (false) : "Invalid focus kind:" + cursor2.itemKind();
                break;
            }
        }
        return 4;
    }

    private static void processElement(VolatileCData volatileCData, Map<String, Object> map2, boolean bl, boolean[] blArray) {
        if (blArray[0]) {
            String string2 = volatileCData.getQNameNamespaceURI(1);
            String string3 = volatileCData.getQNameLocalPart(1);
            if ((string2 == null || string2.length() == 0) && string3.equalsIgnoreCase("html")) {
                map2.put("method", "html");
            } else if (!bl && string2.equals("http://www.w3.org/1999/xhtml") && string3.equals("html")) {
                map2.put("method", "xhtml");
            } else {
                map2.put("method", "xml");
            }
        } else {
            map2.put("method", "xml");
        }
    }

    private static void processItemData(short s, Cursor.Area area, VolatileCData volatileCData, List<CachedItem> list) {
        ArrayList<VolatileCData> arrayList = new ArrayList<VolatileCData>(1);
        arrayList.add(volatileCData.constant(false));
        CachedItem cachedItem = new CachedItem(s, area, arrayList);
        list.add(cachedItem);
    }

    private static void processItemData(short s, Cursor.Area area, VolatileCData volatileCData, VolatileCData volatileCData2, List<CachedItem> list) {
        ArrayList<VolatileCData> arrayList = new ArrayList<VolatileCData>(2);
        arrayList.add(volatileCData.constant(false));
        arrayList.add(volatileCData2.constant(false));
        CachedItem cachedItem = new CachedItem(s, area, arrayList);
        list.add(cachedItem);
    }
}

