/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xml.xci.serializer;

import com.ibm.xml.xci.serializer.Int2StringHashMap;

final class CodepointMappings {
    static final String IBM_COPYRIGHT = "Licensed Materials - Property of IBM\n\nXML Cursor Interface for Java (XCI-J)\u00a9 Copyright IBM Corp. 2004, 2009. All Rights Reserved.\n\nUS Government Users Restricted Rights - Use, duplication or disclosure\nrestricted by GSA ADP Schedule Contract with IBM Corp.";
    private boolean m_hasMappings = false;
    private final Int2StringHashMap m_codepointToString;
    private int m_low = -1;
    private int m_high = -1;
    static final int ASCII_MAX = 127;
    private final String[] m_ASCIIMapped = new String[128];

    public CodepointMappings() {
        this.m_codepointToString = new Int2StringHashMap(256);
    }

    String getString(int n2) {
        if (n2 < this.m_low || n2 > this.m_high) {
            return null;
        }
        if (n2 <= 127) {
            return this.m_ASCIIMapped[n2];
        }
        return this.m_codepointToString.get(n2);
    }

    public void setString(int n2, String string2) {
        if (n2 <= 127) {
            this.m_ASCIIMapped[n2] = string2;
        } else {
            this.m_codepointToString.put(n2, string2);
        }
        if (this.m_low == -1 && this.m_high == -1) {
            this.m_low = this.m_high = n2;
        } else if (n2 > this.m_high) {
            this.m_high = n2;
        } else if (n2 < this.m_low) {
            this.m_low = n2;
        }
        this.m_hasMappings = true;
    }

    public boolean hasMappings() {
        return this.m_hasMappings;
    }

    public void reset() {
        for (int i = 0; i <= 127; ++i) {
            this.m_ASCIIMapped[i] = null;
        }
        this.m_codepointToString.clear();
        this.m_hasMappings = false;
        this.m_high = -1;
        this.m_low = -1;
    }
}

