/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xml.xci.serializer;

import com.ibm.xml.xci.CData;
import com.ibm.xml.xci.Cursor;
import com.ibm.xml.xci.CursorFactory;
import com.ibm.xml.xci.NodeTest;
import com.ibm.xml.xci.VolatileCData;
import com.ibm.xml.xci.dp.values.chars.CharBufferChars;
import com.ibm.xml.xci.dp.values.chars.Chars;
import com.ibm.xml.xci.serializer.AbstractSerializeCommon;
import com.ibm.xml.xci.serializer.CodepointMappings;
import com.ibm.xml.xci.serializer.ElemContext;
import com.ibm.xml.xci.serializer.EncodingInfo;
import com.ibm.xml.xci.serializer.Encodings;
import com.ibm.xml.xci.serializer.GetCursorExtensionsInterface;
import com.ibm.xml.xci.serializer.HiddenOptions;
import com.ibm.xml.xci.serializer.Messages;
import com.ibm.xml.xci.serializer.NamespaceMappings;
import com.ibm.xml.xci.serializer.SecuritySupport;
import com.ibm.xml.xci.serializer.SerializeParam;
import com.ibm.xml.xci.serializer.SerializeParamValue;
import com.ibm.xml.xci.serializer.UnicodeNormalizer;
import com.ibm.xml.xci.serializer.UnicodeNormalizerFactory;
import com.ibm.xml.xci.serializer.WriterCache;
import com.ibm.xml.xci.serializer.WriterOptimized;
import com.ibm.xml.xci.serializer.WriterStateless;
import com.ibm.xml.xci.serializer.WriterToASCI;
import com.ibm.xml.xci.serializer.WriterToUTF8Buffered;
import com.ibm.xml.xml4j.api.s1.xs.XSTypeDefinition;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.StringWriter;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import javax.xml.namespace.QName;
import javax.xml.transform.SourceLocator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
abstract class AbstractStreamCursor
extends AbstractSerializeCommon
implements Cursor,
GetCursorExtensionsInterface {
    static final String IBM_COPYRIGHT = "Licensed Materials - Property of IBM\n\nXML Cursor Interface for Java (XCI-J)\u00a9 Copyright IBM Corp. 2008, 2009. All Rights Reserved.\n\nUS Government Users Restricted Rights - Use, duplication or disclosure \nrestricted by GSA ADP Schedule Contract with IBM Corp.";
    public static final boolean XMLStreamCursor;
    public static final boolean SERIALIZE_ERR_TRACE;
    private static final boolean s_supportYesNo = true;
    protected final Map<SerializeParam, Object> m_OutputProps;
    protected ArrayList<QName> m_cdataElements = null;
    private CodepointMappings m_codePointMappings;
    protected boolean m_isInlineElem = false;
    protected boolean toUndeclarePrefixes = false;
    protected boolean m_isFirstRoot;
    protected boolean m_isASCIIEncoding;
    protected static final String EMPTY_STRING;
    private static final char[] XMLNS_PREFIX;
    static final char[] SLASH_BRACKET;
    protected static final char[] SPACE_SLASH_BRACKET;
    private static final char[] BRACKET_SLASH;
    protected static final char[] XMLNS;
    protected static final String CDATA_SECTION_START;
    protected static final String CDATA_SECTION_END;
    private static final char[] LESSTHAN_QUESTIONMARK;
    private static final char[] QUESTIONMARK_GREATERTHAN;
    private static final char[] COMMENT_START;
    private static final char[] COMMENT_END;
    private static final char[] XMLNS_COLON;
    private static final char[] EQUALS_DOUBLEQUOTE;
    static final String XML_HEADER_VERSION_STRING;
    static final byte[] XML_HEADER_VERSION_BYTES;
    static final char[] XML_HEADER_VERSION_CHARS;
    static final String XML_HEADER_ENCODING_STRING;
    static final byte[] XML_HEADER_ENCODING_BYTES;
    static final char[] XML_HEADER_ENCODING_CHARS;
    static final String XML_HEADER_END_STRING;
    static final byte[] XML_HEADER_END_BYTES;
    static final char[] XML_HEADER_END_CHARS;
    static final char DOUBLE_QUOTE_CHAR;
    static final char SPACE_CHAR;
    static final char EQUALS_CHAR;
    static final char LESSTHAN_CHAR;
    static final char GREATERTHAN_CHAR;
    static final char COLON_CHAR;
    static final byte DOUBLE_QUOTE_BYTE;
    static final char[] DOUBLE_QUOTE_CHARS;
    static final char[] LESSTHAN_QUESTION_CHARS;
    static final char[] QUESTION_GREATERTHAN_CHARS;
    protected static final short CHAR_ESCAPE_MAP_ELEMENT_ID = 0;
    protected static final short CHAR_ESCAPE_MAP_ATTRIBUTE_ID = 1;
    protected static final short CHAR_ESCAPE_MAP_PI_ID = 2;
    protected static final short CHAR_ESCAPE_MAP_COMMENT_ID = 3;
    protected static final short CHAR_ESCAPE_MAP_NAMESPACE_ID = 4;
    private static final byte[] CHARACTERS_CHAR_ESCAPE_MAP;
    private static final byte[] CHARACTERS_CHAR_ESCAPE_MAP_ASCII;
    private static final byte[] ATTRIBUTE_CHAR_ESCAPE_MAP;
    private static final byte[] ATTRIBUTE_CHAR_ESCAPE_MAP_ASCII;
    private static final byte[] NAMESPACE_CHAR_ESCAPE_MAP;
    private static final byte[] NAMESPACE_CHAR_ESCAPE_MAP_ASCII;
    private static final byte[] PI_CHAR_ESCAPE_MAP;
    private static final byte[] PI_CHAR_ESCAPE_MAP_ASCII;
    private static final byte[] COMMENT_CHAR_ESCAPE_MAP;
    private static final byte[] COMMENT_CHAR_ESCAPE_MAP_ASCII;
    boolean m_openMutationCalled = false;
    protected boolean m_wasJustReset;
    protected Writer m_writer = null;
    protected OutputStream m_outputStream;
    private CursorFactory m_factory;
    protected int m_normalizerMode = 1;
    protected UnicodeNormalizer m_unicodeNormalizer = null;
    protected boolean m_isUTF8 = false;
    WriterOptimized m_writerOptimized;
    private boolean m_writer_set_by_user;
    protected EncodingInfo m_encodingInfo = new EncodingInfo(null, null, true);
    private String m_resultDocAbsoluteURI;
    private SourceLocator m_sourceLocator;
    protected boolean m_needTowriteDOCTYPE;
    private boolean m_startNewLine;
    private static final String XMLVERSION11 = "1.1";
    private static final String XMLVERSION10 = "1.0";
    private boolean m_shouldNotWriteXMLHeader;
    private String m_standalone;
    protected boolean m_doIndent;
    protected String m_doctypeSystem;
    protected String m_doctypePublic;
    private static final char[] s_systemLineSep;
    char[] m_indentLineSep = (char[])s_systemLineSep.clone();
    private final boolean m_lineSepUse = true;
    protected int m_indentLineSepLen = this.m_indentLineSep.length;
    protected char m_indentChar = (char)32;
    protected String m_version = null;
    protected boolean m_isXML11 = false;
    final boolean strict = false;

    AbstractStreamCursor(CursorFactory cursorFactory, OutputStream outputStream, Map<SerializeParam, Object> map2) {
        super(cursorFactory);
        this.m_OutputProps = map2;
        this.m_outputStream = outputStream;
        this.m_factory = cursorFactory;
        this.processSerializationParams(map2);
    }

    AbstractStreamCursor(CursorFactory cursorFactory, Writer writer, Map<SerializeParam, Object> map2) {
        super(cursorFactory, null);
        this.m_OutputProps = map2;
        this.setWriter(writer);
        this.m_factory = cursorFactory;
        this.processSerializationParams(map2);
    }

    private void processSerializationParams(Map map2) {
        if (map2 != null) {
            List list;
            int n2;
            Object v = map2.get("cdata-section-elements");
            if (v instanceof ArrayList) {
                this.m_cdataElements = (ArrayList)v;
            }
            v = map2.get("undeclare-prefixes");
            this.toUndeclarePrefixes = Boolean.TRUE.equals(v);
            v = map2.get("use-character-maps");
            if (v instanceof List && (n2 = (list = (List)v).size()) > 0) {
                this.m_codePointMappings = new CodepointMappings();
                for (int i = 0; i < n2; i += 2) {
                    this.m_codePointMappings.setString(((String)list.get(i)).charAt(0), (String)list.get(i + 1));
                }
            }
        }
    }

    protected boolean checkForCDataSectionElements() {
        return this.m_cdataElements != null;
    }

    protected boolean isCDataSectionElement(String string2, String string3) {
        int n2 = this.m_cdataElements.size();
        for (int i = 0; i < n2; ++i) {
            QName qName = this.m_cdataElements.get(i);
            if (!qName.getLocalPart().equals(string3) || !qName.getNamespaceURI().equals(string2)) continue;
            return true;
        }
        return false;
    }

    @Override
    public final void addAttribute(VolatileCData volatileCData, VolatileCData volatileCData2) {
        if (XMLStreamCursor) {
            this.dbgTrace(".addAttribute('" + this.dbgGetQName(volatileCData) + "','" + this.dbgGetValue(volatileCData2) + "'); called");
        }
        try {
            if (!this.mayAddElemAttr()) {
                String string2 = Messages.createMessage2("ER_SER_ATTR_NAMESPACE", null);
                Messages.xciDynamicErrorException(string2);
            }
            if (this.mayAddNamespaceNode()) {
                this.privateElemStart();
                this.m_elemContext.set_STATE(3);
            }
            this.writeAttribute(this.mayAddElemAttr(), volatileCData, volatileCData2);
        }
        catch (IOException iOException) {
            Messages.xciDynamicErrorException(iOException);
        }
    }

    public final boolean processAttrNamespace(VolatileCData volatileCData) throws IOException {
        String string2 = volatileCData.getQNameNamespaceURI(1);
        String string3 = null;
        int n2 = -1;
        if (!(string2 != null && string2.length() != 0 || (string3 = volatileCData.getQNamePrefix(1)) != null && string3.length() != 0 || (n2 = this.toHandle(string2)) != -1)) {
            return false;
        }
        if (this.toHandle(string2) == -1) {
            if (string3 == null) {
                string3 = volatileCData.getQNamePrefix(1);
            }
            this.declareNS(string2, string3, true);
            return true;
        }
        return false;
    }

    @Override
    public void addComment(Cursor.Area area, VolatileCData volatileCData) {
        if (XMLStreamCursor) {
            this.dbgTrace(".addComment('" + this.dbgGetValue(volatileCData) + "'); called");
        }
        try {
            this.ensureContentState(area);
            this.writeComment(volatileCData);
        }
        catch (IOException iOException) {
            throw new AssertionError((Object)iOException);
        }
    }

    void writeoutDOCTYPE(String string2) throws IOException {
        String string3 = this.getDoctypeSystem();
        if (null == string3) {
            return;
        }
        Writer writer = this.m_writer;
        writer.write("<!DOCTYPE ");
        writer.write(string2);
        String string4 = this.getDoctypePublic();
        if (null != string4) {
            writer.write(" PUBLIC \"");
            writer.write(string4);
            writer.write("\" \"");
        } else {
            writer.write(" SYSTEM \"");
        }
        writer.write(string3);
        writer.write("\">");
        writer.write(this.m_indentLineSep, 0, this.m_indentLineSepLen);
    }

    @Override
    public void addElement(Cursor.Area area, VolatileCData volatileCData, XSTypeDefinition xSTypeDefinition) {
        if (XMLStreamCursor) {
            this.dbgTrace(".addElement('" + this.dbgGetQName(volatileCData) + "'); called");
        }
        try {
            String string2;
            if (this.m_needTowriteDOCTYPE) {
                this.writeoutDOCTYPE(volatileCData.toString());
                this.m_needTowriteDOCTYPE = false;
            }
            this.ensureContentState(area);
            if (this.m_elemContext.get_elemDepth() == 0) {
                if (this.m_isFirstRoot) {
                    if (this.standaloneApplicable() || this.getDoctypeSystem() != null) {
                        if (SERIALIZE_ERR_TRACE) {
                            System.err.println("addElement - content of m_writer");
                            System.err.println(this.m_writer.toString());
                            System.err.println("addElement - element name: " + volatileCData.toString());
                        }
                        string2 = Messages.createMessage2("ER_SER_ROOT_MULTIPLE_ELEMENT_TEXT_CHILDREN", null);
                        Messages.xciDynamicErrorException(string2);
                    }
                } else {
                    this.m_isFirstRoot = true;
                }
            }
            this.m_elemContext.set_STATE(4);
            this.pushNamespaceContext();
            this.m_elemContext.set_STATE(1);
            string2 = volatileCData.getQNamePrefix(1);
            if (string2 == null) {
                string2 = "";
            }
            String string3 = volatileCData.getQNameLocalPart(1);
            assert (string3.indexOf(58) < 0);
            String string4 = volatileCData.getQNameNamespaceURI(1);
            String string5 = volatileCData.getString(1);
            this.m_elemContext.setElementValues(string2, string3, string4, string5);
            if (this.checkForCDataSectionElements()) {
                this.m_elemContext.set_isCdataSection(this.isCDataSectionElement(string4, string3));
            }
            this.m_elemContext.set_STATE(1);
        }
        catch (IOException iOException) {
            Messages.xciDynamicErrorException(iOException);
        }
    }

    @Override
    public final void addNamespaceNode(Chars chars, Chars chars2, boolean bl) {
        String string2;
        String string3;
        if (!this.mayAddElemAttr()) {
            string3 = Messages.createMessage2("ER_SER_ATTR_NAMESPACE", null);
            Messages.xciDynamicErrorException(string3);
        }
        string3 = ((Object)chars2).toString();
        String string4 = string2 = chars == null ? "" : ((Object)chars).toString();
        if (string2.length() == 0 || string3.length() > 0 || this.toUndeclarePrefixes) {
            NamespaceMappings.MappingRecord mappingRecord = this.lookupPrefix(string2);
            if (mappingRecord != null && mappingRecord.get_uri().equals(string3)) {
                return;
            }
            int n2 = this.declareNS(string3, string2, false);
            if (this.m_elemContext.get_STATE() == 3) {
                try {
                    this.privateWriteAttrNSDecl(n2);
                }
                catch (IOException iOException) {
                    Messages.xciDynamicErrorException(iOException);
                }
            }
        }
    }

    @Override
    public final void addNamespaceNode(VolatileCData volatileCData, VolatileCData volatileCData2, boolean bl) {
        String string2;
        String string3;
        if (XMLStreamCursor) {
            this.dbgTrace(".addNamespaceNode('" + this.dbgGetValue(volatileCData) + "','" + this.dbgGetValue(volatileCData2) + "'," + bl + "); called");
        }
        if (!this.mayAddElemAttr()) {
            string3 = Messages.createMessage2("ER_SER_ATTR_NAMESPACE", null);
            Messages.xciDynamicErrorException(string3);
        }
        string3 = volatileCData2.toString();
        String string4 = string2 = volatileCData == null ? "" : volatileCData.toString();
        if (string2.length() == 0 || string3.length() > 0 || this.toUndeclarePrefixes) {
            NamespaceMappings.MappingRecord mappingRecord = this.lookupPrefix(string2);
            if (mappingRecord != null && mappingRecord.get_uri().equals(string3)) {
                return;
            }
            int n2 = this.declareNS(string3, string2, false);
            if (this.m_elemContext.get_STATE() == 3) {
                try {
                    this.privateWriteAttrNSDecl(n2);
                }
                catch (IOException iOException) {
                    Messages.xciDynamicErrorException(iOException);
                }
            }
        }
    }

    @Override
    public void addText(Cursor.Area area, VolatileCData volatileCData) {
        if (XMLStreamCursor) {
            this.dbgTrace(".addText('" + this.dbgGetValue(volatileCData) + "'); called");
        }
        try {
            if (!this.m_isFirstRoot && (this.standaloneApplicable() || this.getDoctypeSystem() != null)) {
                if (SERIALIZE_ERR_TRACE) {
                    System.err.println("addText - m_writer content:");
                    System.err.println(this.m_writer.toString());
                    System.err.println("addText - text content: '" + volatileCData.toString() + "'");
                }
                String string2 = Messages.createMessage2("ER_SER_ROOT_MULTIPLE_ELEMENT_TEXT_CHILDREN", null);
                Messages.xciDynamicErrorException(string2);
            }
            this.ensureContentState(area);
            this.m_elemContext.set_STATE(5);
            if (this.m_elemContext.is_CdataSection()) {
                this.writeValueCData(volatileCData);
            } else {
                this.writeValue(volatileCData);
            }
        }
        catch (IOException iOException) {
            throw new AssertionError((Object)iOException);
        }
    }

    @Override
    public void addText(Cursor.Area area, Chars chars) {
        if (XMLStreamCursor) {
            this.dbgTrace(".addText('" + this.dbgGetValue(chars) + "'); called");
        }
        try {
            if (!this.m_isFirstRoot && (this.standaloneApplicable() || this.getDoctypeSystem() != null)) {
                if (SERIALIZE_ERR_TRACE) {
                    System.err.println("addText - m_writer content:");
                    System.err.println(this.m_writer.toString());
                    System.err.println("addText - text content: '" + ((Object)chars).toString() + "'");
                }
                String string2 = Messages.createMessage2("ER_SER_ROOT_MULTIPLE_ELEMENT_TEXT_CHILDREN", null);
                Messages.xciDynamicErrorException(string2);
            }
            this.ensureContentState(area);
            this.m_elemContext.set_STATE(5);
            if (this.m_elemContext.is_CdataSection()) {
                this.writeValueCData(chars);
            } else {
                this.writeValue(chars);
            }
        }
        catch (IOException iOException) {
            throw new AssertionError((Object)iOException);
        }
    }

    @Override
    public final Cursor fork(boolean bl, Cursor.Profile profile, Cursor.Profile profile2) {
        if (XMLStreamCursor) {
            this.dbgTrace(".fork(...); called");
        }
        assert (this.incrementForkReleaseCounter());
        return this;
    }

    @Override
    public final boolean openMutation(Cursor.Area area) {
        if (XMLStreamCursor) {
            this.dbgTrace(".openMutation(...); called");
        }
        if (this.m_openMutationCalled) {
            return false;
        }
        this.m_openMutationCalled = true;
        this.m_elemContext.set_STATE(0);
        try {
            this.startDocumentInternal();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return true;
    }

    @Override
    public final void closeMutation() {
        if (XMLStreamCursor) {
            this.dbgTrace(".closeMutation(); called");
        }
        try {
            this.m_openMutationCalled = false;
            this.m_writer.flush();
            if (this.m_writer instanceof WriterToUTF8Buffered) {
                WriterCache.returnWriterToUTF8Buffered((WriterToUTF8Buffered)this.m_writer);
            }
        }
        catch (IOException iOException) {
            throw new RuntimeException(iOException);
        }
    }

    @Override
    public final Cursor.Profile profile() {
        Cursor.Profile profile = super.profile();
        return profile;
    }

    @Override
    public final Cursor.Profile profileLimit() {
        return this.futureProfile();
    }

    @Override
    public final Cursor.Profile futureProfile() {
        return FEATURES_LIMIT;
    }

    @Override
    public final void writeAttrNSDecl(int n2) throws IOException {
    }

    @Override
    public void writeAttribute(boolean bl, VolatileCData volatileCData, VolatileCData volatileCData2) throws IOException {
        String string2;
        if (XMLStreamCursor) {
            this.dbgTrace(".writeAttribute('" + this.dbgGetQName(volatileCData) + "','" + this.dbgGetQName(volatileCData2) + "'); called");
        }
        if (this.mayAddNamespaceNode()) {
            this.privateElemStart();
            this.m_elemContext.set_STATE(3);
        }
        String string3 = this.processNonElemQName(volatileCData);
        boolean bl2 = AbstractStreamCursor.isQNameType(volatileCData2);
        String string4 = string2 = bl2 ? this.processNonElemQName(volatileCData2) : null;
        if (bl) {
            this.writeASCII(SPACE_CHAR);
        }
        this.writeNonElementQName(string3, volatileCData.getQNameLocalPart(1));
        this.writeASCII(EQUALS_CHAR);
        this.writeASCII(DOUBLE_QUOTE_CHAR);
        if (bl2) {
            this.writeNonElementQName(string2, volatileCData2.getQNameLocalPart(1));
        } else {
            this.writeAttributeValue(volatileCData2);
        }
        this.writeASCII(DOUBLE_QUOTE_CHAR);
    }

    protected final String processNonElemQName(VolatileCData volatileCData) throws IOException {
        String string2 = volatileCData.getQNameNamespaceURI(1);
        String string3 = volatileCData.getQNamePrefix(1);
        if (string2 == null || string2.length() == 0) {
            if (string3.length() != 0) {
                // empty if block
            }
            string3 = "";
        } else {
            string3 = this.processNonElemPrefix(string3, string2);
        }
        return string3;
    }

    private final String processNonElemPrefix(String string2, String string3) throws IOException {
        NamespaceMappings.MappingRecord mappingRecord = null;
        if (string2.length() > 0 && (mappingRecord = this.m_prefixMap.getMappingFromPrefix(string2)) != null && mappingRecord.get_uri().equals(string3)) {
            return string2;
        }
        return this.processNonElemPrefix(mappingRecord, string2, string3);
    }

    private final String processNonElemPrefix(NamespaceMappings.MappingRecord mappingRecord, String string2, String string3) throws IOException {
        boolean bl;
        String string4 = string2;
        boolean bl2 = bl = mappingRecord != null && mappingRecord.m_declarationDepth == this.m_elemContext.get_elemDepth();
        if (string4.length() == 0 || bl) {
            mappingRecord = this.m_prefixMap.getMappingFromURI(string3);
            if (mappingRecord != null && mappingRecord.get_prefix().length() > 0 && string3.equals(mappingRecord.get_uri())) {
                return mappingRecord.get_prefix();
            }
            string4 = this.m_prefixMap.generateUnusedPrefix();
        }
        this.declareNS(string3, string4, false);
        this.writeASCII(SPACE_CHAR);
        this.writeASCII(XMLNS_COLON);
        this.m_writer.write(string4);
        this.writeASCII(EQUALS_DOUBLEQUOTE);
        this.escapeValue(string3, this.getCharEscapeMap((short)4));
        this.writeASCII(DOUBLE_QUOTE_CHAR);
        return string4;
    }

    protected void writeValueCData(Chars chars) {
        StringWriter stringWriter = new StringWriter();
        try {
            chars.writeTo(stringWriter, false);
            String string2 = stringWriter.toString();
            this.writeValueCData2(string2);
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
    }

    protected void writeValueCData(VolatileCData volatileCData) {
        StringWriter stringWriter = new StringWriter();
        try {
            volatileCData.writeTo(stringWriter, false);
            String string2 = stringWriter.toString();
            this.writeValueCData2(string2);
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
    }

    private void writeValueCData2(String string2) throws IOException {
        int n2;
        if (this.m_normalizerMode != 1 && !this.m_unicodeNormalizer.alreadyNormalized(string2, this.m_normalizerMode)) {
            string2 = this.m_unicodeNormalizer.normalizeUnicode(string2, this.m_normalizerMode);
        }
        int n3 = string2.length();
        int n4 = 0;
        for (n2 = 0; n2 < n3; ++n2) {
            char c = string2.charAt(n2);
            if (c <= '\u007f') {
                if (c != ']' || n2 + 2 >= n3 || string2.charAt(n2 + 1) != ']' || string2.charAt(n2 + 2) != '>') continue;
                this.writeCDataSectionText(string2, n4, n2 += 2);
                n4 = n2;
                continue;
            }
            if (this.m_encodingInfo.isCharInEncoding(c)) continue;
            if (n4 < n2) {
                this.writeCDataSectionText(string2, n4, n2);
            }
            this.m_writer.append("&#");
            this.m_writer.append(Integer.toString(c));
            this.m_writer.append(";");
            n4 = n2 + 1;
        }
        if (n4 < n2) {
            this.writeCDataSectionText(string2, n4, n2);
        }
    }

    private void writeCDataSectionText(String string2, int n2, int n3) throws IOException {
        this.m_writer.append(CDATA_SECTION_START);
        this.m_writer.append(string2, n2, n3);
        this.m_writer.append(CDATA_SECTION_END);
    }

    void privateElemStart() throws IOException {
        String string2;
        String string3;
        int n2;
        int n3;
        this.writeASCII(LESSTHAN_CHAR);
        String string4 = this.m_elemContext.get_elemURI();
        String string5 = this.m_elemContext.get_elemPrefix();
        NamespaceMappings.MappingRecord mappingRecord = this.m_prefixMap.getMappingFromPrefix(string5);
        int n4 = n3 = string4 == null ? 0 : string4.length();
        if (mappingRecord != null && (n2 = (string3 = mappingRecord.get_uri()).length()) > 0) {
            if (n2 != n3 || !string3.equals(string4)) {
                if (n3 > 0 || this.isXML11()) {
                    int n5 = mappingRecord.m_declarationDepth;
                    mappingRecord = this.m_prefixMap.getMappingFromURI(string4);
                    if (mappingRecord != null && !string5.equals(mappingRecord.get_prefix())) {
                        string2 = mappingRecord.get_prefix();
                        this.m_elemContext.set_elemPrefix(string2);
                    } else {
                        if (n5 == this.m_elemContext.get_elemDepth()) {
                            string2 = this.m_prefixMap.generateUnusedPrefix();
                            this.m_elemContext.set_elemPrefix(string2);
                        } else {
                            string2 = string5;
                        }
                        this.declareNS(string4, string2, false);
                    }
                } else {
                    string2 = "";
                    this.m_elemContext.set_elemPrefix(string2);
                    this.declareNS(string4, string2, false);
                }
            } else {
                string2 = string5;
            }
        } else if (n3 > 0 || string5.length() > 0 && this.isXML11()) {
            string2 = string5;
            this.declareNS(string4, string5, false);
        } else {
            string2 = "";
            if (string5.length() > 0) {
                this.m_elemContext.set_elemPrefix(string2);
                this.declareNS(string4, string2, false);
            }
        }
        this.privateWritePrefix(string2);
        String string6 = this.m_elemContext.get_elemLocalName();
        this.m_writer.write(string6);
        int n6 = this.m_elemContext.get_firstNamespaceNode();
        if (0 <= n6) {
            int n7 = this.m_elemContext.get_lastNamespaceNode();
            for (int i = n6; i <= n7; ++i) {
                this.privateWriteAttrNSDecl(i);
            }
        }
    }

    protected final void privateWritePrefix(String string2) throws IOException {
        if (string2 != null && string2.length() > 0) {
            this.m_writer.write(string2);
            this.writeASCII(COLON_CHAR);
        }
    }

    @Override
    public final void writeBracketClosingTag(VolatileCData volatileCData) throws IOException {
        this.unimplemented("writeBracketClosingTag");
    }

    @Override
    public final void writeClosingBracket() throws IOException {
        if (this.mayAddNamespaceNode()) {
            this.privateElemStart();
        }
        this.writeASCII(GREATERTHAN_CHAR);
    }

    @Override
    public void writeClosingTag(VolatileCData volatileCData) throws IOException {
        if (this.mayAddNamespaceNode()) {
            this.privateElemStart();
        } else {
            this.m_writer.write(BRACKET_SLASH);
            this.privateWritePrefix(this.m_elemContext.get_elemPrefix());
            this.m_writer.write(this.m_elemContext.get_elemLocalName());
        }
        this.writeASCII(GREATERTHAN_CHAR);
    }

    @Override
    public final void writeComment(VolatileCData volatileCData) throws IOException {
        this.checkPI_CommentValue(volatileCData, this.getCharEscapeMap((short)3), false);
        this.writeASCII(COMMENT_START);
        volatileCData.quote((short)0).writeTo(this.m_writer, false);
        this.writeASCII(COMMENT_END);
    }

    @Override
    public final void writeOpenTag(VolatileCData volatileCData) throws IOException {
        String string2;
        String string3;
        int n2;
        this.writeQName(volatileCData);
        String string4 = volatileCData.getQNamePrefix(1);
        if (string4 == null) {
            string4 = "";
        }
        if (0 < (n2 = (string3 = volatileCData.getQNameLocalPart(1)).indexOf(58))) {
            if (string4.length() == 0) {
                string4 = string3.substring(0, n2);
            }
            string3 = string3.substring(n2 + 1);
        }
        String string5 = volatileCData.getQNameNamespaceURI(1);
        if (string4.length() == 0) {
            string2 = string3;
        } else {
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append(string4);
            stringBuilder.append(':');
            stringBuilder.append(string3);
            string2 = stringBuilder.toString();
        }
        this.m_elemContext.setElementValues(string4, string3, string5, string2);
    }

    @Override
    public final void writePI(VolatileCData volatileCData, VolatileCData volatileCData2) throws IOException {
        this.checkPI_CommentValue(volatileCData2, this.getCharEscapeMap((short)2), true);
        Writer writer = this.m_writer;
        this.writeASCII(LESSTHAN_QUESTION_CHARS);
        this.writeNonElemQName(volatileCData);
        this.writeASCII(SPACE_CHAR);
        volatileCData2.quote((short)0).writeTo(writer, false);
        this.writePIEnd();
    }

    protected void writePIEnd() throws IOException {
        this.writeASCII(QUESTION_GREATERTHAN_CHARS);
    }

    protected final void writeNonElemQName(VolatileCData volatileCData) throws IOException {
        NamespaceMappings.MappingRecord mappingRecord;
        String string2 = volatileCData.getQNameNamespaceURI(1);
        String string3 = null;
        if (string2.length() > 0 && (mappingRecord = this.m_prefixMap.lookupPrefix(string2)) != null) {
            string3 = mappingRecord.get_prefix();
        }
        this.writeNonElementQName(string3, volatileCData.getQNameLocalPart(1));
    }

    @Override
    public final void writeQName(VolatileCData volatileCData) throws IOException {
    }

    @Override
    public void writeSlashBracket() throws IOException {
        if (this.mayAddNamespaceNode()) {
            this.privateElemStart();
        }
        this.m_writer.write(SLASH_BRACKET);
    }

    @Override
    public void writeValue(VolatileCData volatileCData) throws IOException {
        this.writeValue(volatileCData, (short)225, false);
    }

    @Override
    protected void writeValue(Chars chars) throws IOException {
        this.writeValue(chars, (short)225, false);
    }

    protected final void writeValue(VolatileCData volatileCData, short s, boolean bl) throws IOException {
        boolean bl2 = false;
        int n2 = 1;
        while (volatileCData.hasItemAt(n2)) {
            CData cData = volatileCData.itemAt(n2);
            if (this.m_codePointMappings != null) {
                if (bl2) {
                    this.m_writer.append(" ");
                }
                if (this.m_normalizerMode == 1) {
                    this.writeValueCharacterMap1(cData, s, bl);
                } else {
                    this.writeValueCharacterMap2(cData, s, bl);
                }
            } else {
                if (bl2) {
                    this.m_writer.append(" ");
                }
                if (this.m_normalizerMode == 1) {
                    this.quoteValue(cData, s, bl);
                } else {
                    this.normalizeValue(cData, s, bl);
                }
            }
            bl2 = true;
            ++n2;
        }
    }

    protected final void writeValue(Chars chars, short s, boolean bl) throws IOException {
        if (this.m_codePointMappings != null) {
            if (this.m_normalizerMode == 1) {
                this.writeValueCharacterMap1(chars, s, bl);
            } else {
                this.writeValueCharacterMap2(chars, s, bl);
            }
        } else if (this.m_normalizerMode == 1) {
            this.quoteValue(chars, s, bl);
        } else {
            this.normalizeValue(chars, s, bl);
        }
    }

    protected final void writeValueCharacterMap1(Chars chars, short s, boolean bl) throws IOException {
        int n2;
        int n3 = chars.length();
        int n4 = 0;
        for (n2 = 0; n2 < n3; ++n2) {
            char c = chars.charAt(n2);
            String string2 = this.m_codePointMappings.getString(c);
            if (string2 == null) continue;
            if (n4 < n2) {
                this.quoteValue(chars, n4, n2, s, bl);
            }
            n4 = n2 + 1;
            this.m_writer.append(string2);
        }
        if (n4 < n2) {
            this.quoteValue(chars, n4, n2, s, bl);
        }
    }

    protected final void writeValueCharacterMap2(Chars chars, short s, boolean bl) throws IOException {
        int n2;
        int n3 = chars.length();
        int n4 = 0;
        for (n2 = 0; n2 < n3; ++n2) {
            char c = chars.charAt(n2);
            String string2 = this.m_codePointMappings.getString(c);
            if (string2 == null) continue;
            if (n4 < n2) {
                this.normalizeValue(chars, n4, n2, s, bl);
            }
            n4 = n2 + 1;
            this.m_writer.append(string2);
        }
        if (n4 < n2) {
            this.normalizeValue(chars, n4, n2, s, bl);
        }
    }

    protected final void normalizeValue(Chars chars, short s, boolean bl) throws IOException {
        boolean bl2;
        StringWriter stringWriter = new StringWriter();
        chars.writeTo(stringWriter, false);
        String string2 = stringWriter.toString();
        boolean bl3 = bl2 = s != 0;
        if (!this.m_unicodeNormalizer.alreadyNormalized(string2, this.m_normalizerMode)) {
            string2 = this.m_unicodeNormalizer.normalizeUnicode(string2, this.m_normalizerMode);
        }
        this.quoteValue(string2, bl2, bl);
    }

    protected final void normalizeValue(Chars chars, int n2, int n3, short s, boolean bl) throws IOException {
        boolean bl2;
        String string2 = ((Object)chars.subSequence(n2, n3)).toString();
        boolean bl3 = bl2 = s != 0;
        if (!this.m_unicodeNormalizer.alreadyNormalized(string2, this.m_normalizerMode)) {
            string2 = this.m_unicodeNormalizer.normalizeUnicode(string2, this.m_normalizerMode);
        }
        this.quoteValue(string2, bl2, bl);
    }

    protected void quoteValue(Chars chars, short s, boolean bl) throws IOException {
        if (s == 0 || !chars.mayContain(s)) {
            chars.appendQuotedTo(this.m_writer, s, false);
        } else {
            this.escapeValue(chars, 0, chars.length(), this.getCharEscapeMap(bl ? (short)1 : 0));
        }
    }

    protected final void quoteValue(Chars chars, int n2, int n3, short s, boolean bl) throws IOException {
        if (s == 0 || !chars.mayContain(s)) {
            Chars chars2 = CharBufferChars.make(chars.subSequence(n2, n3));
            chars2.appendQuotedTo(this.m_writer, s, false);
        } else {
            this.escapeValue(chars, n2, n3, this.getCharEscapeMap(bl ? (short)1 : 0));
        }
    }

    protected final void quoteValue(String string2, boolean bl, boolean bl2) throws IOException {
        if (bl) {
            this.escapeValue(string2, 0, string2.length(), this.getCharEscapeMap(bl2 ? (short)1 : 0));
        } else {
            this.m_writer.append(string2);
        }
    }

    byte[] getCharEscapeMap(short s) {
        if (s == 0) {
            return this.m_isASCIIEncoding ? CHARACTERS_CHAR_ESCAPE_MAP_ASCII : CHARACTERS_CHAR_ESCAPE_MAP;
        }
        if (s == 1) {
            return this.m_isASCIIEncoding ? ATTRIBUTE_CHAR_ESCAPE_MAP_ASCII : ATTRIBUTE_CHAR_ESCAPE_MAP;
        }
        if (s == 2) {
            return this.m_isASCIIEncoding ? PI_CHAR_ESCAPE_MAP_ASCII : PI_CHAR_ESCAPE_MAP;
        }
        if (s == 3) {
            return this.m_isASCIIEncoding ? COMMENT_CHAR_ESCAPE_MAP_ASCII : COMMENT_CHAR_ESCAPE_MAP;
        }
        return this.m_isASCIIEncoding ? NAMESPACE_CHAR_ESCAPE_MAP_ASCII : NAMESPACE_CHAR_ESCAPE_MAP;
    }

    protected final void escapeValue(CharSequence charSequence, byte[] byArray) throws IOException {
        char c;
        int n2;
        int n3 = charSequence.length();
        for (n2 = 0; n2 < n3 && (c = charSequence.charAt(n2)) < byArray.length && byArray[c] == 0; ++n2) {
        }
        if (n2 == n3) {
            this.m_writer.append(charSequence);
        } else {
            this.escapeValue(charSequence, 0, n2, n3, byArray);
        }
    }

    protected final void escapeValue(CharSequence charSequence, int n2, int n3, byte[] byArray) throws IOException {
        char c;
        int n4;
        for (n4 = n2; n4 < n3 && (c = charSequence.charAt(n4)) < byArray.length && byArray[c] == 0; ++n4) {
        }
        if (n4 == n3) {
            this.m_writer.append(charSequence, n2, n3);
        } else {
            this.escapeValue(charSequence, n2, n4, n3, byArray);
        }
    }

    protected void escapeValue(CharSequence charSequence, int n2, int n3, int n4, byte[] byArray) throws IOException {
        int n5 = n2;
        block11: for (int i = n3; i < n4; ++i) {
            char c = charSequence.charAt(i);
            if (c < byArray.length) {
                block0 : switch (byArray[c]) {
                    case 0: {
                        ++i;
                        while (i < n4) {
                            c = charSequence.charAt(i);
                            if (c >= byArray.length || byArray[c] != 0) {
                                --i;
                                break block0;
                            }
                            ++i;
                        }
                        continue block11;
                    }
                    case 1: 
                    case 2: 
                    case 3: {
                        if (n5 < i) {
                            this.m_writer.append(charSequence, n5, i);
                        }
                        this.writeCharacterAsInt(c);
                        n5 = i + 1;
                        break;
                    }
                    case 4: {
                        if (n5 < i) {
                            this.m_writer.append(charSequence, n5, i);
                        }
                        this.m_writer.append("&lt;");
                        n5 = i + 1;
                        break;
                    }
                    case 5: {
                        if (n5 < i) {
                            this.m_writer.append(charSequence, n5, i);
                        }
                        this.m_writer.append("&gt;");
                        n5 = i + 1;
                        break;
                    }
                    case 6: {
                        if (n5 < i) {
                            this.m_writer.append(charSequence, n5, i);
                        }
                        this.m_writer.append("&amp;");
                        n5 = i + 1;
                        break;
                    }
                    case 7: {
                        if (n5 < i) {
                            this.m_writer.append(charSequence, n5, i);
                        }
                        this.m_writer.append("&quot;");
                        n5 = i + 1;
                        break;
                    }
                    case 16: {
                        if (c <= '\u007f') {
                            if (c <= '\u001f' && !this.m_isXML11) {
                                String string2 = Messages.createMessage2("ER_SER_INVALID_CHARACTER_IN_TEXT", new String[]{Integer.toString(c, 16)});
                                Messages.xciDynamicErrorException(string2);
                            }
                            if (n5 < i) {
                                this.m_writer.append(charSequence, n5, i);
                            }
                            this.writeCharacterAsInt(c);
                            n5 = i + 1;
                            break;
                        }
                    }
                    case 10: {
                        if (n5 < i) {
                            this.m_writer.append(charSequence, n5, i);
                        }
                        this.writeCharacterAsHex(c);
                        n5 = i + 1;
                        break;
                    }
                    case 11: {
                        String string3 = Messages.createMessage2("ER_SER_INVALID_CHARACTER_IN_TEXT", new String[]{Integer.toString(c, 16)});
                        Messages.xciDynamicErrorException(string3);
                        break;
                    }
                }
                continue;
            }
            if (c >= '\ud800' && c <= '\udbff') {
                if (i < n4 - 1) {
                    int n6;
                    char c2;
                    if (!Encodings.isLowUTF16Surrogate(c2 = charSequence.charAt(++i))) {
                        String string4 = Messages.createMessage2("ER_SER_INVALID_UTF16_SURROGATE2", new String[]{Integer.toString(c, 16), Integer.toString(c2, 16)});
                        Messages.xciDynamicErrorException(string4);
                    }
                    if (this.isValidXMLChar(n6 = Encodings.toCodePoint(c, c2))) {
                        if (this.m_encodingInfo.isSurrogatePairInEncoding(c, c2)) continue;
                        if (n5 < i) {
                            this.m_writer.append(charSequence, n5, i);
                        }
                        this.writeCharacterAsHex(n6);
                        n5 = i + 1;
                        continue;
                    }
                    String string5 = Messages.createMessage2("ER_SER_INVALID_CHARACTER_IN_TEXT", new String[]{Integer.toString(c, 16)});
                    Messages.xciDynamicErrorException(string5);
                    continue;
                }
                String string6 = Messages.createMessage2("ER_SER_INVALID_UTF16_SURROGATE1", new String[]{Integer.toString(c, 16)});
                Messages.xciDynamicErrorException(string6);
                continue;
            }
            if (Encodings.isLowUTF16Surrogate(c)) {
                String string7 = Messages.createMessage2("ER_SER_INVALID_UTF16_SURROGATE3", new String[]{Integer.toString(c, 16)});
                Messages.xciDynamicErrorException(string7);
                continue;
            }
            if (this.isValidXMLChar(c)) {
                if (c != '\u2028' && this.m_encodingInfo.isCharInEncoding(c)) continue;
                if (n5 < i) {
                    this.m_writer.append(charSequence, n5, i);
                }
                this.writeCharacterAsHex(c);
                n5 = i + 1;
                continue;
            }
            String string8 = Messages.createMessage2("ER_SER_INVALID_CHARACTER_IN_TEXT", new String[]{Integer.toString(c, 16)});
            Messages.xciDynamicErrorException(string8);
        }
        if (n5 < n4) {
            this.m_writer.append(charSequence, n5, n4);
        }
    }

    protected void escapeValueOld(CharSequence charSequence, int n2, int n3, boolean bl) throws IOException {
        if (bl) {
            while (n2 < n3) {
                char c = charSequence.charAt(n2);
                if (c == '<') {
                    this.m_writer.append("&lt;");
                } else if (c == '>') {
                    this.m_writer.append("&gt;");
                } else if (c == '&') {
                    this.m_writer.append("&amp;");
                } else if (c == '\"') {
                    this.m_writer.append("&quot;");
                } else if (c > '\u001f' && c < '\u007f') {
                    this.m_writer.append(c);
                } else if (n2 + 1 < n3 && Encodings.isHighUTF16Surrogate(c)) {
                    this.m_writer.append(charSequence, n2, n2 + 2);
                    ++n2;
                } else if (c <= '\u001f' || c == '\u007f') {
                    this.writeCharacterAsInt(c);
                } else if (c > '\u007f' && c <= '\u009f' || c == '\u2028' || !this.m_encodingInfo.isCharInEncoding(c)) {
                    this.writeCharacterAsHex(c);
                } else {
                    this.m_writer.append(c);
                }
                ++n2;
            }
        } else {
            while (n2 < n3) {
                char c = charSequence.charAt(n2);
                if (c == '\n' || c == '\t') {
                    this.m_writer.append(c);
                } else if (c == '<') {
                    this.m_writer.append("&lt;");
                } else if (c == '>') {
                    this.m_writer.append("&gt;");
                } else if (c == '&') {
                    this.m_writer.append("&amp;");
                } else if (c > '\u001f' && c < '\u007f') {
                    this.m_writer.append(c);
                } else if (n2 + 1 < n3 && Encodings.isHighUTF16Surrogate(c)) {
                    this.m_writer.append(charSequence, n2, n2 + 2);
                    ++n2;
                } else if (c <= '\u001f' || c == '\u007f') {
                    this.writeCharacterAsInt(c);
                } else if (c > '\u007f' && c <= '\u009f' || c == '\u2028' || !this.m_encodingInfo.isCharInEncoding(c)) {
                    this.writeCharacterAsHex(c);
                } else {
                    this.m_writer.append(c);
                }
                ++n2;
            }
        }
    }

    protected final void writeCharacterAsInt(int n2) throws IOException {
        this.m_writer.append("&#");
        this.m_writer.append(Integer.toString(n2));
        this.m_writer.append(";");
    }

    protected final void writeCharacterAsHex(int n2) throws IOException {
        this.m_writer.append("&#x");
        this.m_writer.append(AbstractStreamCursor.makeHexString(n2));
        this.m_writer.append(";");
    }

    protected static final String makeHexString(int n2) {
        String string2 = Integer.toHexString(n2).toUpperCase(Locale.ENGLISH);
        if (string2.length() == 1) {
            string2 = "0" + string2;
        }
        return string2;
    }

    protected final void checkPI_CommentValue(VolatileCData volatileCData, byte[] byArray, boolean bl) {
        char c;
        int n2;
        int n3 = volatileCData.length();
        for (n2 = 0; n2 < n3 && (c = volatileCData.charAt(n2)) < byArray.length && byArray[c] == 0; ++n2) {
        }
        if (n2 != n3) {
            this.checkPI_CommentValue(volatileCData, n2, n3, byArray, bl);
        }
    }

    protected void checkPI_CommentValue(VolatileCData volatileCData, int n2, int n3, byte[] byArray, boolean bl) {
        block7: for (int i = n2; i < n3; ++i) {
            char c = volatileCData.charAt(i);
            if (c < byArray.length) {
                block0 : switch (byArray[c]) {
                    case 0: {
                        ++i;
                        while (i < n3 && (c = volatileCData.charAt(i)) < byArray.length) {
                            if (byArray[c] != 0) break block0;
                            ++i;
                        }
                        continue block7;
                    }
                    case 8: {
                        if (i >= n3 - 1 || volatileCData.charAt(++i) != '-') continue block7;
                        String string2 = Messages.createMessage2("ER_SER_INVALID_DASH_IN_COMMENT", null);
                        Messages.xciDynamicErrorException(string2);
                        break;
                    }
                    case 11: {
                        String string3 = Messages.createMessage2(bl ? "ER_SER_INVALID_CHARACTER_IN_PI" : "ER_SER_INVALID_CHARACTER_IN_COMMENT", new String[]{Integer.toString(c, 16)});
                        Messages.xciDynamicErrorException(string3);
                        break;
                    }
                    case 15: {
                        String string4 = Messages.createMessage2(bl ? "ER_SER_CHAR_NOT_REPRESENTABLE_IN_ENCODING_FOR_PI" : "ER_SER_CHAR_NOT_REPRESENTABLE_IN_ENCODING_FOR_COMMENT", new String[]{AbstractStreamCursor.makeHexString(c), this.getEncoding()});
                        Messages.xciDynamicErrorException(string4);
                        break;
                    }
                    case 16: {
                        String string5 = Messages.createMessage2(bl ? "ER_SER_INVALID_CHARACTER_IN_PI" : "ER_SER_INVALID_CHARACTER_IN_COMMENT", new String[]{AbstractStreamCursor.makeHexString(c)});
                        Messages.xciDynamicErrorException(string5);
                        break;
                    }
                }
                continue;
            }
            if (c >= '\ud800' && c <= '\udbff') {
                if (i < n3 - 1) {
                    String string6;
                    int n4;
                    char c2;
                    if (!Encodings.isLowUTF16Surrogate(c2 = volatileCData.charAt(++i))) {
                        String string7 = Messages.createMessage2("ER_SER_INVALID_UTF16_SURROGATE2", new String[]{Integer.toString(c, 16), Integer.toString(c2, 16)});
                        Messages.xciDynamicErrorException(string7);
                    }
                    if (this.isValidXMLChar(n4 = Encodings.toCodePoint(c, c2))) {
                        if (this.m_encodingInfo.isSurrogatePairInEncoding(c, c2)) continue;
                        string6 = Messages.createMessage2(bl ? "ER_SER_CHAR_NOT_REPRESENTABLE_IN_ENCODING_FOR_PI" : "ER_SER_CHAR_NOT_REPRESENTABLE_IN_ENCODING_FOR_COMMENT", new String[]{AbstractStreamCursor.makeHexString(n4), this.getEncoding()});
                        Messages.xciDynamicErrorException(string6);
                        continue;
                    }
                    string6 = Messages.createMessage2(bl ? "ER_SER_INVALID_CHARACTER_IN_PI" : "ER_SER_INVALID_CHARACTER_IN_COMMENT", new String[]{Integer.toString(c, 16)});
                    Messages.xciDynamicErrorException(string6);
                    continue;
                }
                String string8 = Messages.createMessage2("ER_SER_INVALID_UTF16_SURROGATE1", new String[]{Integer.toString(c, 16)});
                Messages.xciDynamicErrorException(string8);
                continue;
            }
            if (Encodings.isLowUTF16Surrogate(c)) {
                String string9 = Messages.createMessage2("ER_SER_INVALID_UTF16_SURROGATE3", new String[]{Integer.toString(c, 16)});
                Messages.xciDynamicErrorException(string9);
                continue;
            }
            if (this.isValidXMLChar(c)) {
                if (this.m_encodingInfo.isCharInEncoding(c)) continue;
                String string10 = Messages.createMessage2(bl ? "ER_SER_CHAR_NOT_REPRESENTABLE_IN_ENCODING_FOR_PI" : "ER_SER_CHAR_NOT_REPRESENTABLE_IN_ENCODING_FOR_COMMENT", new String[]{AbstractStreamCursor.makeHexString(c), this.getEncoding()});
                Messages.xciDynamicErrorException(string10);
                continue;
            }
            String string11 = Messages.createMessage2(bl ? "ER_SER_INVALID_CHARACTER_IN_PI" : "ER_SER_INVALID_CHARACTER_IN_COMMENT", new String[]{Integer.toString(c, 16)});
            Messages.xciDynamicErrorException(string11);
        }
    }

    private final boolean isValidStandalone(String string2) {
        return string2.equals("no") || string2.equals("omit") || string2.equals("yes");
    }

    private final void startDocumentInternal0(String string2) throws IOException {
        Object object2;
        Object object3;
        Object object4;
        Object object5;
        Object object6;
        Object object7;
        Object object8;
        Object object9;
        Object object10;
        Object object11 = this.getOutputPropertyNonDefault("byte-order-mark");
        if (Boolean.TRUE.equals(object11) && !"UTF-16".equals(string2)) {
            this.m_writer.write(65279);
        }
        if ((object10 = this.getOutputPropertyNonDefault("doctype-public")) instanceof String) {
            this.set_doctypePublic((String)object10);
        }
        if ((object9 = this.getOutputPropertyNonDefault("doctype-system")) instanceof String) {
            this.setDoctypeSystem((String)object9);
        }
        if ((object8 = this.getOutputPropertyNonDefault("indent")) instanceof Boolean) {
            this.setIndent((Boolean)object8);
        }
        if ((object7 = this.getOutputPropertyNonDefault(SerializeParam.INDENT_LINE_SEPARATOR)) instanceof String) {
            this.setIndentLineSep((String)object7);
        }
        if ((object6 = this.getOutputPropertyNonDefault(SerializeParam.INDENT_CHARACTER)) instanceof Character) {
            this.setIndentChars((Character)object6);
        }
        if ((object5 = this.getOutputPropertyNonDefault("standalone")) instanceof String) {
            if (this.isValidStandalone((String)object5)) {
                this.setStandalone((String)object5);
            } else {
                object4 = Messages.createMessage2("ER_SER_PARAM_NOT_YES_OR_NO_OR_OMIT", new String[]{(String)object5});
                Messages.xciDynamicErrorException((String)object4);
            }
        }
        if ((object4 = this.getOutputPropertyNonDefault("version")) instanceof String) {
            this.m_version = (String)object4;
            this.checkSupportedVersion(this.m_version);
            this.m_isXML11 = XMLVERSION11.equals(this.m_version);
        }
        if (Boolean.TRUE.equals(object3 = this.getOutputPropertyNonDefault("omit-xml-declaration"))) {
            if (this.standaloneApplicable()) {
                object2 = Messages.createMessage2("ER_SER_NO_XML_DECL_STANDALONE", null);
                Messages.xciDynamicErrorException((String)object2);
            } else if (this.getDoctypeSystem() != null && !this.m_version.equals(XMLVERSION10)) {
                object2 = Messages.createMessage2("ER_SER_DOCTYPE_SYSTEM_NOT_XML1", null);
                Messages.xciDynamicErrorException((String)object2);
            }
        }
        if (this.toUndeclarePrefixes && !this.m_isXML11) {
            object2 = Messages.createMessage2("ER_SER_UNDECLARE_PREFIXES_XML1", null);
            Messages.xciDynamicErrorException((String)object2);
        }
        if ((object2 = this.getOutputPropertyNonDefault("normalization-form")) instanceof QName) {
            QName qName = (QName)object2;
            if (SerializeParamValue.UNICODE_NF_C.equals(qName)) {
                this.m_normalizerMode = 2;
            } else if (SerializeParamValue.UNICODE_NF_D.equals(qName)) {
                this.m_normalizerMode = 3;
            } else if (SerializeParamValue.UNICODE_NF_KC.equals(qName)) {
                this.m_normalizerMode = 4;
            } else if (SerializeParamValue.UNICODE_NF_KD.equals(qName)) {
                this.m_normalizerMode = 5;
            } else if (!SerializeParamValue.UNICODE_NF_NONE.equals(qName)) {
                String string3 = Messages.createMessage2("ER_SER_NORM_FORM_NOT_SUPPORTED", new String[]{qName.getLocalPart()});
                Messages.xciDynamicErrorException(string3);
            }
            if (this.m_normalizerMode != 1) {
                this.m_unicodeNormalizer = UnicodeNormalizerFactory.getUnicodeNormalizer();
            }
        }
    }

    private final void startDocumentInternal() throws IOException {
        String string2;
        this.setDefaultProperties();
        this.m_wasJustReset = false;
        String string3 = Encodings.getMimeEncoding(this.getEncoding());
        EncodingInfo encodingInfo = Encodings.getEncodingInfo(string3);
        if (encodingInfo != null) {
            this.m_encodingInfo = encodingInfo;
            this.m_isASCIIEncoding = !this.m_encodingInfo.isCharInEncoding('\u0080');
        } else {
            string2 = Messages.createMessage2("ER_SER_ENCODING_NOT_SUPPORTED", new String[]{string3});
            Messages.xciDynamicErrorException(string2);
        }
        if (this.m_writer == null && this.m_outputStream != null) {
            this.setOutputStreamInternal(this.m_outputStream, false);
        }
        if (this.m_OutputProps != null) {
            this.startDocumentInternal0(string3);
        }
        this.m_needTowriteDOCTYPE = true;
        this.m_startNewLine = false;
        string2 = this.getXMLVersion();
        if (!this.getOmitXMLDeclaration().booleanValue()) {
            String string4 = this.standaloneApplicable() ? " standalone=\"" + this.getStandalone() + "\"" : EMPTY_STRING;
            this.writeOutHeader(string2, string3, string4);
        } else if (this.standaloneApplicable()) {
            String string5 = Messages.createMessage2("ER_SER_NO_XML_DECL_STANDALONE", null);
            Messages.xciDynamicErrorException(string5);
        } else if (this.getDoctypeSystem() != null && !this.m_version.equals(XMLVERSION10)) {
            String string6 = Messages.createMessage2("ER_SER_DOCTYPE_SYSTEM_NOT_XML1", null);
            Messages.xciDynamicErrorException(string6);
        }
    }

    private final void setOutputStreamInternal(OutputStream outputStream, boolean bl) {
        this.m_outputStream = outputStream;
        String string2 = (String)this.getOutputProperty("encoding");
        if ("UTF-8".equalsIgnoreCase(string2)) {
            WriterOptimized writerOptimized = this.m_writerOptimized;
            if (writerOptimized == null) {
                writerOptimized = WriterCache.getWriterToUTF8Buffered(outputStream);
            } else {
                writerOptimized.setOuputStream(outputStream);
            }
            this.setWriterInternal(writerOptimized, false);
        } else if ("WINDOWS-1250".equals(string2) || "US-ASCII".equals(string2) || "ASCII".equals(string2)) {
            this.setWriterInternal(new WriterToASCI(outputStream), false);
        } else if (string2 != null) {
            Object object2;
            Writer writer = null;
            try {
                if ("UTF-16".equals(string2) && Boolean.FALSE.equals(object2 = this.getOutputPropertyNonDefault("byte-order-mark"))) {
                    string2 = "UnicodeBigUnmarked";
                }
                writer = !bl && this.m_encodingInfo != null && this.m_encodingInfo.isStatelessEncoding() ? new WriterStateless(outputStream, this.m_encodingInfo) : Encodings.getWriter(outputStream, string2);
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                writer = null;
            }
            if (writer == null) {
                object2 = Messages.createMessage2("ER_SER_ENCODING_NOT_SUPPORTED", new String[]{string2, "UTF-8"});
                Messages.xciDynamicErrorException((String)object2);
                string2 = "UTF-8";
                try {
                    writer = Encodings.getWriter(outputStream, string2);
                }
                catch (UnsupportedEncodingException unsupportedEncodingException) {
                    String string3 = Messages.createMessage2("ER_SER_ENCODING_NOT_SUPPORTED", new String[]{string2, "UTF-8"});
                    Messages.xciDynamicErrorException(string3);
                }
            }
            this.setWriterInternal(writer, false);
        } else {
            OutputStreamWriter outputStreamWriter = new OutputStreamWriter(outputStream);
            this.setWriterInternal(outputStreamWriter, false);
        }
    }

    final Object getOutputProperty(Object object2) {
        Object object3 = this.getOutputPropertyNonDefault(object2);
        if (object3 == null) {
            object3 = this.getOutputPropertyDefault(object2);
        }
        return object3;
    }

    protected final Object getOutputPropertyNonDefault(Object object2) {
        return this.getProp(object2, false);
    }

    private final void setWriterInternal(Writer writer, boolean bl) {
        this.m_writer_set_by_user = bl;
        this.m_writer = writer;
        this.m_writerOptimized = this.m_writer instanceof WriterOptimized ? (WriterOptimized)this.m_writer : null;
    }

    private final String getURI() {
        return this.m_resultDocAbsoluteURI;
    }

    private final Object getOutputPropertyDefault(Object object2) {
        return this.getProp(object2, true);
    }

    Object getProp(Object object2, boolean bl) {
        Object object3 = null;
        String string2 = null;
        if (object2 instanceof String) {
            string2 = (String)object2;
        } else if (object2 instanceof SerializeParam) {
            string2 = ((SerializeParam)object2).toString();
        } else {
            return null;
        }
        if (bl) {
            if (string2.equals("version".toString())) {
                object3 = XMLVERSION10;
                return object3;
            }
            if (string2.equals("encoding".toString())) {
                object3 = "UTF-8";
                return object3;
            }
            if (string2.equals("indent".toString())) {
                object3 = Boolean.FALSE;
                return object3;
            }
            if (string2.equals("method".toString())) {
                object3 = "xml";
                return object3;
            }
            if (string2.equals("media-type".toString())) {
                object3 = "text/xml";
                return object3;
            }
            if (string2.equals("omit-xml-declaration".toString())) {
                object3 = Boolean.FALSE;
                return object3;
            }
            if (string2.equals("standalone".toString())) {
                object3 = Boolean.FALSE;
                return object3;
            }
            if (string2.equals(SerializeParam.INDENT_AMOUNT.toString())) {
                object3 = 2;
                return object3;
            }
        } else if (this.m_OutputProps == null) {
            object3 = null;
        } else {
            object3 = this.m_OutputProps.get(object2);
            if (object3 == null && object2 instanceof SerializeParam) {
                object3 = this.m_OutputProps.get(object2.toString());
            }
        }
        return object3;
    }

    private final String getXMLVersion() {
        String string2 = this.getVersion();
        string2 = string2 == null || string2.equals(XMLVERSION10) ? XMLVERSION10 : (string2.equals(XMLVERSION11) ? XMLVERSION11 : XMLVERSION10);
        return string2;
    }

    private final Boolean getOmitXMLDeclaration() {
        Object object2 = this.getOutputPropertyNonDefault("omit-xml-declaration");
        if (Boolean.TRUE.equals(object2) || "yes".equals(object2)) {
            return Boolean.TRUE;
        }
        return Boolean.FALSE;
    }

    protected final String getEncoding() {
        return (String)this.getOutputProperty("encoding");
    }

    private final String getStandalone() {
        return this.m_standalone;
    }

    protected final void setStandalone(String string2) {
        this.m_standalone = string2;
    }

    protected final String getDoctypeSystem() {
        return this.m_doctypeSystem;
    }

    private final void setDoctypeSystem(String string2) {
        this.m_doctypeSystem = string2;
    }

    protected final String getDoctypePublic() {
        return this.get_doctypePublic();
    }

    private final String getVersion() {
        return this.m_version;
    }

    void setDefaultProperties() {
        EncodingInfo encodingInfo;
        this.m_version = XMLVERSION10;
        this.m_isXML11 = false;
        this.m_encodingInfo = encodingInfo = Encodings.getEncodingInfo("UTF-8");
        this.m_isUTF8 = true;
        this.setIndent(false);
        this.setStandalone("omit");
        this.m_wasJustReset = true;
        this.m_normalizerMode = 1;
        this.m_isFirstRoot = false;
        this.m_isASCIIEncoding = false;
        this.m_doctypeSystem = null;
        this.m_doctypePublic = null;
    }

    public final void setOutputStream(OutputStream outputStream) {
        this.m_outputStream = outputStream;
        this.m_writer = null;
        this.m_writerOptimized = null;
        this.m_writer_set_by_user = false;
    }

    public final void setWriter(Writer writer) {
        this.m_outputStream = null;
        this.setWriterInternal(writer, true);
    }

    private final String dbgGetValue(Chars chars) {
        StringWriter stringWriter = new StringWriter();
        try {
            chars.quote((short)141).writeTo(stringWriter, false);
        }
        catch (Exception exception) {
            return "";
        }
        return stringWriter.toString();
    }

    protected final String dbgGetQName(VolatileCData volatileCData) {
        String string2;
        String string3 = "";
        String string4 = volatileCData.getQNameNamespaceURI(1);
        NamespaceMappings.MappingRecord mappingRecord = this.m_prefixMap.lookupPrefix(string4);
        if (mappingRecord != null && (string2 = mappingRecord.get_prefix()) != null && string2.length() > 0) {
            string3 = string2 + ':';
        }
        string3 = string3 + volatileCData.getQNameLocalPart(1);
        return string3;
    }

    public final boolean isXML11() {
        return this.m_isXML11;
    }

    @Override
    public void addProcessingInstruction(Cursor.Area area, VolatileCData volatileCData, VolatileCData volatileCData2) {
        String string2 = volatileCData.toString();
        if (!string2.equals("javax.xml.transform.disable-output-escaping") && !string2.equals("javax.xml.transform.enable-output-escaping")) {
            try {
                this.ensureContentState(area);
                if (this.shouldIndent()) {
                    this.indent();
                }
                this.writePI(volatileCData, volatileCData2);
                this.m_startNewLine = true;
            }
            catch (IOException iOException) {
                throw new AssertionError((Object)iOException);
            }
        }
    }

    private final boolean shouldIndent() {
        return false;
    }

    protected void indent() throws IOException {
    }

    protected final void setIndent(Boolean bl) {
        this.m_doIndent = bl;
    }

    protected final void setIndentLineSep(String string2) {
        this.m_indentLineSep = string2.toCharArray();
        this.m_indentLineSepLen = this.m_indentLineSep.length;
    }

    protected final void setIndentChars(Character c) {
        this.m_indentChar = c.charValue();
    }

    protected final boolean doIndent() {
        return this.m_doIndent;
    }

    protected final boolean standaloneApplicable() {
        return !this.m_standalone.equals("omit");
    }

    private final void set_doctypePublic(String string2) {
        this.m_doctypePublic = string2;
    }

    private final String get_doctypePublic() {
        return this.m_doctypePublic;
    }

    @Override
    public final void release() {
        if (XMLStreamCursor) {
            this.dbgTrace(".release(); called");
        }
        try {
            if (this.mayAddElemAttr()) {
                this.finishTag();
                this.popNamespaceContext();
            }
            if (this.m_elemContext.get_elemDepth() == 0) {
                int n2 = this.m_elemContext.get_STATE();
                switch (n2) {
                    case 0: {
                        break;
                    }
                    case 6: {
                        break;
                    }
                    default: {
                        this.m_elemContext.set_STATE(6);
                        break;
                    }
                }
            } else {
                this.writeClosingTag(null);
                this.popNamespaceContext();
                this.m_elemContext.set_STATE(4);
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        assert (this.decrementForkReleaseCounter());
    }

    @Override
    protected boolean decrementForkReleaseCounter() {
        if (null != this.forkReleaseInstanceTracker) {
            this.forkReleaseInstanceTracker.checkAndRecordRelease(false, this);
        }
        return true;
    }

    private final void finishTag() throws IOException {
        if (this.avoidEmptyTags) {
            this.writeBracketClosingTag((VolatileCData)this.openTags.pop());
        } else {
            this.writeSlashBracket();
        }
    }

    @Override
    public final void ensureContentState(Cursor.Area area) throws IOException {
        if (this.mayAddElemAttr()) {
            if (area == Cursor.Area.FOLLOWING_SIBLING) {
                this.finishTag();
                this.popNamespaceContext();
            } else {
                this.writeClosingBracket();
            }
            this.m_elemContext.set_STATE(4);
        }
    }

    @Override
    public final boolean toChildren(NodeTest nodeTest) {
        return true;
    }

    @Override
    public final void addContent(Cursor.Area area, byte[] byArray, int n2, int n3) {
        try {
            this.ensureContentState(area);
            this.writeBytes(byArray, n2, n3);
        }
        catch (IOException iOException) {
            throw new AssertionError((Object)iOException);
        }
    }

    @Override
    public final void toEndOfDocument() {
        while (this.m_elemContext.get_elemDepth() > 0) {
            this.m_elemContext = this.m_elemContext.pop();
        }
        this.m_elemContext.set_STATE(6);
    }

    private boolean mayAddElemAttr() {
        return ElemContext.mayAddElemAttr(this.m_elemContext.get_STATE());
    }

    protected boolean mayAddNamespaceNode() {
        return ElemContext.mayAddNamespaceNode(this.m_elemContext.get_STATE());
    }

    public int getElemDepth() {
        int n2 = this.m_elemContext.get_elemDepth();
        return n2;
    }

    public boolean isPreviousElemInline() {
        return this.m_isInlineElem;
    }

    public boolean isCurrentElemInline(VolatileCData volatileCData) {
        return false;
    }

    public int getSerializationState() {
        int n2 = this.m_elemContext.get_STATE();
        return n2;
    }

    public int getParentSerializationState() {
        ElemContext elemContext = this.m_elemContext.pop();
        if (elemContext != null) {
            int n2 = elemContext.get_STATE();
            return n2;
        }
        return -1;
    }

    @Override
    public CursorFactory factory() {
        return this.m_factory;
    }

    abstract void writeOutHeader(String var1, String var2, String var3) throws IOException;

    abstract void privateWriteAttrNSDecl(int var1) throws IOException;

    abstract void writeASCII(char var1) throws IOException;

    abstract void writeASCII(char[] var1) throws IOException;

    abstract void writeNonElementQName(String var1, String var2) throws IOException;

    abstract void writeAttributeValue(VolatileCData var1) throws IOException;

    protected String encodeURI(String string2) {
        int n2 = string2.indexOf(34);
        if (n2 == -1) {
            return string2;
        }
        StringBuilder stringBuilder = new StringBuilder();
        int n3 = 0;
        do {
            stringBuilder.append(string2.substring(n3, n2));
            stringBuilder.append("&quot;");
        } while ((n2 = string2.indexOf(34, n3 = n2 + 1)) != -1);
        if (n3 < string2.length()) {
            stringBuilder.append(string2.substring(n3));
        }
        return stringBuilder.toString();
    }

    @Override
    public abstract void writeBytes(byte[] var1, int var2, int var3) throws IOException;

    @Override
    public final void writeChars(char[] cArray, int n2, int n3) throws IOException {
        this.m_writer.write(cArray, n2, n3);
    }

    public final List<NamespaceMappings.MappingRecord> getInScopeNamespaces(int n2) {
        List<NamespaceMappings.MappingRecord> list = this.m_prefixMap.getPrefixMappingsAtDepth(n2);
        return list;
    }

    public final void writeAttribute(String string2, String string3) throws IOException {
        if (this.mayAddNamespaceNode()) {
            this.privateElemStart();
            this.m_elemContext.set_STATE(3);
        }
        this.writeASCII(SPACE_CHAR);
        this.m_writer.write(string2);
        this.writeASCII(EQUALS_CHAR);
        this.writeASCII(DOUBLE_QUOTE_CHAR);
        this.m_writer.write(string3);
        this.writeASCII(DOUBLE_QUOTE_CHAR);
    }

    @Override
    public boolean canBeSpecialized() {
        return true;
    }

    @Override
    public boolean toIds(VolatileCData volatileCData, boolean bl) {
        if (bl) {
            String string2 = Messages.createMessage2("ER_UNIMPLEMENTED_METHOD", new String[]{"toIds", this.getClass().getName()});
            Messages.xciDynamicErrorException(string2);
        }
        return false;
    }

    void checkSupportedVersion(String string2) {
        if (!string2.equals(XMLVERSION10) && !string2.equals(XMLVERSION11)) {
            String string3 = Messages.createMessage2("ER_SER_BAD_XML_VERSION", new String[]{string2});
            Messages.xciDynamicErrorException(string3);
        }
    }

    private final boolean isValidXMLChar(int n2) {
        return n2 < 55296 || n2 >= 57344 && n2 <= 65533 || n2 >= 65536 && n2 <= 0x10FFFF;
    }

    static {
        byte[] byArray;
        byte[] byArray2;
        byte[] byArray3;
        XMLStreamCursor = HiddenOptions.wasSpecified("XMLStreamCursor");
        SERIALIZE_ERR_TRACE = HiddenOptions.wasSpecified("SerializeErrors");
        EMPTY_STRING = "";
        XMLNS_PREFIX = "".toCharArray();
        XMLNS = " xmlns".toCharArray();
        SLASH_BRACKET = "/>".toCharArray();
        SPACE_SLASH_BRACKET = " />".toCharArray();
        BRACKET_SLASH = "</".toCharArray();
        CDATA_SECTION_START = "<![CDATA[";
        CDATA_SECTION_END = "]]>";
        LESSTHAN_QUESTIONMARK = new char[]{'<', '?'};
        QUESTIONMARK_GREATERTHAN = new char[]{'?', '>'};
        COMMENT_START = new char[]{'<', '!', '-', '-'};
        COMMENT_END = new char[]{'-', '-', '>'};
        XMLNS_COLON = new char[]{'x', 'm', 'l', 'n', 's', ':'};
        EQUALS_DOUBLEQUOTE = new char[]{'=', '\"'};
        XML_HEADER_VERSION_STRING = "<?xml version=\"";
        try {
            byArray3 = XML_HEADER_VERSION_STRING.getBytes("UTF-8");
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            byArray3 = XML_HEADER_VERSION_STRING.getBytes();
        }
        XML_HEADER_VERSION_BYTES = byArray3;
        XML_HEADER_VERSION_CHARS = XML_HEADER_VERSION_STRING.toCharArray();
        XML_HEADER_ENCODING_STRING = "\" encoding=\"";
        try {
            byArray2 = XML_HEADER_ENCODING_STRING.getBytes("UTF-8");
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            byArray2 = XML_HEADER_ENCODING_STRING.getBytes();
        }
        XML_HEADER_ENCODING_BYTES = byArray2;
        XML_HEADER_ENCODING_CHARS = XML_HEADER_ENCODING_STRING.toCharArray();
        XML_HEADER_END_STRING = "?>";
        try {
            byArray = XML_HEADER_END_STRING.getBytes("UTF-8");
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            byArray = XML_HEADER_END_STRING.getBytes();
        }
        XML_HEADER_END_BYTES = byArray;
        XML_HEADER_END_CHARS = XML_HEADER_END_STRING.toCharArray();
        DOUBLE_QUOTE_CHAR = (char)34;
        SPACE_CHAR = (char)32;
        EQUALS_CHAR = (char)61;
        DOUBLE_QUOTE_BYTE = (byte)34;
        DOUBLE_QUOTE_CHARS = new char[]{'\"'};
        LESSTHAN_CHAR = (char)60;
        GREATERTHAN_CHAR = (char)62;
        COLON_CHAR = (char)58;
        LESSTHAN_QUESTION_CHARS = new char[]{'<', '?'};
        QUESTION_GREATERTHAN_CHARS = new char[]{'?', '>'};
        CHARACTERS_CHAR_ESCAPE_MAP = new byte[]{11, 16, 16, 16, 16, 16, 16, 16, 16, 0, 0, 16, 16, 3, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 0, 0, 0, 0, 0, 0, 6, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 4, 0, 5, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0};
        CHARACTERS_CHAR_ESCAPE_MAP_ASCII = new byte[]{11, 16, 16, 16, 16, 16, 16, 16, 16, 0, 0, 16, 16, 3, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 0, 0, 0, 0, 0, 0, 6, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 4, 0, 5, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 16, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10};
        ATTRIBUTE_CHAR_ESCAPE_MAP = new byte[]{11, 16, 16, 16, 16, 16, 16, 16, 16, 2, 1, 16, 16, 3, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 0, 0, 7, 0, 0, 0, 6, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 4, 0, 5, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0};
        ATTRIBUTE_CHAR_ESCAPE_MAP_ASCII = new byte[]{11, 16, 16, 16, 16, 16, 16, 16, 16, 2, 1, 16, 16, 3, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 0, 0, 7, 0, 0, 0, 6, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 4, 0, 5, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 16, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10};
        NAMESPACE_CHAR_ESCAPE_MAP = new byte[]{11, 16, 16, 16, 16, 16, 16, 16, 16, 0, 0, 16, 16, 0, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 0, 0, 7, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0};
        NAMESPACE_CHAR_ESCAPE_MAP_ASCII = new byte[]{11, 16, 16, 16, 16, 16, 16, 16, 16, 0, 0, 16, 16, 0, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 0, 0, 7, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 16, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10};
        PI_CHAR_ESCAPE_MAP = new byte[]{11, 16, 16, 16, 16, 16, 16, 16, 16, 0, 0, 16, 16, 0, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0};
        PI_CHAR_ESCAPE_MAP_ASCII = new byte[]{11, 16, 16, 16, 16, 16, 16, 16, 16, 0, 0, 16, 16, 0, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15};
        COMMENT_CHAR_ESCAPE_MAP = new byte[]{11, 16, 16, 16, 16, 16, 16, 16, 16, 0, 0, 16, 16, 0, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 8, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0};
        COMMENT_CHAR_ESCAPE_MAP_ASCII = new byte[]{11, 16, 16, 16, 16, 16, 16, 16, 16, 0, 0, 16, 16, 0, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 8, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15};
        s_systemLineSep = SecuritySupport.getSystemProperty("line.separator").toCharArray();
    }
}

