/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xml.xci.sax.serializer;

import com.ibm.xml.xci.Cursor;
import com.ibm.xml.xci.CursorFactory;
import com.ibm.xml.xci.VolatileCData;
import com.ibm.xml.xci.dp.values.chars.Chars;
import com.ibm.xml.xci.sax.serializer.AttributesImplSerializer;
import com.ibm.xml.xci.serializer.AbstractSerializeCommon;
import com.ibm.xml.xci.serializer.Encodings;
import com.ibm.xml.xci.serializer.Messages;
import com.ibm.xml.xci.serializer.NamespaceMappings;
import com.ibm.xml.xci.type.TypeRegistry;
import com.ibm.xml.xml4j.api.s1.xs.XSSimpleTypeDefinition;
import java.io.IOException;
import java.util.Map;
import org.xml.sax.ContentHandler;
import org.xml.sax.SAXException;
import org.xml.sax.ext.LexicalHandler;

public class SAXCursor
extends AbstractSerializeCommon {
    static final String IBM_COPYRIGHT = "Licensed Materials - Property of IBM\n\nXML Cursor Interface for Java (XCI-J)\u00a9 Copyright IBM Corp. 2004, 2009. All Rights Reserved.\n\nUS Government Users Restricted Rights - Use, duplication or disclosure \nrestricted by GSA ADP Schedule Contract with IBM Corp.";
    private static final int START_DOCUMENT = 0;
    protected final int CHARSBUFF_MAX_SIZE = 65536;
    protected final AttributesImplSerializer fAttributes = new AttributesImplSerializer();
    private ContentHandler fContentHandler;
    private LexicalHandler fLexicalHandler;
    private final QName qName;
    private char[] fCharBuffer;
    boolean m_openMutationCalled = false;

    public SAXCursor(CursorFactory cursorFactory, ContentHandler contentHandler, LexicalHandler lexicalHandler, Map map2) {
        super(cursorFactory, map2);
        this.fContentHandler = contentHandler;
        this.fLexicalHandler = lexicalHandler;
        this.qName = new QName();
        this.fCharBuffer = new char[128];
    }

    public void setContentHandler(ContentHandler contentHandler) {
        this.fContentHandler = contentHandler;
    }

    public boolean openMutation(Cursor.Area area) {
        if (this.m_openMutationCalled) {
            return false;
        }
        this.m_openMutationCalled = true;
        this.state = 0;
        try {
            this.fContentHandler.startDocument();
        }
        catch (SAXException sAXException) {
            throw new AssertionError((Object)sAXException);
        }
        return true;
    }

    public void closeMutation() {
        try {
            this.m_openMutationCalled = false;
            this.fContentHandler.endDocument();
        }
        catch (SAXException sAXException) {
            throw new AssertionError((Object)sAXException);
        }
    }

    public void addNamespaceNode(VolatileCData volatileCData, VolatileCData volatileCData2, boolean bl) {
        try {
            if (this.strict && this.state != 1) {
                this.reportAddNamespaceNodeError(volatileCData, volatileCData2);
            }
            String string2 = volatileCData2.toString();
            String string3 = volatileCData == null ? "" : volatileCData.toString();
            NamespaceMappings.MappingRecord mappingRecord = this.lookupPrefix(string3);
            if (mappingRecord != null && mappingRecord.get_uri().equals(string2)) {
                return;
            }
            int n2 = this.declareNS(string2, string3, false);
            this.writeAttrNSDecl(n2);
        }
        catch (IOException iOException) {
            throw new AssertionError((Object)iOException);
        }
    }

    protected void writePI(VolatileCData volatileCData, VolatileCData volatileCData2) throws IOException {
        this.writeQName(volatileCData);
        try {
            this.fContentHandler.processingInstruction(this.qName.toString(), volatileCData2.toString());
        }
        catch (SAXException sAXException) {
            throw new AssertionError((Object)sAXException);
        }
    }

    protected void writeComment(VolatileCData volatileCData) throws IOException {
        if (this.fLexicalHandler != null) {
            String string2 = volatileCData.toString();
            int n2 = string2.length();
            char[] cArray = new char[n2];
            string2.getChars(0, n2, cArray, 0);
            try {
                this.fLexicalHandler.comment(cArray, 0, n2);
            }
            catch (SAXException sAXException) {
                throw new AssertionError((Object)sAXException);
            }
        }
    }

    protected void writeOpenTag(VolatileCData volatileCData) throws IOException {
        this.fAttributes.clear();
        this.writeQName(volatileCData);
        this.m_elemContext.setElementValues(this.qName.prefix, this.qName.localPart, this.qName.uri, this.qName.toString());
    }

    protected void writeClosingBracket() throws IOException {
        try {
            this.startPrefixMappingCalls();
            this.fContentHandler.startElement(this.m_elemContext.get_elemURI(), this.m_elemContext.get_elemLocalName(), this.m_elemContext.get_elemName(), this.fAttributes);
        }
        catch (SAXException sAXException) {
            throw new AssertionError((Object)sAXException);
        }
    }

    private void startPrefixMappingCalls() throws SAXException {
        int n2 = this.m_elemContext.get_firstNamespaceNode();
        if (n2 != -1) {
            int n3 = this.m_elemContext.get_lastNamespaceNode();
            for (int i = n2; i <= n3; ++i) {
                NamespaceMappings.MappingRecord mappingRecord = this.m_prefixMap.lookupNamespace(i);
                this.fContentHandler.startPrefixMapping(mappingRecord.get_prefix(), mappingRecord.get_uri());
            }
        }
    }

    private void endPrefixMappingCalls() throws SAXException {
        int n2 = this.m_elemContext.get_firstNamespaceNode();
        if (n2 != -1) {
            int n3 = this.m_elemContext.get_lastNamespaceNode();
            for (int i = n2; i <= n3; ++i) {
                NamespaceMappings.MappingRecord mappingRecord = this.m_prefixMap.lookupNamespace(i);
                this.fContentHandler.endPrefixMapping(mappingRecord.get_prefix());
            }
        }
    }

    protected void writeBracketClosingTag(VolatileCData volatileCData) throws IOException {
        this.writeSlashBracket();
    }

    protected void writeClosingTag(VolatileCData volatileCData) throws IOException {
        try {
            this.writeQName(volatileCData);
            this.fContentHandler.endElement(this.qName.uri, this.qName.localPart, this.qName.toString());
            this.endPrefixMappingCalls();
        }
        catch (SAXException sAXException) {
            throw new AssertionError((Object)sAXException);
        }
    }

    protected void writeSlashBracket() throws IOException {
        try {
            this.startPrefixMappingCalls();
            this.fContentHandler.startElement(this.m_elemContext.get_elemURI(), this.m_elemContext.get_elemLocalName(), this.m_elemContext.get_elemName(), this.fAttributes);
            this.fContentHandler.endElement(this.m_elemContext.get_elemURI(), this.m_elemContext.get_elemLocalName(), this.m_elemContext.get_elemName());
            this.endPrefixMappingCalls();
        }
        catch (SAXException sAXException) {
            throw new AssertionError((Object)sAXException);
        }
    }

    protected void writeQName(VolatileCData volatileCData) throws IOException {
        String string2 = volatileCData.getQNamePrefix(1);
        this.qName.prefix = string2 == null ? "" : string2;
        this.qName.localPart = volatileCData.getQNameLocalPart(1);
        this.qName.uri = volatileCData.getQNameNamespaceURI(1);
    }

    protected void writeAttribute(boolean bl, VolatileCData volatileCData, VolatileCData volatileCData2) throws IOException {
        this.writeQName(volatileCData);
        this.fAttributes.addAttribute(this.qName.uri, this.qName.localPart, this.qName.toString(), "CDATA", this.getStringValue(volatileCData2), 0);
    }

    protected void writeAttrNSDecl(int n2) throws IOException {
    }

    protected void writeValue(VolatileCData volatileCData) throws IOException {
        this.writeValue(this.getStringValue(volatileCData));
    }

    protected void writeValue(Chars chars) throws IOException {
        this.writeValue(((Object)chars).toString());
    }

    private void writeValue(String string2) {
        int n2 = string2.length();
        if (n2 > 0) {
            int n3;
            for (int i = 0; i < n2; i += n3) {
                n3 = this.getChars(string2, i, n2);
                try {
                    this.fContentHandler.characters(this.fCharBuffer, 0, n3);
                    continue;
                }
                catch (SAXException sAXException) {
                    throw new AssertionError((Object)sAXException);
                }
            }
        }
    }

    protected void writeBytes(byte[] byArray, int n2, int n3) throws IOException {
        String string2 = new String(byArray, n2, n3);
        if (n3 > 0) {
            int n4;
            for (int i = 0; i < n3; i += n4) {
                n4 = this.getChars(string2, i, n3);
                try {
                    this.fContentHandler.characters(this.fCharBuffer, 0, n4);
                    continue;
                }
                catch (SAXException sAXException) {
                    throw new AssertionError((Object)sAXException);
                }
            }
        }
    }

    private int getChars(String string2, int n2, int n3) {
        int n4;
        int n5 = n3 - n2;
        if (n5 <= 0) {
            n4 = 0;
        } else {
            char[] cArray = this.fCharBuffer;
            int n6 = cArray.length;
            if (n5 <= n6) {
                int n7 = n5 - 1;
                string2.getChars(n2, n3, cArray, 0);
                char c = cArray[n7];
                n4 = Encodings.isHighUTF16Surrogate(c) ? n7 : n5;
            } else {
                if (n6 != 65536) {
                    n6 = n5 * 2 + 1;
                    if (n6 > 65536) {
                        n6 = 65536;
                    }
                    this.fCharBuffer = cArray = new char[n6];
                }
                if (n6 < n5) {
                    n5 = n6;
                    n3 = n2 + n5;
                }
                int n8 = n5 - 1;
                string2.getChars(n2, n3, cArray, 0);
                char c = cArray[n8];
                n4 = Encodings.isHighUTF16Surrogate(c) ? n8 : n5;
            }
        }
        return n4;
    }

    private final String getStringValue(VolatileCData volatileCData) throws IOException {
        String string2;
        int n2 = volatileCData.getSize();
        XSSimpleTypeDefinition xSSimpleTypeDefinition = volatileCData.getXSTypeDefinition(1);
        String string3 = string2 = this.isQNameType(xSSimpleTypeDefinition) ? this.getQNameValueString(volatileCData, 1) : volatileCData.getString(1);
        if (n2 == 1) {
            return string2;
        }
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(string2);
        for (int i = 2; i <= n2; ++i) {
            xSSimpleTypeDefinition = volatileCData.getXSTypeDefinition(i);
            string2 = this.isQNameType(xSSimpleTypeDefinition) ? this.getQNameValueString(volatileCData, i) : volatileCData.getString(i);
            stringBuilder.append(" ");
            stringBuilder.append(string2);
        }
        return stringBuilder.toString();
    }

    private final String getQNameValueString(VolatileCData volatileCData, int n2) throws IOException {
        NamespaceMappings.MappingRecord mappingRecord;
        String string2 = volatileCData.getQNameNamespaceURI(n2);
        String string3 = volatileCData.getQNamePrefix(n2);
        String string4 = volatileCData.getQNameLocalPart(n2);
        boolean bl = string3 == null || string3.length() == 0;
        NamespaceMappings.MappingRecord mappingRecord2 = this.lookupPrefix(bl ? "" : string3);
        if (mappingRecord2 != null && mappingRecord2.get_uri().equals(string2 == null ? "" : string2)) {
            return bl ? string4 : string3 + ":" + string4;
        }
        if (!(string2 != null && string2.length() != 0 || bl || (mappingRecord = this.lookupPrefix("")) == null || mappingRecord.get_uri().length() != 0)) {
            return string4;
        }
        int n3 = this.toHandle(string2);
        if (n3 == -1) {
            return bl ? string4 : string3 + ":" + string4;
        }
        String string5 = this.getPrefixOfNSHandle(n3);
        return string5.length() == 0 ? string4 : string5 + ":" + string4;
    }

    private final boolean isQNameType(XSSimpleTypeDefinition xSSimpleTypeDefinition) {
        return xSSimpleTypeDefinition != null && xSSimpleTypeDefinition.derivedFromType(TypeRegistry.XSQNAME, (short)0);
    }

    private final void reportAddNamespaceNodeError(VolatileCData volatileCData, VolatileCData volatileCData2) {
        String string2 = volatileCData2.toString();
        String string3 = volatileCData == null ? "" : volatileCData.toString();
        String string4 = this.m_elemContext.get_elemName();
        if (string4 == null || string4.length() == 0) {
            string4 = this.m_elemContext.get_elemLocalName();
        }
        String string5 = string4 != null && string4.length() > 0 ? Messages.createMessage2("ER_SER_ILLEGAL_NAMESPACE_POSITION3", new String[]{string3, string2, string4}) : Messages.createMessage2("ER_SER_ILLEGAL_NAMESPACE_POSITION2", new String[]{string3, string2});
        Messages.illegalStateException(string5);
    }

    private class QName {
        public String prefix;
        public String localPart;
        public String uri;

        private QName() {
        }

        public void setValues(QName qName) {
            this.prefix = qName.prefix;
            this.localPart = qName.localPart;
            this.uri = qName.uri;
        }

        public String toString() {
            if (this.prefix.length() == 0) {
                return this.localPart;
            }
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append(this.prefix);
            stringBuilder.append(':');
            stringBuilder.append(this.localPart);
            return stringBuilder.toString();
        }
    }
}

