/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xml.xci.sax.serializer;

import com.ibm.xml.xci.errors.XCIIllegalArgumentException;
import java.util.HashMap;
import java.util.Map;
import org.xml.sax.Attributes;

public class AttributesImplSerializer
implements Attributes {
    private Map m_uri2LocalMap;
    private Map m_qName2Index;
    private static final int MAX = 12;
    private static final int MAXMinus1 = 11;
    private int m_numUsed = 0;
    private AttributeImpl[] m_data = new AttributeImpl[this.m_capacity];
    private static final int s_initialCapacity = 0;
    private int m_capacity = 0;

    public int getIndex(String string2) {
        int n2 = this.m_numUsed;
        if (n2 < 12) {
            for (int i = 0; i < n2; ++i) {
                if (!this.m_data[i].get_qName().equals(string2)) continue;
                return i;
            }
            return -1;
        }
        Integer n3 = (Integer)this.m_qName2Index.get(string2);
        int n4 = n3 == null ? -1 : n3;
        return n4;
    }

    public void addAttribute(String string2, String string3, String string4, String string5, String string6, int n2) {
        int n3 = this.m_numUsed++;
        this.ensureCapacity(n3 + 1);
        AttributeImpl attributeImpl = this.m_data[n3];
        attributeImpl.m_uri = string2;
        attributeImpl.m_localName = string3;
        attributeImpl.set_qName(string4);
        attributeImpl.m_type = string5;
        attributeImpl.set_value(string6);
        attributeImpl.set_flags(n2);
        if (n3 < 11) {
            return;
        }
        if (n3 == 11) {
            this.switchOverToHash(12);
        } else {
            Integer n4;
            if (attributeImpl.m_index == null) {
                n4 = n3;
                attributeImpl.m_index = n4;
            } else {
                n4 = attributeImpl.m_index;
            }
            this.m_qName2Index.put(string4, n4);
            HashMap<String, Integer> hashMap = (HashMap<String, Integer>)this.m_uri2LocalMap.get(string2);
            if (hashMap == null) {
                hashMap = new HashMap<String, Integer>();
                this.m_uri2LocalMap.put(string2, hashMap);
            }
            hashMap.put(string3, n4);
        }
    }

    private void switchOverToHash(int n2) {
        if (this.m_qName2Index == null) {
            this.m_qName2Index = new HashMap();
            this.m_uri2LocalMap = new HashMap();
        }
        for (int i = 0; i < n2; ++i) {
            Integer n3;
            AttributeImpl attributeImpl = this.m_data[i];
            if (attributeImpl.m_index != null) {
                n3 = attributeImpl.m_index;
            } else {
                n3 = i;
                attributeImpl.m_index = n3;
            }
            String string2 = attributeImpl.get_qName();
            this.m_qName2Index.put(string2, n3);
            String string3 = attributeImpl.m_uri;
            String string4 = attributeImpl.m_localName;
            HashMap<String, Integer> hashMap = (HashMap<String, Integer>)this.m_uri2LocalMap.get(string3);
            if (hashMap == null) {
                hashMap = new HashMap<String, Integer>();
                this.m_uri2LocalMap.put(string3, hashMap);
            }
            hashMap.put(string4, n3);
        }
    }

    public void clear() {
        if (12 <= this.m_numUsed) {
            this.m_qName2Index.clear();
            this.m_uri2LocalMap.clear();
        }
        this.m_numUsed = 0;
    }

    private void setAttributes(Attributes attributes2) {
        this.setAttributes2(attributes2);
        int n2 = attributes2.getLength();
        if (12 <= n2) {
            this.switchOverToHash(n2);
        }
    }

    public int getIndex(String string2, String string3) {
        Integer n2;
        int n3 = this.m_numUsed;
        if (n3 < 12) {
            for (int i = 0; i < n3; ++i) {
                if (!this.m_data[i].m_uri.equals(string2) || !this.m_data[i].m_localName.equals(string3)) continue;
                return i;
            }
            return -1;
        }
        Map map2 = (Map)this.m_uri2LocalMap.get(string2);
        int n4 = map2 == null ? -1 : ((n2 = (Integer)map2.get(string3)) == null ? -1 : n2);
        return n4;
    }

    public AttributesImplSerializer() {
    }

    private AttributesImplSerializer(Attributes attributes2) {
        this.setAttributes(attributes2);
    }

    public int getLength() {
        return this.m_numUsed;
    }

    public String getURI(int n2) {
        try {
            return this.m_data[n2].m_uri;
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            return null;
        }
    }

    public String getLocalName(int n2) {
        try {
            return this.m_data[n2].m_localName;
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            return null;
        }
    }

    public String getQName(int n2) {
        try {
            return this.m_data[n2].get_qName();
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            return null;
        }
    }

    public String getType(int n2) {
        try {
            return this.m_data[n2].m_type;
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            return null;
        }
    }

    public String getValue(int n2) {
        try {
            return this.m_data[n2].get_value();
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            return null;
        }
    }

    public String getType(String string2, String string3) {
        int n2 = this.m_numUsed;
        for (int i = 0; i < n2; ++i) {
            if (!this.m_data[i].m_uri.equals(string2) || !this.m_data[i].m_localName.equals(string3)) continue;
            return this.m_data[i].m_type;
        }
        return null;
    }

    public String getType(String string2) {
        int n2 = this.m_numUsed;
        for (int i = 0; i < n2; ++i) {
            if (!this.m_data[i].get_qName().equals(string2)) continue;
            return this.m_data[i].m_type;
        }
        return null;
    }

    public String getValue(String string2, String string3) {
        int n2 = this.m_numUsed;
        for (int i = 0; i < n2; ++i) {
            if (!this.m_data[i].m_uri.equals(string2) || !this.m_data[i].m_localName.equals(string3)) continue;
            return this.m_data[i].get_value();
        }
        return null;
    }

    public String getValue(String string2) {
        int n2 = this.m_numUsed;
        for (int i = 0; i < n2; ++i) {
            if (!this.m_data[i].get_qName().equals(string2)) continue;
            return this.m_data[i].get_value();
        }
        return null;
    }

    public AttributeImpl getAttribute(int n2) {
        try {
            return this.m_data[n2];
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            return null;
        }
    }

    private void setAttributes2(Attributes attributes2) {
        this.clear();
        int n2 = attributes2.getLength();
        this.ensureCapacity(n2 + 1);
        this.m_numUsed = attributes2.getLength();
        if (this.m_numUsed > 0) {
            this.m_data = new AttributeImpl[this.m_numUsed];
            for (int i = 0; i < this.m_numUsed; ++i) {
                AttributeImpl attributeImpl = this.m_data[i];
                attributeImpl.m_uri = attributes2.getURI(i);
                attributeImpl.m_localName = attributes2.getLocalName(i);
                attributeImpl.set_qName(attributes2.getQName(i));
                attributeImpl.m_type = attributes2.getType(i);
                attributeImpl.set_value(attributes2.getValue(i));
                attributeImpl.set_flags(0);
            }
        }
    }

    private void setAttribute(int n2, String string2, String string3, String string4, String string5, String string6) {
        if (n2 >= 0 && n2 < this.m_numUsed) {
            AttributeImpl attributeImpl = this.m_data[n2];
            attributeImpl.m_uri = string2;
            attributeImpl.m_localName = string3;
            attributeImpl.set_qName(string4);
            attributeImpl.m_type = string5;
            attributeImpl.set_value(string6);
        } else {
            this.indexOutOfBounds(n2);
        }
    }

    private void setURI(int n2, String string2) {
        if (n2 >= 0 && n2 < this.m_numUsed) {
            this.m_data[n2].m_uri = string2;
        } else {
            this.indexOutOfBounds(n2);
        }
    }

    private void setLocalName(int n2, String string2) {
        if (n2 >= 0 && n2 < this.m_numUsed) {
            this.m_data[n2].m_localName = string2;
        } else {
            this.indexOutOfBounds(n2);
        }
    }

    private void setQName(int n2, String string2) {
        if (n2 >= 0 && n2 < this.m_numUsed) {
            this.m_data[n2].set_qName(string2);
        } else {
            this.indexOutOfBounds(n2);
        }
    }

    private void setType(int n2, String string2) {
        if (n2 >= 0 && n2 < this.m_numUsed) {
            this.m_data[n2].m_type = string2;
        } else {
            this.indexOutOfBounds(n2);
        }
    }

    public void setValue(int n2, String string2) {
        if (n2 >= 0 && n2 < this.m_numUsed) {
            this.m_data[n2].set_value(string2);
        } else {
            this.indexOutOfBounds(n2);
        }
    }

    private void ensureCapacity(int n2) {
        if (this.m_capacity <= n2) {
            int n3 = n2 * 2 + 1;
            AttributeImpl[] attributeImplArray = new AttributeImpl[n3];
            if (0 < this.m_capacity) {
                System.arraycopy(this.m_data, 0, attributeImplArray, 0, this.m_capacity);
            }
            for (int i = this.m_capacity; i < n3; ++i) {
                attributeImplArray[i] = new AttributeImpl();
            }
            this.m_capacity = n3;
            this.m_data = attributeImplArray;
        }
    }

    private void indexOutOfBounds(int n2) throws ArrayIndexOutOfBoundsException {
        throw new XCIIllegalArgumentException("ER_ILLEGAL_INDEX", new String[]{Integer.toString(n2), this.getClass().getName()});
    }

    public class AttributeImpl {
        private String m_uri;
        private String m_localName;
        private String m_qName;
        private String m_type;
        private String m_value;
        private int m_flags;
        private Integer m_index;

        private AttributeImpl() {
        }

        public String toString() {
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append("Attribute: name '" + this.get_qName() + "', value '" + this.get_value() + "', optflags " + this.get_flags());
            return stringBuilder.toString();
        }

        public void set_flags(int n2) {
            this.m_flags = n2;
        }

        public int get_flags() {
            return this.m_flags;
        }

        public void set_qName(String string2) {
            this.m_qName = string2;
        }

        public String get_qName() {
            return this.m_qName;
        }

        public void set_value(String string2) {
            this.m_value = string2;
        }

        public String get_value() {
            return this.m_value;
        }
    }
}

