/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xml.xci.internal.values;

import com.ibm.xml.xci.VolatileCData;
import com.ibm.xml.xci.bytes.Bytes;
import com.ibm.xml.xci.dp.values.BaseCData;
import com.ibm.xml.xci.dp.values.chars.Chars;
import com.ibm.xml.xci.dp.values.chars.StringChars;
import com.ibm.xml.xci.internal.cast.CastJV2XMLGregorianCalendar;
import com.ibm.xml.xci.internal.values.Base64BinaryCData;
import com.ibm.xml.xci.internal.values.HexBinaryCData;
import com.ibm.xml.xci.res.XCIMessages;
import com.ibm.xml.xci.serializer.WriterToUTF8Buffered;
import com.ibm.xml.xci.type.TypeRegistry;
import com.ibm.xml.xml4j.api.s1.xs.XSSimpleTypeDefinition;
import java.io.IOException;
import java.io.OutputStream;
import java.io.Writer;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.net.URI;
import java.net.URISyntaxException;
import java.nio.charset.Charset;
import java.text.ParseException;
import javax.xml.datatype.Duration;
import javax.xml.datatype.XMLGregorianCalendar;
import javax.xml.namespace.NamespaceContext;
import javax.xml.namespace.QName;

public final class StringCData
extends BaseCData {
    static final String IBM_COPYRIGHT = "Licensed Materials - Property of IBM\n\nXML Cursor Interface for Java (XCI-J)\u00a9 Copyright IBM Corp. 2004, 2009. All Rights Reserved.\n\nUS Government Users Restricted Rights - Use, duplication or disclosure \nrestricted by GSA ADP Schedule Contract with IBM Corp.";
    protected final String string;

    public StringCData(CharSequence charSequence, XSSimpleTypeDefinition xSSimpleTypeDefinition) {
        super(xSSimpleTypeDefinition);
        this.string = StringChars.toString(charSequence);
    }

    public int writeTo(Writer writer, boolean bl) throws IOException {
        writer.write(this.string);
        return this.string.length();
    }

    public String toString() {
        return this.string;
    }

    public String getString(int n2) {
        if (n2 != 1) {
            throw new IndexOutOfBoundsException(XCIMessages.createXCIMessage("ER_POSITION_OUTOFRANGE1", null));
        }
        return this.string;
    }

    public Bytes getBase64Binary(int n2) {
        if (n2 != 1) {
            throw new IndexOutOfBoundsException(XCIMessages.createXCIMessage("ER_POSITION_OUTOFRANGE1", null));
        }
        return new Base64BinaryCData(this.string, TypeRegistry.XSBASE64BINARY).getBase64Binary(1);
    }

    public Bytes getHexBinary(int n2) {
        if (n2 != 1) {
            throw new IndexOutOfBoundsException(XCIMessages.createXCIMessage("ER_POSITION_OUTOFRANGE1", null));
        }
        return new HexBinaryCData(this.string, TypeRegistry.XSHEXBINARY).getHexBinary(1);
    }

    public void writeEncodedBytesTo(OutputStream outputStream, Charset charset, boolean bl) throws IOException {
        if (outputStream instanceof WriterToUTF8Buffered.AsOutputStream && charset != null && charset.name().equals("UTF-8")) {
            WriterToUTF8Buffered.AsOutputStream asOutputStream = (WriterToUTF8Buffered.AsOutputStream)outputStream;
            WriterToUTF8Buffered writerToUTF8Buffered = asOutputStream.getAssociatedWriter();
            writerToUTF8Buffered.write(this.getString(1));
            return;
        }
        if (charset == null) {
            outputStream.write(this.getString(1).getBytes());
        } else {
            outputStream.write(this.getString(1).getBytes(charset.name()));
        }
    }

    public String getQNameNamespaceURI(int n2) {
        return "";
    }

    public String getQNamePrefix(int n2) {
        return "";
    }

    public String getQNameLocalPart(int n2) {
        String string2 = this.getString(n2);
        return string2;
    }

    public BigDecimal getBigDecimal(int n2) {
        if (n2 != 1) {
            throw new IndexOutOfBoundsException(XCIMessages.createXCIMessage("ER_POSITION_OUTOFRANGE1", null));
        }
        return super.getBigDecimal(n2);
    }

    public BigInteger getBigInteger(int n2) {
        if (n2 != 1) {
            throw new IndexOutOfBoundsException(XCIMessages.createXCIMessage("ER_POSITION_OUTOFRANGE1", null));
        }
        return super.getBigInteger(n2);
    }

    public boolean getBoolean(int n2) {
        if (n2 != 1) {
            throw new IndexOutOfBoundsException(XCIMessages.createXCIMessage("ER_POSITION_OUTOFRANGE1", null));
        }
        return super.getBoolean(n2);
    }

    public byte getByte(int n2) {
        if (n2 != 1) {
            throw new IndexOutOfBoundsException(XCIMessages.createXCIMessage("ER_POSITION_OUTOFRANGE1", null));
        }
        return super.getByte(n2);
    }

    public double getDouble(int n2) {
        if (n2 != 1) {
            throw new IndexOutOfBoundsException(XCIMessages.createXCIMessage("ER_POSITION_OUTOFRANGE1", null));
        }
        return super.getDouble(n2);
    }

    public Duration getDuration(int n2) throws ParseException {
        if (n2 != 1) {
            throw new IndexOutOfBoundsException(XCIMessages.createXCIMessage("ER_POSITION_OUTOFRANGE1", null));
        }
        return super.getDuration(n2);
    }

    public float getFloat(int n2) {
        if (n2 != 1) {
            throw new IndexOutOfBoundsException(XCIMessages.createXCIMessage("ER_POSITION_OUTOFRANGE1", null));
        }
        return super.getFloat(n2);
    }

    public int getInt(int n2) {
        if (n2 != 1) {
            throw new IndexOutOfBoundsException(XCIMessages.createXCIMessage("ER_POSITION_OUTOFRANGE1", null));
        }
        return super.getInt(n2);
    }

    public long getLong(int n2) {
        if (n2 != 1) {
            throw new IndexOutOfBoundsException(XCIMessages.createXCIMessage("ER_POSITION_OUTOFRANGE1", null));
        }
        return super.getLong(n2);
    }

    public QName getQName(int n2, NamespaceContext namespaceContext) {
        if (n2 != 1) {
            throw new IndexOutOfBoundsException(XCIMessages.createXCIMessage("ER_POSITION_OUTOFRANGE1", null));
        }
        return super.getQName(n2, namespaceContext);
    }

    public short getShort(int n2) {
        if (n2 != 1) {
            throw new IndexOutOfBoundsException(XCIMessages.createXCIMessage("ER_POSITION_OUTOFRANGE1", null));
        }
        return super.getShort(n2);
    }

    public URI getURI(int n2) throws URISyntaxException {
        if (n2 != 1) {
            throw new IndexOutOfBoundsException(XCIMessages.createXCIMessage("ER_POSITION_OUTOFRANGE1", null));
        }
        return super.getURI(n2);
    }

    public String getURIString(int n2) {
        if (n2 != 1) {
            throw new IndexOutOfBoundsException(XCIMessages.createXCIMessage("ER_POSITION_OUTOFRANGE1", null));
        }
        return super.getURIString(n2);
    }

    public XMLGregorianCalendar getXMLGregorianCalendar(int n2) throws ParseException {
        if (n2 != 1) {
            throw new IndexOutOfBoundsException(XCIMessages.createXCIMessage("ER_POSITION_OUTOFRANGE1", null));
        }
        return CastJV2XMLGregorianCalendar.jVToXMLGregorianCalendar(this.string, null, false);
    }

    public Object getObject(int n2) {
        return this.string;
    }

    public CharSequence getOriginalLexicalValue() {
        return this.string;
    }

    public CharSequence lexicalValue() {
        return this.string;
    }

    public char charAt(int n2) {
        return this.string.charAt(n2);
    }

    public int length() {
        return this.string.length();
    }

    public char[] toCharArray() {
        return this.string.toCharArray();
    }

    public CharSequence subSequence(int n2, int n3) {
        return this.string.subSequence(n2, n3);
    }

    public CharSequence sequenceConstructSimpleContent(CharSequence charSequence, boolean bl, boolean bl2) {
        return this.string;
    }

    public VolatileCData itemStringValue() {
        return this;
    }

    public Chars itemStringValueAsChars() {
        return this;
    }
}

