/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xml.xci.internal.values;

import com.ibm.xml.xci.bytes.Bytes;
import com.ibm.xml.xci.errors.XCIDynamicErrorException;
import com.ibm.xml.xci.internal.cast.CastJV2String;
import com.ibm.xml.xci.internal.values.SimpleAsciiCData;
import com.ibm.xml.xci.res.XCIMessages;
import com.ibm.xml.xci.type.TypeRegistry;
import com.ibm.xml.xml4j.api.s1.xs.XSSimpleTypeDefinition;
import com.ibm.xml.xml4j.internal.s1.impl.dv.InvalidDatatypeValueException;
import java.math.BigDecimal;
import java.net.URI;
import java.net.URISyntaxException;
import java.text.ParseException;
import java.util.Iterator;
import javax.xml.datatype.Duration;
import javax.xml.datatype.XMLGregorianCalendar;
import javax.xml.namespace.NamespaceContext;
import javax.xml.namespace.QName;

public class StringBasedQNameCData
extends SimpleAsciiCData {
    static final String IBM_COPYRIGHT = "Licensed Materials - Property of IBM\n\nXML Cursor Interface for Java (XCI-J)\u00a9 Copyright IBM Corp. 2004, 2009. All Rights Reserved.\n\nUS Government Users Restricted Rights - Use, duplication or disclosure \nrestricted by GSA ADP Schedule Contract with IBM Corp.";
    protected String _prefix;
    protected String _localpart;
    protected String _nsuri;
    protected QName _qname;

    public StringBasedQNameCData(QName qName, XSSimpleTypeDefinition xSSimpleTypeDefinition) {
        this(null, qName.getPrefix(), qName.getLocalPart(), qName.getNamespaceURI(), xSSimpleTypeDefinition);
        this._qname = qName;
    }

    public StringBasedQNameCData(String string2, String string3, String string4, XSSimpleTypeDefinition xSSimpleTypeDefinition) {
        this(null, string2, string3, string4, xSSimpleTypeDefinition);
    }

    public StringBasedQNameCData(String string2, XSSimpleTypeDefinition xSSimpleTypeDefinition) {
        this(null, null, string2, null, xSSimpleTypeDefinition);
    }

    protected StringBasedQNameCData(NamespaceContext namespaceContext, String string2, String string3, String string4, XSSimpleTypeDefinition xSSimpleTypeDefinition) {
        super(xSSimpleTypeDefinition);
        this._nsuri = string4;
        this._prefix = string2;
        this._localpart = string3;
        if (this._nsuri != null && !"".equals(string4)) {
            if (string2 == null) {
                this._prefix = namespaceContext.getPrefix(string4);
            } else {
                boolean bl = false;
                Iterator<String> iterator = namespaceContext.getPrefixes(string4);
                while (!bl && iterator.hasNext()) {
                    String string5 = iterator.next();
                    if (!string5.equals(string2)) continue;
                    bl = true;
                }
                assert (bl) : "Cannot find a suitable prefix for the namespace " + string4;
            }
        }
    }

    public QName getQName(int n2, NamespaceContext namespaceContext) {
        if (n2 != 1) {
            throw new IndexOutOfBoundsException(XCIMessages.createXCIMessage("ER_POSITION_OUTOFRANGE1", null));
        }
        return this.getQName();
    }

    public String getQNameLocalPart(int n2) {
        if (n2 != 1) {
            throw new IndexOutOfBoundsException(XCIMessages.createXCIMessage("ER_POSITION_OUTOFRANGE1", null));
        }
        return this._localpart;
    }

    public String getQNameNamespaceURI(int n2) {
        if (n2 != 1) {
            throw new IndexOutOfBoundsException(XCIMessages.createXCIMessage("ER_POSITION_OUTOFRANGE1", null));
        }
        return this._nsuri;
    }

    public String getQNamePrefix(int n2) {
        if (n2 != 1) {
            throw new IndexOutOfBoundsException(XCIMessages.createXCIMessage("ER_POSITION_OUTOFRANGE1", null));
        }
        return this._prefix;
    }

    public boolean equals(Object object2) {
        if (object2 == this) {
            return true;
        }
        if (object2 instanceof StringBasedQNameCData) {
            StringBasedQNameCData stringBasedQNameCData = (StringBasedQNameCData)object2;
            return (this._nsuri == stringBasedQNameCData._nsuri || this._nsuri == null && "".equals(stringBasedQNameCData._nsuri) || stringBasedQNameCData._nsuri == null && "".equals(this._nsuri) || this._nsuri.equals(stringBasedQNameCData._nsuri)) && this._localpart.equals(stringBasedQNameCData._localpart);
        }
        return false;
    }

    public String toString() {
        return this._prefix == null || "".equals(this._prefix) ? this._localpart : this._prefix + ":" + this._localpart;
    }

    public String getString(int n2) {
        if (n2 != 1) {
            throw new IndexOutOfBoundsException(XCIMessages.createXCIMessage("ER_POSITION_OUTOFRANGE1", null));
        }
        try {
            return CastJV2String.jVToString(this.toString(), TypeRegistry.XSSTRING, false);
        }
        catch (InvalidDatatypeValueException invalidDatatypeValueException) {
            throw new XCIDynamicErrorException(invalidDatatypeValueException);
        }
    }

    protected QName getQName() {
        if (null == this._qname) {
            this._qname = new QName(this._nsuri, this._localpart, this._prefix);
        }
        return this._qname;
    }

    public Bytes getBase64Binary(int n2) {
        return super.getBase64Binary(n2);
    }

    public BigDecimal getBigDecimal(int n2) {
        throw new XCIDynamicErrorException("ER_INVALID_CAST", new String[]{this.getXSTypeDefinition().toString(), TypeRegistry.XSDECIMAL.toString()});
    }

    public boolean getBoolean(int n2) {
        throw new XCIDynamicErrorException("ER_INVALID_CAST", new String[]{this.getXSTypeDefinition().toString(), TypeRegistry.XSBOOLEAN.toString()});
    }

    public byte getByte(int n2) {
        throw new XCIDynamicErrorException("ER_INVALID_CAST", new String[]{this.getXSTypeDefinition().toString(), TypeRegistry.XSBYTE.toString()});
    }

    public double getDouble(int n2) {
        throw new XCIDynamicErrorException("ER_INVALID_CAST", new String[]{this.getXSTypeDefinition().toString(), TypeRegistry.XSDOUBLE.toString()});
    }

    public Duration getDuration(int n2) throws ParseException {
        throw new XCIDynamicErrorException("ER_INVALID_CAST", new String[]{this.getXSTypeDefinition().toString(), TypeRegistry.XSDURATION.toString()});
    }

    public float getFloat(int n2) {
        throw new XCIDynamicErrorException("ER_INVALID_CAST", new String[]{this.getXSTypeDefinition().toString(), TypeRegistry.XSFLOAT.toString()});
    }

    public int getInt(int n2) {
        throw new XCIDynamicErrorException("ER_INVALID_CAST", new String[]{this.getXSTypeDefinition().toString(), TypeRegistry.XSINT.toString()});
    }

    public long getLong(int n2) {
        throw new XCIDynamicErrorException("ER_INVALID_CAST", new String[]{this.getXSTypeDefinition().toString(), TypeRegistry.XSLONG.toString()});
    }

    public short getShort(int n2) {
        throw new XCIDynamicErrorException("ER_INVALID_CAST", new String[]{this.getXSTypeDefinition().toString(), TypeRegistry.XSSHORT.toString()});
    }

    public URI getURI(int n2) throws URISyntaxException {
        throw new XCIDynamicErrorException("ER_INVALID_CAST", new String[]{this.getXSTypeDefinition().toString(), TypeRegistry.XSANYURI.toString()});
    }

    public String getURIString(int n2) {
        throw new XCIDynamicErrorException("ER_INVALID_CAST", new String[]{this.getXSTypeDefinition().toString(), TypeRegistry.XSANYURI.toString()});
    }

    public XMLGregorianCalendar getXMLGregorianCalendar(int n2) throws ParseException {
        throw new XCIDynamicErrorException("ER_INVALID_CAST", new String[]{this.getXSTypeDefinition().toString(), TypeRegistry.XSQNAME.toString()});
    }

    public Bytes getHexBinary(int n2) {
        throw new XCIDynamicErrorException("ER_INVALID_CAST", new String[]{this.getXSTypeDefinition().toString(), TypeRegistry.XSHEXBINARY.toString()});
    }

    public Object getObject(int n2) {
        return this.getQName();
    }
}

