/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xml.xci.internal.values;

import com.ibm.xml.xci.CData;
import com.ibm.xml.xci.bytes.Bytes;
import com.ibm.xml.xci.errors.XCIDynamicErrorException;
import com.ibm.xml.xci.internal.cast.CastJV2String;
import com.ibm.xml.xci.internal.values.SimpleAsciiCData;
import com.ibm.xml.xci.res.XCIMessages;
import com.ibm.xml.xci.type.TypeRegistry;
import com.ibm.xml.xml4j.api.s1.xs.XSSimpleTypeDefinition;
import com.ibm.xml.xml4j.internal.s1.impl.dv.InvalidDatatypeValueException;
import java.math.BigDecimal;
import java.net.URI;
import java.net.URISyntaxException;
import java.text.ParseException;
import java.util.Iterator;
import javax.xml.datatype.Duration;
import javax.xml.datatype.XMLGregorianCalendar;
import javax.xml.namespace.NamespaceContext;
import javax.xml.namespace.QName;

public class QNameCData
extends SimpleAsciiCData {
    static final String IBM_COPYRIGHT = "Licensed Materials - Property of IBM\n\nXML Cursor Interface for Java (XCI-J)\u00a9 Copyright IBM Corp. 2004, 2009. All Rights Reserved.\n\nUS Government Users Restricted Rights - Use, duplication or disclosure \nrestricted by GSA ADP Schedule Contract with IBM Corp.";
    protected QName name;

    public QNameCData(QName qName, XSSimpleTypeDefinition xSSimpleTypeDefinition) {
        super(xSSimpleTypeDefinition);
        this.name = qName;
    }

    protected QNameCData(NamespaceContext namespaceContext, QName qName, XSSimpleTypeDefinition xSSimpleTypeDefinition) {
        super(xSSimpleTypeDefinition);
        this.name = qName;
        String string2 = qName.getNamespaceURI();
        String string3 = qName.getPrefix();
        if (string2 != null && !"".equals(string2)) {
            if (string3 == null) {
                string3 = namespaceContext.getPrefix(string2);
            } else {
                boolean bl = false;
                Iterator<String> iterator = namespaceContext.getPrefixes(string2);
                while (!bl && iterator.hasNext()) {
                    String string4 = iterator.next();
                    if (!string4.equals(string3)) continue;
                    bl = true;
                }
                assert (bl) : "Cannot find a suitable prefix for the namespace " + string2;
            }
        }
    }

    public QName getQName(int n2, NamespaceContext namespaceContext) {
        if (n2 != 1) {
            throw new IndexOutOfBoundsException(XCIMessages.createXCIMessage("ER_POSITION_OUTOFRANGE1", null));
        }
        return this.name;
    }

    public String getQNameLocalPart(int n2) {
        if (n2 != 1) {
            throw new IndexOutOfBoundsException(XCIMessages.createXCIMessage("ER_POSITION_OUTOFRANGE1", null));
        }
        return this.name.getLocalPart();
    }

    public String getQNameNamespaceURI(int n2) {
        if (n2 != 1) {
            throw new IndexOutOfBoundsException(XCIMessages.createXCIMessage("ER_POSITION_OUTOFRANGE1", null));
        }
        return this.name.getNamespaceURI();
    }

    public String getQNamePrefix(int n2) {
        if (n2 != 1) {
            throw new IndexOutOfBoundsException(XCIMessages.createXCIMessage("ER_POSITION_OUTOFRANGE1", null));
        }
        return this.name.getPrefix();
    }

    public boolean equals(Object object2) {
        if (object2 == this) {
            return true;
        }
        if (QNameCData.class == object2.getClass()) {
            return this.name.equals(((QNameCData)object2).name);
        }
        if (object2 instanceof QNameCData) {
            return this.name.equals(((QNameCData)object2).getQName());
        }
        if (object2 instanceof CData) {
            CData cData = (CData)object2;
            try {
                return cData.getQNameLocalPart(1).equals(this.name.getLocalPart()) && cData.getQNameNamespaceURI(1).equals(this.name.getNamespaceURI());
            }
            catch (Exception exception) {
                return false;
            }
        }
        return false;
    }

    public String toString() {
        String string2 = this.name.getPrefix();
        return string2 == null || "".equals(string2) ? this.name.getLocalPart() : string2 + ":" + this.name.getLocalPart();
    }

    public String getString(int n2) {
        if (n2 != 1) {
            throw new IndexOutOfBoundsException(XCIMessages.createXCIMessage("ER_POSITION_OUTOFRANGE1", null));
        }
        try {
            return CastJV2String.jVToString(this.name, TypeRegistry.XSSTRING, false);
        }
        catch (InvalidDatatypeValueException invalidDatatypeValueException) {
            throw new XCIDynamicErrorException(invalidDatatypeValueException);
        }
    }

    protected QName getQName() {
        return this.name;
    }

    public Bytes getBase64Binary(int n2) {
        return super.getBase64Binary(n2);
    }

    public BigDecimal getBigDecimal(int n2) {
        throw new XCIDynamicErrorException("ER_INVALID_CAST", new String[]{this.getXSTypeDefinition().toString(), TypeRegistry.XSDECIMAL.toString()});
    }

    public boolean getBoolean(int n2) {
        throw new XCIDynamicErrorException("ER_INVALID_CAST", new String[]{this.getXSTypeDefinition().toString(), TypeRegistry.XSBOOLEAN.toString()});
    }

    public byte getByte(int n2) {
        throw new XCIDynamicErrorException("ER_INVALID_CAST", new String[]{this.getXSTypeDefinition().toString(), TypeRegistry.XSBYTE.toString()});
    }

    public double getDouble(int n2) {
        throw new XCIDynamicErrorException("ER_INVALID_CAST", new String[]{this.getXSTypeDefinition().toString(), TypeRegistry.XSDOUBLE.toString()});
    }

    public Duration getDuration(int n2) throws ParseException {
        throw new XCIDynamicErrorException("ER_INVALID_CAST", new String[]{this.getXSTypeDefinition().toString(), TypeRegistry.XSDURATION.toString()});
    }

    public float getFloat(int n2) {
        throw new XCIDynamicErrorException("ER_INVALID_CAST", new String[]{this.getXSTypeDefinition().toString(), TypeRegistry.XSFLOAT.toString()});
    }

    public int getInt(int n2) {
        throw new XCIDynamicErrorException("ER_INVALID_CAST", new String[]{this.getXSTypeDefinition().toString(), TypeRegistry.XSINT.toString()});
    }

    public long getLong(int n2) {
        throw new XCIDynamicErrorException("ER_INVALID_CAST", new String[]{this.getXSTypeDefinition().toString(), TypeRegistry.XSLONG.toString()});
    }

    public short getShort(int n2) {
        throw new XCIDynamicErrorException("ER_INVALID_CAST", new String[]{this.getXSTypeDefinition().toString(), TypeRegistry.XSSHORT.toString()});
    }

    public URI getURI(int n2) throws URISyntaxException {
        throw new XCIDynamicErrorException("ER_INVALID_CAST", new String[]{this.getXSTypeDefinition().toString(), TypeRegistry.XSANYURI.toString()});
    }

    public String getURIString(int n2) {
        throw new XCIDynamicErrorException("ER_INVALID_CAST", new String[]{this.getXSTypeDefinition().toString(), TypeRegistry.XSANYURI.toString()});
    }

    public XMLGregorianCalendar getXMLGregorianCalendar(int n2) throws ParseException {
        throw new XCIDynamicErrorException("ER_INVALID_CAST", new String[]{this.getXSTypeDefinition().toString(), TypeRegistry.XSQNAME.toString()});
    }

    public Bytes getHexBinary(int n2) {
        throw new XCIDynamicErrorException("ER_INVALID_CAST", new String[]{this.getXSTypeDefinition().toString(), TypeRegistry.XSHEXBINARY.toString()});
    }

    public Object getObject(int n2) {
        return this.name;
    }

    public CharSequence sequenceConstructSimpleContent(CharSequence charSequence, boolean bl, boolean bl2) {
        return this.getString(1);
    }

    public boolean isEmpty() {
        return false;
    }
}

