/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xml.xci.internal.values;

import com.ibm.xml.xci.bytes.Bytes;
import com.ibm.xml.xci.dp.type.TypeHelper;
import com.ibm.xml.xci.errors.XCIDynamicErrorException;
import com.ibm.xml.xci.internal.cast.CastJV2Double;
import com.ibm.xml.xci.internal.cast.CastJV2Float;
import com.ibm.xml.xci.internal.cast.CastJV2String;
import com.ibm.xml.xci.internal.values.SimpleAsciiCData;
import com.ibm.xml.xci.res.XCIMessages;
import com.ibm.xml.xci.type.TypeRegistry;
import com.ibm.xml.xml4j.api.s1.xs.XSSimpleTypeDefinition;
import com.ibm.xml.xml4j.internal.s1.impl.dv.InvalidDatatypeValueException;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.net.URI;
import java.net.URISyntaxException;
import java.text.ParseException;
import javax.xml.datatype.Duration;
import javax.xml.datatype.XMLGregorianCalendar;
import javax.xml.namespace.NamespaceContext;
import javax.xml.namespace.QName;

public class IntCData
extends SimpleAsciiCData {
    static final String IBM_COPYRIGHT = "Licensed Materials - Property of IBM\n\nXML Cursor Interface for Java (XCI-J)\u00a9 Copyright IBM Corp. 2004, 2009. All Rights Reserved.\n\nUS Government Users Restricted Rights - Use, duplication or disclosure \nrestricted by GSA ADP Schedule Contract with IBM Corp.";
    private static final IntCData[] table = new IntCData[256];
    protected final int integer;

    public static IntCData toInt(int n2, XSSimpleTypeDefinition xSSimpleTypeDefinition) {
        if (n2 > -128 && n2 < 128 && TypeHelper.isEqualToBuiltInType(xSSimpleTypeDefinition, TypeRegistry.XSINT)) {
            int n3 = n2 + 128;
            IntCData intCData = table[n3];
            if (intCData == null) {
                IntCData.table[n3] = intCData = new IntCData(n2, xSSimpleTypeDefinition);
            }
            return intCData;
        }
        return new IntCData(n2, xSSimpleTypeDefinition);
    }

    public IntCData(int n2, XSSimpleTypeDefinition xSSimpleTypeDefinition) {
        super(xSSimpleTypeDefinition);
        this.integer = n2;
    }

    public boolean getBoolean(int n2) {
        if (n2 != 1) {
            throw new IndexOutOfBoundsException(XCIMessages.createXCIMessage("ER_POSITION_OUTOFRANGE1", null));
        }
        return this.integer != 0;
    }

    public byte getByte(int n2) {
        if (n2 != 1) {
            throw new IndexOutOfBoundsException(XCIMessages.createXCIMessage("ER_POSITION_OUTOFRANGE1", null));
        }
        if (this.integer <= 127 && this.integer >= -128) {
            return (byte)this.integer;
        }
        throw new XCIDynamicErrorException(XCIMessages.createXCIMessage("ER_INVALID_CAST_DERIVED", new String[]{this.getXSTypeDefinition().toString(), TypeRegistry.XSBYTE.toString()}));
    }

    public short getShort(int n2) {
        if (n2 != 1) {
            throw new IndexOutOfBoundsException(XCIMessages.createXCIMessage("ER_POSITION_OUTOFRANGE1", null));
        }
        if (this.integer <= Short.MAX_VALUE && this.integer >= Short.MIN_VALUE) {
            return (short)this.integer;
        }
        throw new XCIDynamicErrorException(XCIMessages.createXCIMessage("ER_INVALID_CAST_DERIVED", new String[]{this.getXSTypeDefinition().toString(), TypeRegistry.XSSHORT.toString()}));
    }

    public int getInt(int n2) {
        if (n2 != 1) {
            throw new IndexOutOfBoundsException(XCIMessages.createXCIMessage("ER_POSITION_OUTOFRANGE1", null));
        }
        return this.integer;
    }

    public long getLong(int n2) {
        if (n2 != 1) {
            throw new IndexOutOfBoundsException(XCIMessages.createXCIMessage("ER_POSITION_OUTOFRANGE1", null));
        }
        return this.integer;
    }

    public BigInteger getBigInteger(int n2) {
        if (n2 != 1) {
            throw new IndexOutOfBoundsException(XCIMessages.createXCIMessage("ER_POSITION_OUTOFRANGE1", null));
        }
        return BigInteger.valueOf(this.integer);
    }

    public BigDecimal getBigDecimal(int n2) {
        if (n2 != 1) {
            throw new IndexOutOfBoundsException(XCIMessages.createXCIMessage("ER_POSITION_OUTOFRANGE1", null));
        }
        return BigDecimal.valueOf(this.integer);
    }

    public float getFloat(int n2) {
        if (n2 != 1) {
            throw new IndexOutOfBoundsException(XCIMessages.createXCIMessage("ER_POSITION_OUTOFRANGE1", null));
        }
        try {
            return CastJV2Float.jVToFloat(this.integer, TypeRegistry.XSFLOAT, false);
        }
        catch (InvalidDatatypeValueException invalidDatatypeValueException) {
            throw new XCIDynamicErrorException(invalidDatatypeValueException);
        }
    }

    public double getDouble(int n2) {
        if (n2 != 1) {
            throw new IndexOutOfBoundsException(XCIMessages.createXCIMessage("ER_POSITION_OUTOFRANGE1", null));
        }
        try {
            return CastJV2Double.jVToDouble(this.integer, TypeRegistry.XSDOUBLE, false);
        }
        catch (InvalidDatatypeValueException invalidDatatypeValueException) {
            throw new XCIDynamicErrorException(invalidDatatypeValueException);
        }
    }

    public XMLGregorianCalendar getXMLGregorianCalendar(int n2) throws ParseException {
        throw new XCIDynamicErrorException("ER_INVALID_CAST", new String[]{this.getXSTypeDefinition().toString(), TypeRegistry.XSDATETIME.toString()});
    }

    public int hashCode() {
        return this.integer;
    }

    public boolean equals(Object object2) {
        if (object2 != null && object2 instanceof IntCData) {
            return this.integer == ((IntCData)object2).integer;
        }
        return super.equals(object2);
    }

    public String toString() {
        return Long.toString(this.integer);
    }

    public String getString(int n2) {
        if (n2 != 1) {
            throw new IndexOutOfBoundsException(XCIMessages.createXCIMessage("ER_POSITION_OUTOFRANGE1", null));
        }
        try {
            return CastJV2String.jVToString(this.integer, TypeRegistry.XSSTRING, false);
        }
        catch (InvalidDatatypeValueException invalidDatatypeValueException) {
            throw new XCIDynamicErrorException(invalidDatatypeValueException);
        }
    }

    public Bytes getBase64Binary(int n2) {
        throw new XCIDynamicErrorException("ER_INVALID_CAST", new String[]{this.getXSTypeDefinition().toString(), TypeRegistry.XSBASE64BINARY.toString()});
    }

    public Duration getDuration(int n2) throws ParseException {
        throw new XCIDynamicErrorException("ER_INVALID_CAST", new String[]{this.getXSTypeDefinition().toString(), TypeRegistry.XSDURATION.toString()});
    }

    public Bytes getHexBinary(int n2) {
        throw new XCIDynamicErrorException("ER_INVALID_CAST", new String[]{this.getXSTypeDefinition().toString(), TypeRegistry.XSHEXBINARY.toString()});
    }

    public QName getQName(int n2, NamespaceContext namespaceContext) {
        throw new XCIDynamicErrorException("ER_INVALID_CAST", new String[]{this.getXSTypeDefinition().toString(), TypeRegistry.XSQNAME.toString()});
    }

    public URI getURI(int n2) throws URISyntaxException {
        throw new XCIDynamicErrorException("ER_INVALID_CAST", new String[]{this.getXSTypeDefinition().toString(), TypeRegistry.XSANYURI.toString()});
    }

    public String getURIString(int n2) {
        throw new XCIDynamicErrorException("ER_INVALID_CAST", new String[]{this.getXSTypeDefinition().toString(), TypeRegistry.XSANYURI.toString()});
    }

    public XSSimpleTypeDefinition getXSTypeDefinition() {
        return super.getXSTypeDefinition();
    }

    public Object getObject(int n2) {
        return this.integer;
    }

    public CharSequence sequenceConstructSimpleContent(CharSequence charSequence, boolean bl, boolean bl2) {
        return this.getString(1);
    }

    public boolean isEmpty() {
        return false;
    }
}

