/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xml.xci.internal.values;

import com.ibm.xml.xci.bytes.Bytes;
import com.ibm.xml.xci.bytes.BytesUtils;
import com.ibm.xml.xci.dp.values.chars.StringChars;
import com.ibm.xml.xci.errors.XCIDynamicErrorException;
import com.ibm.xml.xci.internal.values.SimpleAsciiCData;
import com.ibm.xml.xci.res.XCIMessages;
import com.ibm.xml.xci.type.TypeRegistry;
import com.ibm.xml.xml4j.api.s1.xs.XSSimpleTypeDefinition;
import com.ibm.xml.xml4j.internal.s1.impl.dv.util.HexBin;
import java.io.IOException;
import java.io.Writer;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.net.URI;
import java.net.URISyntaxException;
import java.text.ParseException;
import java.util.Locale;
import javax.xml.datatype.Duration;
import javax.xml.datatype.XMLGregorianCalendar;
import javax.xml.namespace.NamespaceContext;
import javax.xml.namespace.QName;

public class HexBinaryCData
extends SimpleAsciiCData {
    static final String IBM_COPYRIGHT = "Licensed Materials - Property of IBM\n\nXML Cursor Interface for Java (XCI-J)\u00a9 Copyright IBM Corp. 2004, 2009. All Rights Reserved.\n\nUS Government Users Restricted Rights - Use, duplication or disclosure \nrestricted by GSA ADP Schedule Contract with IBM Corp.";
    private static final char[] HEXDIGIT = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'A', 'B', 'C', 'D', 'E', 'F'};
    private final Bytes bytes;
    private String text;

    public HexBinaryCData(Bytes bytes2, XSSimpleTypeDefinition xSSimpleTypeDefinition) {
        super(xSSimpleTypeDefinition);
        this.bytes = bytes2;
        this.text = null;
    }

    public HexBinaryCData(CharSequence charSequence, XSSimpleTypeDefinition xSSimpleTypeDefinition) {
        super(xSSimpleTypeDefinition);
        String string2 = StringChars.toString(charSequence);
        this.text = string2.toUpperCase(Locale.ENGLISH);
        byte[] byArray = HexBin.decode(this.text);
        if (byArray == null) {
            throw new XCIDynamicErrorException("ER_INVALID_HEXBINARY", new String[]{string2});
        }
        this.bytes = BytesUtils.make(byArray);
    }

    public BigInteger getBigInteger(int n2) {
        throw new XCIDynamicErrorException("ER_INVALID_CAST", new String[]{this.getXSTypeDefinition().toString(), TypeRegistry.XSINTEGER.toString()});
    }

    public Bytes getHexBinary(int n2) {
        if (n2 != 1) {
            throw new IndexOutOfBoundsException(XCIMessages.createXCIMessage("ER_POSITION_OUTOFRANGE1", null));
        }
        return this.bytes;
    }

    public String toString() {
        if (this.text == null) {
            this.text = HexBin.encode(this.bytes.toByteArray(false)).toUpperCase(Locale.ENGLISH);
        }
        return this.text;
    }

    public boolean hasCharAt(int n2) {
        if (this.text != null) {
            return 0 <= n2 && n2 < this.text.length();
        }
        return this.bytes.hasByteAt(n2 / 2);
    }

    public CharSequence subSequence(int n2) {
        if (this.text != null) {
            return this.text.subSequence(n2, this.text.length());
        }
        if (n2 % 2 == 0) {
            return new HexBinaryCData(this.bytes.byteSubSequence(n2 >> 1), this.xstype);
        }
        String string2 = this.toString();
        return string2.subSequence(n2, string2.length());
    }

    public int writeTo(Writer writer, boolean bl) throws IOException {
        if (this.text != null) {
            writer.write(this.text);
            return this.text.length();
        }
        this.text = HexBin.encode(this.bytes.toByteArray(false)).toUpperCase(Locale.ENGLISH);
        writer.write(this.text);
        return this.text.length();
    }

    public char charAt(int n2) {
        if (this.text != null) {
            return this.text.charAt(n2);
        }
        int n3 = this.bytes.byteAt(n2 / 2);
        if (n3 < 0) {
            n3 += 256;
        }
        return HEXDIGIT[(n2 & 1) == 0 ? n3 >> 4 : n3 & 0xF];
    }

    public int length() {
        if (this.text != null) {
            return this.text.length();
        }
        return (int)this.bytes.byteLength() * 2;
    }

    public CharSequence subSequence(int n2, int n3) {
        if (this.text != null) {
            return this.text.subSequence(n2, n3);
        }
        if (n2 % 2 == 0 && n3 % 2 == 0) {
            return new HexBinaryCData(this.bytes.byteSubSequence(n2 / 2, n3 / 2), this.xstype);
        }
        return this.toString().subSequence(n2, n3);
    }

    public String getString(int n2) {
        if (n2 != 1) {
            throw new IndexOutOfBoundsException(XCIMessages.createXCIMessage("ER_POSITION_OUTOFRANGE1", null));
        }
        return this.toString();
    }

    public Bytes getBase64Binary(int n2) {
        if (n2 != 1) {
            throw new IndexOutOfBoundsException(XCIMessages.createXCIMessage("ER_POSITION_OUTOFRANGE1", null));
        }
        return this.bytes;
    }

    public BigDecimal getBigDecimal(int n2) {
        throw new XCIDynamicErrorException("ER_INVALID_CAST", new String[]{this.getXSTypeDefinition().toString(), TypeRegistry.XSDECIMAL.toString()});
    }

    public boolean getBoolean(int n2) {
        throw new XCIDynamicErrorException("ER_INVALID_CAST", new String[]{this.getXSTypeDefinition().toString(), TypeRegistry.XSBOOLEAN.toString()});
    }

    public byte getByte(int n2) {
        throw new XCIDynamicErrorException("ER_INVALID_CAST", new String[]{this.getXSTypeDefinition().toString(), TypeRegistry.XSBYTE.toString()});
    }

    public double getDouble(int n2) {
        throw new XCIDynamicErrorException("ER_INVALID_CAST", new String[]{this.getXSTypeDefinition().toString(), TypeRegistry.XSDOUBLE.toString()});
    }

    public Duration getDuration(int n2) throws ParseException {
        throw new XCIDynamicErrorException("ER_INVALID_CAST", new String[]{this.getXSTypeDefinition().toString(), TypeRegistry.XSDURATION.toString()});
    }

    public float getFloat(int n2) {
        throw new XCIDynamicErrorException("ER_INVALID_CAST", new String[]{this.getXSTypeDefinition().toString(), TypeRegistry.XSFLOAT.toString()});
    }

    public int getInt(int n2) {
        throw new XCIDynamicErrorException("ER_INVALID_CAST", new String[]{this.getXSTypeDefinition().toString(), TypeRegistry.XSINT.toString()});
    }

    public long getLong(int n2) {
        throw new XCIDynamicErrorException("ER_INVALID_CAST", new String[]{this.getXSTypeDefinition().toString(), TypeRegistry.XSLONG.toString()});
    }

    public QName getQName(int n2, NamespaceContext namespaceContext) {
        throw new XCIDynamicErrorException("ER_INVALID_CAST", new String[]{this.getXSTypeDefinition().toString(), TypeRegistry.XSQNAME.toString()});
    }

    public short getShort(int n2) {
        throw new XCIDynamicErrorException("ER_INVALID_CAST", new String[]{this.getXSTypeDefinition().toString(), TypeRegistry.XSSHORT.toString()});
    }

    public URI getURI(int n2) throws URISyntaxException {
        throw new XCIDynamicErrorException("ER_INVALID_CAST", new String[]{this.getXSTypeDefinition().toString(), TypeRegistry.XSANYURI.toString()});
    }

    public String getURIString(int n2) {
        throw new XCIDynamicErrorException("ER_INVALID_CAST", new String[]{this.getXSTypeDefinition().toString(), TypeRegistry.XSANYURI.toString()});
    }

    public XMLGregorianCalendar getXMLGregorianCalendar(int n2) throws ParseException {
        throw new XCIDynamicErrorException("ER_INVALID_CAST", new String[]{this.getXSTypeDefinition().toString(), TypeRegistry.XSQNAME.toString()});
    }

    public Object getObject(int n2) {
        return this.bytes;
    }

    public CharSequence sequenceConstructSimpleContent(CharSequence charSequence, boolean bl, boolean bl2) {
        return this.getString(1);
    }

    public boolean isEmpty() {
        return this.length() == 0;
    }
}

