/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xml.xci.internal.util.xml;

import com.ibm.xml.xci.Cursor;
import com.ibm.xml.xci.CursorFactory;
import com.ibm.xml.xci.DocumentInfo;
import com.ibm.xml.xci.ExtendedNamespaceContext;
import com.ibm.xml.xci.SessionContext;
import com.ibm.xml.xci.VolatileCData;
import com.ibm.xml.xci.dp.util.XCIXpathGenerator;
import com.ibm.xml.xci.dp.util.copy.Copier;
import com.ibm.xml.xci.errors.XCIDynamicErrorException;
import com.ibm.xml.xci.internal.util.resources.XSDGrammarResource;
import com.ibm.xml.xci.internal.util.xml.XCIAttributePSVI;
import com.ibm.xml.xci.internal.util.xml.XCIElementPSVI;
import com.ibm.xml.xci.internal.util.xml.XCIValidationContext;
import com.ibm.xml.xci.sax.serializer.CursorContext;
import com.ibm.xml.xci.sax.serializer.SAXCursor;
import com.ibm.xml.xml4j.api.s1.xs.AttributePSVI;
import com.ibm.xml.xml4j.api.s1.xs.ElementPSVI;
import com.ibm.xml.xml4j.api.s1.xs.PSVIProvider;
import com.ibm.xml.xml4j.api.s1.xs.StringList;
import com.ibm.xml.xml4j.api.s1.xs.XSAttributeDeclaration;
import com.ibm.xml.xml4j.api.s1.xs.XSElementDeclaration;
import com.ibm.xml.xml4j.api.s1.xs.XSObject;
import com.ibm.xml.xml4j.api.s1.xs.XSTypeDefinition;
import com.ibm.xml.xml4j.internal.s1.impl.dv.InvalidDatatypeValueException;
import com.ibm.xml.xml4j.internal.s1.impl.dv.ValidatedInfo;
import com.ibm.xml.xml4j.internal.s1.impl.dv.ValidationContext;
import com.ibm.xml.xml4j.internal.s1.impl.dv.XSSimpleType;
import com.ibm.xml.xml4j.internal.s1.impl.dv.xs.XSSimpleTypeDecl;
import com.ibm.xml.xml4j.internal.s1.impl.xs.XSComplexTypeDecl;
import com.ibm.xml.xml4j.internal.s1.impl.xs.XSMessageFormatter;
import com.ibm.xml.xml4j.internal.s1.impl.xs.util.StringListImpl;
import com.ibm.xml.xml4j.internal.s1.xni.parser.XMLParseException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Stack;
import javax.xml.validation.ValidatorHandler;
import org.w3c.dom.DOMErrorHandler;
import org.xml.sax.Attributes;
import org.xml.sax.ContentHandler;
import org.xml.sax.DTDHandler;
import org.xml.sax.SAXException;
import org.xml.sax.SAXNotRecognizedException;
import org.xml.sax.SAXNotSupportedException;
import org.xml.sax.SAXParseException;
import org.xml.sax.ext.LexicalHandler;
import org.xml.sax.ext.Locator2;
import org.xml.sax.helpers.DefaultHandler;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class XCIValidator {
    static final String IBM_COPYRIGHT = "Licensed Materials - Property of IBM\n\nXML Cursor Interface for Java (XCI-J)\u00a9 Copyright IBM Corp. 2008, 2009. All Rights Reserved.\n\nUS Government Users Restricted Rights - Use, duplication or disclosure \nrestricted by GSA ADP Schedule Contract with IBM Corp.";
    private static final int INITIAL_ERROR_SIZE = 8;
    private static final int INC_ERROR_SIZE = 8;
    private static final String ERROR_HANDLER = "http://apache.org/xml/properties/internal/error-handler";
    private short validity;
    private PSVIProvider psviProvider;
    private Map<String, List<String>> diagnosticsMap;
    private final SAX2XCI sax2xci = new SAX2XCI();
    private final SAX2XCISimple sax2xcisi = new SAX2XCISimple();
    private final SAX2XCIShallow sax2xcish = new SAX2XCIShallow();
    private final XSDGrammarResource.XCIDOMErrorHandlerWrapper errorHandler = new XSDGrammarResource.XCIDOMErrorHandlerWrapper(null);
    private final CursorContext cursorContext = new CursorContext();
    private final XCIValidationContext valContext = new XCIValidationContext();
    private final ValidatedInfo validatedInfo = new ValidatedInfo();
    private Attributes currentAttributes;
    private int featuresLimit;
    private static final Stack<XCIValidator> validators = new Stack();
    private boolean toSetXSType = false;
    private boolean toSetPSVI = false;
    private boolean toApplyDefaults = false;
    private boolean processSubtree;
    private DocumentInfoLocator documentLocator = new DocumentInfoLocator();
    private XSMessageFormatter messageFormatter = new XSMessageFormatter();
    private final ArrayList<String> fErrors = new ArrayList();
    private int[] fDiagnosticsContext = new int[8];
    private int fDiagnosticsContextCount = 0;
    private static final String LOCALE = "http://apache.org/xml/properties/locale";
    private static final String ROOT_TYPE_DEF = "http://apache.org/xml/properties/validation/schema/root-type-definition";
    private static final String ROOT_ELEMENT_DECL = "http://apache.org/xml/properties/validation/schema/root-element-declaration";
    private static final String ID_IDREF_CHECKING = "http://apache.org/xml/features/validation/id-idref-checking";
    protected static final String UNPARSED_ENTITY_CHECKING = "http://apache.org/xml/features/validation/unparsed-entity-checking";
    protected static final String NAMESPACE_GROWTH = "http://apache.org/xml/features/namespace-growth";
    protected static final String TOLERATE_DUPLICATES = "http://apache.org/xml/features/internal/tolerate-duplicates";

    private void pushDiagnosticsContext() {
        if (this.fDiagnosticsContextCount == this.fDiagnosticsContext.length) {
            int n2 = this.fDiagnosticsContextCount + 8;
            int[] nArray = new int[n2];
            System.arraycopy(this.fDiagnosticsContext, 0, nArray, 0, this.fDiagnosticsContextCount);
            this.fDiagnosticsContext = nArray;
        }
        this.fDiagnosticsContext[this.fDiagnosticsContextCount++] = this.fErrors.size();
    }

    private void popDiagnosticsContext() {
        --this.fDiagnosticsContextCount;
    }

    private List<String> currentDiagnosticsContextErrors() {
        int n2 = this.fDiagnosticsContext[this.fDiagnosticsContextCount - 1];
        int n3 = this.fErrors.size() - n2;
        if (n3 == 0) {
            return null;
        }
        ArrayList<String> arrayList = new ArrayList<String>(n3);
        for (int i = 0; i < n3; ++i) {
            arrayList.add(this.fErrors.get(n2 + i));
        }
        return arrayList;
    }

    private void addDiagnosticsErrors(ElementPSVI elementPSVI) {
        block5: {
            int n2;
            int n3;
            StringList stringList;
            int n4;
            StringList stringList2;
            block4: {
                stringList2 = elementPSVI.getErrorMessages();
                n4 = stringList2.getLength();
                if (n4 == 0) {
                    return;
                }
                stringList = elementPSVI.getErrorCodes();
                n3 = this.fDiagnosticsContext[this.fDiagnosticsContextCount - 1];
                n2 = this.fErrors.size();
                if (n3 != n2) break block4;
                for (int i = 0; i < stringList2.getLength(); ++i) {
                    this.fErrors.add(stringList.item(i));
                    this.fErrors.add(stringList2.item(i));
                }
                break block5;
            }
            this.fDiagnosticsContext[this.fDiagnosticsContextCount - 1] = n2;
            if (n4 * 2 <= n2 - n3) break block5;
            for (int i = 0; i < stringList2.getLength(); ++i) {
                int n5;
                String string2 = stringList2.item(i);
                for (n5 = n3 + 1; n5 < n2 && !this.fErrors.get(n5).equals(string2); n5 += 2) {
                }
                if (n5 <= n2) continue;
                this.fErrors.add(stringList.item(i));
                this.fErrors.add(string2);
            }
        }
    }

    private void addDiagnosticsErrors(AttributePSVI attributePSVI) {
        StringList stringList = attributePSVI.getErrorMessages();
        StringList stringList2 = attributePSVI.getErrorCodes();
        int n2 = stringList.getLength();
        for (int i = 0; i < n2; ++i) {
            this.fErrors.add(stringList2.item(i));
            this.fErrors.add(stringList.item(i));
        }
    }

    private XCIValidator() {
    }

    public static int validate(Cursor cursor2, ValidatorHandler validatorHandler, int n2) {
        return XCIValidator.validate(cursor2, validatorHandler, n2, null, null, null);
    }

    public static int validate(Cursor cursor2, ValidatorHandler validatorHandler, int n2, Locale locale, XSObject xSObject, Map<String, List<String>> map2) {
        DOMErrorHandler dOMErrorHandler;
        short s = cursor2.itemKind();
        if (!XCIValidator.isSupportedCursor(s)) {
            return 3;
        }
        if (xSObject == null && s == 2) {
            return 0;
        }
        XCIValidator xCIValidator = XCIValidator.getXCIValidator();
        xCIValidator.setMutationFeatures(n2);
        xCIValidator.fErrors.clear();
        xCIValidator.fDiagnosticsContextCount = 0;
        xCIValidator.processSubtree = true;
        DocumentInfo documentInfo = cursor2.itemDocumentInfo();
        DOMErrorHandler dOMErrorHandler2 = dOMErrorHandler = documentInfo == null ? null : documentInfo.getErrorHandler();
        if (dOMErrorHandler == null) {
            dOMErrorHandler = cursor2.factory().getSessionContext().getErrorHandler();
        }
        xCIValidator.errorHandler.setErrorHandler(dOMErrorHandler);
        xCIValidator.diagnosticsMap = map2 != null && !Cursor.Profile.TO_PARENT.containedIn(cursor2.profile()) ? null : map2;
        if (cursor2.itemKind() == 2) {
            xCIValidator.validateAttribute(cursor2, n2, xSObject, locale);
        } else {
            xCIValidator.validateElement(cursor2, validatorHandler, n2, xSObject, locale);
        }
        XCIValidator.returnXCIValidator(xCIValidator);
        return xCIValidator.validity;
    }

    private void validateElement(Cursor cursor2, ValidatorHandler validatorHandler, int n2, XSObject xSObject, Locale locale) {
        SessionContext sessionContext = cursor2.factory().getSessionContext();
        Boolean bl = (Boolean)sessionContext.getOption("http://www.ibm.com/xml/xci/schema/namespace-growth");
        boolean bl2 = bl != null && bl != false;
        Boolean bl3 = (Boolean)sessionContext.getOption("http://www.ibm.com/xml/xci/bo/bo-bc-mode");
        boolean bl4 = bl3 != null && bl3 != false;
        XCIValidator.setValidationProperties(validatorHandler, xSObject, locale);
        XCIValidator.setValidationFeatures(validatorHandler, n2, bl2, bl4);
        try {
            this.psviProvider = (PSVIProvider)((Object)validatorHandler);
        }
        catch (ClassCastException classCastException) {
            this.psviProvider = null;
        }
        this.validity = (short)2;
        try {
            Object object2 = validatorHandler.getProperty(ERROR_HANDLER);
            if (this.errorHandler != object2) {
                validatorHandler.setProperty(ERROR_HANDLER, this.errorHandler);
            }
        }
        catch (SAXNotRecognizedException sAXNotRecognizedException) {
            throw new IllegalArgumentException(sAXNotRecognizedException);
        }
        catch (SAXNotSupportedException sAXNotSupportedException) {
            throw new IllegalArgumentException(sAXNotSupportedException);
        }
        if (this.psviProvider == null || n2 < 8) {
            this.validateNM(cursor2, validatorHandler, n2);
        } else {
            this.validateM(cursor2, validatorHandler, n2);
        }
        this.psviProvider = null;
        this.documentLocator.clearDocumentInfo();
    }

    private final void validateNM(Cursor cursor2, ValidatorHandler validatorHandler, int n2) {
        XCI2SAXSimple xCI2SAXSimple = new XCI2SAXSimple(null, validatorHandler, null, null);
        Cursor cursor3 = cursor2.fork(true, Cursor.Profile.MINIMAL_STREAMING_NAVIGATION, Cursor.Profile.MINIMAL_STREAMING_NAVIGATION);
        if (this.psviProvider != null) {
            if ((n2 & 1) != 0) {
                validatorHandler.setContentHandler(this.sax2xcish);
            } else if (this.diagnosticsMap == null) {
                validatorHandler.setContentHandler(this.sax2xcisi);
            } else {
                validatorHandler.setContentHandler(this.sax2xci);
            }
        }
        this.featuresLimit = 0;
        xCI2SAXSimple.serializeEvents(cursor3);
    }

    private final void validateM(Cursor cursor2, ValidatorHandler validatorHandler, int n2) {
        XCI2SAX xCI2SAX = new XCI2SAX(null, validatorHandler, null, null);
        if ((n2 & 1) != 0) {
            validatorHandler.setContentHandler(this.sax2xcish);
        } else {
            validatorHandler.setContentHandler(this.sax2xci);
        }
        cursor2.openMutation(Cursor.Area.SUBTREE);
        Cursor cursor3 = cursor2.fork(true);
        this.featuresLimit = n2;
        xCI2SAX.serializeEvents(cursor3);
        cursor2.closeMutation();
    }

    private void validateAttribute(Cursor cursor2, int n2, XSObject xSObject, Locale locale) {
        String string2 = cursor2.itemName().getQNameLocalPart(1);
        String string3 = cursor2.itemStringValue().toString();
        XSAttributeDeclaration xSAttributeDeclaration = null;
        XSSimpleType xSSimpleType = null;
        XCIAttributePSVI xCIAttributePSVI = null;
        this.validity = (short)2;
        this.valContext.setNamespaceContext(cursor2.itemNamespaceContext(true));
        this.valContext.setLocale(locale);
        this.valContext.setExtraChecking((n2 & 4) == 0);
        this.valContext.setDocumentInfo(cursor2.itemDocumentInfo());
        if (this.toSetPSVI || this.diagnosticsMap != null) {
            xCIAttributePSVI = new XCIAttributePSVI();
        }
        this.validatedInfo.reset();
        if (xSObject instanceof XSAttributeDeclaration) {
            xSAttributeDeclaration = (XSAttributeDeclaration)xSObject;
            xSSimpleType = (XSSimpleType)xSAttributeDeclaration.getTypeDefinition();
            this.validateAttribute(string2, string3, xSAttributeDeclaration, xCIAttributePSVI, locale);
        } else if (xSObject instanceof XSSimpleType) {
            xSSimpleType = (XSSimpleType)xSObject;
            this.validateAttribute(string2, string3, (XSSimpleType)xSObject, xCIAttributePSVI, locale);
        } else {
            this.validity = 0;
            this.valContext.setDocumentInfo(null);
            return;
        }
        this.valContext.setDocumentInfo(null);
        if (xCIAttributePSVI != null) {
            String[] stringArray = null;
            if (this.fErrors.size() != 0) {
                stringArray = new String[this.fErrors.size()];
                this.fErrors.toArray(stringArray);
            }
            if (this.toSetPSVI) {
                xCIAttributePSVI.setValues(this.validatedInfo.actualValue, this.validatedInfo.actualValueType, xSAttributeDeclaration, this.validatedInfo.itemValueTypes, this.validatedInfo.memberType, this.validatedInfo.normalizedValue, false, xSSimpleType, (short)2, null, this.validity, stringArray);
                cursor2.setItemPSVI(xCIAttributePSVI);
            }
            if (this.diagnosticsMap != null && stringArray != null) {
                this.addDiagnosticsToMap(cursor2, stringArray, stringArray.length);
            }
        }
    }

    private void validateAttribute(String string2, String string3, XSAttributeDeclaration xSAttributeDeclaration, XCIAttributePSVI xCIAttributePSVI, Locale locale) {
        this.validateAttribute(string2, string3, (XSSimpleType)xSAttributeDeclaration.getTypeDefinition(), xCIAttributePSVI, locale);
        if (this.validatedInfo.actualValue != null && xSAttributeDeclaration.getConstraintType() == 2) {
            ValidatedInfo validatedInfo = new ValidatedInfo();
            validatedInfo.actualValueType = xSAttributeDeclaration.getActualVCType();
            validatedInfo.itemValueTypes = xSAttributeDeclaration.getItemValueTypes();
            if (!ValidatedInfo.isComparable(this.validatedInfo, validatedInfo) || !this.validatedInfo.actualValue.equals(xSAttributeDeclaration.getActualVC())) {
                this.validity = 1;
                String string4 = this.messageFormatter.formatMessage(locale, "cvc-attribute.4", new Object[]{"", string2, string3, xSAttributeDeclaration.getConstraintValue()});
                if (xCIAttributePSVI != null) {
                    this.fErrors.add("cvc-attribute.4");
                    this.fErrors.add(string4);
                }
                try {
                    this.errorHandler.error("http://www.w3.org/TR/xml-schema-1", "cvc-attribute.4", new XMLParseException(null, string4));
                }
                catch (Exception exception) {
                    if (exception instanceof IllegalArgumentException) {
                        throw (IllegalArgumentException)exception;
                    }
                    throw new IllegalArgumentException(exception);
                }
            }
        }
    }

    private void validateAttribute(String string2, String string3, XSSimpleType xSSimpleType, XCIAttributePSVI xCIAttributePSVI, Locale locale) {
        try {
            xSSimpleType.validate(string3, (ValidationContext)this.valContext, this.validatedInfo);
        }
        catch (InvalidDatatypeValueException invalidDatatypeValueException) {
            this.validity = 1;
            String string4 = this.messageFormatter.formatMessage(locale, invalidDatatypeValueException.getKey(), invalidDatatypeValueException.getArgs());
            String string5 = this.messageFormatter.formatMessage(locale, "cvc-attribute.3", new Object[]{"", string2, string3, xSSimpleType instanceof XSSimpleTypeDecl ? ((XSSimpleTypeDecl)xSSimpleType).getTypeName() : xSSimpleType.getName()});
            if (xCIAttributePSVI != null) {
                this.fErrors.add(invalidDatatypeValueException.getKey());
                this.fErrors.add(string4);
                this.fErrors.add("cvc-attribute.3");
                this.fErrors.add(string5);
            }
            try {
                this.errorHandler.error("http://www.w3.org/TR/xml-schema-1", invalidDatatypeValueException.getKey(), new XMLParseException(null, string4));
                this.errorHandler.error("http://www.w3.org/TR/xml-schema-1", "cvc-attribute.3", new XMLParseException(null, string5));
            }
            catch (Exception exception) {
                if (exception instanceof IllegalArgumentException) {
                    throw (IllegalArgumentException)exception;
                }
                throw new IllegalArgumentException(exception);
            }
        }
    }

    private static SAXParseException createSAXParseException(String string2) {
        return new SAXParseException(string2, null, null, -1, -1, null);
    }

    private void setMutationFeatures(int n2) {
        this.toSetPSVI = (n2 & 0x10) != 0;
        this.toSetXSType = (n2 & 0x20) != 0;
        this.toApplyDefaults = (n2 & 8) != 0;
    }

    private void addDiagnosticsToMap(Cursor cursor2, List<String> list) {
        String string2;
        try {
            string2 = XCIXpathGenerator.nodeToXPath(cursor2);
        }
        catch (Exception exception) {
            return;
        }
        this.diagnosticsMap.put(string2, list);
    }

    private void addDiagnosticsToMap(Cursor cursor2, String[] stringArray, int n2) {
        String string2;
        try {
            string2 = XCIXpathGenerator.nodeToXPath(cursor2);
        }
        catch (Exception exception) {
            return;
        }
        StringListImpl stringListImpl = new StringListImpl(stringArray, n2);
        this.diagnosticsMap.put(string2, stringListImpl);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static XCIValidator getXCIValidator() {
        Stack<XCIValidator> stack = validators;
        synchronized (stack) {
            if (validators.isEmpty()) {
                return new XCIValidator();
            }
            return validators.pop();
        }
    }

    private static void returnXCIValidator(XCIValidator xCIValidator) {
        validators.push(xCIValidator);
    }

    private static final boolean isSupportedCursor(short s) {
        return s == 1 || s == 2 || s == 9;
    }

    private static void setValidationProperties(ValidatorHandler validatorHandler, XSObject xSObject, Locale locale) {
        Object object2;
        try {
            object2 = validatorHandler.getProperty(LOCALE);
            if (locale != object2) {
                validatorHandler.setProperty(LOCALE, locale);
            }
        }
        catch (SAXNotRecognizedException sAXNotRecognizedException) {
            System.out.println("Failed to set locale");
        }
        catch (SAXNotSupportedException sAXNotSupportedException) {
            System.out.println("Failed to set locale");
        }
        try {
            object2 = validatorHandler.getProperty(ROOT_TYPE_DEF);
            if (xSObject != object2) {
                if (xSObject instanceof XSTypeDefinition) {
                    validatorHandler.setProperty(ROOT_TYPE_DEF, xSObject);
                } else if (object2 != null) {
                    validatorHandler.setProperty(ROOT_TYPE_DEF, null);
                }
            }
        }
        catch (SAXNotRecognizedException sAXNotRecognizedException) {
            System.out.println("Failed to set root type definition");
        }
        catch (SAXNotSupportedException sAXNotSupportedException) {
            System.out.println("Failed to set root type definition");
        }
        try {
            object2 = validatorHandler.getProperty(ROOT_ELEMENT_DECL);
            if (xSObject != object2) {
                if (xSObject instanceof XSElementDeclaration) {
                    validatorHandler.setProperty(ROOT_ELEMENT_DECL, xSObject);
                } else if (object2 != null) {
                    validatorHandler.setProperty(ROOT_ELEMENT_DECL, null);
                }
            }
        }
        catch (SAXNotRecognizedException sAXNotRecognizedException) {
            System.out.println("Failed to set root element declaration");
        }
        catch (SAXNotSupportedException sAXNotSupportedException) {
            System.out.println("Failed to set root element declaration");
        }
    }

    private static void setValidationFeatures(ValidatorHandler validatorHandler, int n2, boolean bl, boolean bl2) {
        try {
            boolean bl3;
            boolean bl4;
            boolean bl5;
            boolean bl6;
            boolean bl7 = (n2 & 2) == 0;
            boolean bl8 = validatorHandler.getFeature(ID_IDREF_CHECKING);
            if (bl7 != bl8) {
                validatorHandler.setFeature(ID_IDREF_CHECKING, bl7);
            }
            if ((bl6 = (n2 & 4) == 0) != (bl5 = validatorHandler.getFeature(UNPARSED_ENTITY_CHECKING))) {
                validatorHandler.setFeature(UNPARSED_ENTITY_CHECKING, bl6);
            }
            if (bl != (bl4 = validatorHandler.getFeature(NAMESPACE_GROWTH))) {
                validatorHandler.setFeature(NAMESPACE_GROWTH, bl);
            }
            if (bl2 != (bl3 = validatorHandler.getFeature(TOLERATE_DUPLICATES))) {
                validatorHandler.setFeature(TOLERATE_DUPLICATES, bl2);
            }
        }
        catch (SAXNotRecognizedException sAXNotRecognizedException) {
            System.out.println("Failed to set validator options");
        }
        catch (SAXNotSupportedException sAXNotSupportedException) {
            System.out.println("Failed to set validator options");
        }
    }

    private static final class DocumentInfoLocator
    implements Locator2 {
        private DocumentInfo documentInfo;

        private DocumentInfoLocator() {
        }

        public String getSystemId() {
            if (this.documentInfo != null) {
                return this.documentInfo.getURI();
            }
            return null;
        }

        public String getPublicId() {
            return null;
        }

        public int getColumnNumber() {
            return -1;
        }

        public int getLineNumber() {
            return -1;
        }

        public String getEncoding() {
            if (this.documentInfo != null) {
                return this.documentInfo.getXMLEncoding();
            }
            return "UTF-8";
        }

        public String getXMLVersion() {
            DocumentInfo.VersionInfo versionInfo;
            if (this.documentInfo != null && (versionInfo = this.documentInfo.getXMLVersionInfo()) != null) {
                return versionInfo.toString();
            }
            return "1.0";
        }

        public void setDocumentInfo(DocumentInfo documentInfo) {
            this.documentInfo = documentInfo;
        }

        public void clearDocumentInfo() {
            this.documentInfo = null;
        }
    }

    private final class SAX2XCIShallow
    extends SAX2XCI {
        boolean isSimpleType;
        int errorCount;

        private SAX2XCIShallow() {
        }

        public void startDocument() throws SAXException {
            super.startDocument();
            this.isSimpleType = false;
            this.errorCount = 0;
        }

        public void startElement(String string2, String string3, String string4, Attributes attributes2) throws SAXException {
            ElementPSVI elementPSVI = XCIValidator.this.psviProvider.getElementPSVI();
            if (this.elementDepth == 1) {
                XSTypeDefinition xSTypeDefinition = elementPSVI.getTypeDefinition();
                this.isSimpleType = xSTypeDefinition != null && (xSTypeDefinition.getTypeCategory() == 16 || xSTypeDefinition.getTypeCategory() == 15 && ((XSComplexTypeDecl)xSTypeDefinition).getContentType() == 1);
                XCIValidator.this.processSubtree = this.isSimpleType;
            }
            super.startElement(string2, string3, string4, attributes2);
        }

        public void endElement(String string2, String string3, String string4) throws SAXException {
            short s = XCIValidator.this.validity;
            ElementPSVI elementPSVI = XCIValidator.this.psviProvider.getElementPSVI();
            int n2 = elementPSVI.getErrorCodes().size();
            super.endElement(string2, string3, string4);
            if (this.elementDepth == 0) {
                if (XCIValidator.this.validity == 1 && s == 2 && n2 == this.errorCount) {
                    XCIValidator.this.validity = (short)2;
                }
            } else {
                this.errorCount += n2;
                if (this.isSimpleType && n2 > 0) {
                    XCIValidator.this.validity = (short)1;
                }
            }
        }

        protected void addDiagnostics(Cursor cursor2, ElementPSVI elementPSVI) {
            if (this.elementDepth == 0 || this.isSimpleType) {
                super.addDiagnostics(cursor2, elementPSVI);
            } else {
                XCIValidator.this.addDiagnosticsErrors(elementPSVI);
            }
        }

        protected void addDiagnostics(Cursor cursor2, Attributes attributes2) {
            if (this.elementDepth == 0 || this.isSimpleType) {
                super.addDiagnostics(cursor2, attributes2);
            }
        }

        protected void addDiagnostics(Cursor cursor2, AttributePSVI attributePSVI) {
            if (this.elementDepth == 0 || this.isSimpleType) {
                super.addDiagnostics(cursor2, attributePSVI);
            }
        }
    }

    private class SAX2XCI
    extends DefaultHandler {
        protected int elementDepth;

        private SAX2XCI() {
        }

        public void startDocument() throws SAXException {
            this.elementDepth = 0;
        }

        public void startElement(String string2, String string3, String string4, Attributes attributes2) throws SAXException {
            if (XCIValidator.this.diagnosticsMap != null) {
                XCIValidator.this.pushDiagnosticsContext();
            }
            if (XCIValidator.this.featuresLimit > 0) {
                Cursor cursor2 = XCIValidator.this.cursorContext.peekCursor();
                if (attributes2.getLength() > 0) {
                    boolean bl = false;
                    if (XCIValidator.this.toApplyDefaults) {
                        bl = this.addDefaultAttributes(cursor2, attributes2);
                    }
                    if (XCIValidator.this.featuresLimit > 8) {
                        Attributes attributes3;
                        Attributes attributes4 = attributes3 = bl ? attributes2 : XCIValidator.this.currentAttributes;
                        if (attributes3.getLength() > 0) {
                            this.setAttributes(cursor2, attributes3);
                        }
                    } else if (XCIValidator.this.diagnosticsMap != null) {
                        this.addDiagnostics(cursor2, attributes2);
                    }
                }
                if (XCIValidator.this.toSetXSType) {
                    cursor2.setItemXSType(XCIValidator.this.psviProvider.getElementPSVI().getTypeDefinition());
                }
            } else if (XCIValidator.this.diagnosticsMap != null && attributes2.getLength() > 0) {
                this.addDiagnostics(XCIValidator.this.cursorContext.peekCursor(), attributes2);
            }
            ++this.elementDepth;
        }

        public void endElement(String string2, String string3, String string4) throws SAXException {
            ElementPSVI elementPSVI = XCIValidator.this.psviProvider.getElementPSVI();
            if (XCIValidator.this.featuresLimit > 0) {
                Cursor cursor2 = XCIValidator.this.cursorContext.peekCursor();
                if (XCIValidator.this.toApplyDefaults && elementPSVI.getIsSchemaSpecified()) {
                    cursor2.addText(Cursor.Area.FIRST_CHILD, cursor2.factory().data((CharSequence)elementPSVI.getSchemaNormalizedValue(), null, false));
                }
                if (XCIValidator.this.toSetPSVI) {
                    XCIElementPSVI xCIElementPSVI = new XCIElementPSVI(elementPSVI);
                    cursor2.setItemPSVI(xCIElementPSVI);
                }
            }
            if (--this.elementDepth == 0) {
                XCIValidator.this.validity = elementPSVI.getValidity();
            }
            if (XCIValidator.this.diagnosticsMap != null) {
                this.addDiagnostics(XCIValidator.this.cursorContext.peekCursor(), elementPSVI);
                XCIValidator.this.popDiagnosticsContext();
            }
        }

        protected void addDiagnostics(Cursor cursor2, ElementPSVI elementPSVI) {
            XCIValidator.this.addDiagnosticsErrors(elementPSVI);
            List list = XCIValidator.this.currentDiagnosticsContextErrors();
            if (list != null) {
                XCIValidator.this.addDiagnosticsToMap(cursor2, list);
            }
        }

        private boolean addDefaultAttributes(Cursor cursor2, Attributes attributes2) {
            int n2 = attributes2.getLength();
            int n3 = XCIValidator.this.currentAttributes.getLength();
            if (n3 != n2) {
                CursorFactory cursorFactory = cursor2.factory();
                for (int i = n3; i < n2; ++i) {
                    cursor2.addAttribute((VolatileCData)cursorFactory.data((CharSequence)attributes2.getURI(i), attributes2.getLocalName(i), null), cursorFactory.data((CharSequence)attributes2.getValue(i), null, false));
                }
                return true;
            }
            return false;
        }

        private void setAttributes(Cursor cursor2, Attributes attributes2) {
            Cursor cursor3 = cursor2.fork(true);
            if (cursor3.toAttributes(null)) {
                do {
                    VolatileCData volatileCData = cursor3.itemName();
                    for (int i = 0; i < attributes2.getLength(); ++i) {
                        AttributePSVI attributePSVI;
                        if (!attributes2.getLocalName(i).equals(volatileCData.getQNameLocalPart(1)) || !attributes2.getURI(i).equals(volatileCData.getQNameNamespaceURI(1)) || (attributePSVI = XCIValidator.this.psviProvider.getAttributePSVI(i)) == null) continue;
                        if (XCIValidator.this.toSetXSType) {
                            cursor3.setItemXSType(attributePSVI.getTypeDefinition());
                        }
                        if (XCIValidator.this.toSetPSVI) {
                            cursor3.setItemPSVI(new XCIAttributePSVI(attributePSVI));
                        }
                        if (XCIValidator.this.diagnosticsMap == null) continue;
                        this.addDiagnostics(cursor3, attributePSVI);
                    }
                } while (cursor3.toNext());
            }
            cursor3.release();
        }

        protected void addDiagnostics(Cursor cursor2, Attributes attributes2) {
            Cursor cursor3 = cursor2.fork(true);
            if (cursor3.toAttributes(null)) {
                do {
                    VolatileCData volatileCData = cursor3.itemName();
                    for (int i = 0; i < attributes2.getLength(); ++i) {
                        if (!attributes2.getLocalName(i).equals(volatileCData.getQNameLocalPart(1)) || !attributes2.getURI(i).equals(volatileCData.getQNameNamespaceURI(1))) continue;
                        this.addDiagnostics(cursor3, XCIValidator.this.psviProvider.getAttributePSVI(i));
                    }
                } while (cursor3.toNext());
            }
            cursor3.release();
        }

        protected void addDiagnostics(Cursor cursor2, AttributePSVI attributePSVI) {
            StringList stringList = attributePSVI.getErrorMessages();
            int n2 = stringList.getLength();
            if (n2 != 0) {
                StringList stringList2 = attributePSVI.getErrorCodes();
                ArrayList<String> arrayList = new ArrayList<String>(n2 * 2);
                for (int i = 0; i < n2; ++i) {
                    arrayList.add(stringList2.item(i));
                    arrayList.add(stringList.item(i));
                }
                XCIValidator.this.addDiagnosticsToMap(cursor2, arrayList);
                XCIValidator.this.addDiagnosticsErrors(attributePSVI);
            }
        }
    }

    private final class SAX2XCISimple
    extends DefaultHandler {
        private int elementDepth;

        private SAX2XCISimple() {
        }

        public void startDocument() throws SAXException {
            this.elementDepth = 0;
        }

        public void startElement(String string2, String string3, String string4, Attributes attributes2) throws SAXException {
            ++this.elementDepth;
        }

        public void endElement(String string2, String string3, String string4) throws SAXException {
            if (--this.elementDepth == 0) {
                XCIValidator.this.validity = XCIValidator.this.psviProvider.getElementPSVI().getValidity();
            }
        }
    }

    private final class XCI2SAX
    extends XCI2SAXSimple {
        public XCI2SAX(CursorFactory cursorFactory, ContentHandler contentHandler, LexicalHandler lexicalHandler, Map map2) {
            super(cursorFactory, contentHandler, lexicalHandler, map2);
        }

        protected void writeOpenTag(VolatileCData volatileCData) throws IOException {
            super.writeOpenTag(volatileCData);
        }

        protected void writeClosingTag(VolatileCData volatileCData) throws IOException {
            super.writeClosingTag(volatileCData);
        }

        protected void writeSlashBracket() throws IOException {
            XCIValidator.this.currentAttributes = this.fAttributes;
            super.writeSlashBracket();
            XCIValidator.this.cursorContext.popCursor();
        }

        protected void writeClosingBracket() throws IOException {
            XCIValidator.this.currentAttributes = this.fAttributes;
            super.writeClosingBracket();
        }
    }

    private class XCI2SAXSimple
    extends SAXCursor {
        private final ContentHandler contentHandler;
        private final DTDHandler dtdHandler;
        private boolean isRoot;
        protected Cursor currentSource;

        public XCI2SAXSimple(CursorFactory cursorFactory, ContentHandler contentHandler, LexicalHandler lexicalHandler, Map map2) {
            super(cursorFactory, contentHandler, lexicalHandler, map2);
            this.isRoot = true;
            this.currentSource = null;
            this.contentHandler = contentHandler;
            this.dtdHandler = contentHandler instanceof DTDHandler ? (DTDHandler)((Object)contentHandler) : null;
        }

        public void serializeEvents(Cursor cursor2) {
            this.copy(cursor2, this, Cursor.Area.FIRST_CHILD, 49);
        }

        private void copy(Cursor cursor2, Cursor cursor3, Cursor.Area area, int n2) {
            if (cursor2 != null) {
                assert (Copier.SOURCE_FEATURES.containedIn(cursor2.profile())) : "Insufficient source features for copy!";
                assert (Copier.TARGET_FEATURES.containedIn(cursor3.profile())) : "Insufficient target features for copy!";
                if (cursor2.itemKind() == 9 && !cursor2.toChildren(null)) {
                    return;
                }
                if (!cursor3.openMutation(Cursor.Area.SUBTREE)) {
                    throw new XCIDynamicErrorException("ER_ILLEGAL_MUTATION_RELATIVE_TO_AREA");
                }
                XCI2SAXCopier xCI2SAXCopier = new XCI2SAXCopier(n2);
                xCI2SAXCopier.copySequence2Content(cursor2, cursor3, area);
                cursor3.closeMutation();
                cursor3.release();
                cursor2.release();
            }
        }

        protected void ensureContentState(Cursor.Area area) throws IOException {
            if (this.state == 1) {
                if (area == Cursor.Area.FOLLOWING_SIBLING) {
                    this.finishTag();
                    this.popNamespaceContext();
                }
                this.state = 2;
            }
        }

        protected void writeOpenTag(VolatileCData volatileCData) throws IOException {
            XCIValidator.this.cursorContext.pushCursor(this.currentSource);
            super.writeOpenTag(volatileCData);
            if (this.isRoot) {
                Object object2;
                Object object3;
                ExtendedNamespaceContext extendedNamespaceContext = this.currentSource.itemNamespaceContext(true);
                if (extendedNamespaceContext != null) {
                    object3 = extendedNamespaceContext.getInScopeNamespaces();
                    while (object3.hasNext()) {
                        object2 = object3.next();
                        String string2 = (String)object3.next();
                        int n2 = this.toHandleFromPrefix((String)(object2 == null ? "" : object2));
                        if (n2 != -1) continue;
                        this.declareNS(string2, (String)(object2 == null ? "" : object2), false);
                    }
                }
                if (this.dtdHandler != null && (object3 = this.currentSource.itemDocumentInfo()) != null) {
                    XCIValidator.this.documentLocator.setDocumentInfo((DocumentInfo)object3);
                    this.contentHandler.setDocumentLocator(XCIValidator.this.documentLocator);
                    object2 = ((DocumentInfo)object3).getUnparsedEntityNames();
                    if (object2 != null) {
                        try {
                            while (object2.hasNext()) {
                                this.dtdHandler.unparsedEntityDecl((String)object2.next(), "publicId", "systemId", "notationName");
                            }
                        }
                        catch (SAXException sAXException) {
                            throw new AssertionError((Object)sAXException);
                        }
                    }
                }
                this.isRoot = false;
            }
        }

        protected void writeClosingTag(VolatileCData volatileCData) throws IOException {
            super.writeClosingTag(volatileCData);
            XCIValidator.this.cursorContext.popCursor();
        }

        private final void finishTag() throws IOException {
            this.writeClosingTag((VolatileCData)this.openTags.pop());
        }

        private final class XCI2SAXCopier
        extends Copier {
            public XCI2SAXCopier(int n2) {
                super(n2);
            }

            public int copySequence2Content(Cursor cursor2, Cursor cursor3, Cursor.Area area) {
                return super.copySequence2Content(cursor2, cursor3, area);
            }

            protected int copyNode(Cursor cursor2, Cursor cursor3, Cursor.Area area) {
                switch (cursor2.itemKind()) {
                    case 1: {
                        XCI2SAXSimple.this.currentSource = cursor2;
                        cursor3.addElement(area, cursor2.itemName(), cursor2.itemXSType());
                        return 0;
                    }
                }
                return super.copyNode(cursor2, cursor3, area);
            }

            protected int copyContents(Cursor cursor2, Cursor cursor3) {
                int n2;
                Cursor cursor4 = cursor2.fork(true);
                if (cursor4.toNamespaceDecls()) {
                    do {
                        this.copyNode(cursor4, cursor3, Cursor.Area.FOLLOWING_SIBLING);
                    } while (cursor4.toNext());
                }
                cursor4.release();
                Cursor cursor5 = cursor2.fork(true);
                if (cursor5.toAttributes(null)) {
                    do {
                        this.copyNode(cursor5, cursor3, Cursor.Area.FOLLOWING_SIBLING);
                    } while (cursor5.toNext());
                }
                cursor5.release();
                try {
                    XCI2SAXSimple.this.writeClosingBracket();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
                if (XCIValidator.this.processSubtree) {
                    Cursor cursor6 = cursor2.fork(true);
                    n2 = cursor6.toChildren(null) ? this.copySequence2Content(cursor6, cursor3, Cursor.Area.FIRST_CHILD) : 1;
                    cursor6.release();
                } else {
                    n2 = 1;
                }
                try {
                    XCI2SAXSimple.this.ensureContentState(Cursor.Area.FOLLOWING_SIBLING);
                }
                catch (IOException iOException) {
                    // empty catch block
                }
                return n2;
            }
        }
    }
}

