/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xml.xci.internal.util.xml;

import com.ibm.xml.xci.ExtendedNamespaceContext;
import com.ibm.xml.xci.internal.util.FlattenedMapEntryIterator;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class HashMapNamespaceContext
implements ExtendedNamespaceContext {
    static final String IBM_COPYRIGHT = "Licensed Materials - Property of IBM\n\nXML Cursor Interface for Java (XCI-J)\u00a9 Copyright IBM Corp. 2004, 2008. All Rights Reserved.\n\nUS Government Users Restricted Rights - Use, duplication or disclosure \nrestricted by GSA ADP Schedule Contract with IBM Corp.";
    protected final HashMapNamespaceContext parent;
    protected Map<String, String> ns2prefix;
    protected Map<String, String> prefix2ns;

    public HashMapNamespaceContext() {
        this(null);
    }

    public HashMapNamespaceContext(HashMapNamespaceContext hashMapNamespaceContext) {
        this.parent = hashMapNamespaceContext;
        this.ns2prefix = new HashMap<String, String>(10);
        this.prefix2ns = new HashMap<String, String>(10);
    }

    public void declarePrefix(String string2, String string3) {
        this.ns2prefix.put(string3, string2);
        this.prefix2ns.put(string2, string3);
    }

    public HashMapNamespaceContext getParent() {
        return this.parent;
    }

    @Override
    public String getPrefix(String string2) {
        String string3 = null;
        if (this.ns2prefix != null) {
            string3 = this.ns2prefix.get(string2);
        }
        return string3 != null ? string3 : (this.parent == null ? null : this.parent.getPrefix(string2));
    }

    @Override
    public String getNamespaceURI(String string2) {
        String string3 = null;
        if (this.prefix2ns != null) {
            string3 = this.prefix2ns.get(string2);
        }
        return string3 != null ? string3 : (this.parent == null ? null : this.parent.getNamespaceURI(string2));
    }

    @Override
    public Iterator<String> getPrefixes(String string2) {
        throw new UnsupportedOperationException("ER_NOT_SUPPORTED");
    }

    @Override
    public Iterator<String> getInScopeNamespaces() {
        if (this.prefix2ns != null) {
            return new FlattenedMapEntryIterator<String>(this.prefix2ns.entrySet().iterator());
        }
        Iterator<String> iterator = Collections.EMPTY_LIST.iterator();
        return iterator;
    }

    @Override
    public ExtendedNamespaceContext constantENS(boolean bl) {
        return this;
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        if (this.prefix2ns != null) {
            for (Map.Entry<String, String> entry : this.prefix2ns.entrySet()) {
                String string2 = entry.getKey();
                stringBuilder.append(" xmlns" + (string2 == null ? "" : ":" + string2) + "=\"" + entry.getValue() + "\"");
            }
        }
        return stringBuilder.toString();
    }
}

