/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xml.xci.internal.util.resources;

import com.ibm.xml.xci.internal.util.resources.MediaType;
import com.ibm.xml.xci.internal.util.resources.Resource;
import com.ibm.xml.xci.internal.util.resources.WSDLResource;
import com.ibm.xml.xci.internal.util.resources.XSDGrammarResource;
import java.lang.reflect.Constructor;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.HashMap;
import javax.xml.transform.Source;
import javax.xml.transform.stream.StreamSource;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ResourceFactory {
    static final String IBM_COPYRIGHT = "Licensed Materials - Property of IBM\n\nXML Cursor Interface for Java (XCI-J)\u00a9 Copyright IBM Corp. 2004, 2008. All Rights Reserved.\n\nUS Government Users Restricted Rights - Use, duplication or disclosure \nrestricted by GSA ADP Schedule Contract with IBM Corp.";
    protected final MediaType mediaTypes;
    protected final HashMap<String, Constructor<? extends Resource>> constructors = new HashMap();

    public ResourceFactory() {
        this.mediaTypes = new MediaType();
        this.initDefault();
    }

    public Resource create(String string2, Source source) {
        Constructor<? extends Resource> constructor = this.constructors.get(string2);
        if (constructor != null) {
            try {
                return constructor.newInstance(source);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return null;
    }

    public Resource create(Source source) {
        if (source.getSystemId() == null) {
            return null;
        }
        try {
            String[] stringArray = this.mediaTypes.getMediaType(new URI(source.getSystemId()));
            if (stringArray != null) {
                for (int i = 0; i < stringArray.length; ++i) {
                    Resource resource = this.create(stringArray[i], source);
                    if (resource == null) continue;
                    return resource;
                }
            }
        }
        catch (URISyntaxException uRISyntaxException) {
            return null;
        }
        return null;
    }

    public Resource create(URI uRI) {
        return this.create(new StreamSource(uRI.toString()));
    }

    public boolean registerMediaType(String string2, Class<? extends Resource> clazz) {
        try {
            Constructor<? extends Resource> constructor = clazz.getConstructor(Source.class);
            this.constructors.put(string2, constructor);
            return true;
        }
        catch (Exception exception) {
            return false;
        }
    }

    private void initDefault() {
        this.registerMediaType("application/xsd+xml", XSDGrammarResource.class);
        this.registerMediaType("application/wsdl+xml", WSDLResource.class);
    }
}

