/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xml.xci.internal.util.resources;

import java.net.URI;
import java.util.HashMap;

public class MediaType {
    static final String IBM_COPYRIGHT = "Licensed Materials - Property of IBM\n\nXML Cursor Interface for Java (XCI-J)\u00a9 Copyright IBM Corp. 2004, 2008. All Rights Reserved.\n\nUS Government Users Restricted Rights - Use, duplication or disclosure \nrestricted by GSA ADP Schedule Contract with IBM Corp.";
    public static final String MEDIA_TYPE_APP_XSD_XML = "application/xsd+xml";
    public static final String MEDIA_TYPE_APP_WSDL_XML = "application/wsdl+xml";
    public static final String MEDIA_TYPE_APP_XML = "application/xml";
    public static final String MEDIA_TYPE_TEXT_XML = "text/xml";
    private final HashMap<String, String[]> fileext2types = new HashMap();

    public MediaType() {
        this.initDefault();
    }

    public String[] getMediaType(URI uRI) {
        String string2 = this.getFileExt(uRI);
        return string2 == null ? null : this.fileext2types.get(string2);
    }

    private final String getFileExt(URI uRI) {
        String string2 = uRI.isOpaque() ? uRI.getRawSchemeSpecificPart() : uRI.getPath();
        if (string2 == null) {
            return null;
        }
        int n2 = string2.lastIndexOf(46);
        if (n2 == -1) {
            return null;
        }
        return string2.substring(n2 + 1);
    }

    private void initDefault() {
        this.fileext2types.put("xml", new String[]{MEDIA_TYPE_TEXT_XML, MEDIA_TYPE_APP_XML});
        this.fileext2types.put("wsdl", new String[]{MEDIA_TYPE_APP_WSDL_XML});
        this.fileext2types.put("xsd", new String[]{MEDIA_TYPE_APP_XSD_XML});
        this.fileext2types.put("dtd", new String[]{"application/xml-dtd"});
    }
}

