/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xml.xci.internal.util.resources;

import com.ibm.xml.xci.internal.util.resources.Resource;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.UnsupportedEncodingException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Map;
import javax.xml.transform.Source;

abstract class BaseResource
implements Resource {
    static final String IBM_COPYRIGHT = "Licensed Materials - Property of IBM\n\nXML Cursor Interface for Java (XCI-J)\u00a9 Copyright IBM Corp. 2004, 2008. All Rights Reserved.\n\nUS Government Users Restricted Rights - Use, duplication or disclosure \nrestricted by GSA ADP Schedule Contract with IBM Corp.";
    protected final Source source;
    protected URI uri;

    protected BaseResource(Source source) {
        this.source = source;
        try {
            this.uri = source.getSystemId() == null ? null : new URI(source.getSystemId());
        }
        catch (URISyntaxException uRISyntaxException) {
            // empty catch block
        }
    }

    public abstract String getMediaType();

    public URI getURI() {
        return this.uri;
    }

    public boolean isEmpty() {
        return this.getContent() == null;
    }

    public abstract Object getContent();

    public abstract Resource[] getResources(String var1);

    public void load(InputStream inputStream, Map map2) {
        try {
            this.load(inputStream == null ? null : new InputStreamReader(inputStream, "UTF-8"), map2);
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            throw new RuntimeException(unsupportedEncodingException);
        }
    }

    public abstract void load(Reader var1, Map var2);

    public abstract void unload();

    public String getSystemId() {
        return this.source.getSystemId();
    }

    public void setSystemId(String string2) {
        throw new UnsupportedOperationException();
    }
}

