/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xml.xci.internal.util;

import com.ibm.xml.xci.Cursor;
import com.ibm.xml.xci.NodeTest;
import com.ibm.xml.xci.dp.base.AbstractDelegatingCursor;
import java.util.Iterator;
import java.util.LinkedList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class StreamingConcatenationCursor
extends AbstractDelegatingCursor {
    static final String IBM_COPYRIGHT = "Licensed Materials - Property of IBM\n\nXML Cursor Interface for Java (XCI-J)\u00a9 Copyright IBM Corp. 2004, 2009. All Rights Reserved.\n\nUS Government Users Restricted Rights - Use, duplication or disclosure \nrestricted by GSA ADP Schedule Contract with IBM Corp.";
    final Cursor.Profile features;
    Cursor current;
    LinkedList<Cursor> stack;
    Iterator<Cursor> future;

    public static Cursor concatenation(Cursor.Profile profile, Iterator<Cursor> iterator) {
        assert (profile.containedIn(Cursor.Profile.MINIMAL_SKIP_STREAMING_NAVIGATION));
        while (iterator.hasNext()) {
            Cursor cursor2 = iterator.next();
            if (cursor2 == null) continue;
            return new StreamingConcatenationCursor(profile, cursor2, iterator);
        }
        return null;
    }

    public StreamingConcatenationCursor(Cursor.Profile profile, Cursor cursor2, Iterator<Cursor> iterator) {
        this.features = profile;
        this.current = cursor2;
        this.future = iterator;
    }

    @Override
    protected Cursor getDelegate() {
        return this.current;
    }

    @Override
    public Cursor.Profile profile() {
        return this.features;
    }

    @Override
    public Cursor.Profile profileLimit() {
        return this.futureProfile();
    }

    @Override
    public Cursor.Profile futureProfile() {
        return this.features;
    }

    public void featuresSet(long l) {
    }

    @Override
    public Cursor fork(boolean bl, Cursor.Profile profile, Cursor.Profile profile2) {
        this.stack.add(this.current);
        this.current = this.current.fork(bl, profile, profile2);
        return this.current;
    }

    @Override
    public void release() {
        if (this.stack.isEmpty()) {
            this.current.release();
            this.current = null;
            while (this.future.hasNext()) {
                this.future.next().release();
            }
        } else {
            this.current = this.stack.removeLast();
        }
        super.release();
    }

    @Override
    public boolean toAttributes(NodeTest nodeTest) {
        return this.current.toAttributes(nodeTest);
    }

    @Override
    public boolean toChildren(NodeTest nodeTest) {
        return this.current.toChildren(nodeTest);
    }

    @Override
    public boolean toNext() {
        if (this.current.toNext()) {
            return true;
        }
        if (this.stack.isEmpty()) {
            while (this.future.hasNext()) {
                Cursor cursor2 = this.future.next();
                if (cursor2 == null) continue;
                this.current = cursor2;
                return true;
            }
        }
        return false;
    }
}

