/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xml.xci.internal.util;

import java.util.Collection;
import java.util.Iterator;
import java.util.Set;

public class JoinedSet
implements Set {
    static final String IBM_COPYRIGHT = "Licensed Materials - Property of IBM\n\nXML Cursor Interface for Java (XCI-J)\u00a9 Copyright IBM Corp. 2004, 2008. All Rights Reserved.\n\nUS Government Users Restricted Rights - Use, duplication or disclosure \nrestricted by GSA ADP Schedule Contract with IBM Corp.";
    private final Collection first;
    private final Collection second;
    private final Collection secondAvoid;

    public JoinedSet(Collection collection2, Collection collection3, Collection collection4) {
        this.first = collection2;
        this.second = collection3;
        this.secondAvoid = collection4;
    }

    public int size() {
        return this.first.size() + this.second.size() - this.secondAvoid.size();
    }

    public void clear() {
        throw new UnsupportedOperationException();
    }

    public boolean isEmpty() {
        return this.first.isEmpty() && ((Object)this.second).equals(this.secondAvoid);
    }

    public Iterator iterator() {
        return new It();
    }

    public Object[] toArray() {
        return this.toArray(new Object[this.size()]);
    }

    public Object[] toArray(Object[] objectArray) {
        int n2 = 0;
        Iterator iterator = this.iterator();
        while (iterator.hasNext()) {
            objectArray[n2++] = iterator.next();
        }
        assert (n2 == objectArray.length) : "Internal JoinedSet math inconsistency!";
        return objectArray;
    }

    public boolean contains(Object object2) {
        return this.first.contains(object2) || this.second.contains(object2) && !this.secondAvoid.contains(object2);
    }

    public boolean containsAll(Collection collection2) {
        Iterator iterator = this.iterator();
        while (iterator.hasNext()) {
            if (this.contains(iterator.next())) continue;
            return false;
        }
        return true;
    }

    public boolean add(Object object2) {
        throw new UnsupportedOperationException();
    }

    public boolean addAll(Collection collection2) {
        throw new UnsupportedOperationException();
    }

    public boolean remove(Object object2) {
        throw new UnsupportedOperationException();
    }

    public boolean removeAll(Collection collection2) {
        throw new UnsupportedOperationException();
    }

    public boolean retainAll(Collection collection2) {
        throw new UnsupportedOperationException();
    }

    private class It
    implements Iterator {
        boolean inFirst = true;
        Iterator it;
        Object next;

        It() {
            this.it = JoinedSet.this.first.iterator();
        }

        void shift() {
            while (this.next == null) {
                if (this.inFirst) {
                    if (this.it.hasNext()) {
                        this.next = this.it.next();
                        return;
                    }
                    this.inFirst = false;
                    this.it = JoinedSet.this.second.iterator();
                }
                while (this.it.hasNext()) {
                    this.next = this.it.next();
                    if (JoinedSet.this.secondAvoid.contains(this.next)) continue;
                    return;
                }
            }
        }

        public boolean hasNext() {
            this.shift();
            return this.next != null;
        }

        public Object next() {
            this.shift();
            return this.next;
        }

        public void remove() {
            throw new UnsupportedOperationException();
        }
    }
}

