/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xml.xci.internal.util;

import com.ibm.xml.xci.Cursor;
import com.ibm.xml.xci.CursorFactory;
import com.ibm.xml.xci.SessionContext;
import com.ibm.xml.xci.exec.Preparer;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CursorFactoryRegistration {
    static final String IBM_COPYRIGHT = "Licensed Materials - Property of IBM\n\nXML Cursor Interface for Java (XCI-J)\u00a9 Copyright IBM Corp. 2004, 2009. All Rights Reserved.\n\nUS Government Users Restricted Rights - Use, duplication or disclosure \nrestricted by GSA ADP Schedule Contract with IBM Corp.";
    private final ClassLoader _classLoader;
    private String _className;
    private String[] _contentType;
    private String[] _objectClassNames;
    private Class<?>[] _sourceClasses;
    private Cursor.Profile _featureLimit;
    private String[] _hints;
    private String[] _languages;
    private short _priority;
    private String _versionString;
    private Class<?> _preparerClass;

    public CursorFactoryRegistration(ClassLoader classLoader, String string2, String[] stringArray, String[] stringArray2, Cursor.Profile profile, String[] stringArray3, short s, Class<?> clazz, String[] stringArray4, String string3) {
        this._classLoader = classLoader;
        this._className = string2;
        this._contentType = stringArray;
        this._objectClassNames = stringArray2;
        this._featureLimit = profile;
        this._hints = stringArray3;
        this._priority = s;
        this._preparerClass = clazz;
        this._languages = stringArray4;
        this._versionString = string3;
    }

    public String getClassName() {
        return this._className;
    }

    public void setClassName(String string2) {
        this._className = string2;
    }

    public Cursor.Profile getFeatureLimit() {
        return this._featureLimit;
    }

    public void setFeatureLimit(Cursor.Profile profile) {
        this._featureLimit = profile;
    }

    public short getOptions() {
        return this._priority;
    }

    public void setOptions(short s) {
        this._priority = s;
    }

    public String[] getcontentType() {
        return this._contentType;
    }

    public void setcontentType(String[] stringArray) {
        this._contentType = stringArray;
    }

    public CursorFactory getFactoryInstance(SessionContext sessionContext) {
        String string2 = this._className;
        if (null != string2) {
            CursorFactoryRegistration cursorFactoryRegistration = this;
            synchronized (cursorFactoryRegistration) {
                try {
                    Class<?> clazz = this._classLoader != null ? this._classLoader.loadClass(string2) : Class.forName(string2);
                    Constructor<?> constructor = clazz.getConstructor(SessionContext.class);
                    return (CursorFactory)constructor.newInstance(sessionContext);
                }
                catch (InstantiationException instantiationException) {
                    throw new RuntimeException(instantiationException);
                }
                catch (IllegalAccessException illegalAccessException) {
                    throw new RuntimeException(illegalAccessException);
                }
                catch (SecurityException securityException) {
                    throw new RuntimeException(securityException);
                }
                catch (NoSuchMethodException noSuchMethodException) {
                    throw new RuntimeException(noSuchMethodException);
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    throw new RuntimeException(illegalArgumentException);
                }
                catch (InvocationTargetException invocationTargetException) {
                    throw new RuntimeException(invocationTargetException);
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new RuntimeException(classNotFoundException);
                }
            }
        }
        return null;
    }

    public Preparer getPreparerInstance(SessionContext sessionContext) {
        Class<?> clazz = this._preparerClass;
        if (null != clazz) {
            CursorFactoryRegistration cursorFactoryRegistration = this;
            synchronized (cursorFactoryRegistration) {
                try {
                    Constructor<?> constructor = clazz.getConstructor(SessionContext.class);
                    return (Preparer)constructor.newInstance(sessionContext);
                }
                catch (InstantiationException instantiationException) {
                    throw new RuntimeException(instantiationException);
                }
                catch (IllegalAccessException illegalAccessException) {
                    throw new RuntimeException(illegalAccessException);
                }
                catch (SecurityException securityException) {
                    throw new RuntimeException(securityException);
                }
                catch (NoSuchMethodException noSuchMethodException) {
                    throw new RuntimeException(noSuchMethodException);
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    throw new RuntimeException(illegalArgumentException);
                }
                catch (InvocationTargetException invocationTargetException) {
                    throw new RuntimeException(invocationTargetException);
                }
            }
        }
        return null;
    }

    public String[] getHints() {
        return this._hints;
    }

    public void setHints(String[] stringArray) {
        this._hints = stringArray;
    }

    public short getPriority() {
        return this._priority;
    }

    public void setPriority(short s) {
        this._priority = s;
    }

    public String[] getObjectClassNames() {
        return this._objectClassNames;
    }

    public void setObjectClassNames(String[] stringArray) {
        this._objectClassNames = stringArray;
    }

    public Class<?>[] getSourceClasses() {
        if (null != this._objectClassNames && null == this._sourceClasses) {
            this._sourceClasses = new Class[this._objectClassNames.length];
            for (int i = 0; i < this._objectClassNames.length; ++i) {
                try {
                    if (this._classLoader != null) {
                        this._sourceClasses[i] = this._classLoader.loadClass(this._objectClassNames[i]);
                        continue;
                    }
                    this._sourceClasses[i] = Class.forName(this._objectClassNames[i]);
                    continue;
                }
                catch (ClassNotFoundException classNotFoundException) {
                    System.err.println("WARNING: Specified source class not found: " + this._objectClassNames[i]);
                }
            }
        }
        return this._sourceClasses;
    }

    public void setSourceClasses(Class<?>[] classArray) {
        this._sourceClasses = classArray;
    }

    public String[] getLanguages() {
        return this._languages;
    }

    public void setLanguages(String[] stringArray) {
        this._languages = stringArray;
    }

    public String toString() {
        int n2;
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("Data Provider Class: ");
        stringBuilder.append(this._className);
        stringBuilder.append(" ");
        stringBuilder.append("Preparer: ");
        stringBuilder.append(this._preparerClass);
        stringBuilder.append(" ");
        if (null != this._objectClassNames && this._objectClassNames.length > 0) {
            stringBuilder.append("Object Classes: ");
            stringBuilder.append(this._objectClassNames[0]);
            for (n2 = 1; n2 < this._objectClassNames.length; ++n2) {
                stringBuilder.append("|");
                stringBuilder.append(this._objectClassNames[n2]);
            }
            stringBuilder.append(" ");
        }
        if (null != this._versionString) {
            stringBuilder.append("Version: ");
            stringBuilder.append(this._versionString);
            stringBuilder.append(" ");
        }
        if (null != this._hints && this._hints.length > 0) {
            stringBuilder.append("Hints: ");
            stringBuilder.append(this._hints[0]);
            for (n2 = 1; n2 < this._hints.length; ++n2) {
                stringBuilder.append("|");
                stringBuilder.append(this._hints[n2]);
            }
            stringBuilder.append(" ");
        }
        if (null != this._languages && this._languages.length > 0) {
            stringBuilder.append("Languages: ");
            stringBuilder.append(this._languages[0]);
            for (n2 = 1; n2 < this._languages.length; ++n2) {
                stringBuilder.append("|");
                stringBuilder.append(this._languages[n2]);
            }
            stringBuilder.append(" ");
        }
        stringBuilder.append("Priority: ");
        stringBuilder.append(this._priority);
        stringBuilder.append(" ");
        if (null != this._featureLimit) {
            stringBuilder.append("Feature Limit: ");
            stringBuilder.append(this._featureLimit.toString());
        }
        return stringBuilder.toString();
    }

    public Class<?> getPreparerClass() {
        return this._preparerClass;
    }

    public String getVersionString() {
        return this._versionString;
    }

    public void setVersionString(String string2) {
        this._versionString = string2;
    }
}

