/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xml.xci.internal.util;

import com.ibm.xml.xci.Cursor;
import com.ibm.xml.xci.VolatileCData;
import com.ibm.xml.xci.dp.values.chars.Chars;
import com.ibm.xml.xci.errors.XCIDynamicErrorException;
import com.ibm.xml.xci.serializer.SAX2DOM;
import com.ibm.xml.xci.serializer.SAX2XMLEventWriter;
import com.ibm.xml.xci.serializer.SAX2XMLStreamWriter;
import com.ibm.xml.xci.serializer.Serialize;
import com.ibm.xml.xml4j.internal.s1.impl.XMLEntityManager;
import java.io.IOException;
import java.io.OutputStream;
import java.io.Writer;
import java.util.Map;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.stream.XMLEventWriter;
import javax.xml.stream.XMLStreamWriter;
import javax.xml.transform.Result;
import javax.xml.transform.dom.DOMResult;
import javax.xml.transform.sax.SAXResult;
import javax.xml.transform.stax.StAXResult;
import javax.xml.transform.stream.StreamResult;
import org.w3c.dom.Node;
import org.xml.sax.ContentHandler;
import org.xml.sax.ext.LexicalHandler;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CopyToResultHelper {
    static final String IBM_COPYRIGHT = "Licensed Materials - Property of IBM\n\nXML Cursor Interface for Java (XCI-J)\u00a9 Copyright IBM Corp. 2009. All Rights Reserved.\n\nUS Government Users Restricted Rights - Use, duplication or disclosure \nrestricted by GSA ADP Schedule Contract with IBM Corp.";

    public static boolean copyToResult(Cursor cursor2, Result result2, Map<String, Object> map2, boolean bl, boolean bl2) {
        boolean bl3 = false;
        if (result2 instanceof DOMResult) {
            bl3 = CopyToResultHelper.copyToDOMResult(cursor2, (DOMResult)result2, map2, bl, bl2);
        } else if (result2 instanceof SAXResult) {
            bl3 = CopyToResultHelper.copyToSAXResult(cursor2, (SAXResult)result2, map2, bl, bl2);
        } else if (result2 instanceof StreamResult) {
            bl3 = CopyToResultHelper.copyToStreamResult(cursor2, (StreamResult)result2, map2, bl, bl2);
        } else if (result2 instanceof StAXResult) {
            bl3 = CopyToResultHelper.copyToStAXResult(cursor2, (StAXResult)result2, map2, bl, bl2);
        }
        return bl3;
    }

    public static boolean copyToStAXResult(Cursor cursor2, StAXResult stAXResult, Map<String, Object> map2, boolean bl, boolean bl2) {
        XMLEventWriter xMLEventWriter = stAXResult.getXMLEventWriter();
        if (xMLEventWriter != null) {
            SAX2XMLEventWriter sAX2XMLEventWriter = new SAX2XMLEventWriter(xMLEventWriter);
            Serialize.toContentHandler(cursor2, sAX2XMLEventWriter, sAX2XMLEventWriter, map2);
        } else {
            XMLStreamWriter xMLStreamWriter = stAXResult.getXMLStreamWriter();
            SAX2XMLStreamWriter sAX2XMLStreamWriter = new SAX2XMLStreamWriter(xMLStreamWriter);
            Serialize.toContentHandler(cursor2, sAX2XMLStreamWriter, sAX2XMLStreamWriter, map2);
        }
        return false;
    }

    public static boolean copyToStreamResult(Cursor cursor2, StreamResult streamResult, Map<String, Object> map2, boolean bl, boolean bl2) {
        Object object2;
        Object object3 = object2 = map2 == null ? null : map2.get("method");
        boolean bl3 = object2 == null ? true : !object2.toString().equals("text");
        VolatileCData volatileCData = cursor2.serialize(map2);
        Writer writer = streamResult.getWriter();
        if (writer != null) {
            try {
                volatileCData.appendQuotedTo(writer, bl3 ? (short)33 : 0, bl2);
            }
            catch (IOException iOException) {
                throw new XCIDynamicErrorException(iOException);
            }
        }
        if (streamResult.getOutputStream() != null) {
            OutputStream outputStream = streamResult.getOutputStream();
            String string2 = map2 != null ? (String)map2.get("encoding") : null;
            try {
                volatileCData.writeEncodedBytesTo(outputStream, string2 != null ? string2 : Chars.UTF8.name(), bl3 ? (short)33 : 0, bl2);
            }
            catch (IOException iOException) {
                throw new XCIDynamicErrorException(iOException);
            }
        }
        if (streamResult.getSystemId() != null) {
            try {
                OutputStream outputStream = XMLEntityManager.createOutputStream(streamResult.getSystemId());
                volatileCData.writeEncodedBytesTo(outputStream, Chars.UTF8.name(), bl3 ? (short)33 : 0, bl2);
            }
            catch (IOException iOException) {
                throw new XCIDynamicErrorException(iOException);
            }
        }
        return false;
    }

    public static boolean copyToSAXResult(Cursor cursor2, SAXResult sAXResult, Map<String, Object> map2, boolean bl, boolean bl2) {
        ContentHandler contentHandler = sAXResult.getHandler();
        LexicalHandler lexicalHandler = sAXResult.getLexicalHandler();
        Serialize.toContentHandler(cursor2, contentHandler, lexicalHandler, map2);
        return false;
    }

    public static boolean copyToDOMResult(Cursor cursor2, DOMResult dOMResult, Map<String, Object> map2, boolean bl, boolean bl2) {
        Node node2 = dOMResult.getNode();
        try {
            Object object2;
            SAX2DOM sAX2DOM = node2 != null ? ((object2 = dOMResult.getNextSibling()) == null ? new SAX2DOM(node2) : new SAX2DOM(node2, (Node)object2)) : new SAX2DOM();
            object2 = sAX2DOM;
            SAX2DOM sAX2DOM2 = sAX2DOM;
            cursor2 = bl2 ? cursor2 : cursor2.fork(false);
            Serialize.toContentHandler(cursor2, (ContentHandler)object2, sAX2DOM2, map2);
            if (node2 == null) {
                dOMResult.setNode(sAX2DOM.getDOM());
            }
        }
        catch (ParserConfigurationException parserConfigurationException) {
            parserConfigurationException.printStackTrace();
        }
        return false;
    }
}

