/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xml.xci.internal.equality;

import com.ibm.xml.ras.LoggerUtil;
import com.ibm.xml.xci.CData;
import com.ibm.xml.xci.Cursor;
import com.ibm.xml.xci.VolatileCData;
import com.ibm.xml.xci.dp.type.TypeHelper;
import com.ibm.xml.xci.dp.util.misc.Stack;
import com.ibm.xml.xci.errors.XCIDynamicErrorException;
import com.ibm.xml.xci.internal.equality.AcceptAllDiffHandler;
import com.ibm.xml.xci.internal.equality.DiffDispatcher;
import com.ibm.xml.xci.internal.equality.DifferenceHandler;
import com.ibm.xml.xci.internal.equality.RootElementHandler;
import com.ibm.xml.xci.internal.equality.WhitespaceHandler;
import com.ibm.xml.xci.internal.equality.XSIAttributeHandler;
import com.ibm.xml.xml4j.api.s1.xs.XSTypeDefinition;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EqualityHelper {
    static final String IBM_COPYRIGHT = "Licensed Materials - Property of IBM\n\nXML Cursor Interface for Java (XCI-J)\u00a9 Copyright IBM Corp. 2004, 2008. All Rights Reserved.\n\nUS Government Users Restricted Rights - Use, duplication or disclosure \nrestricted by GSA ADP Schedule Contract with IBM Corp.";
    private static final Logger logger = LoggerUtil.getLogger(EqualityHelper.class);

    public static boolean isEquals(Cursor cursor2, Cursor cursor3, Map<String, Object> map2) {
        DifferenceHandler differenceHandler = EqualityHelper.getDifferenceHandler(map2);
        boolean bl = EqualityHelper.getBoolean("equal-ignore-whitespace", map2);
        if (LoggerUtil.isAnyTracingEnabled() && logger.isLoggable(Level.FINEST)) {
            logger.logp(Level.FINEST, logger.getName(), "isEquals", "Parameters: " + String.valueOf(map2));
        }
        if (cursor2 == null || cursor3 == null) {
            return cursor2 == cursor3;
        }
        Stack<Cursor> stack = new Stack<Cursor>(500);
        Stack<Cursor> stack2 = new Stack<Cursor>(500);
        stack.push(cursor2.fork(false, Cursor.Profile.MINIMAL_SKIP_STREAMING_NAVIGATION, Cursor.Profile.MINIMAL_SKIP_STREAMING_NAVIGATION));
        stack2.push(cursor3.fork(false, Cursor.Profile.MINIMAL_SKIP_STREAMING_NAVIGATION, Cursor.Profile.MINIMAL_SKIP_STREAMING_NAVIGATION));
        boolean bl2 = true;
        boolean bl3 = true;
        block9: do {
            cursor2 = (Cursor)stack.peek();
            cursor3 = (Cursor)stack2.peek();
            if (cursor2.itemKind() != cursor3.itemKind() && differenceHandler.differenceFound(2, cursor2, cursor3)) {
                return EqualityHelper.fail(stack, stack2);
            }
            switch (cursor2.itemKind()) {
                case 1: {
                    Cursor cursor4;
                    Cursor cursor5;
                    if (!EqualityHelper.qnameEquals(cursor2.itemName(), cursor3.itemName()) && differenceHandler.differenceFound(bl3 ? 0 : 1, cursor2, cursor3)) {
                        return EqualityHelper.fail(stack, stack2);
                    }
                    if (cursor2.itemXSType() != cursor3.itemXSType()) {
                        return EqualityHelper.fail(stack, stack2);
                    }
                    if (!EqualityHelper.isAttrEquals(stack, stack2, cursor2, cursor3, differenceHandler, bl3)) {
                        return EqualityHelper.fail(stack, stack2);
                    }
                    bl3 = false;
                    if (cursor2.itemXSType() == null || cursor2.itemXSType().getTypeCategory() == 15) {
                        cursor5 = cursor2.fork(true);
                        if (cursor5.toChildren(null)) {
                            cursor4 = cursor3.fork(true);
                            if (!cursor4.toChildren(null)) {
                                if (bl && cursor5.itemKind() == 3 && cursor5.itemStringValueAsChars().isSpace() && !cursor5.toNext()) break;
                                return EqualityHelper.fail(stack, stack2);
                            }
                            stack.push(cursor5);
                            stack2.push(cursor4);
                            bl2 = false;
                            break;
                        }
                        cursor4 = cursor3.fork(true);
                        if (cursor4.toChildren(null) && (!bl || cursor4.itemKind() != 3 || !cursor4.itemStringValueAsChars().isSpace() || cursor4.toNext())) {
                            return EqualityHelper.fail(stack, stack2);
                        }
                        cursor5.release();
                        cursor4.release();
                        bl2 = true;
                        break;
                    }
                    if (!EqualityHelper.typedValueEquals(cursor2.itemTypedValue(), cursor3.itemTypedValue()) && differenceHandler.differenceFound(4, cursor2, cursor3)) {
                        return EqualityHelper.fail(stack, stack2);
                    }
                    bl2 = true;
                    break;
                }
                case 9: {
                    Cursor cursor4;
                    Cursor cursor5 = cursor2.fork(true);
                    if (cursor5.toChildren(null)) {
                        cursor4 = cursor3.fork(true);
                        if (!cursor4.toChildren(null)) {
                            return EqualityHelper.fail(stack, stack2);
                        }
                        stack.push(cursor5);
                        stack2.push(cursor4);
                        bl2 = false;
                        break;
                    }
                    cursor4 = cursor3.fork(true);
                    if (cursor4.toChildren(null)) {
                        return EqualityHelper.fail(stack, stack2);
                    }
                    cursor5.release();
                    cursor4.release();
                    bl2 = true;
                    break;
                }
                case 2: {
                    if (!EqualityHelper.qnameEquals(cursor2.itemName(), cursor3.itemName())) {
                        return EqualityHelper.fail(stack, stack2);
                    }
                    if (EqualityHelper.typedValueEquals(cursor2.itemTypedValue(), cursor3.itemTypedValue())) break;
                    return EqualityHelper.fail(stack, stack2);
                }
                case 3: {
                    if (!EqualityHelper.typedValueEquals(cursor2.itemTypedValue(), cursor3.itemTypedValue()) && differenceHandler.differenceFound(4, cursor2, cursor3)) {
                        return EqualityHelper.fail(stack, stack2);
                    }
                    bl2 = true;
                    break;
                }
                case 4: {
                    if (!EqualityHelper.typedValueEquals(cursor2.itemTypedValue(), cursor3.itemTypedValue())) {
                        return EqualityHelper.fail(stack, stack2);
                    }
                    if (!cursor2.itemName().equals(cursor3.itemName())) {
                        return EqualityHelper.fail(stack, stack2);
                    }
                    bl2 = true;
                    break;
                }
                case 8: {
                    if (!EqualityHelper.typedValueEquals(cursor2.itemTypedValue(), cursor3.itemTypedValue())) {
                        return EqualityHelper.fail(stack, stack2);
                    }
                    bl2 = true;
                    break;
                }
                case 7: {
                    if (!EqualityHelper.qnameEquals(cursor2.itemName(), cursor3.itemName())) {
                        return EqualityHelper.fail(stack, stack2);
                    }
                    if (!EqualityHelper.typedValueEquals(cursor2.itemTypedValue(), cursor3.itemTypedValue())) {
                        return EqualityHelper.fail(stack, stack2);
                    }
                    bl2 = true;
                }
            }
            if (!bl2) continue;
            do {
                if (stack.size() != 1) {
                    if (cursor2.toNext()) {
                        if (cursor3.toNext()) continue block9;
                        if (differenceHandler.differenceFound(3, cursor3, cursor2)) {
                            return EqualityHelper.fail(stack, stack2);
                        }
                    }
                    if (cursor3.toNext() && differenceHandler.differenceFound(3, cursor2, cursor3)) {
                        return EqualityHelper.fail(stack, stack2);
                    }
                }
                cursor2.release();
                cursor3.release();
                stack.pop();
                stack2.pop();
                cursor2 = stack.isEmpty() ? null : stack.peek();
                Cursor cursor6 = cursor3 = stack2.isEmpty() ? null : stack2.peek();
            } while (cursor2 != null && cursor3 != null);
        } while (!stack.isEmpty() && !stack2.isEmpty());
        if (!stack2.isEmpty() || !stack.isEmpty()) {
            return EqualityHelper.fail(stack, stack2);
        }
        return true;
    }

    public static boolean typedValueEquals(VolatileCData volatileCData, VolatileCData volatileCData2) {
        if (!TypeHelper.isEqual(volatileCData.getXSTypeDefinition(), volatileCData2.getXSTypeDefinition())) {
            return false;
        }
        switch (volatileCData.getXSTypeDefinition().getBuiltInKind()) {
            case 3: {
                return volatileCData.getBoolean(1) == volatileCData2.getBoolean(1);
            }
            case 4: {
                return volatileCData.getBigDecimal(1).compareTo(volatileCData2.getBigDecimal(1)) == 0;
            }
            case 5: {
                float f2 = volatileCData.getFloat(1);
                float f3 = volatileCData2.getFloat(1);
                if (Float.isNaN(f2) && Float.isNaN(f3)) {
                    return true;
                }
                return f2 == f3;
            }
            case 6: {
                double d = volatileCData.getDouble(1);
                double d2 = volatileCData2.getDouble(1);
                if (Double.isNaN(d) && Double.isNaN(d2)) {
                    return true;
                }
                return d == d2;
            }
            case 7: 
            case 46: 
            case 47: {
                try {
                    return volatileCData.getDuration(1).equals(volatileCData2.getDuration(1));
                }
                catch (ParseException parseException) {
                    throw new XCIDynamicErrorException("ER_INVALID_CAST", new String[]{volatileCData.getXSTypeDefinition().toString(), "xs:duration"});
                }
            }
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: {
                try {
                    return volatileCData.getXMLGregorianCalendar(1).equals(volatileCData2.getXMLGregorianCalendar(1));
                }
                catch (ParseException parseException) {
                    throw new XCIDynamicErrorException("ER_INVALID_CAST", new String[]{volatileCData.getXSTypeDefinition().toString(), volatileCData2.getXSTypeDefinition().toString()});
                }
            }
            case 16: {
                return ((Object)volatileCData.getHexBinary(1)).equals(volatileCData2.getHexBinary(1));
            }
            case 17: {
                return ((Object)volatileCData.getBase64Binary(1)).equals(volatileCData2.getBase64Binary(1));
            }
            case 19: {
                return volatileCData.getQNameLocalPart(1).equals(volatileCData2.getQNameLocalPart(1)) && volatileCData.getQNameNamespaceURI(1).equals(volatileCData2.getQNameNamespaceURI(1));
            }
            case 35: 
            case 41: {
                return volatileCData.getShort(1) == volatileCData2.getShort(1);
            }
            case 30: 
            case 31: 
            case 32: 
            case 37: 
            case 38: 
            case 42: {
                return volatileCData.getBigInteger(1).equals(volatileCData2.getBigInteger(1));
            }
            case 33: 
            case 39: {
                return volatileCData.getLong(1) == volatileCData2.getLong(1);
            }
            case 34: 
            case 40: {
                return volatileCData.getInt(1) == volatileCData2.getInt(1);
            }
            case 36: {
                return volatileCData.getByte(1) == volatileCData2.getByte(1);
            }
        }
        return volatileCData.getString(1).equals(volatileCData2.getString(1));
    }

    private static boolean qnameEquals(VolatileCData volatileCData, VolatileCData volatileCData2) {
        return volatileCData.equals(volatileCData2);
    }

    private static DifferenceHandler getDifferenceHandler(Map<String, Object> map2) {
        if (map2 == null) {
            return AcceptAllDiffHandler.SINGLETON;
        }
        DiffDispatcher diffDispatcher = new DiffDispatcher();
        if (EqualityHelper.getBoolean("equal-ignore-root-element-name", map2)) {
            diffDispatcher.setHandler(0, RootElementHandler.SINGLETON);
        }
        if (EqualityHelper.getBoolean("equal-ignore-whitespace", map2)) {
            diffDispatcher.setHandler(3, new WhitespaceHandler());
            diffDispatcher.setHandler(2, new WhitespaceHandler());
            diffDispatcher.setHandler(4, new WhitespaceHandler());
        }
        if (EqualityHelper.getBoolean("equal-ignore-root-xsi-type", map2)) {
            diffDispatcher.setHandler(5, XSIAttributeHandler.SINGLETON);
            diffDispatcher.setHandler(6, XSIAttributeHandler.SINGLETON);
        }
        if (EqualityHelper.getBoolean("equal-strict-fn-spec", map2)) {
            throw new XCIDynamicErrorException("ER_EQUALITY_UNSUPPORTED_OPERATION");
        }
        return diffDispatcher;
    }

    private static boolean isAttrEquals(Stack<Cursor> stack, Stack<Cursor> stack2, Cursor cursor2, Cursor cursor3, DifferenceHandler differenceHandler, boolean bl) {
        Cursor cursor4 = cursor2.fork(true);
        Cursor cursor5 = cursor3.fork(true);
        if (cursor4.toAttributes(null)) {
            int n2;
            if (!cursor5.toAttributes(null)) {
                if (bl && !differenceHandler.differenceFound(5, cursor4, cursor5)) {
                    cursor4.release();
                    cursor5.release();
                    return true;
                }
                return EqualityHelper.fail(stack, stack2);
            }
            ArrayList<CData> arrayList = new ArrayList<CData>();
            ArrayList<CData> arrayList2 = new ArrayList<CData>();
            ArrayList<XSTypeDefinition> arrayList3 = new ArrayList<XSTypeDefinition>();
            ArrayList<Boolean> arrayList4 = new ArrayList<Boolean>();
            do {
                arrayList.add(cursor4.itemName().constant(true));
                arrayList2.add(cursor4.itemTypedValue().constant(true));
                arrayList3.add(cursor4.itemXSType());
                arrayList4.add(differenceHandler.conditionFound(6, cursor4));
            } while (cursor4.toNext());
            do {
                if (bl && differenceHandler.conditionFound(6, cursor5)) continue;
                n2 = arrayList.indexOf(cursor5.itemName());
                if (n2 == -1) {
                    cursor4.release();
                    cursor5.release();
                    return EqualityHelper.fail(stack, stack2);
                }
                if (!EqualityHelper.typedValueEquals((VolatileCData)arrayList2.get(n2), cursor5.itemTypedValue())) {
                    cursor4.release();
                    cursor5.release();
                    return EqualityHelper.fail(stack, stack2);
                }
                arrayList4.set(n2, Boolean.TRUE);
            } while (cursor5.toNext());
            cursor4.release();
            cursor5.release();
            for (n2 = 0; n2 < arrayList4.size(); ++n2) {
                if (((Boolean)arrayList4.get(n2)).equals(Boolean.TRUE)) continue;
                return EqualityHelper.fail(stack, stack2);
            }
        } else {
            if (cursor5.toAttributes(null) && (!bl || differenceHandler.differenceFound(5, cursor5, cursor4))) {
                cursor4.release();
                cursor5.release();
                return EqualityHelper.fail(stack, stack2);
            }
            cursor4.release();
            cursor5.release();
        }
        return true;
    }

    private static boolean fail(Stack<Cursor> stack, Stack<Cursor> stack2) {
        while (!stack.isEmpty()) {
            stack.pop().release();
        }
        while (!stack2.isEmpty()) {
            stack2.pop().release();
        }
        return false;
    }

    private static boolean getBoolean(String string2, Map<String, Object> map2) {
        Object object2;
        if (map2 != null && (object2 = map2.get(string2)) instanceof Boolean) {
            return (Boolean)object2;
        }
        return false;
    }
}

